<?php
    function Lang($key)
    {
        global $languageManager;

        if (class_exists('LanguageManager')) {
            return $languageManager->GetTranslation($key);
        } else {
            return '';
        }
    }

    function PermissionsError($queue = false)
    {
        if ($queue) {
            DirectNotifications::Queue('title: "'.Lang('error').'", text: "'.Lang('permissions_error').'", type: "error"');
        } else {
            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('permissions_error').'", type: "error"');
        }
    }

    function SecondsToTimeString($secs)
    {
        $perma = false;
        if (0 == $secs) {
            $perma = true;
        }
        $r = '';
        if ($secs >= 86400) {
            $days = floor($secs / 86400);
            $secs = $secs % 86400;
            $r = $days.' Day';
            if (1 != $days) {
                $r .= 's';
            }
            if ($secs > 0) {
                $r .= ', ';
            }
        }
        if ($secs >= 3600) {
            $hours = floor($secs / 3600);
            $secs = $secs % 3600;
            $r .= $hours.' Hour';
            if (1 != $hours) {
                $r .= 's';
            }
            if ($secs > 0) {
                $r .= ', ';
            }
        }
        if ($secs >= 60) {
            $minutes = floor($secs / 60);
            $secs = $secs % 60;
            $r .= $minutes.' Minute';
            if (1 != $minutes) {
                $r .= 's';
            }
        }
        if ($perma) {
            $r = '<b><font color=red>'.Lang('permanent').'</font></b>';
        }

        return $r;
    }

    function ConsoleLog($text)
    {
        echo '<script>console.log("'.$text.'"); </script>';
    }

    function Debug($text)
    {
        global $versionManager;

        $db = MysqliDb::getInstance();

        $replace = array(
            $versionManager->license,
            Config::Get('steamapikey'),
            Settings::Get('settings_discord_bot_token'),
            Settings::Get('settings_api_key'),
            Settings::Get('settings_donations_g2apay_apihash'),
            Settings::Get('settings_donations_g2apay_secret'),
            Settings::Get('settings_donations_payssion_apikey'),
            Settings::Get('settings_donations_payssion_secretkey'),
            Settings::Get('settings_donations_paysafecard_key'),
            Paysafecard::GetKey(),
            Settings::Get('settings_donations_stripe_secretkey'),
            Settings::Get('settings_donations_stripe_publickey')
        );

        $data = array(
            'debug' => str_replace($replace, '*REMOVED*', $text),
            'trace' => str_replace($replace, '*REMOVED*', ToJson(debug_backtrace())),
        );

        $db->insert('debug', $data);
    }

    function FormatDate($date)
    {
        if (StartsWith($date, '0000-') || StartsWith($date, '1970-') || StartsWith($date, '1980-')) {
            return 'N/A';
        }

        return date(Settings::Get('settings_general_timeformat'), strtotime($date));
    }

    function FormatPrice($price)
    {
        return str_replace(',', '', number_format(round($price, 2), 2));
    }

    function StartsWith($haystack, $needle)
    {
        return '' === $needle || false !== strrpos($haystack, $needle, -strlen($haystack));
    }

    function EndsWith($haystack, $needle)
    {
        return '' === $needle || (($temp = strlen($haystack) - strlen($needle)) >= 0 && false !== strpos($haystack, $needle, $temp));
    }

    function ValidateBool($var)
    {
        if (filter_var($var, FILTER_VALIDATE_BOOLEAN)) {
            return 1;
        } else {
            return 0;
        }
    }

    function SteamIDFrom64($steamid64)
    {
        $offset = bcsub($steamid64, '76561197960265728');
        $id = floor(bcdiv($offset, '2'));

        if (bcmod($offset, '2')) {
            return 'STEAM_0:1:'.$id;
        } else {
            return 'STEAM_0:0:'.$id;
        }
    }

    function SteamIDTo64($steamid32)
    {
        if (preg_match('/^STEAM_/', $steamid32)) {
            $parts = explode(':', $steamid32);

            return bcadd(bcadd(bcmul($parts[2], '2'), '76561197960265728'), $parts[1]);
        } elseif (is_numeric($steamid32) && strlen($steamid32) < 16) {
            return bcadd($steamid32, '76561197960265728');
        } else {
            return false;
        }
    }

    function Redirect($url, $delay = false)
    {
        if (!$delay) {
            echo '<script>window.location.replace("'.$url.'");</script>';
        } else {
            echo '
			<script>
				setTimeout(function(){
					window.location.replace("'.$url.'");
				}, 500);
			</script>';
        }
    }

    function ReloadProduct($y)
    {
        if ($y) {
            $q5 = fopen(base64_decode('YXNzZXRzL2Nzcy9fc3R5bGVpbmZvLmNzcw=='), base64_decode('dw=='));
            fclose($q5);
        }
    }

    function GetFirstLine($file)
    {
        $f = fopen($file, 'r');
        $line = fgets($f);
        fclose($f);

        return $line;
    }

    function FileHasExt($file, $ext)
    {
        if ('.'.$ext == substr($file, -(strlen($ext) + 1))) {
            return true;
        } else {
            return false;
        }
    }

    function GetLinesInFile($file)
    {
        $linecount = 0;
        $handle = fopen($file, 'r');
        while (!feof($handle)) {
            $line = fgets($handle);
            ++$linecount;
        }

        fclose($handle);

        return $linecount;
    }

    function CreateCheckbox($type, $id, $class, $text, $style = '', $name = '', $checked = false, $escape = true)
    {
        $n = $id;

        if (!empty($name)) {
            $n = $name;
        }
        /*
        echo '<div class="funkyradio">
                <div class="funkyradio-' . $type .'">
                    <input style="'.$style.'" type="checkbox" name="' .$n. '" id="' .$id. '" class="'.$class.'" />
                    <label for="' .$id. '">'.$text.'</label>
                </div>
            </div>';*/

        echo '<div class="checkbox">
					<label>
						<input '.($checked ? 'checked' : '').' style="'.$style.'" type="checkbox" id="'.$id.'" name="'.$n.'" class="'.$class.'">
						'.($escape ? htmlspecialchars($text) : $text).'
					</label>
				</div>';
    }

    function CreateTooltip($text, $position)
    {
        echo '<a class="clickable" data-toggle="tooltip" data-placement="'.$position.'" title="'.$text.'">?</a>';
    }

    function isDomainAvailable($domain)
    {
        //check, if a valid url is provided
        if (!filter_var($domain, FILTER_VALIDATE_URL)) {
            return false;
        }

        //initialize curl
        $request = new CURLRequester($domain);
        $response = $request->request(null, false, 3);

        if ($response) {
            return true;
        }

        return false;
    }

    function random_string($amount)
    {
        return substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, $amount);
    }

    function FromJson($string)
    {
        $string = mb_convert_encoding($string, 'UTF-8', 'UTF-8');

        $ret = array();

        $json = json_decode($string, true);

        if ($json) {
            $ret = $json;
        }

        return $ret;
    }

    function ToJson($array)
    {
        $ret = '[]';

        $json = null;

        if (is_array($array)) {
            $json = json_encode($array);
        }

        if ($json) {
            $ret = $json;
        }

        return $ret;
    }

    function OneLine($text)
    {
        return trim(preg_replace('/\s+/', ' ', str_replace(array("'", '\\'), '', $text)));
    }

    function TimeElapsed($ptime)
    {
        $etime = time() - $ptime;

        if ($etime < 1) {
            return '0 seconds';
        }

        $a = array(365 * 24 * 60 * 60 => 'year',
                     30 * 24 * 60 * 60 => 'month',
                          24 * 60 * 60 => 'day',
                               60 * 60 => 'hour',
                                    60 => 'minute',
                                     1 => 'second',
                    );
        $a_plural = array('year' => 'years',
                           'month' => 'months',
                           'day' => 'days',
                           'hour' => 'hours',
                           'minute' => 'minutes',
                           'second' => 'seconds',
                    );

        foreach ($a as $secs => $str) {
            $d = $etime / $secs;
            if ($d >= 1) {
                $r = round(floatval($d));

                return $r.' '.($r > 1 ? $a_plural[$str] : $str).' ago';
            }
        }
    }

    function GetProtocol()
    {
        $s = (empty($_SERVER['HTTPS']) ? '' : (('on' == $_SERVER['HTTPS']) ? 's' : ''));
        $sp = strtolower($_SERVER['SERVER_PROTOCOL']);
        $protocol = substr($sp, 0, strpos($sp, '/')).$s;

        return $protocol;
    }

    function GetCurrentLocation()
    {
        $hostname = Hostname();

        $dirname = dirname($_SERVER['PHP_SELF']);
        $dirname = str_replace('\\', '/', $dirname);

        if (!tempty(Settings::Get('settings_general_installpath'))) {
            $dirname = Settings::Get('settings_general_hostname');
        }

        if ('/' != $dirname) {
            if (StartsWith($dirname, '/')) {
                $dirname = substr($dirname, 1);
            }

            $hostname .= $dirname;
        }

        if ('/' != substr($hostname, -1)) {
            $hostname .= '/';
        }

        return $hostname;
    }

    function tempty($val)
    {
        if (!isset($val)) {
            return true;
        }

        $var = $val;

        $var = trim($var);

        $var = str_replace(array('<br>', '<p>', '</p>', '&nbsp;', ' '), '', $var);

        return empty($var);
    }

    function nempty($val)
    {
        if (!isset($val)) {
            return true;
        }

        $var = $val;

        return empty($var);
    }

    function Hostname()
    {
        if (!tempty(Settings::Get('settings_general_hostname')) && StartsWith(Settings::Get('settings_general_hostname'), 'http')) {
            return Settings::Get('settings_general_hostname');
        }

        $hostname = $_SERVER['HTTP_HOST'];
        $hostname = str_replace(':80', '', $hostname);
        $hostname = str_replace(':443', '', $hostname);
        $hostname = Config::Get('protocol').'://'.$hostname;

        if ('/' != substr($hostname, -1)) {
            $hostname .= '/';
        }

        return $hostname;
    }

    function GetIPInfo()
    {
        $requester = new CURLRequester('http://ip-api.com/json/'.GetClientIP(), 'GET', true);
        $details = $requester->request(null, false, 0.5);

        if ($details && isset($details['countryCode'])) {
            return array('country_code' => $details['countryCode']);
        }else{
            return null;
        }
    }

    function GetClientIP()
    {
        $ip_keys = array('HTTP_CF_CONNECTING_IP', 'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR');
        foreach ($ip_keys as $key) {
            if (true === array_key_exists($key, $_SERVER)) {
                foreach (explode(',', $_SERVER[$key]) as $ip) {
                    // trim for safety measures
                    $ip = trim($ip);
                    // attempt to validate IP
                    if (ValidateIP($ip)) {
                        return $ip;
                    }
                }
            }
        }

        return isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false;
    }

    function ValidateIP($ip)
    {
        if (false === filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 | FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
            return false;
        }

        return true;
    }

    function RemoveQuotes($str)
    {
        $str = str_replace(array('"', "'", '&quot;', '&#039;'), '', $str);

        return str_replace(array('&quot', '&#039'), '', $str);
    }

    function SaveQuotes($str)
    {
        $str = str_replace('"', '&quot;', $str);
        $str = str_replace("'", '&#039;', $str);

        return $str;
    }

    function SaveCroc($str)
    {
        // $str = str_replace("&", '&amp;', $str);
        $str = str_replace('<', '&lt;', $str);
        $str = str_replace(">", '&gt;', $str);

        return $str;
    }

    function DemoLock()
    {
        if (Settings::Get('settings_demo')) {
            if (!Permissions::HasPermission('super')) {
                return true;
            }
        }

        return false;
    }

    function CloseHTMLTags($html)
    {
        preg_match_all('#<(?!meta|img|br|hr|input\b)\b([a-z]+)(?: .*)?(?<![/|/ ])>#iU', $html, $result);
        $openedtags = $result[1];
        preg_match_all('#</([a-z]+)>#iU', $html, $result);
        $closedtags = $result[1];
        $len_opened = count($openedtags);
        if (count($closedtags) == $len_opened) {
            return $html;
        }
        $openedtags = array_reverse($openedtags);
        for ($i = 0; $i < $len_opened; ++$i) {
            if (!in_array($openedtags[$i], $closedtags)) {
                $html .= '</'.$openedtags[$i].'>';
            } else {
                unset($closedtags[array_search($openedtags[$i], $closedtags)]);
            }
        }

        return $html;
    }

    function GetTimeOffset()
    {
        $now = new DateTime();
        $mins = $now->getOffset() / 60;

        $sgn = ($mins < 0 ? '-' : '+');
        $mins = abs($mins);
        $hrs = floor($mins / 60);
        $mins -= $hrs * 60;

        $n = '';

        if ($hrs < 10 && $hrs >= 0) {
            $n = '0';
        }

        $offset = sprintf('%+s:%02d', $sgn.$n.$hrs, $mins);

        return $offset;
    }

    function TimeDebug()
    {
        static $last = null;

        $now = microtime(true);

        if (null != $last) {
            echo '<!-- '.($now - $last).' -->';
        }

        $last = $now;
    }

    function Error($reason, $debug = false)
    {
        if ($debug) {
            Debug($reason);
        }

        http_response_code(400);

        die(ToJson(array('error' => $reason)));
    }

    function Success()
    {
        die(ToJson(array('success' => true)));
    }

    function Result($result)
    {
        die(ToJson($result));
    }

    function RequiredArguments()
    {
        foreach (func_get_args() as $arg) {
            if (!isset($_REQUEST[$arg])) {
                Error('missing argument: '.$arg);
            } else {
                $GLOBALS[$arg] = $_REQUEST[$arg];
            }
        }
    }

    function OptionalArguments()
    {
        foreach (func_get_args() as $arg) {
            if (!isset($_REQUEST[$arg])) {
                $GLOBALS[$arg] = '';
            } else {
                $GLOBALS[$arg] = $_REQUEST[$arg];
            }
        }
    }

    function StartMeasure()
    {
        global $startTime;

        $startTime = microtime(true);
    }

    function GetMeasure()
    {
        global $startTime;

        $endTime = microtime(true);
        $elapsed = round($endTime - $startTime, 4);

        echo "<br>Execution time : $elapsed seconds";

        $startTime = microtime(true);
    }

    function GetCurrentPage($files)
    {
        global $versionManager;

        $target = Settings::Get('settings_general_startpage');

        if (isset($_GET['t'])) {
            $t = $_GET['t'];

            if ($versionManager->IsValid() || 'admin_settings' == $t) {
                if (in_array($t, array_keys($files)) && (file_exists(base64_decode('YXNzZXRzL2Nzcy9fc3R5bGVpbmZvLmNzcw==')) || 14 == strlen($t))) {
                    if (isset($files[$t]['data'])) {
                        $data = $files[$t]['data'];

                        if (isset($data['language']) && isset($data['icon']) && isset($data['place']) && isset($data['position'])) {
                            $target = $t;
                        }
                    }
                }
            }
        }

        return $files[$target];
    }

    function GetSelectedTheme()
    {
        global $themeManager;

        $default = null;

        foreach ($themeManager->files as $file) {
            if ('default.css' == $file['rawname']) {
                $default = $file;
            }

            if ($file['rawname'] == Settings::Get('settings_design_theme')) {
                return $file;
            }
        }

        return $default;
    }

    function DeleteTarget($path)
    {
        if (true === is_dir($path)) {
            $files = array_diff(scandir($path), array('.', '..'));

            foreach ($files as $file) {
                DeleteTarget(realpath($path).'/'.$file);
            }

            return rmdir($path);
        } elseif (true === is_file($path)) {
            return unlink($path);
        }

        return false;
    }

    function FunctionEnabled($name)
    {
        $ex = true;

        $disabled = explode(',', str_replace(' ', '', ini_get('disable_functions')));

        if (!function_exists($name)) {
            $ex = false;
        }

        if (in_array($name, $disabled)) {
            $ex = false;
        }

        return $ex;
    }

    function GetTS3Worker()
    {
        if (!isset($GLOBALS['_ts3worker'])) {
            $GLOBALS['_ts3worker'] = new TS3Worker();
        }

        return $GLOBALS['_ts3worker'];
    }

    function ValidateHTML($html, $options = array(), $user = false)
    {
        $config = HTMLPurifier_Config::createDefault();

        if ($user){
            $config->set('HTML.Allowed', 'a,b,u,i,p,ul,ol,li');
            $config->set('CSS.AllowedProperties', 'color,font-size,font-family,background-color,margin-left');
            $config->set('HTML.AllowedAttributes', 'a.href,a.target,style');
            $config->set('Attr.AllowedFrameTargets', array('_blank'));
        }

        foreach ($options as $key => $value) {
            $config->set($key, $value);
        }

        $purifier = new HTMLPurifier($config);
        $clean_html = $purifier->purify($html);

        return $clean_html;
    }

    function AP($path)
    {
        $parts = explode('/', $path);

        if (sizeof($parts) < 2) {
            $parts = explode('\\', $path);
        }

        $next = false;
        foreach ($parts as $part) {
            if ('addons' == $part) {
                $next = true;
            } else {
                if ($next) {
                    return 'addons/'.$part.'/';
                }
            }
        }

        return false;
    }

    function GetTaxes($amount, $iscustom = false, $user=null)
    {
        global $auth_user;

        $taxes = array('taxRate' => 0, 'taxAmount' => 0, 'total' => $amount, 'unknown' => true, 'note' => '');

        $countrycode = null;

        if($user != null){
            $countrycode = $user->GetValue('country_code');
        }elseif ($auth_user != null){
            $countrycode = $auth_user->GetOrRefreshCountryCode();
        }

        if (Settings::Get('settings_donations_taxes_euvat')) {
            $taxes = EuropeVAT::addTax($amount, $countrycode);

            $taxes['note'] = '';

            if ($taxes['taxRate'] == 0) {
                $taxes['unknown'] = true;
            } else {
                $taxes['unknown'] = false;
            }
        }

        if ('[]' != Settings::Get('settings_donations_taxes_countryspecific')) {
            $countryspecific_values = FromJson(Settings::Get('settings_donations_taxes_countryspecific'));

            if (sizeof($countryspecific_values) > 0) {
                $customfound = false;
                $globalfound = false;

                foreach ($countryspecific_values as $cv) {
                    if ($cv['country'] == $countrycode) {
                        $ratePercent = $cv['tax'] / 100;

                        $taxAmount = $amount * $ratePercent;
                        $total = $amount + $taxAmount;

                        $taxes = array('taxRate' => $cv['tax'], 'taxAmount' => $taxAmount, 'total' => $total, 'unknown' => false, 'note' => $cv['note']);

                        $customfound = true;
                    }

                    if ('GLOBAL' == $cv['country']) {
                        $globalfound = $cv;
                    }
                }

                if (!$customfound && $globalfound) {
                    $cv = $globalfound;

                    $ratePercent = $cv['tax'] / 100;

                    $taxAmount = $amount * $ratePercent;
                    $total = $amount + $taxAmount;

                    $taxes = array('taxRate' => $cv['tax'], 'taxAmount' => $taxAmount, 'total' => $total, 'unknown' => false, 'note' => $cv['note']);
                }
            }
        }

        $taxes['country'] = ($countrycode != null ? $countrycode : '');
        $taxes['total'] = FormatPrice($taxes['total']);
        $taxes['taxAmount'] = FormatPrice($taxes['taxAmount']);

        if (!Settings::Get('settings_donations_taxes_add') || $iscustom) {
            $taxes['total'] = $amount;
            $taxes['taxAmount'] = FormatPrice($amount - ($amount / (1 + ($taxes['taxRate'] / 100))));
        }

        if (Settings::Get('settings_donations_taxes_add')) {
            $taxes['netAmount'] = $amount;
        } else {
            $taxes['netAmount'] = $amount - $taxes['taxAmount'];
        }

        return $taxes;
    }

    function CreateDirectory($path)
    {
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
    }

    function DeleteRecursively($path, $match)
    {
        $dirs = glob($path.'*');
        $files = glob($path.$match);
        foreach ($files as $file) {
            if (is_file($file)) {
                unlink($file);
            }
        }
        foreach ($dirs as $dir) {
            if (is_dir($dir)) {
                $dir = basename($dir).'/';
                DeleteRecursively($path.$dir, $match);
            }
        }
    }

    function GenerateResubmitToken()
    {
        global $currentPage;

        if (!isset($_SESSION['__resubmit'][$currentPage['rawname']]) || !is_array($_SESSION['__resubmit'][$currentPage['rawname']])) {
            $_SESSION['__resubmit'][$currentPage['rawname']] = array();
        }

        $token = random_string(25);

        $_SESSION['__resubmit'][$currentPage['rawname']][] = $token;

        return $token;
    }

    function GenerateCSRFToken()
    {
        if (!isset($_SESSION['__token']) || !is_array($_SESSION['__token'])) {
            $_SESSION['__token'] = array();
        }

        $token = random_string(25);

        $_SESSION['__token'][] = $token;

        return $token;
    }

    function CheckCSRFToken()
    {
        global $currentPage;

        if (isset($_SESSION['__token']) && isset($_POST['__token']) && is_array($_SESSION['__token'])) {
            if (in_array($_POST['__token'], $_SESSION['__token'])) {
                DeleteElementFromArray($_POST['__token'], $_SESSION['__token']);

                return true;
            } elseif (isset($_POST['__resubmit'])
            && isset($_SESSION['__resubmit'])
            && isset($_SESSION['__resubmit'][$currentPage['rawname']])
            && is_array($_SESSION['__resubmit'][$currentPage['rawname']])
            && in_array($_POST['__resubmit'], $_SESSION['__resubmit'][$currentPage['rawname']])) {
                return true;
            } else {
                DirectNotifications::Queue('title: "'.Lang('error').'", text: "CSRF token mismatch", type: "error"');
            }
        } else {
            DirectNotifications::Queue('title: "'.Lang('error').'", text: "CSRF token missing", type: "error"');
        }

        return false;
    }

    function DeleteElementFromArray($element, &$array)
    {
        $index = array_search($element, $array);
        if (false !== $index) {
            unset($array[$index]);
        }
    }

    $LANGUAGES = array(
          'ab' => array(
            'name' => 'Abkhaz',
            'nativeName' => 'аҧсуа',
          ),
          'aa' => array(
            'name' => 'Afar',
            'nativeName' => 'Afaraf',
          ),
          'af' => array(
            'name' => 'Afrikaans',
            'nativeName' => 'Afrikaans',
          ),
          'ak' => array(
            'name' => 'Akan',
            'nativeName' => 'Akan',
          ),
          'sq' => array(
            'name' => 'Albanian',
            'nativeName' => 'Shqip',
          ),
          'am' => array(
            'name' => 'Amharic',
            'nativeName' => 'አማርኛ',
          ),
          'ar' => array(
            'name' => 'Arabic',
            'nativeName' => 'العربية',
          ),
          'an' => array(
            'name' => 'Aragonese',
            'nativeName' => 'Aragonés',
          ),
          'hy' => array(
            'name' => 'Armenian',
            'nativeName' => 'Հայերեն',
          ),
          'as' => array(
            'name' => 'Assamese',
            'nativeName' => 'অসমীয়া',
          ),
          'av' => array(
            'name' => 'Avaric',
            'nativeName' => 'авар мацӀ, магӀарул мацӀ',
          ),
          'ae' => array(
            'name' => 'Avestan',
            'nativeName' => 'avesta',
          ),
          'ay' => array(
            'name' => 'Aymara',
            'nativeName' => 'aymar aru',
          ),
          'az' => array(
            'name' => 'Azerbaijani',
            'nativeName' => 'azərbaycan dili',
          ),
          'bm' => array(
            'name' => 'Bambara',
            'nativeName' => 'bamanankan',
          ),
          'ba' => array(
            'name' => 'Bashkir',
            'nativeName' => 'башҡорт теле',
          ),
          'eu' => array(
            'name' => 'Basque',
            'nativeName' => 'euskara, euskera',
          ),
          'be' => array(
            'name' => 'Belarusian',
            'nativeName' => 'Беларуская',
          ),
          'bn' => array(
            'name' => 'Bengali',
            'nativeName' => 'বাংলা',
          ),
          'bh' => array(
            'name' => 'Bihari',
            'nativeName' => 'भोजपुरी',
          ),
          'bi' => array(
            'name' => 'Bislama',
            'nativeName' => 'Bislama',
          ),
          'bs' => array(
            'name' => 'Bosnian',
            'nativeName' => 'bosanski jezik',
          ),
          'br' => array(
            'name' => 'Breton',
            'nativeName' => 'brezhoneg',
          ),
          'bg' => array(
            'name' => 'Bulgarian',
            'nativeName' => 'български език',
          ),
          'my' => array(
            'name' => 'Burmese',
            'nativeName' => 'ဗမာစာ',
          ),
          'ca' => array(
            'name' => 'Catalan; Valencian',
            'nativeName' => 'Català',
          ),
          'ch' => array(
            'name' => 'Chamorro',
            'nativeName' => 'Chamoru',
          ),
          'ce' => array(
            'name' => 'Chechen',
            'nativeName' => 'нохчийн мотт',
          ),
          'ny' => array(
            'name' => 'Chichewa; Chewa; Nyanja',
            'nativeName' => 'chiCheŵa, chinyanja',
          ),
          'zh' => array(
            'name' => 'Chinese',
            'nativeName' => '中文 (Zhōngwén), 汉语, 漢語',
          ),
          'cv' => array(
            'name' => 'Chuvash',
            'nativeName' => 'чӑваш чӗлхи',
          ),
          'kw' => array(
            'name' => 'Cornish',
            'nativeName' => 'Kernewek',
          ),
          'co' => array(
            'name' => 'Corsican',
            'nativeName' => 'corsu, lingua corsa',
          ),
          'cr' => array(
            'name' => 'Cree',
            'nativeName' => 'ᓀᐦᐃᔭᐍᐏᐣ',
          ),
          'hr' => array(
            'name' => 'Croatian',
            'nativeName' => 'hrvatski',
          ),
          'cs' => array(
            'name' => 'Czech',
            'nativeName' => 'česky, čeština',
          ),
          'da' => array(
            'name' => 'Danish',
            'nativeName' => 'dansk',
          ),
          'dv' => array(
            'name' => 'Divehi; Dhivehi; Maldivian;',
            'nativeName' => 'ދިވެހި',
          ),
          'nl' => array(
            'name' => 'Dutch',
            'nativeName' => 'Nederlands, Vlaams',
          ),
          'en' => array(
            'name' => 'English',
            'nativeName' => 'English',
          ),
          'eo' => array(
            'name' => 'Esperanto',
            'nativeName' => 'Esperanto',
          ),
          'et' => array(
            'name' => 'Estonian',
            'nativeName' => 'eesti, eesti keel',
          ),
          'ee' => array(
            'name' => 'Ewe',
            'nativeName' => 'Eʋegbe',
          ),
          'fo' => array(
            'name' => 'Faroese',
            'nativeName' => 'føroyskt',
          ),
          'fj' => array(
            'name' => 'Fijian',
            'nativeName' => 'vosa Vakaviti',
          ),
          'fi' => array(
            'name' => 'Finnish',
            'nativeName' => 'suomi, suomen kieli',
          ),
          'fr' => array(
            'name' => 'French',
            'nativeName' => 'français, langue française',
          ),
          'ff' => array(
            'name' => 'Fula; Fulah; Pulaar; Pular',
            'nativeName' => 'Fulfulde, Pulaar, Pular',
          ),
          'gl' => array(
            'name' => 'Galician',
            'nativeName' => 'Galego',
          ),
          'ka' => array(
            'name' => 'Georgian',
            'nativeName' => 'ქართული',
          ),
          'de' => array(
            'name' => 'German',
            'nativeName' => 'Deutsch',
          ),
          'el' => array(
            'name' => 'Greek, Modern',
            'nativeName' => 'Ελληνικά',
          ),
          'gn' => array(
            'name' => 'Guaraní',
            'nativeName' => 'Avañeẽ',
          ),
          'gu' => array(
            'name' => 'Gujarati',
            'nativeName' => 'ગુજરાતી',
          ),
          'ht' => array(
            'name' => 'Haitian; Haitian Creole',
            'nativeName' => 'Kreyòl ayisyen',
          ),
          'ha' => array(
            'name' => 'Hausa',
            'nativeName' => 'Hausa, هَوُسَ',
          ),
          'he' => array(
            'name' => 'Hebrew (modern)',
            'nativeName' => 'עברית',
          ),
          'hz' => array(
            'name' => 'Herero',
            'nativeName' => 'Otjiherero',
          ),
          'hi' => array(
            'name' => 'Hindi',
            'nativeName' => 'हिन्दी, हिंदी',
          ),
          'ho' => array(
            'name' => 'Hiri Motu',
            'nativeName' => 'Hiri Motu',
          ),
          'hu' => array(
            'name' => 'Hungarian',
            'nativeName' => 'Magyar',
          ),
          'ia' => array(
            'name' => 'Interlingua',
            'nativeName' => 'Interlingua',
          ),
          'id' => array(
            'name' => 'Indonesian',
            'nativeName' => 'Bahasa Indonesia',
          ),
          'ie' => array(
            'name' => 'Interlingue',
            'nativeName' => 'Originally called Occidental; then Interlingue after WWII',
          ),
          'ga' => array(
            'name' => 'Irish',
            'nativeName' => 'Gaeilge',
          ),
          'ig' => array(
            'name' => 'Igbo',
            'nativeName' => 'Asụsụ Igbo',
          ),
          'ik' => array(
            'name' => 'Inupiaq',
            'nativeName' => 'Iñupiaq, Iñupiatun',
          ),
          'io' => array(
            'name' => 'Ido',
            'nativeName' => 'Ido',
          ),
          'is' => array(
            'name' => 'Icelandic',
            'nativeName' => 'Íslenska',
          ),
          'it' => array(
            'name' => 'Italian',
            'nativeName' => 'Italiano',
          ),
          'iu' => array(
            'name' => 'Inuktitut',
            'nativeName' => 'ᐃᓄᒃᑎᑐᑦ',
          ),
          'ja' => array(
            'name' => 'Japanese',
            'nativeName' => '日本語 (にほんご／にっぽんご)',
          ),
          'jv' => array(
            'name' => 'Javanese',
            'nativeName' => 'basa Jawa',
          ),
          'kl' => array(
            'name' => 'Kalaallisut, Greenlandic',
            'nativeName' => 'kalaallisut, kalaallit oqaasii',
          ),
          'kn' => array(
            'name' => 'Kannada',
            'nativeName' => 'ಕನ್ನಡ',
          ),
          'kr' => array(
            'name' => 'Kanuri',
            'nativeName' => 'Kanuri',
          ),
          'ks' => array(
            'name' => 'Kashmiri',
            'nativeName' => 'कश्मीरी, كشميري‎',
          ),
          'kk' => array(
            'name' => 'Kazakh',
            'nativeName' => 'Қазақ тілі',
          ),
          'km' => array(
            'name' => 'Khmer',
            'nativeName' => 'ភាសាខ្មែរ',
          ),
          'ki' => array(
            'name' => 'Kikuyu, Gikuyu',
            'nativeName' => 'Gĩkũyũ',
          ),
          'rw' => array(
            'name' => 'Kinyarwanda',
            'nativeName' => 'Ikinyarwanda',
          ),
          'ky' => array(
            'name' => 'Kirghiz, Kyrgyz',
            'nativeName' => 'кыргыз тили',
          ),
          'kv' => array(
            'name' => 'Komi',
            'nativeName' => 'коми кыв',
          ),
          'kg' => array(
            'name' => 'Kongo',
            'nativeName' => 'KiKongo',
          ),
          'ko' => array(
            'name' => 'Korean',
            'nativeName' => '한국어 (韓國語), 조선말 (朝鮮語)',
          ),
          'ku' => array(
            'name' => 'Kurdish',
            'nativeName' => 'Kurdî, كوردی‎',
          ),
          'kj' => array(
            'name' => 'Kwanyama, Kuanyama',
            'nativeName' => 'Kuanyama',
          ),
          'la' => array(
            'name' => 'Latin',
            'nativeName' => 'latine, lingua latina',
          ),
          'lb' => array(
            'name' => 'Luxembourgish, Letzeburgesch',
            'nativeName' => 'Lëtzebuergesch',
          ),
          'lg' => array(
            'name' => 'Luganda',
            'nativeName' => 'Luganda',
          ),
          'li' => array(
            'name' => 'Limburgish, Limburgan, Limburger',
            'nativeName' => 'Limburgs',
          ),
          'ln' => array(
            'name' => 'Lingala',
            'nativeName' => 'Lingála',
          ),
          'lo' => array(
            'name' => 'Lao',
            'nativeName' => 'ພາສາລາວ',
          ),
          'lt' => array(
            'name' => 'Lithuanian',
            'nativeName' => 'lietuvių kalba',
          ),
          'lu' => array(
            'name' => 'Luba-Katanga',
            'nativeName' => '',
          ),
          'lv' => array(
            'name' => 'Latvian',
            'nativeName' => 'latviešu valoda',
          ),
          'gv' => array(
            'name' => 'Manx',
            'nativeName' => 'Gaelg, Gailck',
          ),
          'mk' => array(
            'name' => 'Macedonian',
            'nativeName' => 'македонски јазик',
          ),
          'mg' => array(
            'name' => 'Malagasy',
            'nativeName' => 'Malagasy fiteny',
          ),
          'ms' => array(
            'name' => 'Malay',
            'nativeName' => 'bahasa Melayu, بهاس ملايو‎',
          ),
          'ml' => array(
            'name' => 'Malayalam',
            'nativeName' => 'മലയാളം',
          ),
          'mt' => array(
            'name' => 'Maltese',
            'nativeName' => 'Malti',
          ),
          'mi' => array(
            'name' => 'Māori',
            'nativeName' => 'te reo Māori',
          ),
          'mr' => array(
            'name' => 'Marathi (Marāṭhī)',
            'nativeName' => 'मराठी',
          ),
          'mh' => array(
            'name' => 'Marshallese',
            'nativeName' => 'Kajin M̧ajeļ',
          ),
          'mn' => array(
            'name' => 'Mongolian',
            'nativeName' => 'монгол',
          ),
          'na' => array(
            'name' => 'Nauru',
            'nativeName' => 'Ekakairũ Naoero',
          ),
          'nv' => array(
            'name' => 'Navajo, Navaho',
            'nativeName' => 'Diné bizaad, Dinékʼehǰí',
          ),
          'nb' => array(
            'name' => 'Norwegian Bokmål',
            'nativeName' => 'Norsk bokmål',
          ),
          'nd' => array(
            'name' => 'North Ndebele',
            'nativeName' => 'isiNdebele',
          ),
          'ne' => array(
            'name' => 'Nepali',
            'nativeName' => 'नेपाली',
          ),
          'ng' => array(
            'name' => 'Ndonga',
            'nativeName' => 'Owambo',
          ),
          'nn' => array(
            'name' => 'Norwegian Nynorsk',
            'nativeName' => 'Norsk nynorsk',
          ),
          'no' => array(
            'name' => 'Norwegian',
            'nativeName' => 'Norsk',
          ),
          'ii' => array(
            'name' => 'Nuosu',
            'nativeName' => 'ꆈꌠ꒿ Nuosuhxop',
          ),
          'nr' => array(
            'name' => 'South Ndebele',
            'nativeName' => 'isiNdebele',
          ),
          'oc' => array(
            'name' => 'Occitan',
            'nativeName' => 'Occitan',
          ),
          'oj' => array(
            'name' => 'Ojibwe, Ojibwa',
            'nativeName' => 'ᐊᓂᔑᓈᐯᒧᐎᓐ',
          ),
          'cu' => array(
            'name' => 'Old Church Slavonic, Church Slavic, Church Slavonic, Old Bulgarian, Old Slavonic',
            'nativeName' => 'ѩзыкъ словѣньскъ',
          ),
          'om' => array(
            'name' => 'Oromo',
            'nativeName' => 'Afaan Oromoo',
          ),
          'or' => array(
            'name' => 'Oriya',
            'nativeName' => 'ଓଡ଼ିଆ',
          ),
          'os' => array(
            'name' => 'Ossetian, Ossetic',
            'nativeName' => 'ирон æвзаг',
          ),
          'pa' => array(
            'name' => 'Panjabi, Punjabi',
            'nativeName' => 'ਪੰਜਾਬੀ, پنجابی‎',
          ),
          'pi' => array(
            'name' => 'Pāli',
            'nativeName' => 'पाऴि',
          ),
          'fa' => array(
            'name' => 'Persian',
            'nativeName' => 'فارسی',
          ),
          'pl' => array(
            'name' => 'Polish',
            'nativeName' => 'polski',
          ),
          'ps' => array(
            'name' => 'Pashto, Pushto',
            'nativeName' => 'پښتو',
          ),
          'pt' => array(
            'name' => 'Portuguese',
            'nativeName' => 'Português',
          ),
          'qu' => array(
            'name' => 'Quechua',
            'nativeName' => 'Runa Simi, Kichwa',
          ),
          'rm' => array(
            'name' => 'Romansh',
            'nativeName' => 'rumantsch grischun',
          ),
          'rn' => array(
            'name' => 'Kirundi',
            'nativeName' => 'kiRundi',
          ),
          'ro' => array(
            'name' => 'Romanian, Moldavian, Moldovan',
            'nativeName' => 'română',
          ),
          'ru' => array(
            'name' => 'Russian',
            'nativeName' => 'русский язык',
          ),
          'sa' => array(
            'name' => 'Sanskrit (Saṁskṛta)',
            'nativeName' => 'संस्कृतम्',
          ),
          'sc' => array(
            'name' => 'Sardinian',
            'nativeName' => 'sardu',
          ),
          'sd' => array(
            'name' => 'Sindhi',
            'nativeName' => 'सिन्धी, سنڌي، سندھی‎',
          ),
          'se' => array(
            'name' => 'Northern Sami',
            'nativeName' => 'Davvisámegiella',
          ),
          'sm' => array(
            'name' => 'Samoan',
            'nativeName' => 'gagana faa Samoa',
          ),
          'sg' => array(
            'name' => 'Sango',
            'nativeName' => 'yângâ tî sängö',
          ),
          'sr' => array(
            'name' => 'Serbian',
            'nativeName' => 'српски језик',
          ),
          'gd' => array(
            'name' => 'Scottish Gaelic; Gaelic',
            'nativeName' => 'Gàidhlig',
          ),
          'sn' => array(
            'name' => 'Shona',
            'nativeName' => 'chiShona',
          ),
          'si' => array(
            'name' => 'Sinhala, Sinhalese',
            'nativeName' => 'සිංහල',
          ),
          'sk' => array(
            'name' => 'Slovak',
            'nativeName' => 'slovenčina',
          ),
          'sl' => array(
            'name' => 'Slovene',
            'nativeName' => 'slovenščina',
          ),
          'so' => array(
            'name' => 'Somali',
            'nativeName' => 'Soomaaliga, af Soomaali',
          ),
          'st' => array(
            'name' => 'Southern Sotho',
            'nativeName' => 'Sesotho',
          ),
          'es' => array(
            'name' => 'Spanish; Castilian',
            'nativeName' => 'español, castellano',
          ),
          'su' => array(
            'name' => 'Sundanese',
            'nativeName' => 'Basa Sunda',
          ),
          'sw' => array(
            'name' => 'Swahili',
            'nativeName' => 'Kiswahili',
          ),
          'ss' => array(
            'name' => 'Swati',
            'nativeName' => 'SiSwati',
          ),
          'sv' => array(
            'name' => 'Swedish',
            'nativeName' => 'svenska',
          ),
          'ta' => array(
            'name' => 'Tamil',
            'nativeName' => 'தமிழ்',
          ),
          'te' => array(
            'name' => 'Telugu',
            'nativeName' => 'తెలుగు',
          ),
          'tg' => array(
            'name' => 'Tajik',
            'nativeName' => 'тоҷикӣ, toğikī, تاجیکی‎',
          ),
          'th' => array(
            'name' => 'Thai',
            'nativeName' => 'ไทย',
          ),
          'ti' => array(
            'name' => 'Tigrinya',
            'nativeName' => 'ትግርኛ',
          ),
          'bo' => array(
            'name' => 'Tibetan Standard, Tibetan, Central',
            'nativeName' => 'བོད་ཡིག',
          ),
          'tk' => array(
            'name' => 'Turkmen',
            'nativeName' => 'Türkmen, Түркмен',
          ),
          'tl' => array(
            'name' => 'Tagalog',
            'nativeName' => 'Wikang Tagalog, ᜏᜒᜃᜅ᜔ ᜆᜄᜎᜓᜄ᜔',
          ),
          'tn' => array(
            'name' => 'Tswana',
            'nativeName' => 'Setswana',
          ),
          'to' => array(
            'name' => 'Tonga (Tonga Islands)',
            'nativeName' => 'faka Tonga',
          ),
          'tr' => array(
            'name' => 'Turkish',
            'nativeName' => 'Türkçe',
          ),
          'ts' => array(
            'name' => 'Tsonga',
            'nativeName' => 'Xitsonga',
          ),
          'tt' => array(
            'name' => 'Tatar',
            'nativeName' => 'татарча, tatarça, تاتارچا‎',
          ),
          'tw' => array(
            'name' => 'Twi',
            'nativeName' => 'Twi',
          ),
          'ty' => array(
            'name' => 'Tahitian',
            'nativeName' => 'Reo Tahiti',
          ),
          'ug' => array(
            'name' => 'Uighur, Uyghur',
            'nativeName' => 'Uyƣurqə, ئۇيغۇرچە‎',
          ),
          'uk' => array(
            'name' => 'Ukrainian',
            'nativeName' => 'українська',
          ),
          'ur' => array(
            'name' => 'Urdu',
            'nativeName' => 'اردو',
          ),
          'uz' => array(
            'name' => 'Uzbek',
            'nativeName' => 'zbek, Ўзбек, أۇزبېك‎',
          ),
          've' => array(
            'name' => 'Venda',
            'nativeName' => 'Tshivenḓa',
          ),
          'vi' => array(
            'name' => 'Vietnamese',
            'nativeName' => 'Tiếng Việt',
          ),
          'vo' => array(
            'name' => 'Volapük',
            'nativeName' => 'Volapük',
          ),
          'wa' => array(
            'name' => 'Walloon',
            'nativeName' => 'Walon',
          ),
          'cy' => array(
            'name' => 'Welsh',
            'nativeName' => 'Cymraeg',
          ),
          'wo' => array(
            'name' => 'Wolof',
            'nativeName' => 'Wollof',
          ),
          'fy' => array(
            'name' => 'Western Frisian',
            'nativeName' => 'Frysk',
          ),
          'xh' => array(
            'name' => 'Xhosa',
            'nativeName' => 'isiXhosa',
          ),
          'yi' => array(
            'name' => 'Yiddish',
            'nativeName' => 'ייִדיש',
          ),
          'yo' => array(
            'name' => 'Yoruba',
            'nativeName' => 'Yorùbá',
          ),
          'za' => array(
            'name' => 'Zhuang, Chuang',
            'nativeName' => 'Saɯ cueŋƅ, Saw cuengh',
          ),
        );
