<!--{"language":"adverts","icon":"fa-envelope","place":"admin","position":50}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['admin_adverts_edit_save'])) {
            if (is_numeric($_POST['admin_adverts_edit_id'])) {
                $bundles = array();

                if (isset($_POST['admin_adverts_edit_serverbundles'])) {
                    $bundles = $_POST['admin_adverts_edit_serverbundles'];
                }

                $data = array(
                    'title' => htmlspecialchars($_POST['admin_adverts_edit_title']),
                    'content' => $_POST['admin_adverts_edit_text'],
                    'color' => htmlspecialchars($_POST['admin_adverts_edit_color']),
                    'active' => isset($_POST['admin_adverts_edit_active']),
                    'serverbundles' => ToJson($bundles),
                );

                $db->where('id', $_POST['admin_adverts_edit_id']);

                if ($db->update('adverts', $data)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                }
            }
        } elseif (isset($_POST['admin_adverts_edit_delete'])) {
            if (is_numeric($_POST['admin_adverts_edit_id'])) {
                $db->where('id', $_POST['admin_adverts_edit_id']);

                if ($db->delete('adverts')) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('advert_deleted_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
                }
            }
        } elseif (isset($_POST['admin_adverts_add_save'])) {
            $bundles = array();

            if (isset($_POST['admin_adverts_add_serverbundles'])) {
                $bundles = $_POST['admin_adverts_add_serverbundles'];
            }

            $data = array(
                'title' => htmlspecialchars($_POST['admin_adverts_add_title']),
                'content' => $_POST['admin_adverts_add_text'],
                'color' => htmlspecialchars($_POST['admin_adverts_add_color']),
                'active' => isset($_POST['admin_adverts_add_active']),
                'orderid' => 0,
                'serverbundles' => ToJson($bundles),
            );

            if ($db->insert('adverts', $data)) {
                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('advert_created_success').'", type: "success"');
            } else {
                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
            }
        }
    }
?>

<!-- Bootstrap ColorPicker CSS -->
<link rel="stylesheet" href="assets/css/bootstrap.colorpickersliders.css">
<!-- Bootstrap Multiselect CSS -->
<link rel="stylesheet" href="assets/css/bootstrap-multiselect.css">

<!-- Bootstrap TinyColor JS -->
<script src='assets/js/tinycolor-min.js'></script>
<!-- Bootstrap ColorPicker JS | Requires tinycolor -->
<script src='assets/js/bootstrap.colorpickersliders.js'></script>
<!-- Sortable JS-->
<script src="assets/js/sortable.js"></script>
<!-- Bootstrap Multiselect JS -->
<script src="assets/js/bootstrap-multiselect.js"></script>

<div class="row">
	<div class="col-md-12">
		<h1 class="page-header">
			<?php echo Lang('adverts'); ?>

			<div class="pull-right">
				<?php echo !isset($_GET['sort']) ? '<a href="index.php?t=admin_adverts&sort"><button class="btn btn-warning"><i class="fa fa-sort"></i></button></a>' : '<a href="index.php?t=admin_adverts"><button class="btn btn-warning"><i class="fa fa-pencil"></i></button></a>'; ?>
				<button onclick="admin_adverts_new();" type="button" class="btn btn-success"><i class="fa fa-plus-circle"></i> <?php echo Lang('advert_create'); ?></button>
			</div>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-md-12 <?php echo isset($_GET['sort']) ? 'sortable' : ''; ?>">
		<?php
            $adverts = Adverts::GetAll();
            foreach ($adverts as $advert) {
                echo '
					<div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<a data-toggle="'.(!isset($_GET['sort']) ? 'collapse' : '').'" href="#admin_faq_collapse_'.$advert['id'].'">'.$advert['title'].'</a>
								'.(isset($_GET['sort']) ? '<span class="pull-right"><i class="fa fa-sort cursor-sortable"></i></span>' : '').'
							</h4>
						</div>
						<div id="admin_faq_collapse_'.$advert['id'].'" class="panel-collapse collapse">

							<form action="index.php?t=admin_adverts" method="POST">
								<div class="panel-body">
									<input name="admin_adverts_edit_id" class="admin_adverts_advert_id" type="hidden" value="'.$advert['id'].'" />

									<label>'.Lang('title').'</label><br>
									<input name="admin_adverts_edit_title" class="form-control" placeholder="'.Lang('title').'" value="'.$advert['title'].'" />
									<br />

									<label>'.Lang('text').'</label><span class="pull-right">';
                CreateTooltip(Lang('newline_usable'), 'left');
                echo '</span><br>
									<textarea rows="5" class="form-control" style="resize:vertical;" name="admin_adverts_edit_text">'.$advert['content'].'</textarea>

									<br>
									<div class="row">
										<div class="col-sm-4">
											<label>'.Lang('enabled').'</label><br>
										';
                CreateCheckbox('primary', 'admin_adverts_edit_active_'.$advert['id'], 'admin_adverts_edit_active_'.$advert['id'], Lang('advert_enable'), '', 'admin_adverts_edit_active');
                echo '
										</div>

										<div class="col-sm-4">
											<label>'.Lang('color').'</label><br>
				                            <input value="'.$advert['color'].'" class="form-control admin_adverts_color" name="admin_adverts_edit_color">
										</div>

										<div class="col-sm-4">
											<label>'.Lang('bundles').'</label><br>
											<select name="admin_adverts_edit_serverbundles[]" id="admin_adverts_serverbundles_'.$advert['id'].'" class="admin_adverts_serverbundles" multiple>';
                foreach (Serverbundle::GetAll() as $serverbundle) {
                    echo '<option value="'.$serverbundle->GetValue('id').'">'.$serverbundle->GetValue('name').'</option>';
                }
                echo '
											</select>
										</div>
									</div>

								</div>
								<div class="panel-footer">
									<button name="admin_adverts_edit_save" class="btn btn-primary">'.Lang('save').'</button>
									<button name="admin_adverts_edit_delete" class="btn btn-danger"><i class="fa fa-trash"></i></button>
								</div>
							</form>
						</div>
					</div>

					<script>
						$(".admin_adverts_edit_active_'.$advert['id'].'").prop("checked", '.$advert['active'].');';

                $bundles = FromJson($advert['serverbundles']);

                foreach ($bundles as $bundle) {
                    echo '$("#admin_adverts_serverbundles_'.$advert['id'].'").multiselect("select", '.$bundle.');';
                }

                echo '
					</script>
				';
            }

            if (!sizeof($adverts)) {
                echo '<i>'.Lang('no_entries').'</i>';
            } else {
                echo isset($_GET['sort']) ? '<button onclick="admin_adverts_order_save();" class="btn btn-sm btn-primary">
						'.Lang('order_save').'
					</button>' : '';
            }
        ?>


	</div>
</div>

<!-- Create advert Modal -->
<div class="modal fade" id="admin_adverts_add_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-envelope"></i> &nbsp;<?php echo Lang('advert_create'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_adverts">
				<div class="modal-body">
					<label><?php echo Lang('title'); ?></label><br>
					<input name="admin_adverts_add_title" class="form-control" />
					<br />

					<label><?php echo Lang('text'); ?></label><span class="pull-right"><?php CreateTooltip(Lang('newline_usable'), 'left'); ?></span><br>
					<textarea rows="5" class="form-control" style="resize:vertical;" name="admin_adverts_add_text"></textarea>
					<br />

					<div class="row">
						<div class="col-sm-4">
							<label><?php echo Lang('enabled'); ?></label><br>
							<?php CreateCheckbox('primary', 'admin_adverts_add_active', '', Lang('advert_enable')); ?>
						</div>

						<div class="col-sm-4">
							<label><?php echo Lang('color'); ?></label><br>
	                        <input value="#FFFFFF" class="form-control admin_adverts_color" name="admin_adverts_add_color">
						</div>

						<div class="col-sm-4">
							<label><?php echo Lang('bundles'); ?></label><br>
							<select name="admin_adverts_add_serverbundles[]" class="admin_adverts_serverbundles" multiple>
								<?php
                                    foreach (Serverbundle::GetAll() as $serverbundle) {
                                        echo '<option value="'.$serverbundle->GetValue('id').'">'.$serverbundle->GetValue('name').'</option>';
                                    }
                                ?>
							</select>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" name="admin_adverts_add_save" class="btn btn-success"><?php echo Lang('create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
	$('.sortable').each(function(i, obj){
		new Sortable(obj);
	});

	function admin_adverts_new(){
		$('#admin_adverts_add_modal').modal('show');
	}

	$( document ).ready(function() {
        $('.admin_adverts_color').ColorPickerSliders({
	        previewformat: 'hex',
	        sliders: false,
	        swatches: false,
	        hsvpanel: true
	    });

        $('.admin_adverts_serverbundles').multiselect();
    });

    function admin_adverts_order_save(){
		var adverts = [];

    	$('.admin_adverts_advert_id').each(function(i, obj){
			adverts[$(obj).val()] = i;
		});

		$.getJSON('request.php?t=admin_adverts&order=' + JSON.stringify(adverts), function(data) {
			if(data['success']){
				new PNotify({
				    title: '<?php echo Lang('success'); ?>',
				    text: '<?php echo Lang('order_saved'); ?>',
				    type: 'success'
				});
			}else{
				new PNotify({
				    title: '<?php echo Lang('error'); ?>',
				    text: data['error'],
				    type: 'error'
				});
			}
		});
    }
</script>