<!--{"language":"bans","icon":"fa-minus-circle","place":"admin","position":20}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['admin_bans_modal_add_form_submit'])) {
            $steamid = trim(htmlspecialchars($_POST['admin_bans_modal_add_form_steamid']));
            $length = $_POST['admin_bans_modal_add_form_length'];
            $reason = $_POST['admin_bans_modal_add_form_reason'];
            $serverbundle = htmlspecialchars($_POST['admin_bans_modal_add_form_serverbundle']);

            $global = 0;

            if (isset($_POST['admin_bans_modal_add_form_global'])) {
                $global = 1;
            }

            if (is_numeric($length) && is_numeric($serverbundle) && !empty($steamid)) {
                if (Permissions::HasPermission('super') || (Permissions::HasPermission('bans_add', $auth_user->GetGroup($serverbundle)) || $global) && (Permissions::HasPermission('bans_global') || !$global)) {
                    $found = false;

                    if (!is_numeric($steamid)) {
                        $user = new User($steamid);

                        if ($user->valid) {
                            $steamid = $user->GetValue('steamid64');
                            $found = true;
                        }
                    } else {
                        $found = true;
                    }

                    if ($found) {
                        if (Bans::CanBan($steamid, $length, $serverbundle)) {
                            if (Bans::Add($steamid, $length, $reason, $auth_user->GetValue('steamid64'), $serverbundle, $global)) {
                                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('user_banned_success').'", type: "success"');
                            } else {
                                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
                            }
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('lengthlimit_reached_or_noperm').'", type: "error"');
                        }
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('steamid_invalid').'", type: "error"');
                    }
                } else {
                    PermissionsError();
                }
            }
        } elseif (isset($_POST['admin_bans_modal_edit_form_submit'])) {
            $length = $_POST['admin_bans_modal_edit_form_length'];
            $reason = $_POST['admin_bans_modal_edit_form_reason'];
            $id = $_POST['admin_bans_modal_edit_form_id'];
            $serverbundle = htmlspecialchars($_POST['admin_bans_modal_edit_form_serverbundle']);

            $global = 0;

            if (isset($_POST['admin_bans_modal_edit_form_global'])) {
                $global = 1;
            }

            if (is_numeric($length) && is_numeric($id)) {
                $db->where('id', $id);
                $ban = $db->getOne('bans');

                if ($db->count) {
                    if (Permissions::HasPermission('super') || (Permissions::HasPermission('bans_edit', $auth_user->GetGroup($serverbundle)) || $global) && (Permissions::HasPermission('bans_edit', $auth_user->GetGroup($ban['serverbundle'])) || $ban['global']) && (Permissions::HasPermission('bans_global') || !$global)) {
                        if (Bans::CanBan($ban['steamid64'], $length, $serverbundle)) {
                            $data = array(
                                'length' => $length,
                                'reason' => $reason,
                                'global' => $global,
                                'serverbundle' => $serverbundle,
                            );

                            $db->where('id', $id);
                            $db->update('bans', $data);

                            if ($db->count) {
                                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('ban_edited_success').'", type: "success"');
                            } else {
                                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                            }
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('lengthlimit_reached_or_noperm').'", type: "error"');
                        }
                    } else {
                        PermissionsError();
                    }
                }
            }
        } elseif (isset($_POST['admin_bans_delete'])) {
            if (is_numeric($_POST['admin_bans_delete'])) {
                $db->where('id', $_POST['admin_bans_delete']);
                $ban = $db->getOne('bans');

                if ($db->count) {
                    if ((Permissions::HasPermission('super') || (Permissions::HasPermission('bans_delete', $auth_user->GetGroup($ban['serverbundle'])) || $ban['global']) && (Permissions::HasPermission('bans_global') || !$ban['global'])) && Bans::CanBan($ban['steamid64'], $ban['length'], $ban['serverbundle'])) {
                        $db->where('id', $_POST['admin_bans_delete']);
                        $db->update('bans', array('status' => 2));

                        if ($db->count) {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('ban_deleted_success').'", type: "success"');
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
                        }
                    } else {
                        PermissionsError();
                    }
                }
            }
        } elseif (isset($_POST['admin_bans_unban'])) {
            if (is_numeric($_POST['admin_bans_unban'])) {
                $db->where('id', $_POST['admin_bans_unban']);
                $ban = $db->getOne('bans');

                if ($db->count) {
                    if ((Permissions::HasPermission('super') || (Permissions::HasPermission('bans_unban', $auth_user->GetGroup($ban['serverbundle'])) || $ban['global']) && (Permissions::HasPermission('bans_global') || !$ban['global'])) && Bans::CanBan($ban['steamid64'], $ban['length'], $ban['serverbundle'])) {
                        if (Bans::Unban($_POST['admin_bans_unban'], $auth_user->GetValue('steamid64'))) {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('ban_unbanned_success').'", type: "success"');
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                        }
                    } else {
                        PermissionsError();
                    }
                }
            }
        } elseif (isset($_POST['admin_bans_reban'])) {
            if (is_numeric($_POST['admin_bans_reban'])) {
                $db->where('id', $_POST['admin_bans_reban']);
                $ban = $db->getOne('bans');

                if ($db->count) {
                    if ((Permissions::HasPermission('super') || (Permissions::HasPermission('bans_unban', $auth_user->GetGroup($ban['serverbundle'])) || $ban['global']) && (Permissions::HasPermission('bans_global') || !$ban['global'])) && Bans::CanBan($ban['steamid64'], $ban['length'], $ban['serverbundle'])) {
                        $db->where('id', $_POST['admin_bans_reban']);
                        $db->update('bans', array('status' => 0));

                        if ($db->count) {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('ban_rebanned_success').'", type: "success"');
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                        }
                    } else {
                        PermissionsError();
                    }
                }
            }
        }
    }

    $banprotests = Banprotest::GetAll(true);
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<span id="admin_bans_header"><?php echo Lang('ban_administration'); ?></span>
			<span class="pull-right">
				<button <?php if (sizeof($banprotests)) {
    echo 'style="border-color: red;"';
} ?> onclick="admin_bans_protests();" class="btn btn-success"><i class="fa fa-unlock"></i> <?php echo Lang('protests'); ?></button>
				<button onclick="admin_bans_add();" class="btn btn-danger"><i class="fa fa-plus-circle"></i> <?php echo Lang('add'); ?></button>
			</span>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<div class="table-responsive">
			<table class="table">
				<tr class="active">
					<th style="width: 0%;">#</th>
					<th><?php echo Lang('user'); ?></th>
					<th><?php echo Lang('reason'); ?></th>
					<th><?php echo Lang('serverbundle'); ?></th>
					<th><?php echo Lang('admin'); ?></th>
					<th><?php echo Lang('date'); ?></th>
					<th><?php echo Lang('length'); ?></th>
					<th style="width: 3%;" class="text-right"><?php echo Lang('details'); ?></th>
				</tr>
				<tbody>
					<?php
                        $page = 1;

                        if (isset($_GET['page'])) {
                            $page = $_GET['page'];
                        }

                        $bans = Bans::GetAll(25, $page);

                        if (isset($_GET['id'])) {
                            $bans = Bans::GetByUser($_GET['id']);
                        }

                        $bandata = '';

                        foreach ($bans as $ban) {
                            $user = new User($ban['steamid64']);

                            $admin = new User($ban['steamid64_admin']);

                            $bundle = new Serverbundle($ban['serverbundle']);

                            $expires = new DateTime($ban['date_banned']);
                            $expires->add(new DateInterval('PT'.$ban['length'].'M'));

                            $now = new DateTime('now');

                            $ban['reason'] = htmlspecialchars($ban['reason']);

                            $clientinfo = $ban;

                            $clientinfo['reason'] = RemoveQuotes($clientinfo['reason']);
                            $clientinfo['expires'] = FormatDate($expires->format('Y-m-d H:i:s'));
                            $clientinfo['date_banned'] = FormatDate($ban['date_banned']);
                            $clientinfo['date_unbanned'] = FormatDate($ban['date_unbanned']);

                            if ($user->valid) {
                                $clientinfo['user'] = RemoveQuotes($user->GetValue('nick'));
                            }

                            if ($admin->valid) {
                                $clientinfo['admin'] = RemoveQuotes($admin->GetValue('nick'));
                            }

                            $clientinfo['admin_unbanned'] = 'undefined';

                            if (isset($ban['steamid64_admin_unbanned'])) {
                                $admin_unbanned = new User($ban['steamid64_admin_unbanned']);

                                if ($admin_unbanned->valid) {
                                    $clientinfo['admin_unbanned'] = $admin_unbanned->GetValue('nick');
                                }
                            }

                            $clientinfo['serverbundle_string'] = '-';

                            if ($ban['global']) {
                                $clientinfo['serverbundle_string'] = Lang('global');
                            } elseif ($bundle->valid) {
                                $clientinfo['serverbundle_string'] = $bundle->GetValue('name');
                            }

                            $clientinfo['length_string'] = SecondsToTimeString($ban['length'] * 60);
                            $clientinfo['expired'] = 0;
                            $clientinfo['protests'] = array();

                            foreach (Banprotest::GetForBan($ban['id']) as $protest) {
                                $in = ' in';

                                $status = Lang('pending');

                                if (1 == $protest->GetValue('status')) {
                                    $status = '<font color=green>'.Lang('accepted').'</font>';
                                    $in = '';
                                } elseif (2 == $protest->GetValue('status')) {
                                    $status = '<font color=red>'.Lang('denied').'</font>';
                                    $in = '';
                                }

                                $protestnew = array(
                                    'id' => $protest->GetValue('id'),
                                    'text' => $protest->GetValue('protesttext'),
                                    'status' => $protest->GetValue('status'),
                                    'status_text' => $status,
                                    'in' => $in,
                                    'date' => $protest->GetValue('date'),
                                );

                                $clientinfo['protests'][] = $protestnew;
                            }

                            if ($now > $expires && $ban['length']) {
                                $clientinfo['expired'] = 1;
                            }

                            $bandata .= 'bandata['.$ban['id'].'] = '.ToJson($clientinfo).';';

                            $class = '';

                            if (1 == $ban['status']) {
                                $class = 'warning';
                            } elseif ($now > $expires && $ban['length']) {
                                $class = 'danger';
                            } elseif ($ban['global']) {
                                $class = 'info';
                            } elseif (0 == $ban['status']) {
                                $class = 'success';
                            }

                            echo '<tr class="'.$class.'">';
                            echo '<td>';
                            echo $ban['id'];
                            echo '</td>';
                            echo '<td>';
                            if ($user->valid) {
                                echo '<a href="index.php?t=user&id='.$user->GetValue('steamid64').'" target="_blank">'.$user->GetValue('nick').'</a>';
                            } else {
                                echo '<a href="http://steamcommunity.com/profiles/'.$ban['steamid64'].'" target="_blank">'.$ban['steamid64'].'</a>';
                            }
                            echo '</td>';
                            echo '<td>';
                            echo $ban['reason'];
                            echo '</td>';
                            echo '<td>';
                            if (!$ban['global'] && $bundle->valid) {
                                echo $bundle->GetValue('name');
                            } elseif (!$ban['global'] && !$bundle->valid) {
                                echo '-';
                            } else {
                                echo '<font color="blue">'.Lang('global').'</font>';
                            }
                            echo '</td>';
                            echo '<td>';
                            if ($admin->valid) {
                                echo '<a href="index.php?t=user&id='.$admin->GetValue('steamid64').'" target="_blank">'.$admin->GetValue('nick').'</a>';
                            } else {
                                echo '<a href="http://steamcommunity.com/profiles/'.$ban['steamid64_admin'].'" target="_blank">'.$ban['steamid64_admin'].'</a>';
                            }
                            echo '</td>';
                            echo '<td>';
                            echo FormatDate($ban['date_banned']);
                            echo '</td>';
                            echo '<td>';
                            echo SecondsToTimeString($ban['length'] * 60);
                            echo '</td>';
                            echo '<td class="text-right">';
                            echo '<button type="button" onclick="admin_bans_details('.$ban['id'].')" class="btn btn-xs btn-danger">'.Lang('details').'</button>';
                            echo '</td>';
                            echo '</tr>';
                        }
                    ?>
				</tbody>
			</table>
		</div>

		<ul class="pager">
			<?php if ($page > 1) {
                        ?>
				<li class="previous"><a href="index.php?t=admin_bans&page=<?php echo $page - 1; ?>"><span aria-hidden="true">&larr;</span> <?php echo Lang('previous'); ?></a></li>
			<?php
                    } ?>

			<?php if (25 == sizeof($bans)) {
                        ?>
				<li class="next"><a href="index.php?t=admin_bans&page=<?php echo $page + 1; ?>"><?php echo Lang('next'); ?> <span aria-hidden="true">&rarr;</span></a></li>
			<?php
                    } ?>
		</ul>

		<?php
            if (Permissions::HasPermission('super')) {
                echo '<br/><a href="index.php?t=admin_import_gban">Import GBan Bans</a>';
            }
        ?>
	</div>
</div>

<!-- BanProtest Modal -->
<div class="modal fade" id="admin_bans_modal_protests" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-unlock"></i> &nbsp;<?php echo Lang('ban_protests'); ?></h4>
			</div>

			<div class="modal-body">
				<?php
                    foreach ($banprotests as $protest) {
                        $db->where('id', $protest->GetValue('banid'));
                        $ban = $db->getOne('bans');
                        if ($db->count) {
                            $user_banned = new User($ban['steamid64']);

                            $nick = $ban['steamid64'];

                            if ($user_banned->valid) {
                                $nick = $user_banned->GetValue('nick');
                            }

                            echo '
								<div class="panel panel-default" id="admin_bans_protest_'.$protest->GetValue('id').'">
									<div class="panel-heading">
										<h4 class="panel-title">
											<a data-toggle="collapse" data-parent="#accordion" href="#admin_bans_protest_collapse_'.$protest->GetValue('id').'">'.$nick.'</a> | <a target="_blank" href="index.php?t=admin_bans&id='.$ban['steamid64'].'"><font color="red">#'.$protest->GetValue('banid').'</font></a>
											<div class="pull-right">
												<a target="_blank" href="index.php?t=user&id='.$ban['steamid64'].'" ><button type="button" class="btn btn-link btn-sm" data-toggle="tooltip" data-placement="top" title="'.Lang('profile').'"><i class="fa fa-user"></i></button></a>
											</div>
										</h4>
									</div>
									<div id="admin_bans_protest_collapse_'.$protest->GetValue('id').'" class="panel-collapse collapse in">
										<div class="panel-body">
											'.$protest->GetValue('protesttext').'
										</div>
										<div class="panel-footer">
											<button onclick="admin_bans_protest_accept_deny('.$protest->GetValue('id').', 1);" name="admin_bans_protest_accept" type="button" class="btn btn-success btn-sm"><i class="fa fa-check"></i> '.Lang('accept').'</button>
											<button onclick="admin_bans_protest_accept_deny('.$protest->GetValue('id').', 0);" name="admin_bans_protest_deny "type="button" class="btn btn-danger btn-sm"><i class="fa fa-times"></i> '.Lang('deny').'</button>
										</div>
									</div>
								</div>
							';
                        }
                    }
                ?>
			</div>
		</div>
	</div>
</div>

<!-- BanDetails Modal -->
<div class="modal fade" id="admin_bans_modal_details" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i id="admin_bans_modal_details_icon"></i> &nbsp;<?php echo Lang('details'); ?>: <span id="admin_bans_modal_details_user_title"></span> <font color="red">#<span id="admin_bans_modal_details_id_title"></span></font></h4>
			</div>

			<div class="modal-body">
				<table class="table table-responsive table-bordered table-striped">
					<tr>
						<td>ID:</td>
						<td id="admin_bans_modal_details_id"></td>
					</tr>
					<tr>
						<td><?php echo Lang('user'); ?>:</td>
						<td id="admin_bans_modal_details_user"></td>
					</tr>
					<tr>
						<td><?php echo Lang('ban_date'); ?>:</td>
						<td id="admin_bans_modal_details_date_banned"></td>
					</tr>
					<tr>
						<td><?php echo Lang('unban_date'); ?>:</td>
						<td id="admin_bans_modal_details_date_unban"></td>
					</tr>
					<tr>
						<td><?php echo Lang('length'); ?>:</td>
						<td id="admin_bans_modal_details_length"></td>
					</tr>
					<tr>
						<td><?php echo Lang('reason'); ?>:</td>
						<td id="admin_bans_modal_details_reason"></td>
					</tr>
					<tr>
						<td><?php echo Lang('admin'); ?>:</td>
						<td id="admin_bans_modal_details_admin"></td>
					</tr>
					<tr>
						<td><?php echo Lang('serverbundle'); ?>:</td>
						<td id="admin_bans_modal_details_serverbundle"></td>
					</tr>
				</table>

				<div id="admin_bans_modal_details_advanced_unban">

				</div>

				<div id="admin_bans_modal_details_advanced_protest">

				</div>
			</div>

			<div class="modal-footer">
				<button type="button" name="admin_bans_modal_details_button_delete" onclick="" class="btn btn-danger"><?php echo Lang('delete'); ?></button>
				<button type="button" name="admin_bans_modal_details_button_unban" onclick="" class="btn btn-warning"><?php echo Lang('unban'); ?></button>
				<button type="button" name="admin_bans_modal_details_button_reban" onclick="" class="btn btn-warning"><?php echo Lang('reban'); ?></button>
				<button type="button" name="admin_bans_modal_details_button_edit" onclick="" class="btn btn-primary"><?php echo Lang('edit'); ?></button>
			</div>
		</div>
	</div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="admin_bans_modal_edit" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-pencil"></i> &nbsp;<?php echo Lang('edit'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_bans<?php echo ''.(isset($_GET['id']) ? '&id='.$_GET['id'] : '').(isset($_GET['page']) ? '&page='.$_GET['page'] : ''); ?>">
				<div class="modal-body">
					<!-- Reason -->
		            <label><?php echo Lang('reason'); ?></label><br>
		            <input class="form-control" name="admin_bans_modal_edit_form_reason" placeholder="<?php echo Lang('reason'); ?>" /><br>
		            <!-- length -->
		            <label><?php echo Lang('length'); ?></label><br>
		            <input class="form-control" name="admin_bans_modal_edit_form_length" placeholder="<?php echo Lang('length'); ?>" /><br>

		            <label><?php echo Lang('serverbundle'); ?></label><br>
					<select class="form-control" name="admin_bans_modal_edit_form_serverbundle">
						<option value="0">Web</option>
						<?php
                            foreach (ServerBundle::GetAll() as $bundle) {
                                echo '<option value="'.$bundle->GetValue('id').'">'.$bundle->GetValue('name').'</option>';
                            }
                        ?>
					</select>
					<br>

					<label><?php echo Lang('ban_global'); ?></label><br>
					<?php CreateCheckbox('primary', 'admin_bans_modal_edit_form_global', '', Lang('ban_everywhere')); ?>

		            <input type="hidden" name="admin_bans_modal_edit_form_id" />
				</div>
				<div class="modal-footer">
					<button type="submit" name="admin_bans_modal_edit_form_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="admin_bans_modal_add" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-ban"></i> &nbsp;<?php echo Lang('user_ban'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_bans<?php echo ''.(isset($_GET['id']) ? '&id='.$_GET['id'] : '').(isset($_GET['page']) ? '&page='.$_GET['page'] : ''); ?>">
				<div class="modal-body">
					<!-- Steamid64/SteamID32 -->
		            <label>SteamID64 / SteamID32</label>
		            <input class="form-control" name="admin_bans_modal_add_form_steamid" placeholder="SteamID" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>" /><br>

		            <!-- Reason -->
		            <label><?php echo Lang('reason'); ?></label><br>
		            <input class="form-control" name="admin_bans_modal_add_form_reason" placeholder="<?php echo Lang('reason'); ?>" /><br>

		            <!-- length -->
		            <label><?php echo Lang('length'); ?></label><br>
		            <input class="form-control" name="admin_bans_modal_add_form_length" value="0" placeholder="<?php echo Lang('length'); ?>" />
		            <br>

		            <label><?php echo Lang('serverbundle'); ?></label><br>
					<select class="form-control" name="admin_bans_modal_add_form_serverbundle">
						<option value="0">Web</option>
						<?php
                            foreach (ServerBundle::GetAll() as $bundle) {
                                echo '<option value="'.$bundle->GetValue('id').'">'.$bundle->GetValue('name').'</option>';
                            }
                        ?>
					</select>
					<br>

					<label><?php echo Lang('ban_global'); ?></label><br>
					<?php CreateCheckbox('primary', 'admin_bans_modal_add_form_global', '', Lang('ban_everywhere')); ?>
				</div>
				<div class="modal-footer">
					<button type="submit" name="admin_bans_modal_add_form_submit" class="btn btn-danger"><?php echo Lang('ban_create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
	var bandata = {};

	var url = 'index.php?t=admin_bans<?php echo ''.(isset($_GET['id']) ? '&id='.$_GET['id'] : '').(isset($_GET['page']) ? '&page='.$_GET['page'] : ''); ?>';

	<?php echo $bandata; ?>

	var protest_edited = [];

	function admin_bans_edit(id){
		ban = bandata[id];

		$('#admin_bans_modal_details').modal('hide');

		$('input[name="admin_bans_modal_edit_form_id"]').val(id);
		$('input[name="admin_bans_modal_edit_form_reason"]').val(ban["reason"]);
		$('input[name="admin_bans_modal_edit_form_length"]').val(ban["length"]);
		$('select[name="admin_bans_modal_edit_form_serverbundle"]').val(ban["serverbundle"]);
		$('input[name="admin_bans_modal_edit_form_global"]').prop('checked', ban["global"]);

		$('#admin_bans_modal_edit').modal('show');
	}

	function admin_bans_add(){
		$('#admin_bans_modal_add').modal('show');
	}

	function admin_bans_protests(){
		$('#admin_bans_modal_protests').modal('show');
	}

	function admin_bans_unban(id){
		post(url, {"admin_bans_unban": id});
	}

	function admin_bans_reban(id){
		post(url, {"admin_bans_reban": id});
	}

	function admin_bans_delete(id){
		post(url, {"admin_bans_delete": id});
	}

	function admin_bans_protest_accept_deny(protestid, accept, fromdetails = false){
		$.getJSON( "request.php?t=admin_bans", {
			protestid: protestid,
			accept: accept
		}).done(function( data ) {
			if(data['success']){
				protest_edited.push(protestid);

				if(!fromdetails){
					$('#admin_bans_protest_collapse_' + protestid ).collapse('hide');
					$('#admin_bans_protest_collapse_' + protestid ).on('hidden.bs.collapse', function () {
						$('#admin_bans_protest_' + protestid ).hide();
					});
				}else{
					var newfooter = "<?php echo Lang('status'); ?>: <b><font color=green><?php echo Lang('accepted'); ?></font></b>"

					if(!accept){
						var newfooter = "<?php echo Lang('status'); ?>: <b><font color=red><?php echo Lang('denied'); ?></font></b>"
					}

					$('#admin_bans_modal_details_advanced_protest_footer_' + protestid).html(newfooter);
				}

				new PNotify({
				    title: '<?php echo Lang('success'); ?>',
				    text: '<?php echo Lang('protest_handeled'); ?>',
				    type: 'success'
				});
			}else if(data['error']){
				new PNotify({
				    title: '<?php echo Lang('error'); ?>',
				    text: data['error'],
				    type: 'error'
				});
			}else{
				new PNotify({
				    title: '<?php echo Lang('error'); ?>',
				    text: '<?php echo Lang('sqlerror_update'); ?>',
				    type: 'error'
				});
			}
		});
	}

	function admin_bans_details(id){
		ban = bandata[id];

		$('#admin_bans_modal_details_id').html('#' + ban['id']);
		$('#admin_bans_modal_details_id_title').html(ban['id']);
		$('#admin_bans_modal_details_banid').val(ban['id']);
		$('#admin_bans_modal_details_date_banned').html(ban['date_banned']);
		$('#admin_bans_modal_details_date_unban').html(ban['expires']);
		$('#admin_bans_modal_details_length').html(ban['length_string']);
		$('#admin_bans_modal_details_reason').html(ban['reason']);

		$('#admin_bans_modal_details_serverbundle').html(ban['serverbundle_string']);

		if(ban['user'] == null){
			$('#admin_bans_modal_details_user').html('<a href="http://steamcommunity.com/profiles/' + ban['steamid64'] + '" target="_blank">' + ban['steamid64'] + '</a>');
		}else{
			$('#admin_bans_modal_details_user').html('<a href="index.php?t=user&id=' + ban['steamid64'] + '" target="_blank">' + ban['user'] + '</a>');
		}

		$('#admin_bans_modal_details_user_title').html(ban['user']);
		$('#admin_bans_modal_details_admin').html('<a href="index.php?t=user&id=' + ban['steamid64_admin'] + '" target="_blank">' + ban['admin'] + '</a>');
		$('button[name="admin_bans_modal_details_button_edit"]').attr('onclick', "admin_bans_edit(" + ban["id"] + ");");
		$('button[name="admin_bans_modal_details_button_delete"]').attr('onclick', "admin_bans_delete(" + ban["id"] + ");");
		$('button[name="admin_bans_modal_details_button_unban"]').attr('onclick', "admin_bans_unban(" + ban["id"] + ");");
		$('button[name="admin_bans_modal_details_button_reban"]').attr('onclick', "admin_bans_reban(" + ban["id"] + ");");

		if(ban['status']){
			$('button[name="admin_bans_modal_details_button_unban"]').hide();
			$('button[name="admin_bans_modal_details_button_reban"]').show();
			$('#admin_bans_modal_details_icon').attr('class', 'fa fa-unlock-alt');
		}else{
			$('button[name="admin_bans_modal_details_button_unban"]').show();
			$('button[name="admin_bans_modal_details_button_reban"]').hide();
			$('#admin_bans_modal_details_icon').attr('class', 'fa fa-lock');
		}

		$('#admin_bans_modal_details_advanced_protest').html('');
		$('#admin_bans_modal_details_advanced_unban').html('');

		ban['protests'].forEach(function(entry){
			if($.inArray(entry['id'], protest_edited) == -1){
				var protestbuttons = "";

				if(entry['status'] == 0){
					protestbuttons = `
						<div class="text-right">
							<button onclick="admin_bans_protest_accept_deny(` + entry['id'] + `, 1, true);" name="admin_bans_protest_accept" type="button" class="btn btn-success btn-sm"><i class="fa fa-check"></i> <?php echo Lang('accept'); ?></button>
							<button onclick="admin_bans_protest_accept_deny(` + entry['id'] + `, 0, true);" name="admin_bans_protest_deny "type="button" class="btn btn-danger btn-sm"><i class="fa fa-times"></i> <?php echo Lang('deny'); ?></button>
						</div>
					`;
				}

				$('#admin_bans_modal_details_advanced_protest').append(`
					<div class="panel panel-default" id="bans_protest_` + entry['id'] + `">
						<div class="panel-heading">
							<h4 class="panel-title">
								<a data-toggle="collapse" data-parent="#accordion" href="#admin_bans_protest_collapse_` + entry['id'] + `"><?php echo Lang('protest'); ?> #` + entry['id'] + `</a>
							</h4>
						</div>
						<div id="admin_bans_protest_collapse_` + entry['id'] + `" class="panel-collapse collapse` + entry['in'] + `">
							<div class="panel-body">
								` + entry['text'] + `
							</div>
							<div class="panel-footer" id="admin_bans_modal_details_advanced_protest_footer_` + entry['id'] + `">
								<?php echo Lang('status'); ?>: <b>` + entry['status_text'] + `</b>
								` + protestbuttons + `
							</div>
						</div>
					</div>`
				);
			}
		});

		var unbannedtext = "<?php echo Lang('admin_bans_unbanned'); ?>";
		unbannedtext = ReplaceAll('%date%', ban['date_unbanned'], unbannedtext);
		unbannedtext = ReplaceAll('%admin%', '<a href="index.php?t=user&id=' + ban['steamid64_admin_unbanned'] + '" target="_blank">' + ban['admin_unbanned'] + '</a>', unbannedtext);

		if(ban['status'] == 1 && ban['admin_unbanned'] != 'undefined'){
			$('#admin_bans_modal_details_advanced_unban').html(`
				<div class="panel panel-warning">
					<div class="panel-body">
						` + unbannedtext + `
					</div>
				</div>
			`);
		}

		if(ban['expired']){
			$('button[name="admin_bans_modal_details_button_reban"]').hide();
			$('button[name="admin_bans_modal_details_button_unban"]').hide();
			$('#admin_bans_modal_details_icon').attr('class', 'fa fa-unlock-alt');
			$('#admin_bans_modal_details_date_unban').append(' <font color="red">(<?php echo Lang('reached'); ?>)</font>')
		}

		if(!ban['length']){
			$('#admin_bans_modal_details_date_unban').html('-');
		}

		$('#admin_bans_modal_details').modal('show');
	}

	$("input[name='admin_bans_modal_edit_form_length']").TouchSpin({
        min: 0,
        max: 1000000000,
        forcestepdivisibility: 'none',
    	step: 60,
        decimals: 0,
        verticalbuttons: true,
        prefix: '<?php echo Lang('minutes'); ?>'
    });

    $("input[name='admin_bans_modal_add_form_length']").TouchSpin({
        min: 0,
        max: 1000000000,
    	step: 60,
    	forcestepdivisibility: 'none',
        decimals: 0,
        verticalbuttons: true,
        prefix: '<?php echo Lang('minutes'); ?>'
    });
</script>