<!--{"language":"console","icon":"fa-terminal","place":"admin","position":10}-->
<?php 
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<!-- funkyradio CSS -->
<link rel="stylesheet" href="assets/css/funkyradio.css">

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('console'); ?>
			<span class="pull-right">
				<form method="post" action="index.php?t=admin_servers">
					<select style="margin-bottom:0px;" class="form-control" id="admin_console_server" onchange="admin_console_server_load();">
						<?php 
                            foreach (Server::GetAll() as $server) {
                                echo '<option value="'.$server->GetValue('id').'">'.$server->GetValue('hostname').'</option>';
                            }
                        ?>
					</select>
				</form>
			</span>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-6">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
					<p><i class="fa fa-line-chart fa-lg"></i></p>
		        	<p><b><?php echo Lang('status'); ?></b></p>
		        </div>
		        
		        <div class="box-icon pull-right">
		        	<a href="#" onclick="admin_console_status_refresh();"><i class="fa fa-refresh fa-lg"></i></a>
		        </div>
			</div>
			
		  	<div class="box-content" id="admin_console_status">
		 		<center>
		  			<span id="admin_console_status_players"><i class="fa fa-refresh fa-spin"></i></span>
		  		</center>
		  	</div>
		</div>
	</div>
	<div class="col-xs-6">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
					<p><i class="fa fa-comment fa-lg"></i></p>
		        	<p><b><?php echo Lang('command_execute'); ?></b></p>
		        </div>
			</div>
			
		  	<div class="box-content" id="admin_console_exec_command">
		  		<div class="input-group">
                    <input type="text" id="admin_console_command" class="form-control" placeholder="<?php echo Lang('command'); ?>..." />
                    
                    <span class="input-group-btn">
                        <button class="btn btn-primary btn-sm" id="admin_console_command_submit" onclick="admin_console_exec_command();">
                            <?php echo Lang('send'); ?>
                        </button>
                    </span>
                </div>
		  	</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
					<p><i class="fa fa-terminal fa-lg"></i></p>
		        	<p><b><?php echo Lang('console_log'); ?></b></p>
		        </div>
		        
		        <div class="box-icon pull-right">
		        	<i class="fa fa-circle-o-notch fa-spin fa-lg fa-fw"></i>
		        </div>
			</div>
			
		  	<div class="box-content" id="admin_console_log" style="overflow-y: auto;">
		  		
		  	</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
					<p><i class="fa fa-clock-o fa-lg"></i></p>
		        	<p><b><?php echo Lang('timeframe'); ?></b></p>
		        </div>
			</div>
			
		  	<div class="box-content" id="admin_console_timeframe">
		  	</div>
		</div>
	</div>
</div>

<!--<div class="modal fade" id="admin_console_users_online_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-users"></i> &nbsp;<?php echo Lang('users_online'); ?></h4>
			</div>

			<div class="modal-body">
	            <table class="table table-responsive table-hover">
					<tr class="active">
						<th style="width: 80%;"><?php echo Lang('name'); ?></th>
						<th class="text-right" style="width: 20%;"><i class="fa fa-cogs"></i></th>
					</tr>

					<tbody id="admin_console_users_online">

					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>-->

<script>
	var admin_console_timeframe = 0;
	var admin_console_scrolled_bottom = true;
	
	$("#admin_console_command").keyup(function(event){
	    if(event.keyCode == 13){
	        admin_console_exec_command();
	    }
	});
	
	/*function admin_console_users_online_refresh(){
		var serverid = $('#admin_console_server').val();
		
		if($.isNumeric(serverid)){
			$.getJSON( 'request.php?t=admin_console', {
				serverid: serverid,
				users_online: true
			}).done(function( data ) {
				$('#admin_console_users_online').html('');
				
				data.forEach(function(v){
					var commands = [];
					
					v['actions'].forEach(function(action){
						commands.push('<a href="#" onclick="admin_console_exec_command(\'' + action['command'] + '\');">' + action['title'] + '</a>');
					});
					
					var actionbtn = '<div class="dropdown"><button class="btn btn-warning dropdown-toggle" type="button" data-toggle="dropdown"><?php echo Lang('action'); ?> <span class="caret"></span></button><ul class="dropdown-menu"><li>' + commands + '</li></ul></div>';
					
					$('#admin_console_users_online').append('<tr><td>' + v['nick'] + '</td><td>' + actionbtn + '</td></tr>');
				});
			});
		}
	}*/
	
	function admin_console_users_online_open(){
		$('#admin_console_users_online_modal').modal("show");
	}
	
	function admin_console_size_adjust(){
		$('#admin_console_log').height($(document).height() - $('#admin_console_log').offset().top - 160 );
		$('#admin_console_status').height($('#admin_console_exec_command').height());
	}
	
	setTimeout(function() {admin_console_size_adjust()}, 50);
	
	function admin_console_server_load(){
		admin_console_timeframe = 0;
		
		var serverid = $('#admin_console_server').val();

		admin_console_refresh();
		admin_console_status_refresh();
	}
	
	function admin_console_refresh(){
		var serverid = $('#admin_console_server').val();
		
		if($.isNumeric(serverid)){
			$.get( 'request.php?t=admin_console', {
				serverid: serverid,
				timeframe: admin_console_timeframe
			}).done(function( data ) {
				/*if(data[0] == ""){
					data.shift();
				}*/
				
				$('#admin_console_log').html(data);

				if(admin_console_scrolled_bottom){
					$('#admin_console_log').scrollTop($('#admin_console_log').prop("scrollHeight"));
				}
			});
			
			$.getJSON( 'request.php?t=admin_console', {
				serverid: serverid
			}).done(function( data ) {
				if(data.length <= 3){
					$('#admin_console_timeframe').html('');
					
					data.forEach(function(tf, i){
						var checked = '';
						
						if(i == admin_console_timeframe){
							checked = 'checked';
						}
						
						$('#admin_console_timeframe').append('\
							<div class="col-sm-4">\
								<div class="funkyradio funkyradio-primary">\
						            <input name="radio" onclick="admin_console_timeframe = ' + i + '; admin_console_refresh();" type="radio" id="admin_console_timeframe_' + i + '" ' + checked + '/>\
						            <label for="admin_console_timeframe_' + i + '">' + tf + '</label>\
						        </div>\
						    </div>\
						');
					});
				}
			});
		}
	}
	
	$('#admin_console_log').bind('scroll', function(e){
		var elem = $(e.currentTarget);
	    if (elem[0].scrollHeight - elem.scrollTop() == elem.outerHeight()) {
	        admin_console_scrolled_bottom = true;
	    }else{
	    	admin_console_scrolled_bottom = false;
	    }
	});
	
	function admin_console_status_refresh(){
		var serverid = $('#admin_console_server').val();
		
		$.getJSON( "request.php?t=servers", {
			serverid: serverid
		}).done(function( data ) {
			if(data["status"]){
				$('#admin_console_status_players').html('<i style="color:green;" class="fa fa-bolt"></i> ' + data["players"].length + ' / ' + data["slots"] + '');
			}else{
				$('#admin_console_status_players').html('<i style="color:red;" class="fa fa-bolt"></i> 0 / 0');
			}
		});
	}
	
	function admin_console_exec_command(command) {
		$('#admin_console_command').prop('disabled', true);
		$('#admin_console_command_submit').prop('disabled', true);
		
		if(!command){
			command = $('#admin_console_command').val();
		}
		
		var serverid = $('#admin_console_server').val();

		if ($.isNumeric(serverid)) {
			$.getJSON('request.php?t=admin_console', {
					serverid: serverid,
					command: command
			}).done(function(data) {
				if (data['success']) {
					$('#admin_console_command').val('');

					new PNotify({
						title: '<?php echo Lang('success'); ?>',
						text: '<?php echo Lang('command_sent_success'); ?>',
						type: 'success'
					});
					
					$('#admin_console_command').prop('disabled', false);
					$('#admin_console_command_submit').prop('disabled', false);
				}
			}).always(function(){
				
			});
		}
	}
	
	 admin_console_refresh();
	 admin_console_status_refresh();
	 
	 setInterval(function(){
	 	admin_console_refresh();
	 }, 11000);
	 
	 setInterval(function(){
	 	admin_console_status_refresh();
	 }, 30000);
	 
	 $( window ).resize(function() {
		admin_console_size_adjust();
	});
</script>