<!--{"language":"shop","icon":"fa-money","place":"admin","position":30}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['admin_donations_paysafecard_accept'])) {
            if (Permissions::HasPermission('donations_paysafecard')) {
                $id = $_POST['admin_donations_paysafecard_accept'];

                if (is_numeric($id)) {
                    $db->where('id', $id);
                    $inquierie = $db->getOne('paysafecard');

                    if (0 == $inquierie['status']) {
                        $for = new User($inquierie['steamid64_for']);
                        $buyer = new User($inquierie['steamid64_buyer']);
                        $package = new Package($inquierie['package']);

                        $db->where('id', $id);
                        $db->update('paysafecard', array('status' => 1));

                        $data = array(
                            'name_buyer' => $buyer->GetValue('nick'),
                            'steamid64_buyer' => $buyer->GetValue('steamid64'),
                            'steamid64_for' => $for->GetValue('steamid64'),
                            'amount' => $inquierie['price_should'],
                            'package' => $package->GetValue('id'),
                            'transactionid' => 'psc-'.trim($inquierie['id']),
                            'coupon' => $inquierie['coupon'],
                            'email' => $buyer->GetValue('email'),
                            'gateway' => 'paysafecard',
                        );

                        Payment::Finish($data, $buyer, $for, $package);

                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('payment_accepted').'", type: "success"');
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_paysafecard_deny'])) {
            if (Permissions::HasPermission('donations_paysafecard')) {
                $id = $_POST['admin_donations_paysafecard_deny'];

                if (is_numeric($id)) {
                    $db->where('id', $id);
                    $inquierie = $db->getOne('paysafecard');

                    if (0 == $inquierie['status']) {
                        $coupon = new Coupon($inquierie['coupon'], true);

                        if ($coupon->valid) {
                            $coupon->AddAmount($inquierie['discount']);
                        }

                        $db->where('id', $id);
                        $db->update('paysafecard', array('status' => 2));

                        $package = new Package($inquierie['package']);

                        Notifications::Send($inquierie['steamid64_buyer'], 'notification_psc_denied', array('package' => $package->GetValue('title')), 'index.php?t=home', 'credit-card-alt');

                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('payment_denied').'", type: "success"');
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_donation_revoke'])) {
            if (Permissions::HasPermission('donations_revoke')) {
                if (is_numeric($_POST['admin_donations_donation_revoke'])) {
                    $donation = new Donation($_POST['admin_donations_donation_revoke']);

                    if ($donation->valid) {
                        if ($donation->Revoke()) {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('donation_revoked_success').'", type: "success"');
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donation_revoked_error').'", type: "error"');
                        }
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_donation_delete'])) {
            if (Permissions::HasPermission('donations_delete')) {
                if (is_numeric($_POST['admin_donations_donation_delete'])) {
                    $donation = new Donation($_POST['admin_donations_donation_delete']);

                    if ($donation->valid) {
                        if ($donation->Delete()) {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('donation_deleted_success').'", type: "success"');
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donation_delete_error').'", type: "error"');
                        }
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_donation_unrevoke'])) {
            if (Permissions::HasPermission('donations_revoke')) {
                $donation = new Donation($_POST['admin_donations_donation_unrevoke']);

                if ($donation->valid) {
                    if ($donation->Unrevoke()) {
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('donation_unrevoked_success').'", type: "success"');
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donation_unrevoked_error').'", type: "error"');
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_coupon_empty'])) {
            if (Permissions::HasPermission('donations_coupons')) {
                $coupon = new Coupon($_POST['admin_donations_coupon_empty'], true);

                if ($coupon->valid) {
                    $coupon->Devaluate();
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('coupon_edited').'", type: "success"');
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_coupon_refill'])) {
            if (Permissions::HasPermission('donations_coupons')) {
                $coupon = new Coupon($_POST['admin_donations_coupon_refill'], true);

                if ($coupon->valid) {
                    $coupon->SetValue('amount_left', $coupon->GetValue('amount'));
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('coupon_edited').'", type: "success"');
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_coupon_delete'])) {
            if (Permissions::HasPermission('donations_coupons')) {
                $coupon = new Coupon($_POST['admin_donations_coupon_delete'], true);

                if ($coupon->valid) {
                    if ($coupon->Delete()) {
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('coupon_edited').'", type: "success"');
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_package_disable'])) {
            if (Permissions::HasPermission('donations_package')) {
                if (is_numeric($_POST['admin_donations_package_disable'])) {
                    $db->where('id', $_POST['admin_donations_package_disable']);
                    $package = $db->getOne('packages_bought');

                    if ($db->count) {
                        if (1 == $package['status']) {
                            if (Package::Disable($package['id'], false)) {
                                Notifications::Send($package['steamid64'], 'notification_package_disabled', array('package' => $package['package_name']), 'index.php?t=home', 'power-off');

                                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('package_bought_disabled_success').'", type: "success"');
                            } else {
                                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                            }
                        }
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_package_delete'])) {
            if (Permissions::HasPermission('donations_package_delete')) {
                if (is_numeric($_POST['admin_donations_package_delete'])) {
                    $db->where('id', $_POST['admin_donations_package_delete']);
                    $package = $db->getOne('packages_bought');

                    if ($db->count) {
                        $db->where('id', $_POST['admin_donations_package_delete']);
                        $db->delete('packages_bought');

                        Notifications::Send($package['steamid64'], 'notification_package_deleted', array('package' => $package['package_name']), 'index.php?t=home', 'trash');

                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('package_bought_delete_success').'", type: "success"');
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_package_enable'])) {
            if (Permissions::HasPermission('donations_package')) {
                if (is_numeric($_POST['admin_donations_package_enable'])) {
                    $db->where('id', $_POST['admin_donations_package_enable']);
                    $package = $db->getOne('packages_bought');

                    if ($db->count) {
                        $success = false;

                        if (0 == $package['status']) {
                            if (Package::Enable($package['id'])) {
                                Notifications::Send($package['steamid64'], 'notification_package_reactivated', array('package' => $package['package_name']), 'index.php?t=home', 'unlock-alt');
                                $success = true;
                            }
                        } elseif (2 == $package['status']) {
                            $donation = $package['donationid'];

                            if ($donation->valid) {
                                if ($donation->Unrevoke()) {
                                    $success = true;
                                }
                            } else {
                                if (Package::Enable($package['id'])) {
                                    $success = true;
                                }
                            }
                        }

                        if ($success) {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('package_bought_enabled_success').'", type: "success"');
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                        }
                    }
                }
            } else {
                PermissionsError();
            }
        } elseif (isset($_POST['admin_donations_modal_coupon_create_form_code'])) {
            if (Permissions::HasPermission('donations_coupons')) {
                if (isset($_POST['admin_donations_modal_coupon_create_form_amount'])) {
                    if (is_numeric($_POST['admin_donations_modal_coupon_create_form_amount'])) {
                        $data = array(
                            'code' => $_POST['admin_donations_modal_coupon_create_form_code'],
                            'amount' => $_POST['admin_donations_modal_coupon_create_form_amount'],
                            'amount_left' => $_POST['admin_donations_modal_coupon_create_form_amount'],
                        );

                        $db->insert('coupons', $data);

                        if ($db->count) {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('coupon_created').'", type: "success"');
                        }
                    }
                }
            } else {
                PermissionsError();
            }
        }
    }
?>

<!-- Chart JS-->
<script src="assets/js/chart.min.js"></script>
<!-- ZingChart JS-->
<script src="assets/js/zingchart.min.js"></script>
<!-- DatePicker JS-->
<script src="assets/js/bootstrap-datepicker.js"></script>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header"><?php echo Lang('donation_administration'); ?></h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<ul class="nav nav-tabs" role="tablist">
		    <li role="presentation" class="active"><a href="#admin_donations_tab_donations" role="tab" data-toggle="tab"><i class="fa fa-clock-o"></i> <?php echo Lang('donations'); ?></a></li>
		    <li role="presentation"><a href="#admin_donations_tab_coupons" role="tab" data-toggle="tab"><i class="fa fa-ticket"></i> <?php echo Lang('coupons'); ?></a></li>
		    <li role="presentation"><a href="#admin_donations_tab_paysafecard" role="tab" data-toggle="tab"><i class="fa fa-credit-card-alt"></i> <?php echo Lang('paysafecard'); ?></a></li>
			<li role="presentation"><a href="#admin_donations_tab_packages_bought" role="tab" data-toggle="tab"><i class="fa fa-archive"></i> <?php echo Lang('packages_bought'); ?></a></li>
			<li role="presentation"><a href="#admin_donations_tab_report" role="tab" data-toggle="tab"><i class="fa fa-calendar"></i> <?php echo Lang('report'); ?></a></li>
			<li role="presentation"><a href="#admin_donations_tab_statistics" role="tab" data-toggle="tab"><i class="fa fa-pie-chart"></i> <?php echo Lang('statistics'); ?></a></li>
		</ul>

		<div class="tab-content">
	   		<div role="tabpanel" class="tab-pane active" id="admin_donations_tab_donations">
	   			<br>

   				<div class="box">
				    <div class="box-header">
				        <div class="box-title pull-left">
							<p><i class="fa fa-clock-o fa-lg"></i></p>
				        	<p><b><?php echo Lang('latest_donations'); ?></b></p>
				        </div>
					</div>

				  	<div class="box-content" id="admin_donations_latest_donations">
				  	    <div class="table-responsive">
    				  		<table class="table table-hover">
    							<tr>
    								<th style="width: 5%;">#</th>
    								<th><?php echo Lang('buyer'); ?></th>
    								<th><?php echo Lang('for'); ?></th>
    								<th><?php echo Lang('date'); ?></th>
    								<th><?php echo Lang('package'); ?></th>
    								<th><?php echo Lang('gateway'); ?></th>
    								<th style="width: 5%;"><?php echo Lang('amount'); ?></th>
    							</tr>
    							<tbody>
    								<?php
                                        $page = 1;

                                        if (isset($_GET['page'])) {
                                            $page = $_GET['page'];
                                        }

                                        $donations = Donations::GetLatestDonations(25, false, true, $page);

                                        foreach ($donations as $donation) {
                                            $buyer = new User($donation['steamid64_buyer']);

                                            $for = new User($donation['steamid64_for']);

                                            $package = new Package($donation['package']);

                                            $class = '';

                                            if (1 == $donation['revoked']) {
                                                $class = 'danger';
                                            }

                                            echo '<tr class="'.$class.'">';
                                            echo '<td>';
                                            echo '<a onclick="admin_donations_donation_show('.$donation['id'].');" href="#">'.$donation['id'].'</a>';
                                            echo '</td>';
                                            echo '<td>';
                                            if ($buyer->valid) {
                                                echo '<a href="index.php?t=user&id='.$buyer->GetValue('steamid64').'" target="_blank">'.$buyer->GetValue('nick').'</a>';
                                            } else {
                                                echo '<a href="http://steamcommunity.com/profiles/'.$donation['steamid64_buyer'].'" target="_blank">'.$donation['steamid64_buyer'].'</a>';
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            if ($donation['steamid64_buyer'] == $donation['steamid64_for']) {
                                                echo '-';
                                            } elseif ($for->valid) {
                                                echo '<a href="index.php?t=user&id='.$for->GetValue('steamid64').'" target="_blank">'.$for->GetValue('nick').'</a>';
                                            } else {
                                                echo '<a href="http://steamcommunity.com/profiles/'.$donation['steamid64_for'].'" target="_blank">'.$donation['steamid64_for'].'</a>';
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            echo FormatDate($donation['date']);
                                            echo '</td>';
                                            echo '<td>';
                                            if ($package->valid) {
                                                echo '<a href="index.php?t=shop&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id').'" target="_blank">'.$package->GetValue('title').'</a>';
                                            } else {
                                                echo '<font color="red"><i class="fa fa-times"></i></font>';
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            echo $donation['gateway'];
                                            echo '</td>';
                                            echo '<td>';
                                            if ($donation['amount'] <= 0) {
                                                echo '<font color="red">';
                                            }
                                            echo Settings::Get('settings_donations_currency').FormatPrice($donation['amount']);
                                            if ($donation['amount'] <= 0) {
                                                echo '</font>';
                                            }
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    ?>
    							</tbody>
    						</table>
    					</div>

						<ul class="pager">
							<?php if ($page > 1) {
                                        ?>
								<li class="previous"><a href="index.php?t=admin_donations&part=donations&page=<?php echo $page - 1; ?>"><span aria-hidden="true">&larr;</span> <?php echo Lang('previous'); ?></a></li>
							<?php
                                    } ?>

							<?php if (25 == sizeof($donations)) {
                                        ?>
								<li class="next"><a href="index.php?t=admin_donations&part=donations&page=<?php echo $page + 1; ?>"><?php echo Lang('next'); ?> <span aria-hidden="true">&rarr;</span></a></li>
							<?php
                                    } ?>
						</ul>
				  	</div>
				</div>

				<?php
                    if (Permissions::HasPermission('super')) {
                        echo '<br/><a href="index.php?t=admin_import_prometheus">Import Prometheus Donations</a>';
                        echo '<br/><a href="index.php?t=admin_import_sdonate">Import SDonate Donations</a>';
                    }
                ?>
	   		</div>

	   		<div role="tabpanel" class="tab-pane" id="admin_donations_tab_coupons">
	   			<br>

	   			<div class="box">
				    <div class="box-header">
				        <div class="box-title pull-left">
							<p><i class="fa fa-ticket fa-lg"></i></p>
				        	<p><b><?php echo Lang('existing_coupons'); ?></b></p>
				        </div>

				        <div class="box-icon pull-right">
				        	<a href="#" onclick="admin_donations_coupon_create();"><i class="fa fa-plus fa-lg"></i></a>
				        </div>
					</div>

				  	<div class="box-content" id="admin_donations_coupons">
				  	    <div class="table-responsive">
    				  		<table class="table table-hover">
    							<tr>
    								<th><?php echo Lang('coupon'); ?></th>
    								<th><?php echo Lang('amount_start'); ?></th>
    								<th><?php echo Lang('amount_left'); ?></th>
    								<th><?php echo Lang('date'); ?></th>
    								<th style="width: 5%;"><i class="fa fa-cogs"></i></th>
    							</tr>
    							<tbody>
    								<?php
                                        foreach (Coupon::GetAll() as $coupon) {
                                            $class = '';

                                            if ($coupon['amount_left'] <= 0) {
                                                $class = 'danger';
                                            } else {
                                                $class = 'success';
                                            }

                                            echo '<tr class="'.$class.'">';
                                            echo '<td>';
                                            echo $coupon['code'];
                                            echo '</td>';
                                            echo '<td>';
                                            echo Settings::Get('settings_donations_currency').FormatPrice($coupon['amount']);
                                            echo '</td>';
                                            echo '<td>';
                                            echo Settings::Get('settings_donations_currency').FormatPrice($coupon['amount_left']);
                                            echo '</td>';
                                            echo '<td>';
                                            echo FormatDate($coupon['date']);
                                            echo '</td>';
                                            echo '<td>';
                                            echo '<a href="#" onclick="admin_donations_coupon_edit(\''.$coupon['code'].'\')"><i class="fa fa-wrench"></i></a>';
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    ?>
    							</tbody>
    						</table>
    					</div>
				  	</div>
	   			</div>
	   		</div>

	   		<div role="tabpanel" class="tab-pane" id="admin_donations_tab_paysafecard">
	   			<br>

   				<div class="box">
				    <div class="box-header">
				        <div class="box-title pull-left">
							<p><i class="fa fa-credit-card-alt fa-lg"></i></p>
				        	<p><b><?php echo Lang('donations_via_paysafecard'); ?></b></p>
				        </div>
					</div>

				  	<div class="box-content" id="admin_donations_paysafecard">
				  	    <div class="table-responsive">
    				  		<table class="table table-hover">
    							<tr>
    								<th>#</th>
    								<th><?php echo Lang('buyer'); ?></th>
    								<th><?php echo Lang('for'); ?></th>
    								<th><?php echo Lang('pins'); ?></th>
    								<th><?php echo Lang('date'); ?></th>
    								<th><?php echo Lang('package'); ?></th>
    								<th style="width: 5%;"><?php echo Lang('price'); ?></th>
    								<th style="width: 5%;"><?php echo Lang('discount'); ?></th>
    								<th style="width: 10%;"><?php echo Lang('needed_credit'); ?></th>
    								<th><i class="fa fa-cogs"></i></th>
    							</tr>
    							<tbody>
    								<?php
                                        foreach (Donations::GetPaysafecardInquieries() as $inquierie) {
                                            $buyer = new User($inquierie['steamid64_buyer']);

                                            if (!$buyer->valid) {
                                                continue;
                                            }

                                            $for = new User($inquierie['steamid64_for']);

                                            $package = new Package($inquierie['package']);

                                            $class = '';

                                            if (0 == $inquierie['status']) {
                                                $class = 'warning';
                                            } elseif (1 == $inquierie['status']) {
                                                $class = 'success';
                                            } elseif (2 == $inquierie['status']) {
                                                $class = 'danger';
                                            }

                                            echo '<tr class="'.$class.'">';
                                            echo '<td>';
                                            echo $inquierie['id'];
                                            echo '</td>';
                                            echo '<td>';
                                            echo '<a href="index.php?t=user&id='.$buyer->GetValue('steamid64').'" target="_blank">'.$buyer->GetValue('nick').'</a>';
                                            echo '</td>';
                                            echo '<td>';
                                            if ($inquierie['steamid64_buyer'] == $inquierie['steamid64_for']) {
                                                echo '-';
                                            } else {
                                                echo '<a href="index.php?t=user&id='.$for->GetValue('steamid64').'" target="_blank">'.$for->GetValue('nick').'</a>';
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            echo Permissions::HasPermission('donations_paysafecard') ? $inquierie['pins'] : '<i>'.Lang('hidden').'</i>';
                                            echo '</td>';
                                            echo '<td>';
                                            echo FormatDate($inquierie['date']);
                                            echo '</td>';
                                            echo '<td>';
                                            if ($package->valid) {
                                                echo '<a href="index.php?t=shop&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id').'" target="_blank">'.$package->GetValue('title').'</a>';
                                            } else {
                                                echo '<font color="red"><i class="fa fa-times"></i></font>';
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            echo Settings::Get('settings_donations_currency').FormatPrice($inquierie['price']);
                                            echo '</td>';
                                            echo '<td>';
                                            echo '-'.Settings::Get('settings_donations_currency').FormatPrice($inquierie['discount']);
                                            echo '</td>';
                                            echo '<td>';
                                            echo Settings::Get('settings_donations_currency').FormatPrice($inquierie['price_should']);
                                            echo '</td>';
                                            echo '<td>';
                                            if (0 == $inquierie['status'] && Permissions::HasPermission('donations_paysafecard')) {
                                                echo '<a href="#" onclick="admin_donations_paysafecard_status_change('.$inquierie['id'].', \''.$inquierie['pins'].'\', '.FormatPrice($inquierie['price_should']).')"><i class="fa fa-wrench"></i></a>';
                                            } else {
                                                echo '-';
                                            }
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    ?>
    							</tbody>
    						</table>
    					</div>
				  	</div>
	   			</div>
	   		</div>

	   		<div role="tabpanel" class="tab-pane" id="admin_donations_tab_packages_bought">
	   			<br>

   				<div class="box">
				    <div class="box-header">
				        <div class="box-title pull-left">
							<p><i class="fa fa-archive fa-lg"></i></p>
				        	<p><b><?php echo Lang('packages_bought'); ?></b></p>
				        </div>
					</div>

				  	<div class="box-content" id="admin_donations_packages_bought">
				  	    <div class="table-responsive">
    				  		<table class="table table-hover">
    							<tr>
    								<th><?php echo Lang('user'); ?></th>
    								<th><?php echo Lang('package'); ?></th>
    								<th><?php echo Lang('activated'); ?></th>
    								<th><?php echo Lang('expires'); ?></th>
    								<th><?php echo Lang('days'); ?></th>
    								<th style="width: 5%;"><?php echo Lang('donation'); ?></th>
    								<th class="text-right"><i class="fa fa-cogs"></i></th>
    							</tr>
    							<tbody>
    								<?php
                                        $page = 1;

                                        if (isset($_GET['page_pb'])) {
                                            $page = $_GET['page_pb'];
                                        }

                                        $packages_bought = Package::GetBoughtPackages(25, $page);

                                        foreach ($packages_bought as $package_bought) {
                                            $user = new User($package_bought['steamid64']);

                                            $package = new Package($package_bought['package']);

                                            $class = '';

                                            if (2 == $package_bought['status'] || 0 == $package_bought['status']) {
                                                $class = 'warning';
                                            } elseif (strtotime($package_bought['expires']) < time()) {
                                                $class = 'danger';
                                            } else {
                                                $class = 'success';
                                            }

                                            if (0 == $package_bought['status']) {
                                                //$class = $class . ' striked';
                                            }

                                            echo '<tr class="'.$class.'">';
                                            echo '<td>';
                                            if ($user->valid) {
                                                echo '<a href="index.php?t=user&id='.$user->GetValue('steamid64').'" target="_blank">'.$user->GetValue('nick').'</a>';
                                            } else {
                                                echo '<a href="http://steamcommunity.com/profiles/'.$package_bought['steamid64'].'" target="_blank">'.$package_bought['steamid64'].'</a>';
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            if ($package->valid) {
                                                echo '<a href="index.php?t=shop&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id').'" target="_blank">'.$package->GetValue('title').'</a>';
                                            } else {
                                                echo '<font color="red">'.$package_bought['package_name'].'</font>';
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            echo FormatDate($package_bought['activated']);
                                            echo '</td>';
                                            echo '<td>';
                                            if (!$package_bought['days']) {
                                                echo '-';
                                            } else {
                                                echo FormatDate($package_bought['expires']);
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            if (!$package_bought['days']) {
                                                echo '-';
                                            } else {
                                                echo $package_bought['days'];

                                                if ($package_bought['days_from_upgrade']) {
                                                    echo ' (+'.$package_bought['days_from_upgrade'].')';
                                                }
                                            }
                                            echo '</td>';
                                            echo '<td>';
                                            echo '<a onclick="admin_donations_donation_show('.$package_bought['donationid'].');" href="#">#'.$package_bought['donationid'].'</a>';
                                            echo '</td>';
                                            echo '<td class="text-right">';
                                            if (1 == $package_bought['status']) {
                                                echo '<button type="button" onclick="admin_donations_package_disable('.$package_bought['id'].');" class="btn btn-xs btn-danger">'.Lang('disable').'</button>';
                                            } else {
                                                echo '<button type="button" onclick="admin_donations_package_enable('.$package_bought['id'].');" class="btn btn-xs btn-success">'.Lang('enable').'</button>';
                                            }

                                            echo ' <button type="button" onclick="admin_donations_package_delete('.$package_bought['id'].');" class="btn btn-xs btn-danger"><i class="fa fa-trash"></i></button>';
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    ?>
    							</tbody>
    						</table>
    					</div>

						<ul class="pager">
							<?php if ($page > 1) {
                                        ?>
								<li class="previous"><a href="index.php?t=admin_donations&part=packages_bought&page_pb=<?php echo $page - 1; ?>"><span aria-hidden="true">&larr;</span> <?php echo Lang('previous'); ?></a></li>
							<?php
                                    } ?>

							<?php if (25 == sizeof($packages_bought)) {
                                        ?>
								<li class="next"><a href="index.php?t=admin_donations&part=packages_bought&page_pb=<?php echo $page + 1; ?>"><?php echo Lang('next'); ?> <span aria-hidden="true">&rarr;</span></a></li>
							<?php
                                    } ?>
						</ul>
				  	</div>
				</div>
	   		</div>

            <div role="tabpanel" class="tab-pane" id="admin_donations_tab_report">
                <br />

                <div class="row">
                    <form method="POST" action="index.php?t=admin_donations&part=report">
                        <div class="col-sm-5">
                            <div class="form-group label-static">
								<label class="control-label"><?php echo Lang('from'); ?></label>
                                <input name="admin_donations_statistics_report_from" type="text" class="form-control datepicker">
                            </div>
                        </div>
                        <div class="col-sm-5">
                            <div class="form-group label-static">
								<label class="control-label"><?php echo Lang('to'); ?></label>
                                <input name="admin_donations_statistics_report_to" type="text" class="form-control datepicker">
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <button id="admin_donations_report_go" type="submit" class="btn btn-primary" style="width: 100%;"><?php echo Lang('go'); ?></button>
                        </div>
                    </form>
                </div>

                <?php
                    if (isset($_POST['admin_donations_statistics_report_from']) && isset($_POST['admin_donations_statistics_report_to'])) {
                        echo "<script>
                            $('input[name=\"admin_donations_statistics_report_from\"]').val('".$_POST['admin_donations_statistics_report_from']."');
                            $('input[name=\"admin_donations_statistics_report_to\"]').val('".$_POST['admin_donations_statistics_report_to']."');
                        </script>";

                        if (strtotime($_POST['admin_donations_statistics_report_from']) <= strtotime($_POST['admin_donations_statistics_report_to'])) {
                            $data = Donations::GetCountryReport($_POST['admin_donations_statistics_report_from'], $_POST['admin_donations_statistics_report_to']);

                            echo '<hr />';

                            if (sizeof($data)) {
                                echo '
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                    	<tr class="active">
                                    		<th>'.Lang('country').'</th>
                                    		<th>'.Lang('tax_rate').'</th>
                                    		<th>'.Lang('sales').'</th>
                                    		<th>'.Lang('taxes').'</th>
                                    	</tr>

                                    	<tbody>
                                ';

                                foreach ($data as $entry) {
                                    echo '<tr>';
                                    echo '<td>'.(empty($entry['country']) ? '<i>'.Lang('unknown').'</i>' : $entry['country']).'</td>';
                                    echo '<td>'.$entry['tax_rate'].'%</td>';
                                    echo '<td>'.Settings::Get('settings_donations_currency').$entry['sales'].'</td>';
                                    echo '<td>'.Settings::Get('settings_donations_currency').$entry['taxes'].'</td>';
                                    echo '</tr>';
                                }

                                echo '
                                    	</tbody>
                                    </table></div>
                            	';
                            } else {
                                echo '<i>'.Lang('no_data_available').'</i>';
                            }
                        } else {
                            echo '<i>'.Lang('input_invalid').'</i>';
                        }
                    }
                ?>
            </div>

	   		<div role="tabpanel" class="tab-pane" id="admin_donations_tab_statistics">
	   			<br>

	   			<div class="row">
	   				<div class="col-sm-8">
		   				<div class="box">
						    <div class="box-header">
						        <div class="box-title pull-left">
									<p><i class="fa fa-area-chart fa-lg"></i></p>
						        	<p><b><?php echo Lang('earnings_monthly'); ?></b></p>
						        </div>
							</div>

						  	<div class="box-content" id="admin_donations_statistics_monthly">
						  		<div class="col-xs-12">
									<div id="admin_donations_statistics_monthly_chart" style="height: 50%;"></div>
								</div>
						  	</div>
						</div>
					</div>

					<div class="col-sm-4">
		   				<div class="box">
						    <div class="box-header">
						        <div class="box-title pull-left">
									<p><i class="fa fa-usd fa-lg"></i></p>
						        	<p><b><?php echo Lang('earnings_total'); ?></b></p>
						        </div>
							</div>

						  	<div class="box-content text-center" id="admin_donations_statistics_total">
						  		<h2><b><?php echo Donations::GetTotalEarnings().' '.Settings::Get('settings_donations_currency_plain'); ?></b></h2><br>
						  	</div>
						</div>

						<div class="box">
						    <div class="box-header">
						        <div class="box-title pull-left">
									<p><i class="fa fa-sign-out fa-lg"></i></p>
						        	<p><b><?php echo Lang('earnings_by_gateway'); ?></b></p>
						        </div>
							</div>

						  	<div class="box-content" id="admin_donations_statistics_gateway">
						  		<canvas id="admin_donations_statistics_gateway_chart" width="100%" height="100%"></canvas>
						  	</div>
						</div>
					</div>
	   			</div>

	   			<div class="row">
	   				<div class="col-xs-6">
	   					<div class="box">
						    <div class="box-header">
						        <div class="box-title pull-left">
									<p><i class="fa fa-server fa-lg"></i></p>
						        	<p><b><?php echo Lang('server_sales'); ?></b></p>
						        </div>
							</div>

						  	<div class="box-content" id="admin_donations_statistics_server">
						  		<canvas id="admin_donations_statistics_server_chart" width="100%" height="100%"></canvas>
						  	</div>
						</div>
					</div>

					<div class="col-xs-6">
	   					<div class="box">
						    <div class="box-header">
						        <div class="box-title pull-left">
									<p><i class="fa fa-archive fa-lg"></i></p>
						        	<p><b><?php echo Lang('package_sales'); ?></b></p>
						        </div>
							</div>

						  	<div class="box-content text-center" id="admin_donations_statistics_packages">
						  		<canvas id="admin_donations_statistics_package_chart" width="100%" height="100%"></canvas>
						  	</div>
						</div>
					</div>
	   			</div>
	   		</div>
	   	</div>
	</div>
</div>

<!-- DonationDetails Modal -->
<div class="modal fade" id="admin_donations_modal_donation" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-usd"></i> &nbsp;<?php echo Lang('donation_details'); ?></h4>
			</div>

			<div class="modal-body">
				<table class="table table-responsive table-striped">
				    <caption><?php echo Lang('general'); ?></caption>
					<tr>
						<td style="width: 35%;">ID:</td>
						<td id="admin_donations_modal_donation_detail_id"></td>
					</tr>
					<tr>
						<td><?php echo Lang('amount'); ?>:</td>
						<td id="admin_donations_modal_donation_detail_amount"></td>
					</tr>
					<tr>
						<td><?php echo Lang('buyer'); ?>:</td>
						<td id="admin_donations_modal_donation_detail_buyer"></td>
					</tr>
					<tr>
						<td><?php echo Lang('for'); ?>:</td>
						<td id="admin_donations_modal_donation_detail_for"></td>
					</tr>
					<tr>
						<td><?php echo Lang('date'); ?>:</td>
						<td id="admin_donations_modal_donation_detail_date"></td>
					</tr>
					<tr>
						<td><?php echo Lang('package'); ?>:</td>
						<td id="admin_donations_modal_donation_detail_package"></td>
					</tr>
					<tr>
						<td><?php echo Lang('gateway'); ?>:</td>
						<td id="admin_donations_modal_donation_detail_gateway"></td>
					</tr>
				</table>

				<table class="table table-responsive table-striped" id="admin_donations_modal_donation_taxes">
				    <caption><?php echo Lang('taxes'); ?></caption>
					<tr>
						<td style="width: 35%;"><?php echo Lang('tax_amount'); ?>:</td>
						<td id="admin_donations_modal_donation_taxes_taxamount"></td>
					</tr>
					<tr>
						<td><?php echo Lang('tax_rate'); ?>:</td>
						<td id="admin_donations_modal_donation_taxes_taxrate"></td>
					</tr>
					<tr>
						<td><?php echo Lang('country'); ?>:</td>
						<td id="admin_donations_modal_donation_taxes_country"></td>
					</tr>
				</table>

				<br/>

				<div id="admin_donations_modal_donation_revoked">

				</div>

				<div id="admin_donations_modal_donation_gateway_advanced">

				</div>

				<div id="admin_donations_modal_donation_coupon">

				</div>
			</div>

			<div class="modal-footer" id="admin_donations_modal_donation_footer">

			</div>
		</div>
	</div>
</div>

<!-- Create Coupon Modal -->
<div class="modal fade" id="admin_donations_modal_coupon_create" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-ticket"></i> &nbsp;<?php echo Lang('coupon_create'); ?></h4>
			</div>

			<form action="index.php?t=admin_donations&part=coupons" method="post">
				<div class="modal-body">
					<label><?php echo Lang('code'); ?></label><br>
		            <input name="admin_donations_modal_coupon_create_form_code" type="text" class="form-control" value="<?php echo strtoupper(random_string(16)); ?>" placeholder="<?php echo Lang('code'); ?>">
		            <br>

					<label><?php echo Lang('amount'); ?></label><br>
		            <input name="admin_donations_modal_coupon_create_form_amount" type="text" class="form-control" value="10">
				</div>

				<div class="modal-footer">
					<button type="submit" class="btn btn-success"><?php echo Lang('create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>


<script>
    var url_page = '<?php echo ''.(isset($_GET['page']) ? '&page='.$_GET['page'] : '').(isset($_GET['page_bp']) ? '&page_bp='.$_GET['page_bp'] : ''); ?>';

	$("input[name='admin_donations_modal_coupon_create_form_amount']").TouchSpin({
        min: 0,
        max: 100000,
        step: 0.01,
        decimals: 2,
        verticalbuttons: true,
        prefix: '<?php echo Settings::Get('settings_donations_currency_plain'); ?>'
    });

	function admin_donations_coupon_create(){
		$('#admin_donations_modal_coupon_create').modal('show');
	}

	function admin_donations_donation_show(id){
		if($.isNumeric(id)){
			$.getJSON('request.php?t=admin_donations&id=' + id, function(data) {
				$('#admin_donations_modal_donation_detail_id').html(data['donation']['id']);
				$('#admin_donations_modal_donation_detail_buyer').html('<a target="_blank" href="index.php?t=user&id=' + data['buyer']['steamid64'] + '">' + data['buyer']['nick'] + '</a>');
				$('#admin_donations_modal_donation_detail_for').html('<a target="_blank" href="index.php?t=user&id=' + data['for']['steamid64'] + '">' + data['for']['nick'] + '</a>');
				$('#admin_donations_modal_donation_detail_date').html(data['date']);

				if(data['donation']['tax_rate'] > 0){
                    $('#admin_donations_modal_donation_taxes').show();
				    $('#admin_donations_modal_donation_taxes_taxamount').html(data['donation']['tax_amount'] + ' <?php echo Settings::Get('settings_donations_currency_plain'); ?>');
    				$('#admin_donations_modal_donation_taxes_taxrate').html(data['donation']['tax_rate'] + '%');
    				$('#admin_donations_modal_donation_taxes_country').html(data['donation']['country']);
				}else{
				    $('#admin_donations_modal_donation_taxes').hide();
				}

				if(data['package']){
					$('#admin_donations_modal_donation_detail_package').html(data['package']['title']);
				}else{
					$('#admin_donations_modal_donation_detail_package').html('<font color="red"><i class="fa fa-times"></i></font>');
				}

				$('#admin_donations_modal_donation_detail_gateway').html(data['donation']['gateway']);
				$('#admin_donations_modal_donation_detail_amount').html(data['donation']['amount'] + ' <?php echo Settings::Get('settings_donations_currency_plain'); ?>');

				if(data['donation']['gateway'] == 'paypal'){
					$('#admin_donations_modal_donation_gateway_advanced').html(`
						<div class="panel panel-primary">
							<div class="panel-heading">
								<h3 class="panel-title"><i class="fa fa-paypal"></i> PayPal</h3>
							</div>
							<div class="panel-body">
								<?php echo Lang('transactionid'); ?>: ` + data['donation']['transactionid'] + `
								<div class="pull-right">
									<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_view-a-trans&id=` + data['donation']['transactionid'] + `" target="_blank"><button type="button" class="btn btn-xs btn-primary"><i class="fa fa-paypal"></i></button></a>
								</div>
							</div>
						</div>
					`);
				}else if(data['donation']['gateway'] == 'payssion'){
					$('#admin_donations_modal_donation_gateway_advanced').html(`
						<div class="panel panel-info">
							<div class="panel-heading">
								<h3 class="panel-title"><i class="fa fa-globe"></i> Payssion</h3>
							</div>
							<div class="panel-body">
								<?php echo Lang('transactionid'); ?>: ` + data['donation']['transactionid'] + `
								<div class="pull-right">
									<a href="https://payssion.com/account/payments/detail?id=` + data['donation']['transactionid'] + `" target="_blank"><button type="button" class="btn btn-xs btn-info"><i class="fa fa-globe"></i></button></a>
								</div>
							</div>
						</div>
					`);
				}else if(data['donation']['gateway'] == 'g2apay'){
					$('#admin_donations_modal_donation_gateway_advanced').html(`
						<div class="panel panel-warning">
							<div class="panel-heading">
								<h3 class="panel-title"><i class="fa fa-star"></i> G2A Pay</h3>
							</div>
							<div class="panel-body">
								<?php echo Lang('transactionid'); ?>: ` + data['donation']['transactionid'] + `
								<div class="pull-right">
									<a href="https://pay.g2a.com/merchant/transactionDetails/` + data['donation']['transactionid'] + `" target="_blank"><button type="button" class="btn btn-xs btn-warning"><i class="fa fa-star"></i></button></a>
								</div>
							</div>
						</div>
					`);
				}else if(data['donation']['gateway'] == 'stripe'){
					$('#admin_donations_modal_donation_gateway_advanced').html(`
						<div class="panel panel-info">
							<div class="panel-heading">
								<h3 class="panel-title"><i class="fa fa-cc-stripe"></i> Stripe</h3>
							</div>
							<div class="panel-body">
								<?php echo Lang('transactionid'); ?>: ` + data['donation']['transactionid'] + `
								<div class="pull-right">
									<a href="https://dashboard.stripe.com/payments/` + data['donation']['transactionid'] + `" target="_blank"><button type="button" class="btn btn-xs btn-info"><i class="fa fa-cc-stripe"></i></button></a>
								</div>
							</div>
						</div>
					`);
				}else if(data['donation']['gateway'] == 'coupon'){
					$('#admin_donations_modal_donation_gateway_advanced').html('');
				}else if(data['donation']['gateway'] == 'paysafecard'){
					if(data['paysafecard_partner']){
						$('#admin_donations_modal_donation_gateway_advanced').html(`
							<div class="panel panel-danger">
								<div class="panel-heading">
									<h3 class="panel-title"><i class="fa fa-credit-card-alt"></i> Paysafecard Partner</h3>
								</div>
								<div class="panel-body">
									<?php echo Lang('transactionid'); ?>: ` + data['donation']['transactionid'] + `
								</div>
							</div>
						`);
					}else if(data['paysafecard']){
						$('#admin_donations_modal_donation_gateway_advanced').html(`
							<div class="panel panel-danger">
								<div class="panel-heading">
									<h3 class="panel-title"><i class="fa fa-credit-card-alt"></i> Paysafecard</h3>
								</div>
								<div class="panel-body">
									Paysafecard PINs: ` + data['paysafecard']['pins'] + `
								</div>
							</div>
						`);
					}
				}else{
					$('#admin_donations_modal_donation_gateway_advanced').html(`
						<div class="panel panel-default">
							<div class="panel-heading">
									<h3 class="panel-title"><i class="fa fa-money"></i> <?php echo Lang('other'); ?></h3>
								</div>
							<div class="panel-body">
								<b><?php echo Lang('transactionid'); ?>:</b> ` + data['donation']['transactionid'] + `
							</div>
						</div>
					`);
				}

				if(data['donation']['revoked']){
					$('#admin_donations_modal_donation_revoked').html(`
						<div class="alert alert-danger" role="alert"><?php echo Lang('donation_hasbeen_revoked'); ?></div>
					`);
				}

				$('#admin_donations_modal_donation_coupon').html('');

				if(data.hasOwnProperty('coupon')){
					$('#admin_donations_modal_donation_coupon').html(`
						<div class="panel panel-success">
							<div class="panel-heading">
								<h3 class="panel-title"><i class="fa fa-ticket"></i> <?php echo Lang('coupon'); ?></h3>
							</div>
							<div class="panel-body">
								<table class="table table-responsive table-condensed table-bordered">
									<tr style="border-bottom:2px solid black;">
										<td>
											<b><?php echo Lang('used_coupon'); ?></b>
										</td>
										<td>
											<b>` + data['coupon']['code'] + `</b>
										</td>
									</tr>
									<tr>
										<td>
											<?php echo Lang('amount_left'); ?>
										</td>
										<td>
											<?php echo Settings::Get('settings_donations_currency'); ?>` + parseFloat(data['coupon']['amount_left']).toFixed(2) + `
										</td>
									</tr>
									<tr>
										<td>
											<?php echo Lang('amount_initial'); ?>
										</td>
										<td>
											<?php echo Settings::Get('settings_donations_currency'); ?>` + parseFloat(data['coupon']['amount']).toFixed(2) + `
										</td>
									</tr>
								</table>
							</div>
						</div>
					`);
				}

				var revokebtn = '<button onclick="admin_donations_donation_revoke(' + data['donation']['id'] + ');" class="btn btn-danger btn-simple"><?php echo Lang('revoke'); ?></button>';

				if(data['donation']['revoked']){
					revokebtn = '<button onclick="admin_donations_donation_unrevoke(' + data['donation']['id'] + ');" class="btn btn-success btn-simple"><?php echo Lang('unrevoke'); ?></button>';
				}


				$('#admin_donations_modal_donation_footer').html('<span class="pull-left"><a target="_blank" href="index.php?t=invoice&id=' + data['donation']['id'] + '"><button class="btn btn-info btn-simple"><i class="fa fa-file-pdf-o"></i> <?php echo Lang('invoice'); ?></button></a></span><button class="btn btn-danger btn-simple" onclick="admin_donations_donation_delete(' + data['donation']['id'] + ');"><?php echo Lang('delete'); ?></button> ' + revokebtn);

				$('#admin_donations_modal_donation').modal('show');
			});
		}
	}

	function admin_donations_adjustsize(){
		if($( document ).width() > 870){
			var height_right = $('#admin_donations_statistics_gateway').offset().top - $('#admin_donations_statistics_total').offset().top + $('#admin_donations_statistics_gateway').height();

			if(height_right > $('#admin_donations_statistics_monthly').height() ){
				$('#admin_donations_statistics_monthly').height(height_right);
			}
		}
	}

	$( window ).resize(function() {
		admin_donations_adjustsize();
	});

	function admin_donations_donation_delete(donationid){
        var text = '<?php echo Lang('are_you_sure'); ?>';

        (new PNotify({
            title: '<?php echo Lang('confirmation'); ?>',
            text: text,
            type: "error",
            hide: false,
            icon: '',
            confirm: {
                confirm: true
            },
            buttons: {
                closer: false,
                sticker: false
            },
            history: {
                history: false
            }
            })).get().on('pnotify.confirm', function() {
                post('index.php?t=admin_donations' + url_page, {admin_donations_donation_delete: donationid});
        });
	}

	function admin_donations_package_delete(package_bought){
        var text = '<?php echo Lang('are_you_sure'); ?>';

        (new PNotify({
            title: '<?php echo Lang('confirmation'); ?>',
            text: text,
            type: "error",
            hide: false,
            icon: '',
            confirm: {
                confirm: true
            },
            buttons: {
                closer: false,
                sticker: false
            },
            history: {
                history: false
            }
            })).get().on('pnotify.confirm', function() {
                post('index.php?t=admin_donations&part=packages_bought' + url_page, {admin_donations_package_delete: package_bought});
        });
	}

	function admin_donations_donation_revoke(donationid){
		post('index.php?t=admin_donations' + url_page, {"admin_donations_donation_revoke": donationid});
	}

	function admin_donations_donation_unrevoke(donationid){
		post('index.php?t=admin_donations' + url_page, {"admin_donations_donation_unrevoke": donationid});
	}

	function admin_donations_package_disable(package_bought){
		post('index.php?t=admin_donations&part=packages_bought' + url_page, {"admin_donations_package_disable": package_bought});
	}

	function admin_donations_package_enable(package_bought){
		post('index.php?t=admin_donations&part=packages_bought' + url_page, {"admin_donations_package_enable": package_bought});
	}

	function admin_donations_paysafecard_status_change(id, pins, price_should){
		(new PNotify({
	        title: '<?php echo Lang('accept_deny'); ?>',
	        text: '<small>' + pins + '<br><?php echo Lang('needed_credit').': '.Settings::Get('settings_donations_currency'); ?>' + price_should + '</small>',
	        icon: '',
	        type: "success",
	        hide: false,
	        confirm: {
		        confirm: true,
		        buttons: [{
		            text: '<?php echo Lang('accept'); ?>',
		            addClass: 'btn-primary',
		            click: function() {
		                post("index.php?t=admin_donations&part=paysafecard", {"admin_donations_paysafecard_accept": id});
		            }
		        }, {
		            text: '<?php echo Lang('deny'); ?>',
		            click: function() {
		                post("index.php?t=admin_donations&part=paysafecard", {"admin_donations_paysafecard_deny": id});
		            }
		        }, {
		            text: '<?php echo Lang('cancel'); ?>',
		            click: function(notice) {
		                notice.remove();
		            }
		        }]
		    },
	        buttons: {
	            closer: false,
	            sticker: false
	        },
	        history: {
	            history: false
	        }
	    }));
	}

	function admin_donations_coupon_edit(code){
		(new PNotify({
	        title: '<?php echo Lang('coupon_edit'); ?>',
	        icon: '',
	        type: "info",
	        hide: false,
	        confirm: {
		        confirm: true,
		        buttons: [{
		            text: '<?php echo Lang('empty'); ?>',
		            click: function() {
		                post("index.php?t=admin_donations&part=coupons", {"admin_donations_coupon_empty": code});
		            }
		        }, {
		            text: '<?php echo Lang('refill'); ?>',
		            click: function() {
		                post("index.php?t=admin_donations&part=coupons", {"admin_donations_coupon_refill": code});
		            }
		        },{
		            text: '<?php echo Lang('delete'); ?>',
		            click: function() {
		                post("index.php?t=admin_donations&part=coupons", {"admin_donations_coupon_delete": code});
		            }
		        }, {
		            text: '<?php echo Lang('cancel'); ?>',
		            addClass: 'btn-primary',
		            click: function(notice) {
		                notice.remove();
		            }
		        }]
		    },
	        buttons: {
	            closer: false,
	            sticker: false
	        },
	        history: {
	            history: false
	        }
	    }));
	}

    $('.nav-tabs > li').bind('click', function (e) {
        var tab = $(e.target).attr('href').substr(21);
		history.pushState(null, null, "index.php?t=admin_donations&part=" + tab);


		setTimeout(function(){
			admin_donations_adjustsize();
		}, 500)
    });

    var earnings_monthly = <?php echo ToJson(Donations::GetMonthlyEarnings()); ?>

    var admin_donations_statistics_monthly_chart_data = {
        "graphset": [
            {
                "type": "area",
                "title": {
				  "text":"<?php echo Lang('monthly_earnings'); ?>"
				},
				"gui": {
					"behaviors":
					[
			            {
			                "id":"DownloadPDF",
			                "enabled":"none"
			            },
			            {
			                "id":"DownloadPNG",
			                "enabled":"none"
			            },
			            {
			                "id":"DownloadSVG",
			                "enabled":"none"
			            },
			            {
			                "id":"About",
			                "enabled":"none"
			            },
			            {
			                "id":"Print",
			                "enabled":"none"
			            },
			            {
			                "id":"SaveAsImage",
			                "enabled":"none"
			            },
			            {
			                "id":"ViewSource",
			                "enabled":"none"
			            },
			            {
			                "id":"ExportData",
			                "enabled":"none"
			            },
			            {
			                "id":"GuideHide",
			                "enabled":"none"
			            },
			            {
			                "id":"GuideShow",
			                "enabled":"none"
			            },
			            {
			                "id":"ZoomIn",
			                "enabled":"none"
			            },
			            {
			                "id":"ZoomOut",
			                "enabled":"none"
			            },
			            {
			                "id":"CrosshairHide",
			                "enabled":"none"
			            }
			        ]
				},
                "tooltip":{
                    "visible":false
                },
                "crosshair-x":{
                    "plot-label":{
                        "text":"%v <?php echo Settings::Get('settings_donations_currency_plain'); ?>"
                    }
                },
                "backgroundColor":"none",
                "scale-x":{
                    "-max-items":5,
                    "-max-labels":5,
                    "max-ticks":5,
                    "transform":{
                        "item":{
                            "visible":false
                        },
                        "type":"date",
                        "all": "%M %Y"
                    }
                },
                "series":[
	                {
	                  "values": earnings_monthly
	                }
                ]
            }
        ]
    };

    zingchart.render({
        id: 'admin_donations_statistics_monthly_chart',
        data: admin_donations_statistics_monthly_chart_data,
        height: "99%",
        width: "100%",
		hideprogresslogo: true
    });

    //gateway

    var admin_donations_statistics_gateway_chart_data = <?php echo json_encode(Donations::GetEarningsByGateway()); ?>;

    var admin_donations_statistics_gateway_chart_config = {
        type: 'pie',
        data: admin_donations_statistics_gateway_chart_data ,
        options: {
            responsive: true
        }
    };

    var ctx = $("#admin_donations_statistics_gateway_chart").get(0).getContext("2d");

	var admin_donations_statistics_gateway_chart = new Chart(ctx, admin_donations_statistics_gateway_chart_config);

	//Server

	var admin_donations_statistics_server_chart_data = <?php echo json_encode(Donations::GetSalesPerServer()); ?>;

    var admin_donations_statistics_server_chart_config = {
        type: 'pie',
        data: admin_donations_statistics_server_chart_data ,
        options: {
            responsive: true
        }
    };

    var ctx = $("#admin_donations_statistics_server_chart").get(0).getContext("2d");

	var admin_donations_statistics_server_chart = new Chart(ctx, admin_donations_statistics_server_chart_config);

	//Package

	var admin_donations_statistics_package_chart_data = <?php echo json_encode(Donations::GetSalesPerPackage()); ?>;

    var admin_donations_statistics_package_chart_config = {
        type: 'pie',
        data: admin_donations_statistics_package_chart_data ,
        options: {
            responsive: true
        }
    };

    var ctx = $("#admin_donations_statistics_package_chart").get(0).getContext("2d");

	var admin_donations_statistics_package_chart = new Chart(ctx, admin_donations_statistics_package_chart_config);

	jQuery(window).load(function () {
	    admin_donations_adjustsize();
	});

</script>

<?php
    if (isset($_GET['part'])) {
        echo '<script>
					activateTab("admin_donations_tab_'.$_GET['part'].'");
			</script>';
    }

    if (isset($_GET['id'])) {
        echo '<script>
					admin_donations_donation_show('.$_GET['id'].');
					history.pushState(null, null, "index.php?t=admin_donations");
			</script>';
    }
?>
