<!--{"language":"faq","icon":"fa-list-ol","place":"admin","position":40}-->

<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['admin_faq_edit_save'])) {
            if (is_numeric($_POST['admin_faq_edit_id'])) {
                $data = array(
                    'question' => htmlspecialchars($_POST['admin_faq_edit_question']),
                    'answer' => ValidateHTML($_POST['admin_faq_edit_answer']),
                    'category' => htmlspecialchars($_POST['admin_faq_edit_category']),
                    'orderid' => 0,
                );

                $db->where('id', $_POST['admin_faq_edit_id']);

                if ($db->update('faq', $data)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                }
            }
        } elseif (isset($_POST['admin_faq_edit_delete'])) {
            if (is_numeric($_POST['admin_faq_edit_id'])) {
                $db->where('id', $_POST['admin_faq_edit_id']);

                if ($db->delete('faq')) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('faq_deleted_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
                }
            }
        } elseif (isset($_POST['admin_faq_add_save'])) {
            $data = array(
                'question' => htmlspecialchars($_POST['admin_faq_add_question']),
                'answer' => ValidateHTML($_POST['admin_faq_add_answer']),
                'category' => htmlspecialchars($_POST['admin_faq_add_category']),
                'orderid' => 1000,
            );

            if ($db->insert('faq', $data)) {
                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('faq_created_success').'", type: "success"');
            } else {
                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
            }
        }
    }
?>

<!-- Summernote CSS -->
<link rel="stylesheet" href="assets/css/summernote.css" />

<!-- Summernote JS-->
<script src="assets/js/summernote.min.js"></script>
<!-- Sortable JS-->
<script src="assets/js/sortable.js"></script>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('administration_faq'); ?>
			<div class="pull-right">
				<?php echo !isset($_GET['sort']) ? '<a href="index.php?t=admin_faq&sort"><button class="btn btn-warning"><i class="fa fa-sort"></i></button></a>' : '<a href="index.php?t=admin_faq"><button class="btn btn-warning"><i class="fa fa-pencil"></i></button></a>'; ?>
				<button onclick="admin_faq_new();" type="button" class="btn btn-success"><i class="fa fa-plus-circle"></i> <?php echo Lang('entry_create'); ?></button>
			</div>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<?php
            $entries_sorted = FAQ::GetEntries();
            $i = 0;
            foreach ($entries_sorted as $category => $entries) {
                ++$i;
                if (empty($category)) {
                    $category = Lang('general');
                }

                echo '<label>'.$category.'</label><span class="'.(isset($_GET['sort']) ? 'sortable' : '').'">';
                foreach ($entries as $entry) {
                    echo '
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title">
									<a data-toggle="'.(!isset($_GET['sort']) ? 'collapse' : '').'" href="#admin_faq_collapse_'.$entry['id'].'">'.$entry['question'].'</a>
									'.(isset($_GET['sort']) ? '<span class="pull-right"><i class="fa fa-sort cursor-sortable"></i></span>' : '').'
								</h4>
							</div>
							<div id="admin_faq_collapse_'.$entry['id'].'" class="panel-collapse collapse">

								<form action="index.php?t=admin_faq" method="POST">
									<div class="panel-body">
										<input name="admin_faq_edit_id" class="admin_faq_entry_id" type="hidden" value="'.$entry['id'].'" />
										<div class="row">
											<div class="col-xs-8">
												<label>'.Lang('question').'</label><br />
												<input name="admin_faq_edit_question" class="form-control" placeholder="'.Lang('question').'" value="'.$entry['question'].'" />
											</div>

											<div class="col-xs-4">
												<label>'.Lang('category').'</label><br />
												<input name="admin_faq_edit_category" class="form-control" placeholder="'.Lang('category').'" value="'.$entry['category'].'" />
											</div>
										</div>

										<br />
										<label>'.Lang('answer').'</label><br />
										<textarea class="summernote-faq" name="admin_faq_edit_answer">'.$entry['answer'].'</textarea>
									</div>
									<div class="panel-footer">
										<button name="admin_faq_edit_save" class="btn btn-primary">'.Lang('save').'</button>
										<button name="admin_faq_edit_delete" class="btn btn-danger"><i class="fa fa-trash"></i></button>
									</div>
								</form>
							</div>
						</div>
					';
                }

                echo '</span>';

                if ($i < sizeof($entries_sorted)) {
                    echo '<hr>';
                }
            }

            if (!sizeof($entries_sorted)) {
                echo '<i>'.Lang('no_entries').'</i>';
            } else {
                echo isset($_GET['sort']) ? '<button onclick="admin_faq_order_save();" class="btn btn-sm btn-primary">'.Lang('order_save').'</button>' : '';
            }
        ?>
	</div>
</div>

<!-- Create entry Modal -->
<div class="modal fade" id="admin_faq_add_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-list-ol"></i> &nbsp;<?php echo Lang('faq_new'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_faq">
				<div class="modal-body">
					<label><?php echo Lang('category'); ?></label><br>
					<input name="admin_faq_add_category" class="form-control" placeholder="<?php echo Lang('category'); ?>"  />
					<br />

					<label><?php echo Lang('question'); ?></label><br>
					<input name="admin_faq_add_question" class="form-control" placeholder="<?php echo Lang('question'); ?>"  />
					<br />

					<label><?php echo Lang('answer'); ?></label><br>
					<textarea class="summernote-faq" name="admin_faq_add_answer"></textarea>
				</div>
				<div class="modal-footer">
					<button type="submit" name="admin_faq_add_save" class="btn btn-success"><?php echo Lang('create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
	$('.sortable').each(function(i, obj){
		new Sortable(obj);
	});

	function admin_faq_new(){
		$('#admin_faq_add_modal').modal('show');
	}

	$('.summernote-faq').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});

	function admin_faq_order_save(){
		var entries = [];

    	$('.admin_faq_entry_id').each(function(i, obj){
			entries[$(obj).val()] = i;
		});

		$.getJSON('request.php?t=admin_faq&order=' + JSON.stringify(entries), function(data) {
			if(data['success']){
				new PNotify({
				    title: '<?php echo Lang('success'); ?>',
				    text: '<?php echo Lang('order_saved'); ?>',
				    type: 'success'
				});
			}else{
				new PNotify({
				    title: '<?php echo Lang('error'); ?>',
				    text: data['error'],
				    type: 'error'
				});
			}
		});
    }
</script>