<!--{"language":"gban_import","icon":"fa-money","place":"none","position":0}-->

<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (!Permissions::HasPermission('super')) {
            die('The GBan import function can only be used by an user with super permission.');
        }

        $success = false;
        $transactions = null;
        $packages = null;

        if (isset($_POST['admin_import_gban_mysql_ip'])) {
            $mysql = array(
                'ip' => $_POST['admin_import_gban_mysql_ip'],
                'user' => $_POST['admin_import_gban_mysql_user'],
                'password' => $_POST['admin_import_gban_mysql_password'],
                'port' => $_POST['admin_import_gban_mysql_port'],
                'database' => $_POST['admin_import_gban_mysql_db'],
            );

            $empty = false;

            foreach ($mysql as $value) {
                if (empty($value)) {
                    $empty = true;
                }
            }

            if (!$empty) {
                $promdb = mysqli_init();
                $promdb->options(MYSQLI_OPT_CONNECT_TIMEOUT, 5) || die('<br>mysqli_options croaked: '.$promdb->error);
                $promdb->real_connect($mysql['ip'], $mysql['user'], $mysql['password'], $mysql['database'], $mysql['port']) || die('<br>mysqli_real_connect croaked: '.$promdb->error);

                if (mysqli_connect_errno()) {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.RemoveQuotes(mysqli_connect_error()).'", type: "error"');
                } else {
                    if ($result_bans = $promdb->query('SELECT * FROM gban_list;')) {
                        $banids = $db->getValue('bans', 'steamid64', null);
                        $bans_current = $db->get('bans');

                        function SearchBan($bans_current, $steamid64, $steamid64_admin, $date_banned, $length)
                        {
                            foreach ($bans_current as $ban_current) {
                                if ($ban_current['steamid64'] == $steamid64) {
                                    if ($ban_current['steamid64_admin'] == $steamid64_admin) {
                                        if ($ban_current['date_banned'] == $date_banned) {
                                            if ($ban_current['length'] == $length) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }

                            return false;
                        }

                        $double = 0;
                        $imported = 0;

                        while ($ban = $result_bans->fetch_assoc()) {
                            if (isset($ban['target_uniqueid']) && isset($ban['admin_id']) && isset($ban['reason']) && isset($ban['date']) && isset($ban['length'])) {
                                $steamid64 = $ban['target_uniqueid'];
                                $steamid64_admin = ('CONSOLE' == $ban['admin_id'] ? '0' : SteamIDTo64($ban['admin_id']));
                                $reason = $ban['reason'];
                                $date = $ban['date'];
                                $length = $ban['length'];

                                if (tempty($steamid64)) {
                                    if (!tempty($ban['target_id'])) {
                                        $steamid64 = SteamIDTo64($ban['target_id']);
                                    }
                                }

                                if (0 != $length) {
                                    $length = ceil(($length - $date) / 60);

                                    if ($length < 0) {
                                        $length = 1;
                                    }
                                }

                                $date = date('Y-m-d H:i:s', $date);

                                if (!is_numeric($steamid64_admin)) {
                                    $steamid64_admin = '0';
                                }

                                if (!tempty($steamid64) && !tempty($date)) {
                                    $ok = false;

                                    if (!in_array($steamid64, $banids)) {
                                        $ok = true;
                                    } else {
                                        if (!SearchBan($bans_current, $steamid64, $steamid64_admin, $date, $length)) {
                                            $ok = true;
                                        }
                                    }

                                    if ($ok) {
                                        Bans::Add($steamid64, $length, $reason, $steamid64_admin, 0, 1, $date, true);
                                        ++$imported;
                                    } else {
                                        ++$double;
                                    }
                                } else {
                                    $est = 1;
                                }
                            } else {
                                $est = 1;
                            }
                        }

                        if (0 == $imported) {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "Couldn\'t find any bans to import.<br/>Ignored '.$double.'.", type: "error"');
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "Successfuly imported '.$imported.' bans.<br/>Ignored '.$double.'.", type: "success"');
                        }
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "No gBan data found!", type: "error"');
                    }
                }
            }
        }
    }
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('gban_import'); ?>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<h4>How to import bans from GBan</h4>
		<ol>
			<li>Insert MySQL credentials for the database with the GBan tables</li>
			<li>Press the "Import" button</li>
		</ol>

		<br/>

		READ FIRST: <a href="https://gextension.ibot3.de/wiki/index.php?title=Import:GBan" target="_blank">INSTRUCTIONS (WIKI)</a>

		<br>
		<br>
		<label>Already imported bans will not get imported again.</label>

		<hr>

		<form action="index.php?t=admin_import_gban" method="POST">
			<label>MySQL IP</label><br/>
			<input class="form-control" name="admin_import_gban_mysql_ip" /><br/>
			<label>MySQL Username</label><br/>
			<input class="form-control" name="admin_import_gban_mysql_user" /><br/>
			<label>MySQL Password</label><br/>
			<input class="form-control" name="admin_import_gban_mysql_password" /><br/>
			<label>MySQL Port</label><br/>
			<input class="form-control" value="3306" name="admin_import_gban_mysql_port" /><br/>
			<label>MySQL Database</label><br/>
			<input class="form-control" name="admin_import_gban_mysql_db" /><br/>
			
			<input type="hidden" name="__resubmit" value="<?php echo GenerateResubmitToken(); ?>" />

			<button type="submit" class="btn btn-primary">Import</button>
		</form>
	</div>
</div>