<!--{"language":"prometheus_import","icon":"fa-money","place":"none","position":0}-->

<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (!Permissions::HasPermission('super')) {
            die('The Prometheus import function can only be used by an user with super permission.');
        }

        $success = false;
        $transactions = null;
        $packages = null;

        if (isset($_POST['admin_import_prometheus_mysql_ip'])) {
            $mysql = array(
                'ip' => $_POST['admin_import_prometheus_mysql_ip'],
                'user' => $_POST['admin_import_prometheus_mysql_user'],
                'password' => $_POST['admin_import_prometheus_mysql_password'],
                'port' => $_POST['admin_import_prometheus_mysql_port'],
                'database' => $_POST['admin_import_prometheus_mysql_db'],
            );

            $empty = false;

            foreach ($mysql as $value) {
                if (empty($value)) {
                    $empty = true;
                }
            }

            if (!$empty) {
                $promdb = mysqli_init();
                $promdb->options(MYSQLI_OPT_CONNECT_TIMEOUT, 5) || die('<br>mysqli_options croaked: '.$promdb->error);
                $promdb->real_connect($mysql['ip'], $mysql['user'], $mysql['password'], $mysql['database'], $mysql['port']) || die('<br>mysqli_real_connect croaked: '.$promdb->error);

                if (mysqli_connect_errno()) {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.RemoveQuotes(mysqli_connect_error()).'", type: "error"');
                } else {
                    if ($result_packages = $promdb->query('SELECT * FROM packages;')) {
                        if ($result_transactions = $promdb->query('SELECT * FROM transactions;')) {
                            if ($result_transactions->num_rows > 0 && $result_packages->num_rows > 0) {
                                $transactions = array();
                                while ($transaction = $result_transactions->fetch_assoc()) {
                                    $transactions[] = $transaction;
                                }

                                $packages = array();
                                while ($package = $result_packages->fetch_assoc()) {
                                    $packages[] = $package;
                                }

                                Settings::Set('import_prometheus_mysql', ToJson($mysql));

                                $success = true;
                            }
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "No prometheus data found!", type: "error"');
                        }
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "No prometheus data found!", type: "error"');
                    }
                }
            }
        } elseif (isset($_POST['admin_import_prometheus_import'])) {
            $mysql = FromJson(Settings::Get('import_prometheus_mysql'));

            $empty = false;

            foreach ($mysql as $value) {
                if (empty($value)) {
                    $empty = true;
                }
            }

            if (!$empty) {
                $promdb = mysqli_init();
                $promdb->options(MYSQLI_OPT_CONNECT_TIMEOUT, 5) || die('<br>mysqli_options croaked: '.$promdb->error);
                $promdb->real_connect($mysql['ip'], $mysql['user'], $mysql['password'], $mysql['database'], $mysql['port']) || die('<br>mysqli_real_connect croaked: '.$promdb->error);

                if (mysqli_connect_errno()) {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.RemoveQuotes(mysqli_connect_error()).'", type: "error"');
                } else {
                    if ($result_transactions = $promdb->query('SELECT * FROM transactions;')) {
                        if ($result_transactions->num_rows > 0) {
                            $transactions = array();
                            while ($transaction = $result_transactions->fetch_assoc()) {
                                $transactions[] = $transaction;
                            }

                            $count = 0;

                            if (sizeof($transactions)) {
                                $transactionids = $db->getValue('donations', 'transactionid', null);

                                if (!is_array($transactionids)) {
                                    $transactionids = array();
                                }

                                foreach ($_POST as $key => $val) {
                                    if (StartsWith($key, 'admin_import_prometheus_package_from_')) {
                                        $oldpackage = substr($key, 37);
                                        $newpackage = $val;

                                        if ($newpackage > 0) {
                                            $package = new Package($newpackage);

                                            if ($package->valid) {
                                                foreach ($transactions as $key => $transaction) {
                                                    if ($transaction['package'] == $oldpackage) {
                                                        $transactionid = $transaction['txn_id'];

                                                        if (tempty($transactionid) || 'Assigned by Admin' == $transactionid) {
                                                            $transactionid = 'prometheus-'.$transaction['id'];
                                                        }

                                                        if (!in_array($transactionid, $transactionids)) {
                                                            $buyer = new User($transaction['uid']);
                                                            $for = new User($transaction['uid']);

                                                            if (isset($transaction['buyer_uid'])) {
                                                                $buyer = new User($transaction['buyer_uid']);
                                                            }

                                                            $gateway = 'prometheus';
                                                            $amount = 0;

                                                            if (isset($transaction['gateway'])) {
                                                                $gateway = $transaction['gateway'];
                                                                $amount = $transaction['price'];
                                                            }

                                                            if (!$for->valid) {
                                                                User::Create($for->GetValue('steamid64'));

                                                                $for = new User($for->GetValue('steamid64'));

                                                                if ($buyer->GetValue('steamid64') == $for->GetValue('steamid64')) {
                                                                    $buyer = $for;
                                                                }
                                                            }

                                                            if (!$buyer->valid && $buyer->GetValue('steamid64') != $for->GetValue('steamid64')) {
                                                                User::Create($for->GetValue('steamid64'));

                                                                $for = new User($for->GetValue('steamid64'));
                                                            }

                                                            if ($buyer->valid && $for->valid) {
                                                                $data = array(
                                                                    'name_buyer' => $transaction['name'],
                                                                    'steamid64_buyer' => $buyer->GetValue('steamid64'),
                                                                    'steamid64_for' => $for->GetValue('steamid64'),
                                                                    'amount' => $amount,
                                                                    'package' => $package->GetValue('id'),
                                                                    'transactionid' => $transactionid,
                                                                    'email' => $transaction['email'],
                                                                    'gateway' => $gateway,
                                                                    'date' => $transaction['timestamp'],
                                                                );

                                                                Payment::Finish($data, $buyer, $for, $package, false, true, (isset($_POST['admin_import_prometheus_runonetimerewards']) ? false : true));

                                                                ++$count;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.$count.' donations imported.", type: "success"');
                            } else {
                                DirectNotifications::Execute('title: "'.Lang('error').'", text: "Could not load transactions.", type: "error"');
                            }
                        }
                    }
                }
            }
        }
    }
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('prometheus_import'); ?>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<?php if (!$success) {
    ?>
			<h4>How to import donations from Prometheus</h4>
			<ol>
				<li>Create Serverbundles and Packages (GExtension)</li>
				<li>Insert MySQL data for Prometheus</li>
				<li>Select a new package for each old package</li>
			</ol>

			<br/>

			READ FIRST: <a href="https://gextension.ibot3.de/wiki/index.php?title=Import:Prometheus" target="_blank">INSTRUCTIONS (WIKI)</a>

            <br/>
			<hr>

			<form action="index.php?t=admin_import_prometheus" method="POST">
				<label>MySQL IP</label><br/>
				<input class="form-control" name="admin_import_prometheus_mysql_ip" /><br/>
				<label>MySQL Username</label><br/>
				<input class="form-control" name="admin_import_prometheus_mysql_user" /><br/>
				<label>MySQL Password</label><br/>
				<input class="form-control" name="admin_import_prometheus_mysql_password" /><br/>
				<label>MySQL Port</label><br/>
				<input class="form-control" value="3306" name="admin_import_prometheus_mysql_port" /><br/>
				<label>MySQL Database</label><br/>
				<input class="form-control" name="admin_import_prometheus_mysql_db" /><br/>
				
				<input type="hidden" name="__resubmit" value="<?php echo GenerateResubmitToken(); ?>" />

				<button type="submit" class="btn btn-primary">Next Step</button>
			</form>
		<?php
} else {
        echo '
			<form action="index.php?t=admin_import_prometheus" method="POST">
				<table class="table table-responsive">
					<tr>
						<th>Old Package (Prometheus)</th>
						<th>New Package (GExtension)</th>
					</tr>

					<tbody>';

        if ($transactions && $packages) {
            $ps = Package::GetAll();

            foreach ($packages as $package) {
                echo '<tr><td>';
                echo $package['title'];
                echo '</td>';

                echo '<td>';
                echo '<select name="admin_import_prometheus_package_from_'.$package['id'].'" class="form-control">';
                echo '<option value="0">None, do not import donations for this package</option>';
                foreach ($ps as $p) {
                    $serverbundle = new Serverbundle($p->GetValue('serverbundle'));

                    if ($serverbundle->valid) {
                        echo '<option value="'.$p->GetValue('id').'">'.$p->GetValue('title').' ('.$serverbundle->GetValue('name').')</option>';
                    }
                }
                echo '<select>';
                echo '</td></tr>';
            }
        }

        echo ' </tbody>
				</table>

				';

        CreateCheckbox('primary', 'admin_import_prometheus_runonetimerewards', '', Lang('runonetimerewards'));

        echo '

				<br />
				
				<input type="hidden" name="__resubmit" value="'.GenerateResubmitToken().'" />

				<button type="submit" name="admin_import_prometheus_import" class="btn btn-primary">Import Donations</button>
			</form>
			';
    } ?>
	</div>
</div>