<!--{"language":"sdonate_import","icon":"fa-money","place":"none","position":0}-->

<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (!Permissions::HasPermission('super')) {
            die('The SDonate import function can only be used by an user with super permission.');
        }

        $success = false;
        $transactions = null;
        $packages = null;

        if (isset($_POST['admin_import_sdonate_mysql_ip'])) {
            $mysql = array(
                'ip' => $_POST['admin_import_sdonate_mysql_ip'],
                'user' => $_POST['admin_import_sdonate_mysql_user'],
                'password' => $_POST['admin_import_sdonate_mysql_password'],
                'port' => $_POST['admin_import_sdonate_mysql_port'],
                'database' => $_POST['admin_import_sdonate_mysql_db'],
            );

            $empty = false;

            foreach ($mysql as $value) {
                if (empty($value)) {
                    $empty = true;
                }
            }

            if (!$empty) {
                $sdonatedb = mysqli_init();
                $sdonatedb->options(MYSQLI_OPT_CONNECT_TIMEOUT, 5) || die('<br>mysqli_options croaked: '.$sdonatedb->error);
                $sdonatedb->real_connect($mysql['ip'], $mysql['user'], $mysql['password'], $mysql['database'], $mysql['port']) || die('<br>mysqli_real_connect croaked: '.$sdonatedb->error);

                if (mysqli_connect_errno()) {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.RemoveQuotes(mysqli_connect_error()).'", type: "error"');
                } else {
                    if ($result_packages = $sdonatedb->query('SELECT * FROM packages;')) {
                        if ($result_transactions = $sdonatedb->query('SELECT * FROM paypalpayments;')) {
                            if ($result_transactions->num_rows > 0 && $result_packages->num_rows > 0) {
                                $transactions = array();
                                while ($transaction = $result_transactions->fetch_assoc()) {
                                    $transactions[] = $transaction;
                                }

                                $packages = array();
                                while ($package = $result_packages->fetch_assoc()) {
                                    $packages[] = $package;
                                }

                                Settings::Set('import_sdonate_mysql', ToJson($mysql));

                                $success = true;
                            }
                        } else {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "No sdonate data found!", type: "error"');
                        }
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "No sdonate data found!", type: "error"');
                    }
                }
            }
        } elseif (isset($_POST['admin_import_sdonate_import'])) {
            $mysql = FromJson(Settings::Get('import_sdonate_mysql'));

            $empty = false;

            foreach ($mysql as $value) {
                if (empty($value)) {
                    $empty = true;
                }
            }

            if (!$empty) {
                $sdonatedb = mysqli_init();
                $sdonatedb->options(MYSQLI_OPT_CONNECT_TIMEOUT, 5) || die('<br>mysqli_options croaked: '.$sdonatedb->error);
                $sdonatedb->real_connect($mysql['ip'], $mysql['user'], $mysql['password'], $mysql['database'], $mysql['port']) || die('<br>mysqli_real_connect croaked: '.$sdonatedb->error);

                if (mysqli_connect_errno()) {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.RemoveQuotes(mysqli_connect_error()).'", type: "error"');
                } else {
                    if ($result_transactions = $sdonatedb->query('SELECT * FROM paypalpayments;')) {
                        if ($result_transactions->num_rows > 0) {
                            $transactions = array();
                            while ($transaction = $result_transactions->fetch_assoc()) {
                                $transactions[] = $transaction;
                            }

                            $count = 0;
                            $errors = 0;

                            if (sizeof($transactions)) {
                                $transactionids = $db->getValue('donations', 'transactionid', null);

                                if (!is_array($transactionids)) {
                                    $transactionids = array();
                                }

                                foreach ($_POST as $key => $val) {
                                    if (StartsWith($key, 'admin_import_sdonate_package_from_')) {
                                        $oldpackage = substr($key, 34);
                                        $newpackage = $val;

                                        if ($newpackage > 0) {
                                            $package = new Package($newpackage);

                                            if ($package->valid) {
                                                foreach ($transactions as $key => $transaction) {
                                                    if ('success' == $transaction['status']) {
                                                        $oldpckg_arr = FromJson($transaction['package']);
                                                        $vars_arr = FromJson($transaction['vars']);

                                                        if (isset($vars_arr['STEAMID']) && isset($oldpckg_arr['id']) && $oldpckg_arr['id'] == $oldpackage) {
                                                            $transactionid = 'sdonate-'.$transaction['id'];

                                                            if (!in_array($transactionid, $transactionids)) {
                                                                $buyer = new User($vars_arr['STEAMID']);

                                                                $gateway = 'sdonate';
                                                                $amount = 0;

                                                                if (isset($transaction['price'])) {
                                                                    $amount = $transaction['price'];
                                                                }

                                                                if (!$buyer->valid) {
                                                                    if (!User::Create($buyer->GetValue('steamid64'))) {
                                                                        ++$errors;
                                                                    }

                                                                    $buyer = new User($buyer->GetValue('steamid64'));
                                                                }

                                                                if ($buyer->valid) {
                                                                    $data = array(
                                                                        'name_buyer' => $transaction['username'],
                                                                        'steamid64_buyer' => $buyer->GetValue('steamid64'),
                                                                        'steamid64_for' => $buyer->GetValue('steamid64'),
                                                                        'amount' => $amount,
                                                                        'package' => $package->GetValue('id'),
                                                                        'transactionid' => $transactionid,
                                                                        'email' => '',
                                                                        'gateway' => $gateway,
                                                                        'date' => $transaction['created'],
                                                                    );

                                                                    Payment::Finish($data, $buyer, $buyer, $package, false, true, (isset($_POST['admin_import_sdonate_runonetimerewards']) ? false : true));

                                                                    ++$count;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }

                                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.$count.' donations imported.", type: "success"');

                                if ($errors) {
                                    //DirectNotifications::Execute('title: "'.Lang('error').'", text: "' . $errors . ' donations could not be imported due to a SteamAPI error. Try again later. Already imported donations will not be added again.", type: "error"');
                                }
                            } else {
                                DirectNotifications::Execute('title: "'.Lang('error').'", text: "Could not load transactions.", type: "error"');
                            }
                        }
                    }
                }
            }
        }
    }
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('sdonate_import'); ?>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<?php if (!$success) {
    ?>
			<h4>How to import donations from SDonate</h4>
			<ol>
				<li>Create Serverbundles and Packages (GExtension)</li>
				<li>Insert MySQL data for SDonate</li>
				<li>Select a new package for each old package</li>
			</ol>

			<br/>

			READ FIRST: <a href="https://gextension.ibot3.de/wiki/index.php?title=Import:SDonate" target="_blank">INSTRUCTIONS (WIKI)</a>

			<br/>
			<br/>
			<b>You do not have access to the database? Ask the creator of SDonate for a copy of your SDonate database and import the data to your own database.</b>

			<hr>

			<form action="index.php?t=admin_import_sdonate" method="POST">
				<label>MySQL IP</label><br/>
				<input class="form-control" name="admin_import_sdonate_mysql_ip" /><br/>
				<label>MySQL Username</label><br/>
				<input class="form-control" name="admin_import_sdonate_mysql_user" /><br/>
				<label>MySQL Password</label><br/>
				<input class="form-control" name="admin_import_sdonate_mysql_password" /><br/>
				<label>MySQL Port</label><br/>
				<input class="form-control" value="3306" name="admin_import_sdonate_mysql_port" /><br/>
				<label>MySQL Database</label><br/>
				<input class="form-control" name="admin_import_sdonate_mysql_db" /><br/>
				
				<input type="hidden" name="__resubmit" value="<?php echo GenerateResubmitToken(); ?>" />

				<button type="submit" class="btn btn-primary">Next Step</button>
			</form>
		<?php
} else {
        echo '
			<form action="index.php?t=admin_import_sdonate" method="POST">
				<table class="table table-responsive">
					<tr>
						<th>Old Package (sdonate)</th>
						<th>New Package (GExtension)</th>
					</tr>

					<tbody>';

        if ($transactions && $packages) {
            $ps = Package::GetAll();

            foreach ($packages as $package) {
                echo '<tr><td>';
                echo $package['title'];
                echo '</td>';

                echo '<td>';
                echo '<select name="admin_import_sdonate_package_from_'.$package['id'].'" class="form-control">';
                echo '<option value="0">None, do not import donations for this package</option>';
                foreach ($ps as $p) {
                    $serverbundle = new Serverbundle($p->GetValue('serverbundle'));

                    if ($serverbundle->valid) {
                        echo '<option value="'.$p->GetValue('id').'">'.$p->GetValue('title').' ('.$serverbundle->GetValue('name').')</option>';
                    }
                }
                echo '<select>';
                echo '</td></tr>';
            }
        }

        echo ' </tbody>
				</table>

				';

        CreateCheckbox('primary', 'admin_import_sdonate_runonetimerewards', '', Lang('runonetimerewards'));

        echo '

				<br />
				
				<input type="hidden" name="__resubmit" value="'.GenerateResubmitToken().'" />

				<button type="submit" name="admin_import_sdonate_import" class="btn btn-primary">Import Donations</button>
			</form>
			';
    } ?>
	</div>
</div>