<!--{"language":"news","icon":"fa-newspaper-o","place":"admin","position":50}-->
<?php 
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    $firstnews = 0;
    $cleardraft = false;

    if (!DemoLock()) {
        if (isset($_POST['admin_news_edit_id'])) {
            $news = new News($_POST['admin_news_edit_id']);

            $title = htmlspecialchars($_POST['admin_news_edit_title']);
            $content = ValidateHTML($_POST['admin_news_edit_content']);

            if ($news->valid) {
                $data = array(
                    'content' => $content,
                    'title' => $title,
                );

                if (isset($_POST['admin_news_edit_enable'])) {
                    $data['active'] = 1;
                } elseif (isset($_POST['admin_news_edit_disable'])) {
                    $data['active'] = 0;
                }

                $news->Update($data);

                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
            }
        } elseif (isset($_POST['admin_news_delete'])) {
            $news = new News($_POST['admin_news_delete']);

            if ($news->valid) {
                if ($news->Delete()) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('news_deleted_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
                }
            }
        } elseif (isset($_POST['admin_news_create_modal_submit'])) {
            $title = htmlspecialchars($_POST['admin_news_create_modal_title']);
            $content = ValidateHTML($_POST['admin_news_create_modal_content']);
            $active = isset($_POST['admin_news_create_modal_active']);

            if (!tempty($title) && !tempty($content)) {
                if (News::Create($title, $content, $active)) {
                    $cleardraft = true;

                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('news_created_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
                }
            }
        }
    }
?>

<!-- Summernote CSS -->
<link rel="stylesheet" href="assets/css/summernote.css" />

<!-- Summernote JS-->
<script src="assets/js/summernote.min.js"></script>

<div class="row">
	<div class="col-md-12">
		<h1 class="page-header">
			<?php echo Lang('news'); ?>
			
			<div class="pull-right">
			    <button onclick="admin_news_create();" class="btn btn-success"><i class="fa fa-pencil"></i> <?php echo Lang('create'); ?></button>
			</div>
		</h1>
	</div>
</div>

<div class="row">
    <div class="col-sm-3" id="admin_news_navigation">
        <div class="list-group" id="admin_news_navigation_list">
            <?php
                $news = News::GetAll();
                $first = true;

                $newsdata = '';

                foreach ($news as $_news) {
                    $author = new User($_news->GetValue('steamid64'));

                    if ($author->valid) {
                        $active = '';
                        $disabled = '';

                        if ($first) {
                            $first = false;

                            $active = 'active';

                            $firstnews = $_news->GetValue('id');
                        }

                        if (!$_news->GetValue('active')) {
                            $disabled = '<span style="background-color:#f0ad4e;" class="badge pull-right">'.Lang('disabled').'</span>';
                        }

                        $newsdata .= 'newsdata['.$_news->GetValue('id').'] = '.ToJson($_news->data).';';

                        echo '
                            <a onclick="admin_news_load('.$_news->GetValue('id').');" href="#" id="admin_news_navigation_list_item_'.$_news->GetValue('id').'" class="admin_news_navigation_list_item list-group-item '.$active.'">
                                <h4 class="list-group-item-heading">'.$_news->GetValue('title').'</h4>
                                <p class="list-group-item-text">
                                    '.FormatDate($_news->GetValue('date')).$disabled.'<br/>
                                    '.$author->GetValue('nick').'
                                </p>
                            </a>
                        ';
                    }
                }

                if (!sizeof($news)) {
                    echo Lang('no_entries');
                }
            ?>
        </div>
    </div>
    
    <div class="col-sm-9" id="admin_news_content">
        <?php if (sizeof($news)) {
                ?>
        <form action="index.php?t=admin_news" method="POST">
            <input class="form-control" name="admin_news_edit_title" />
            
            <textarea name="admin_news_edit_content"></textarea>
            
            <input type="hidden" name="admin_news_edit_id" />
            
            <span class="pull-right">
                <button type="button" onclick="" name="admin_news_edit_delete" class="btn btn-danger"><?php echo Lang('delete'); ?></button>
                <button type="submit" name="admin_news_edit_enable" class="btn btn-success"><?php echo Lang('enable'); ?></button>
                <button type="submit" name="admin_news_edit_disable" class="btn btn-warning"><?php echo Lang('disable'); ?></button>
                <button type="submit" name="admin_news_edit_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
            </span>
            
        </form>
        
        <?php
            } ?>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="admin_news_create_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-pencil"></i> &nbsp;<?php echo Lang('news_create'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_news">
				<div class="modal-body">
					<!-- Title -->
		            <label><?php echo Lang('title'); ?></label>
		            <input class="form-control" name="admin_news_create_modal_title" /><br>
		            
		            <label><?php echo Lang('content'); ?></label><span class="pull-right" id="admin_news_create_modal_savestatus"></span>
		            <textarea name="admin_news_create_modal_content"></textarea>
		            
					<?php CreateCheckbox('primary', 'admin_news_create_modal_active', '', Lang('enabled'), '', '', true); ?>
				</div>
				<div class="modal-footer">
					<button type="submit" name="admin_news_create_modal_submit" class="btn btn-success"><?php echo Lang('publish'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
    var newsdata = {};
    var h = $(window).height() * 0.6;
    
    <?php echo $newsdata; ?>
    
    function admin_news_create(){
        $('#admin_news_create_modal').modal('show');
    }
    
    function admin_news_load(id){
        if(newsdata[id]){
            $('.admin_news_navigation_list_item').removeClass('active');
            $('#admin_news_navigation_list_item_' + id).addClass('active');
            
            $('input[name="admin_news_edit_id"]').val(id);
            $('input[name="admin_news_edit_title"]').val(newsdata[id]['title']);
            $('button[name="admin_news_edit_delete"]').attr('onclick', 'admin_news_delete(' + id + ');');
            $('textarea[name="admin_news_edit_content"]').summernote('code', newsdata[id]['content']);
            
            if(newsdata[id]['active']){
                $('button[name="admin_news_edit_enable"]').hide();
                $('button[name="admin_news_edit_disable"]').show();
            }else{
                $('button[name="admin_news_edit_enable"]').show();
                $('button[name="admin_news_edit_disable"]').hide();
            }
        }
    }
    
    function admin_news_delete(id){
        var text = '<?php echo Lang('are_you_sure'); ?>';
        
        (new PNotify({
            title: '<?php echo Lang('confirmation'); ?>',
            text: text,
            icon: '',
            type: "error",
            hide: false,
            confirm: {
                confirm: true
            },
            buttons: {
                closer: false,
                sticker: false
            },
            history: {
                history: false
            }
            })).get().on('pnotify.confirm', function() {
                post('index.php?t=admin_news', {admin_news_delete: id});
        });
    }

    $(function(){
        $('textarea[name="admin_news_edit_content"]').summernote({
    		height: h - 50,
    		toolbar: summernote_toolbar_default
    	});
    	
        $('textarea[name="admin_news_create_modal_content"]').summernote({
    		height: 300,
    		toolbar: summernote_toolbar_default
    	});
    	
    	<?php echo 'admin_news_load('.$firstnews.');'; ?>
    	
    	<?php echo $cleardraft ? 'SaveInStorage("admin_news_create_draft_title", "");SaveInStorage("admin_news_create_draft_content", "");' : ''; ?>
    	
    	if(LoadFromStorage('admin_news_create_draft_title') != '' || LoadFromStorage('admin_news_edit_content') != ''){
    	    $('input[name="admin_news_create_modal_title"]').val(LoadFromStorage('admin_news_create_draft_title'));
    	    $('textarea[name="admin_news_create_modal_content"]').summernote('code', LoadFromStorage('admin_news_create_draft_content'));
    	}
    });
	
	var draftsave = null;
	
	$('#admin_news_create_modal').on('shown.bs.modal', function (e) {
        draftsave = setInterval(function(){
            SaveInStorage('admin_news_create_draft_title', $('input[name="admin_news_create_modal_title"]').val());
            SaveInStorage('admin_news_create_draft_content', $('textarea[name="admin_news_create_modal_content"]').summernote('code'));
            $('#admin_news_create_modal_savestatus').html('<div class="label label-success"><?php echo Lang('chages_saved'); ?></div>');
        }, 5000);
    })
    
    $('#admin_news_create_modal').on('hidden.bs.modal', function (e) {
        clearInterval(draftsave);
    })
    
    $('textarea[name="admin_news_create_modal_content"]').on('summernote.change', function(){
        $('#admin_news_create_modal_savestatus').html('<div class="label label-danger"><?php echo Lang('chages_unsafed'); ?></div>');
    });
</script>