<!--{"language":"repeatoffenders","icon":"fa-balance-scale","place":"admin","position":60}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    $repeatoffenders = $db->rawQuery('SELECT b.steamid64, COUNT(b.steamid64) AS bans, (SELECT COUNT(*) FROM gex_warnings WHERE steamid64 = b.steamid64 AND status < 2) AS warns, (SELECT date_lastonline_gmod FROM gex_users WHERE steamid64 = b.steamid64) as lastlogin, (SELECT nick FROM gex_users WHERE steamid64 = b.steamid64) as nick FROM gex_bans AS b WHERE (SELECT date_lastonline_gmod FROM gex_users WHERE steamid64 = b.steamid64) > DATE_SUB(NOW(), INTERVAL 30 DAY)  AND status < 2 GROUP BY b.steamid64 ORDER BY bans DESC, warns DESC, lastlogin DESC LIMIT 25;');

    foreach ($repeatoffenders as $key => $offender) {
        $date1 = new DateTime($offender['lastlogin']);
        $date2 = new DateTime();

        $diff = $date2->diff($date1)->format('%a');

        $repeatoffenders[$key]['bwtindex'] = (($offender['bans'] * 3) + $offender['warns']) - $diff;
    }

    uasort($repeatoffenders, function ($a, $b) {
        if ($a['bwtindex'] == $b['bwtindex']) {
            return 0;
        }

        return ($a['bwtindex'] < $b['bwtindex']) ? 1 : -1;
    });
?>

<div class="row">
	<div class="col-md-12">
		<h1 class="page-header">
			<?php echo Lang('repeatoffenders'); ?>
		</h1>
	</div>
</div>

<div class="table-responsive">
    <table class="table table-hover">
        <tr class="active">
            <th style="width: 1%;">#</th>
            <th style="width: 15%;"><?php echo Lang('name'); ?></th>
            <th style="width: 5%;"><?php echo Lang('bans'); ?></th>
            <th style="width: 5%;"><?php echo Lang('warnings'); ?></th>
            <th style="width: 10%;" class="text-right"><?php echo Lang('lastonline'); ?></th>
        </tr>
    
        <tbody>
            <?php
                $count = 0;

                foreach ($repeatoffenders as $offender) {
                    ++$count;

                    echo '<tr>';
                    echo '<td>'.$count.'</td>';
                    echo  '<td><a href="index.php?t=user&id='.$offender['steamid64'].'" target="_blank">'.$offender['nick'].'</a></td>';
                    echo  '<td><a href="index.php?t=admin_bans&id='.$offender['steamid64'].'" target="_blank">'.$offender['bans'].'</a></td>';
                    echo  '<td><a href="index.php?t=admin_warnings&id='.$offender['steamid64'].'" target="_blank">'.$offender['warns'].'</a></td>';
                    echo  '<td class="text-right">'.FormatDate($offender['lastlogin']).'</td>';
                    echo '</tr>';
                }
            ?>
        </tbody>
    </table>
</div>
