<!--{"language":"settings","icon":"fa-cogs","place":"admin","position":10000}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>
<?php
    $settingpagesManager = new FileManager('settings');

    $pages = $settingpagesManager->files;

    if (!isset($_GET['part'])) {
        $_GET['part'] = 'general';
    }

    array_multisort(array_column(array_column($pages, 'data'), 'position'), $pages);
?>

<link rel="stylesheet" href="assets/css/bootstrap.vertical-tabs.css">

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header"><?php echo Lang('settings'); ?></h1>
	</div>
</div>


<div class="row">
    <div class="col-sm-2">
        <ul id="admin_settings_menu_main" class="nav nav-tabs tabs-left">
            <?php
                foreach ($pages as $page) {
                    if ($_GET['part'] == $page['rawname']) {
                        echo '<li class="active">';
                    } else {
                        echo '<li>';
                    }

                    echo '<a href="#admin_settings_tab_'.$page['rawname'].'" data-toggle="tab"><i class="fa '.$page['data']['icon'].'"></i> '.Lang($page['data']['language']).'</a></li>';
                }

            ?>
        </ul>
    </div>
    <div class="col-sm-10">
        <div class="tab-content">
            <?php
                foreach ($pages as $page) {
                    $active = '';

                    if ($_GET['part'] == $page['rawname']) {
                        $active = 'active';
                    } else {
                        $active = '';
                    }

                    echo '<div class="tab-pane '.$active.'" id="admin_settings_tab_'.$page['rawname'].'">';

                    echo '<div id="admin_settings_'.$page['rawname'].'">';
                    if ($_GET['part'] == $page['rawname']) {
                        foreach ($page['files'] as $file) {
                            include $file;
                        }
                    } else {
                        echo '<br><i class="fa fa-spinner fa-pulse fa-2x"></i>';
                    }
                    echo '</div>';

                    echo '</div>';
                }
            ?>
        </div>
    </div>
</div>


<script>

    $('#admin_settings_menu_main a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var target = $(e.target).attr("href").substr(20);

        UpdateURL('index.php?t=admin_settings&part=' + target);

        if(	$('#admin_settings_' + target).html() == '<br><i class="fa fa-spinner fa-pulse fa-2x"></i>'){
            $.ajax({
    			type: 'GET',
    			url: 'request.php?t=admin_settings&page=' + target,
    			success: function(data){
    				$('#admin_settings_' + target).html(data);
    				main_load();
    			},
    			error: function(){
    			    $('#admin_settings_' + target).html('<font color="red"><?php echo Lang('404'); ?></font>');
    			}
    		});
        }
    });

</script>