<!--{"language":"warnings","icon":"fa-exclamation-triangle","place":"admin","position":25}-->
<?php 
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        $user = null;

        if (isset($_GET['id'])) {
            $user = new User($_GET['id']);

            if (!$user->valid) {
                $user = null;
            }
        }

        if (isset($_POST['admin_warnings_inactive'])) {
            if (is_numeric($_POST['admin_warnings_inactive'])) {
                $db->where('id', $_POST['admin_warnings_inactive']);
                $warning = $db->getOne('warnings');

                if ($db->count) {
                    if (Permissions::HasPermission('warnings_add', $auth_user->GetGroup($warning['serverbundle']))) {
                        Warnings::SetInactive($_POST['admin_warnings_inactive']);
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('warning_inactive_success').'", type: "success"');
                    } else {
                        PermissionsError();
                    }
                }
            }
        } elseif (isset($_POST['admin_warnings_delete'])) {
            if (is_numeric($_POST['admin_warnings_delete'])) {
                $db->where('id', $_POST['admin_warnings_delete']);
                $warning = $db->getOne('warnings');

                if ($db->count) {
                    if (Permissions::HasPermission('warnings_delete', $auth_user->GetGroup($warning['serverbundle']))) {
                        Warnings::Delete($_POST['admin_warnings_delete']);
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('warning_deleted_success').'", type: "success"');
                    } else {
                        PermissionsError();
                    }
                }
            }
        } elseif (isset($_POST['admin_warnings_modal_add_form_submit'])) {
            $steamid = trim($_POST['admin_warnings_modal_add_form_steamid']);
            $reason = $_POST['admin_warnings_modal_add_form_reason'];
            $serverbundle = $_POST['admin_warnings_modal_add_form_serverbundle'];

            $user = new User($steamid);

            if ($user->valid && !empty($reason) && is_numeric($serverbundle)) {
                if (Permissions::HasPermission('warnings_add', $auth_user->GetGroup($serverbundle))) {
                    if (Warnings::Warn($user->GetValue('steamid64'), $reason, $serverbundle)) {
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('warning_created_success').'", type: "success"');
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
                    }
                } else {
                    PermissionsError();
                }
            }
        }
    }
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<span id="admin_warnings_header"><?php echo Lang('warnings').($user ? ': '.$user->GetValue('nick') : ''); ?></span>
			<span class="pull-right">
				<button onclick="admin_warnings_add();" class="btn btn-danger"><i class="fa fa-plus-circle"></i> <?php echo Lang('add'); ?></button>
			</span>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
	    <div class="table-responsive">
    		<table class="table">
    			<tr class="active">
    				<th style="width: 0%;">#</th>
    				<th><?php echo Lang('user'); ?></th>
    				<th><?php echo Lang('reason'); ?></th>
    				<th><?php echo Lang('admin'); ?></th>
    				<th><?php echo Lang('date'); ?></th>
    				<th><?php echo Lang('serverbundle'); ?></th>
    				<th style="widhth: 10%;" class="text-right"><i class="fa fa-cogs"></i></th>
    			</tr>
    			<tbody>
    				<?php
                        $page = 1;

                        if (isset($_GET['page'])) {
                            $page = $_GET['page'];
                        }

                        $warnings = array();

                        if ($user) {
                            $warnings = Warnings::GetByUser($user->GetValue('steamid64'));
                        } else {
                            $warnings = Warnings::GetAll(25, $page);
                        }

                        foreach ($warnings as $warning) {
                            $admin = new User($warning['steamid64_admin']);
                            $warned = new User($warning['steamid64']);

                            if ($admin->valid && $warned->valid) {
                                $status = $warning['status'];

                                if (time() > (strtotime($warning['date']) + (Settings::Get('settings_warnings_decay') * 60))) {
                                    $status = 1;
                                }

                                $class = '';

                                if (1 == $status) {
                                    $class = 'danger';
                                } elseif (0 == $status) {
                                    $class = 'success';
                                }

                                $serverbundle = new Serverbundle($warning['serverbundle']);

                                if ($serverbundle->valid) {
                                    echo '<tr class="'.$class.'">';
                                    echo '<td>';
                                    echo $warning['id'];
                                    echo '</td>';
                                    echo '<td>';
                                    echo '<a href="index.php?t=user&id='.$warned->GetValue('steamid64').'" target="_blank">'.$warned->GetValue('nick').'</a>';
                                    echo '</td>';
                                    echo '<td>';
                                    echo htmlspecialchars($warning['reason']);
                                    echo '</td>';
                                    echo '<td>';
                                    echo '<a href="index.php?t=user&id='.$admin->GetValue('steamid64').'" target="_blank">'.$admin->GetValue('nick').'</a>';
                                    echo '</td>';
                                    echo '<td>';
                                    echo FormatDate($warning['date']);
                                    echo '</td>';
                                    echo '<td>';
                                    echo $serverbundle->GetValue('name');
                                    echo '</td>';
                                    echo '<td class="text-right">';
                                    if (0 == $status) {
                                        echo '<button class="btn btn-xs btn-warning" onclick="admin_warnings_inactive('.$warning['id'].');">'.Lang('set_inactive').'</button>';
                                    } elseif (1 == $status) {
                                        echo '<button class="btn btn-xs btn-danger" onclick="admin_warnings_delete('.$warning['id'].');">'.Lang('delete').'</button>';
                                    }
                                    echo '</td>';
                                    echo '</tr>';
                                }
                            }
                        }
                    ?>
    			</tbody>
    		</table>
    	</div>
		
		<ul class="pager">
			<?php if ($page > 1 && !$user) {
                        ?>
				<li class="previous"><a href="index.php?t=admin_warnings&page=<?php echo $page - 1; ?>"><span aria-hidden="true">&larr;</span> <?php echo Lang('previous'); ?></a></li>
			<?php
                    } ?>
			
			<?php if (25 == sizeof($warnings) && !$user) {
                        ?>
				<li class="next"><a href="index.php?t=admin_warnings&page=<?php echo $page + 1; ?>"><?php echo Lang('next'); ?> <span aria-hidden="true">&rarr;</span></a></li>
			<?php
                    } ?>
		</ul>
	</div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="admin_warnings_modal_add" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-exclamation-triangle"></i> &nbsp;<?php echo Lang('user_warn'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_warnings<?php echo ''.(isset($_GET['id']) ? '&id='.$_GET['id'] : '').(isset($_GET['page']) ? '&page='.$_GET['page'] : ''); ?>">
				<div class="modal-body">
					<!-- Steamid64/SteamID32 -->
		            <label>SteamID64 / SteamID32</label><br>
		            <input class="form-control" name="admin_warnings_modal_add_form_steamid" placeholder="SteamID" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>" /><br>
		            
		            <!-- Reason -->
		            <label><?php echo Lang('reason'); ?></label><br>
		            <input class="form-control" name="admin_warnings_modal_add_form_reason" placeholder="<?php echo Lang('reason'); ?>" /><br>
		            
		            <label><?php echo Lang('serverbundle'); ?></label><br>
		            <select class="form-control" name="admin_warnings_modal_add_form_serverbundle">
						<?php
                            foreach (ServerBundle::GetAll(true) as $bundle) {
                                echo '<option value="'.$bundle->GetValue('id').'">'.$bundle->GetValue('name').'</option>';
                            }
                        ?>
					</select>
				</div>
				<div class="modal-footer">
					<button type="submit" name="admin_warnings_modal_add_form_submit" class="btn btn-danger"><?php echo Lang('warn'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
	function admin_warnings_inactive(id){
		post('index.php?t=admin_warnings<?php echo isset($_GET['id']) ? '&id='.$_GET['id'] : ''; ?>', {'admin_warnings_inactive': id});
	}
	
	function admin_warnings_delete(id){
		post('index.php?t=admin_warnings<?php echo isset($_GET['id']) ? '&id='.$_GET['id'] : ''; ?>', {'admin_warnings_delete': id});
	}
	
	function admin_warnings_add(){
		$('#admin_warnings_modal_add').modal('show');
	}
</script>