<!--{"language":"profile","icon":"fa-home","place":"main","position":10}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    $information_required = tempty($auth_user->GetValue('email')) || (tempty($auth_user->GetValue('ts3uid')) && !tempty(Settings::Get('settings_teamspeak_query_password'))) || (tempty($auth_user->GetValue('discord_user_id')) && !tempty(Settings::Get('settings_discord_guild_id')));
?>

<!-- ImageFrame CSS-->
<link rel="stylesheet" href="assets/css/image-frame.css" />

<!-- ZingChart JS-->
<script src="assets/js/zingchart.min.js"></script>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header"><?php echo Lang('dashboard'); ?> </h1>
	</div>
</div>
<div class="row">
	<div class="col-md-4">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
		         	<p><i class="fa fa-user fa-lg"></i></p>
		          	<p><b><?php echo $auth_user->GetValue('nick'); ?></b></p>
		        </div>

		        <div class="box-icon pull-right">
		         	<a href="#" data-toggle="modal" data-target="#main_modal_settings"><i <?php if ($information_required) {
    echo 'style="color:red; animation: blink-animation 1s steps(5, start) infinite; -webkit-animation: blink-animation 1s steps(5, start) infinite;"';
} ?> class="fa fa-pencil fa-lg"></i></a>
		        </div>
			</div>
		  	<div class="box-content" id="home_overview">
		        <div class="profile-header-container">
		    		<div class="profile-header-img">
		                <img style="border-color: <?php echo $auth_user->GetGroup()->GetValue('hexcolor'); ?>;" class="img-circle" src="<?php echo $auth_user->GetValue('avatar_large'); ?>" />
		                <!-- badge -->
		                <div class="rank-label-container">
		                    <span style="background-color: <?php echo $auth_user->GetGroup()->GetValue('hexcolor'); ?>;" class="label label-default rank-label"><font size="2.5"><?php echo $auth_user->GetGroup()->GetValue('displayname'); ?></font></span>
		                </div>
		            </div>
		        </div>
				<span class="table-label label label-primary"><i class="fa fa-info"></i> <?php echo Lang('general'); ?> </span><br>
				<table class="table table-responsive">
					<tbody>
						<tr>
							<td style="width: 15%;"><i class="fa fa-user"></i></td>
							<td style="width: 30%;"><?php echo  Lang('nickname'); ?></td>
							<td style="width: 55%;"><?php echo $auth_user->GetValue('nick'); ?></td>
						</tr>
						<tr>
							<td><i class="fa fa-steam"></i></td>
							<td>SteamID64</td>
							<td><?php echo $auth_user->GetValue('steamid64'); ?></td>
						</tr>
						<tr>
							<td><i class="fa fa-steam"></i></td>
							<td>SteamID32</td>
							<td><?php echo $auth_user->GetValue('steamid32'); ?></td>
						</tr>
					</tbody>
				</table>
				<span class="table-label label label-primary"><i class="fa fa-clock-o"></i> <?php echo  Lang('activity'); ?></span><br>
				<table class="table table-responsive table-user-information">
					<tbody>
						<tr>
							<td style="width: 15%;"><i class="fa fa-sign-in"></i></td>
							<td style="width: 30%;"><?php echo  Lang('registered'); ?></td>
							<td style="width: 55%;"><?php echo FormatDate($auth_user->GetValue('date_registered')); ?></td>
						</tr>
						<tr>
						<td><i class="fa fa-globe"></i></td>
							<td>Web</td>
							<td><?php echo FormatDate($auth_user->GetValue('date_lastonline_web')); ?></td>
						</tr>
						<tr>
							<td><i class="fa fa-gamepad"></i></td>
							<td>Garry's Mod</td>
							<td><?php echo FormatDate($auth_user->GetValue('date_lastonline_gmod')); ?></td>
						</tr>
					</tbody>
				</table>
				<span class="table-label label label-primary"><i class="fa fa-exclamation-circle"></i> <?php echo  Lang('violations'); ?></span><br>
				<table class="table table-responsive table-user-information">
					<tbody>
						<tr>
							<td style="width: 15%;"><i class="fa fa-exclamation-triangle"></i></td>
							<td style="width: 30%;"><?php echo Lang('warnings'); ?></td>
							<td style="width: 55%;">
								<?php
                                    echo '<a href="index.php?t=violations" target="_blank">'.sizeof(Warnings::GetByUser($auth_user->GetValue('steamid64'))).'</a>';
                                ?>
							</td>
						</tr>
						<tr>
							<td><i class="fa fa-ban"></i></td>
							<td><?php echo Lang('bans'); ?></td>
							<td>
								<?php
                                    echo '<a href="index.php?t=violations" target="_blank">'.sizeof(Bans::GetByUser($auth_user->GetValue('steamid64'))).'</a>';
                                ?>
							</td>
						</tr>
					</tbody>
				</table>
		  	</div>
		</div>
	</div>
	<div class="col-md-8">
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				    <div class="box-header">
				        <div class="box-title pull-left">
				          	<p><i class="fa fa-line-chart fa-lg"></i></p>
							<p><b><?php echo Lang('statistics'); ?></b></p>
				        </div>
					</div>

				  	<div class="box-content" id="home_statistics">
						<ul class="nav nav-tabs" role="tablist">
							<?php
                                $count = 0;
                                foreach (Serverbundle::GetAll() as $bundle) {
                                    $statistics = $auth_user->statistics->GetTimeStatistics($bundle);

                                    if (!empty($statistics)) {
                                        if (!$count) {
                                            echo '<li class="active">';
                                        } else {
                                            echo '<li>';
                                        }

                                        $totaltime = $auth_user->statistics->GetTotalTime($bundle);

                                        echo '<a href="#stats_server'.$bundle->GetValue('id').'" role="tab" data-toggle="tab">'.$bundle->GetValue('name').' ('.$totaltime.' '.Lang('hours_short').')</a></li>';

                                        ++$count;
                                    }
                                }
                            ?>
					  	</ul>
						<div class="tab-content">
							<?php
                                $count = 0;
                                foreach (Serverbundle::GetAll() as $bundle) {
                                    $statistics = $auth_user->statistics->GetTimeStatistics($bundle);

                                    if (!empty($statistics)) {
                                        if (!$count) {
                                            echo '<div role="tabpanel" class="tab-pane active" id="stats_server'.$bundle->GetValue('id').'">';
                                        } else {
                                            echo '<div style="position:relative;" role="tabpanel" class="tab-pane" id="stats_server'.$bundle->GetValue('id').'">';
                                        }

                                        echo '<div style="height: 230px; !important;" id="chart_stats_server_'.$bundle->GetValue('id').'">';
                                        echo '</div>';
                                        echo '</div>';

                                        echo '  <script>
											var statdata = JSON.parse(\''.ToJson($statistics).'\');
											var subtitle = "";

											if(statdata.length == 0){
												subtitle = "<i>'.Lang('no_data_available').'</i>";
											}else{
												subtitle = "'.Lang('total_alltime').': '.$auth_user->statistics->GetTotalTime($bundle).' '.Lang('hours').'";
											}

											var home_chart_onlinetime_data = {
									            "graphset": [
									                {
									                    "type": "area",
									                    "plotarea": {
									                		"adjust-layout":true
									                    },
									                    "gui": {
															"watermark": {
													        	"position": "tr" //br (default), bl, tr, tl
															},
															"behaviors":[
													            {
													                "id":"DownloadPDF",
													                "enabled":"none"
													            },
													            {
													                "id":"DownloadPNG",
													                "enabled":"none"
													            },
													            {
													                "id":"DownloadSVG",
													                "enabled":"none"
													            },
													            {
													                "id":"About",
													                "enabled":"none"
													            },
													            {
													                "id":"Print",
													                "enabled":"none"
													            },
													            {
													                "id":"SaveAsImage",
													                "enabled":"none"
													            },
													            {
													                "id":"ViewSource",
													                "enabled":"none"
													            },
													            {
													                "id":"ExportData",
													                "enabled":"none"
													            },
													            {
													                "id":"GuideHide",
													                "enabled":"none"
													            },
													            {
													                "id":"GuideShow",
													                "enabled":"none"
													            },
													            {
													                "id":"ZoomIn",
													                "enabled":"none"
													            },
													            {
													                "id":"ZoomOut",
													                "enabled":"none"
													            },
													            {
													                "id":"CrosshairHide",
													                "enabled":"none"
													            }
													        ]
														},
									                    "tooltip":{
									                        "visible":false
									                    },
									                    "backgroundColor":"none",
									                    "crosshair-x":{
									                        "plot-label":{
									                            "text":"%v '.Lang('hours').'"
									                        }
									                    },
									                    "scale-y":{
									                    	//"values":"0:24"
									                    },
									                    "scale-x":{
									                    	"offset": 15,
									                        "max-items":5,
									                        "zooming":true,
									                        "max-ticks":5,
									                        "guide": {
									                        	"visible": true
									                        },
									                        "transform":{
									                            "item":{
									                                "visible":false
									                            },
									                            "type":"date",
									                            "all": "'.Settings::Get('settings_general_timeformat_charts').'"
									                        }
									                    },
									                    "series":[
										                    {
										                      "values":statdata
										                    }
										                ]
										            }
										        ]
										    };

									        zingchart.render({
									    		hideprogresslogo: true,
									            id: "chart_stats_server_'.$bundle->GetValue('id').'",
									            data: home_chart_onlinetime_data,
									            height: "100%",
									            width: "100%",
									        });
									   </script>';

                                        ++$count;
                                    }
                                }
                            ?>
						</div>
				  	</div>
				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-sm-6">
				<div class="box">
				    <div class="box-header">
				        <div class="box-title pull-left">
							<p><i class="fa fa-users fa-lg"></i></p>
				        	<p><b><?php echo Lang('groups'); ?></b></p>
				        </div>
					</div>

				  	<div class="box-content" id="home_groups">
				  		<ul class="list-group" >
					  		<?php
                                foreach (Serverbundle::GetAll(true) as $bundle) {
                                    $group = $auth_user->GetGroup($bundle->GetValue('id'));

                                    $icon = $bundle->GetValue('icon');

                                    echo '
										<li class="list-group-item" style="border-radius: 0px;">
											<i class="fa '.$icon.'"></i> '.$bundle->GetValue('name').'
											<span style="background-color: '.$group->GetValue('hexcolor').'" class="badge">'.$group->GetValue('displayname').'</span>
										</li>
									';
                                }

                            ?>
				  		</ul>
				  	</div>
				</div>
			</div>

			<div class="col-sm-6">
				<div class="box">
				    <div class="box-header">
				        <div class="box-title pull-left">
							<p><i class="fa fa-archive fa-lg"></i></p>
				        	<p><b><?php echo Lang('packages'); ?></b></p>
				        </div>

				        <div class="box-icon pull-right">
				        	<a href="index.php?t=shop"><i class="fa fa-plus fa-lg"></i></a>
				        </div>
					</div>

				  	<div class="box-content" id="home_donations">
				  		<?php
                            Package::GeneratePackageListForUser($auth_user);
                        ?>
				  	</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
	function home_adjustsize(ignoresize = false){
		if($('#home_groups, #home_donations').length){
			if($( document ).width() > 768){
				var overviewpartheight = $('#home_overview').offset().top + $('#home_overview').height() - $('#home_groups').offset().top;

				$('#home_groups, #home_donations').height(overviewpartheight);
			}
		}
	}

	home_adjustsize();

	$( window ).resize(function() {
		home_adjustsize();
	});
</script>