<!--{"language":"invoice","icon":"fa-file-pdf-o","place":"none","position":0,"nologin":false}-->
<?php
if (!isset($G_MAIN)) {
    die(json_encode(array("error" => "authentification failed")));
}
?>
<?php
    $okay = false;
    $package_name = '';

    if (isset($_GET['id'])) {
        $donation = new Donation($_GET['id']);

        if ($donation->valid) {
            if ($donation->GetValue('steamid64_buyer') == $auth_user->GetValue('steamid64') || Permissions::HasPagePermission('admin_donations')) {
                if($donation->GetValue('package_name') == null){
                    $package = new Package($donation->GetValue('package'));

                    if (!$package->valid) {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "No package name found!", type: "error"');
                        die();
                    }else{
                        $package_name = $package->GetValue('title');
                    }
                }else{
                    $package_name = $donation->GetValue('package_name');
                }
            }else{
                PermissionsError();
                die();
            }
        }
    }
?>

<style>
    .table > tbody > tr > .no-line {
        border-top: none;
    }

    .table > thead > tr > .no-line {
        border-bottom: none;
    }

    .table > tbody > tr > .thick-line {
        border-top: 2px solid;
    }
</style>

<div class="row">
    <div class="col-xs-12">
        <h1 class="page-header"><?php echo Lang('invoice'); ?>
            <span class="pull-right">
                <h3 class="pull-right"># <?php echo $donation->GetValue('id'); ?></h3>
            </span>
        </h1>

    </div>
</div>
<div class="row">
    <div class="col-xs-12">
        <div class="row">
            <div class="col-xs-6">
                <address>
                    <strong><?php echo Lang('buyer'); ?>:</strong><br>
                    <?php echo nl2br($donation->GetValue('name_buyer')); ?><br/>
                    <?php echo $donation->GetValue('steamid64_buyer'); ?><br/>
                    <?php echo $donation->GetValue('country'); ?>
                </address>
            </div>
            <div class="col-xs-6 text-right">
                <address>
                    <strong><?php echo Lang('seller'); ?>:</strong><br>
                    <?php echo nl2br(Settings::Get('settings_donations_invoice_business')); ?>
                </address>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-6">
                <address>
                    <strong><?php echo Lang('payment_method'); ?>:</strong><br>
                    <?php echo $donation->GetValue('gateway'); ?>
                </address>
            </div>
            <div class="col-xs-6 text-right">
                <address>
                    <strong><?php echo Lang('date'); ?>:</strong><br>
                    <?php echo FormatDate($donation->GetValue('date')); ?><br><br>
                </address>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><strong><?php echo Lang('overview'); ?></strong></h3>
            </div>
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-condensed">
                        <thead>
                        <tr>
                            <td><strong><?php echo Lang('package'); ?></strong></td>
                            <td class="text-right"><strong><?php echo Lang('price'); ?></strong></td>
                        </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?php echo $package_name; ?></td>
                                <td class="text-right"><?php echo Settings::Get('settings_donations_currency') . FormatPrice($donation->GetValue('amount_net')); ?></td>
                            </tr>
                            <tr>
                                <td class="no-line text-right thick-line"><strong><?php echo Lang('taxes'); ?> (<?php echo FormatPrice($donation->GetValue('tax_rate')); ?>%)</strong></td>
                                <td class="no-line text-right thick-line"><?php echo Settings::Get('settings_donations_currency') . FormatPrice($donation->GetValue('tax_amount')); ?></td>
                            </tr>
                            <tr>
                                <td class="no-line text-right"><strong><?php echo Lang('total'); ?></strong></td>
                                <td class="no-line text-right"><b><?php echo Settings::Get('settings_donations_currency') . FormatPrice($donation->GetValue('amount')); ?></b></td>
                            </tr>
                        </tbody>

                    </table>
                </div>
                <br/>
                <span class="text-center">
                    <?php echo $donation->GetValue('tax_note'); ?>
                </span>
            </div>
        </div>
    </div>
</div>
