<!--{"language":"notifications","icon":"fa-bell","place":"none","position":0}-->
<?php 
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('notifications'); ?>
			<div class="pull-right">
				<button onclick="notifications_mark_all_raad();" class="btn btn-default"><i class="fa fa-eye"></i> <?php echo Lang('mark_all_as_read'); ?></button>
			</div>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<div class="text-left">
			<div style="list-style-type: none;" class="list-group notifications-list">
				<div id="notifications_list">
					<?php
                        $page = 1;

                        if (isset($_GET['page'])) {
                            $page = $_GET['page'];
                        }

                        $notifications = Notifications::GetAll(15, $page);

                        foreach ($notifications as $notification) {
                            $bold_open = '';
                            $bold_close = '';

                            if (0 == $notification['status']) {
                                $bold_open = '<b>';
                                $bold_close = '</b>';
                            }

                            echo '
								<a onclick="main_notification_devaluate('.$notification['id'].')" href="'.$notification['url'].'" class="notifications-item list-group-item">
							    	<li class="list-group-item-text">
							    		<div class="row">
							    			<div class="col-xs-1">
								    			<i class="notifications-icon fa fa-lg fa-'.$notification['icon'].'"></i>
								    		</div>
								    		<div class="col-xs-11">
								    			'.$bold_open.'
								    			'.$notification['text'].'
								    			<div class="pull-right">
								    				<i class="fa fa-clock-o"></i> <script> document.write(moment("'.$notification['date'].'").fromNow());</script>
								    			</div>
								    			'.$bold_close.'
								    		</div>
							    		</div>
							    	</li>
							 	</a>
							';
                        }

                    ?>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<ul class="pager">
			<?php if ($page > 1) {
                        ?>
				<li class="previous"><a href="index.php?t=notifications&page=<?php echo $page - 1; ?>"><span aria-hidden="true">&larr;</span> <?php echo Lang('previous'); ?></a></li>
			<?php
                    } ?>
			
			<?php if (15 == sizeof($notifications)) {
                        ?>
				<li class="next"><a href="index.php?t=notifications&page=<?php echo $page + 1; ?>"><?php echo Lang('next'); ?> <span aria-hidden="true">&rarr;</span></a></li>
			<?php
                    } ?>
		</ul>
		
		<div class="text-center">
			<?php echo Lang('page').' '.$page; ?>
		</div>
	</div>
</div>

<script>
	function notifications_mark_all_raad(){
		$.getJSON( "request.php?t=notifications", {
			markallread: true
		}).done(function(  ) {
			Redirect("index.php?t=notifications");
		});
	}
	
</script>