<!--{"language":"purchase","icon":"fa-shopping-cart","place":"none","position":0}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<div class="row">
	<div class="col-md-12">
		<h1 class="page-header"><?php echo Lang('purchase'); ?></h1>
	</div>
</div>

<?php
    if (!ValidateBool(Settings::Get('settings_donations_enabled'))) {
        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donations_not_enabled').'", type: "error"');
        die(Lang('donations_not_enabled'));
    }
?>

<div class="row">
	<div class="col-md-12">
		<div id="purchase_main">
			<i class="fa fa-spinner fa-pulse fa-2x"></i>
		</div>
	</div>
</div>

<br style="display:block; margin: 35% 0;" />

<?php
    if (isset($_POST['package']) && isset($_POST['gateway']) && isset($_POST['coupon']) && isset($_POST['for']) && isset($_POST['price_custom'])) {
        if (is_numeric($_POST['price_custom'])) {
            $package = new Package($_POST['package']);

            $coupon = new Coupon($_POST['coupon']);

            $for = new User($_POST['for']);

            $_POST['price_custom'] = FormatPrice($_POST['price_custom']);

            if ($for->valid) {
                if ($package->valid) {
                    if ($coupon->valid) {
                        if ($coupon->GetValue('amount_left') >= $package->GetValue('price')) {
                            if (!$package->GetValue('price_custom') || ($coupon->GetValue('amount_left') >= $_POST['price_custom'])) {
                                $_POST['gateway'] = 'coupon';
                            }
                        }
                    }

                    $gateway = new Gateway($_POST['gateway']);

                    if ($gateway->valid) {
                        $gateway->Load($package, $for, $coupon, $_POST['price_custom']);
                    } else {
                        DirectNotifications::Queue('title: "'.Lang('error').'", text: "'.Lang('gateway_not_found').'", type: "error"');
                        echo '<script>window.history.back();</script>';
                        //Gateway not found
                    }
                }
            }
        }
    } elseif (isset($_GET['gateway'])) {
        $gw = $_GET['gateway'];

        if ('payssion' == $gw) {
            $state = (isset($_GET['state']) ? $_GET['state'] : 'canceled');

            if ('completed' == $state || 'awaiting_confirm' == $state || 'awaiting' == $state) {
                echo '
					<script>
						$("#purchase_main").html("<b><big><i style=\"color: green;\" class=\"fa fa-check-circle-o\"></i> '.Lang('postpurchase_success_soon').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
					</script>
				';
            } elseif ('pending' == $state) {
                echo '
					<script>
						$("#purchase_main").html("<b><big><i style=\"color: orange;\" class=\"fa fa-clock-o\"></i> '.Lang('payment_pending').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
					</script>
				';
            } else {
                echo '
					<script>
						$("#purchase_main").html("<b><big><i style=\"color: red;\" class=\"fa fa-times-circle-o\"></i> '.Lang('payment_canceled_client').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
					</script>
				';
            }
        }
    } elseif (isset($_GET['payment_success'])) {
        $gw = $_GET['payment_success'];

        if ('paypal' == $gw) {
            echo '
				<script>
					$("#purchase_main").html("<b><big><i style=\"color: green;\" class=\"fa fa-check-circle-o\"></i> '.Lang('postpurchase_success_soon').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
				</script>
			';
        } elseif ('paysafecard' == $gw && !empty($_GET['payment_id']) && !empty($_GET['gex_payment_id'])) {
            if (!Paysafecard::PostProcess($_GET['payment_id'], $_GET['gex_payment_id'])) {
                echo '
					<script>
						$("#purchase_main").html("<b><big><i style=\"color: red;\" class=\"fa fa-times-circle-o\"></i> '.Lang('payment_could_not_completed').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
					</script>
				';
            } else {
                echo '
					<script>
						$("#purchase_main").html("<b><big><i style=\"color: green;\" class=\"fa fa-check-circle-o\"></i> '.Lang('postpurchase_success_soon').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
					</script>
				';
            }
        } elseif ('g2apay' == $gw) {
            echo '
				<script>
					$("#purchase_main").html("<b><big><i style=\"color: green;\" class=\"fa fa-check-circle-o\"></i> '.Lang('postpurchase_success_soon').'</big></b><br><br><a class=\"btn btn-primary\" href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>");
				</script>
			';
        }
    } elseif (isset($_GET['canceled_client'])) {
        $href = 'href=\"index.php?t=home\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('dashboard').'</a>';

        if (isset($_GET['package']) && isset($_GET['bundle'])) {
            $package = $_GET['package'];
            $bundle = $_GET['bundle'];

            if (is_numeric($package) && is_numeric($bundle)) {
                $href = 'href=\"index.php?t=shop&bundle='.$bundle.'&package='.$package.'\"><i class=\"fa fa-long-arrow-left\"></i> '.Lang('package').'</a>';
            }
        }

        echo '
			<script>
				$("#purchase_main").html("<b><big><i style=\"color: red;\" class=\"fa fa-times-circle-o\"></i> '.Lang('payment_canceled_client').'</big></b><br><br><a class=\"btn btn-primary\" '.$href.'");
			</script>
		';
    } else {
        echo '<script>setTimeout(function(){ window.location.replace("index.php?t=home"); }, 100);</script>';
    }
?>