<!--{"language":"search","icon":"fa-search","place":"main","position":40,"nologin":true}-->

<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<br><br>

<div class="row">
	<div class="col-md-12">
		<div class="input-group">
			<input type="text" class="form-control" id="search_main" placeholder="<?php echo Lang('search_user'); ?>" />
			<span class="input-group-btn dropdown">
				<button style="border-radius: 0;" class="btn btn-default btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
					<i class="fa fa-caret-down"></i>
				</button>
				<ul class="dropdown-menu">
					<li><a onclick="$('#search_main').val('').focus().val('GROUP::');" href="#"><i class="fa fa-users"></i> <?php echo Lang('group'); ?></a></li>
					<?php echo Permissions::HasPermission('user_ips') ? ' <li><a onclick="$(\'#search_main\').val(\'\').focus().val(\'IP::\');" href="#"><i class="fa fa-eye"></i> '.Lang('ipaddress').'</a></li>' : ''; ?>
				</ul>
			</span>
			<span class="input-group-btn">
				<button onclick="search_results_list()" type="button" class="btn btn-primary">
					<i class="glyphicon glyphicon-search"></i>
				</button>
			</span>
		</div>
		<div id="search_results">

		</div>
		<div id="search_lastactive">
			<h5 class="page-header"><?php echo Lang('latest_activities'); ?></h5>
			<i class="fa fa-spinner fa-pulse fa-2x"></i>
		</div>
	</div>
</div>

<br>

<script type="text/javascript" src="assets/js/bootstrap3-typeahead.min.js"></script>

<script>
	$( document ).ready(function(){
		$.get('request.php?t=search&query=', function(data){
		    $("#search_main").typeahead({ source:data });
		    main_load();
		},'json');
	});

	function search_results_list(){
		$("#search_results").html('<h5 class="page-header"><?php echo Lang('search_results'); ?></h5><i class="fa fa-spinner fa-pulse fa-2x"></i>');

		$.get('request.php?t=search', {listres:true, query:$("#search_main").val()}).done(function(data){
			$("#search_results").html('<h5 class="page-header"><?php echo Lang('search_results'); ?></h5>');
			$("#search_results").append(data);
			main_load();
		});
	}

	$("#search_main").keyup(function(event){
	    if(event.keyCode == 13){
	        setTimeout(function(){
			    search_results_list();
			}, 100);
	    }
	});

	$.getJSON('request.php?t=search&amount=20', function(data){
		var lastactiveusers = data;

		$("#search_lastactive").html('<h5 class="page-header"><?php echo Lang('latest_activities'); ?></h5><div class="row">');

		lastactiveusers.forEach(function(user){
			$("#search_lastactive").append('<div class="col-md-3 col-sm-4 col-xs-6"><div class="panel panel-default"><div class="panel-body ellipsis"><a href="index.php?t=user&id=' + user['steamid64'] + '" target="_blank"><img style="border-radius: 4px;" src="' + user['avatar_small'] + '"></img></a> <a style="padding: 5px 5px 5px 5px;" class="btn btn-simple btn-primary" href="index.php?t=user&id=' + user['steamid64'] + '" target="_blank">' + user['nick'] + '</a></div></div></div>');
		});

		$("#search_lastactive").append('</div>');

		main_load();
	});
</script>
