<!--{"language":"servers","icon":"fa-server","place":"main","position":30,"nologin":true}-->

<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('servers'); ?>

			<span class="pull-right">
				<button onclick="servers_refresh();" class="btn btn-default"><i class="fa fa-refresh"></i> <?php echo Lang('refresh'); ?></button>
			</span>
		</h1>
	</div>
</div>

<script>
	var servers = [];
	var teamspeakservers = [];
	var discord = null;
</script>

<div class="row">
	<div class="col-xs-12">

			<?php
                $printed = false;

                $modals = array();

                if (Settings::Get('settings_teamspeak_query_password')) {
                    $printed = true;

                    echo '<div class="table-responsive"><table class="table table-hover"><caption>Teamspeak 3</caption>

					<tr class="active">
						<th style="width: 5%; ">#</b></th>
						<th style="width: 10%;">'.Lang('users').'</th>
						<th>'.Lang('hostname').'</th>
						<th style="width: 33%;">'.Lang('ipaddress').'</th>
						<th style="width: 2%; " class="text-right">'.Lang('actions').'</th>
					</tr>

					<tbody>';

                    echo '<tr>';
                    echo '<td>';
                    echo 1;
                    echo '</td>';
                    echo '<td>';
                    echo '<span id="servers_users_teamspeak"><i class="fa fa-refresh fa-spin"></i></span>';
                    echo '</td>';
                    echo '<td>';
                    echo '<span id="servers_hostname_teamspeak"><i class="fa fa-refresh fa-spin"></i></span>';
                    echo '</td>';
                    echo '<td>';
                    echo DemoLock() ? '<i>hidden</i>' : (Settings::Get('settings_teamspeak_display_ip') ? Settings::Get('settings_teamspeak_display_ip') : Settings::Get('settings_teamspeak_ip')).':'.Settings::Get('settings_teamspeak_port');

                    echo '</td>';

                    echo '<td class="text-right">';
                    echo '<a href="ts3server://'.(DemoLock() ? 'HIDDEN' : (Settings::Get('settings_teamspeak_display_ip') ? Settings::Get('settings_teamspeak_display_ip') : Settings::Get('settings_teamspeak_ip')).':'.Settings::Get('settings_teamspeak_port')).'"><button type="button" class="btn btn-success btn-xs"><i class="fa fa-plug"></i> '.Lang('connect').'</button></a>';
                    echo '</td>';
                    echo '</tr>';

                    echo '
							<script>
								teamspeakservers.push({
									id: "teamspeak",
									tsviewerid: "'.Settings::Get('settings_teamspeak_tsviewerid').'",
									ip: "'.Settings::Get('settings_teamspeak_ip').'",
									port: "'.Settings::Get('settings_teamspeak_port').'"
								});
							</script>
						';

                    $modals[] = '
							<div class="modal fade" id="servers_server_teamspeak_modal" tabindex="-1" role="dialog" aria-hidden="true">
								<div class="modal-dialog">
									<div class="modal-content">
										<div class="modal-header">
											<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
											<h4 class="modal-title"><i class="fa fa-microphone"></i> &nbsp; Teamspeak</h4>
										</div>

										<div class="modal-body" id="servers_playerlist_teamspeak">
								            <i class="fa fa-spinner fa-spin"></i>
										</div>

									</div>
								</div>
							</div>
						';
                    echo '</tbody></table></div>';
                }

                if (Settings::Get('settings_discord_bot_token') && Settings::Get('settings_discord_guild_id')) {
                    $printed = true;

                    echo '<div class="table-responsive"><table class="table table-hover"><caption>Discord</caption>

					<tr class="active">
						<th style="width: 5%; ">#</b></th>
						<th style="width: 10%;">'.Lang('users').'</th>
						<th>'.Lang('hostname').'</th>
						<th style="width: 2%; " class="text-right">'.Lang('actions').'</th>
					</tr>

					<tbody>';

                    echo '<tr>';
                    echo '<td>';
                    echo 1;
                    echo '</td>';
                    echo '<td>';
                    echo '<span id="servers_users_discord"><i class="fa fa-refresh fa-spin"></i></span>';
                    echo '</td>';
                    echo '<td>';
                    echo '<span id="servers_hostname_discord"><i class="fa fa-refresh fa-spin"></i></span>';
                    echo '</td>';
                    echo '<td class="text-right">';
                    echo '<button data-toggle="modal" data-target="#servers_server_discord_modal" type="button" class="btn btn-success btn-xs"><i class="fa fa-plug"></i> '.Lang('connect').'</button>';
                    echo '</td>';
                    echo '</tr>';

                    echo '
							<script>
								discord = {
									id: "discord",
									guild_id: "'.Settings::Get('settings_discord_guild_id').'"
								}
							</script>
						';

                    $modals[] = '
							<div class="modal fade" id="servers_server_discord_modal" tabindex="-1" role="dialog" aria-hidden="true">
								<div class="modal-dialog">
									<div class="modal-content">
										<div class="modal-header">
											<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
											<h4 class="modal-title"><i class="fa fa-comments-o"></i> &nbsp; Discord</h4>
										</div>

										<div class="modal-body text-center">
								            <iframe src="https://discordapp.com/widget?id='.Settings::Get('settings_discord_guild_id').'&theme=light" width="300" height="500" allowtransparency="true" frameborder="0"></iframe>
										</div>

									</div>
								</div>
							</div>
						';
                    echo '</tbody></table></div>';
                }
            ?>


		<?php


            foreach (Serverbundle::GetAll() as $bundle) {
                $servers = $bundle->GetServers();

                if (sizeof($servers)) {
                    $printed = true;
                    echo '
                    	<div class="table-responsive">
						<table class="table table-responsive table-hover">
							<caption>'.$bundle->GetValue('name').'</caption>

							<tr class="active">
								<th style="width: 5%; ">#</b></th>
								<th style="width: 10%;">'.Lang('players').'</th>
								<th>'.Lang('hostname').'</th>
								<th style="width: 15%;">'.Lang('ipaddress').'</th>
								<th style="width: 18%;">'.Lang('map').'</th>
								<th style="width: 2%; " class="text-right">'.Lang('actions').'</th>
							</tr>

							<tbody>';

                    foreach ($servers as $server) {
                        echo '<tr>';
                        echo '<td>';
                        echo $server->GetValue('id');
                        echo '</td>';
                        echo '<td>';
                        echo '<span id="servers_players_'.$server->GetValue('id').'"><i class="fa fa-refresh fa-spin"></i></span>';
                        echo '</td>';
                        echo '<td>';
                        echo htmlspecialchars($server->GetValue('hostname'));
                        echo '</td>';

                        echo '<td>';
                        echo $server->GetValue('ip').':'.$server->GetValue('port');
                        echo '</td>';

                        echo '<td>';
                        echo '<span id="servers_map_'.$server->GetValue('id').'"><i class="fa fa-refresh fa-spin"></i></span>';
                        echo '</td>';

                        echo '<td class="text-right">';
                        echo '<a href="steam://connect/'.$server->GetValue('ip').':'.$server->GetValue('port').'"><button type="button" class="btn btn-success btn-xs"><i class="fa fa-plug"></i> '.Lang('connect').'</button></a>';
                        echo '</td>';
                        echo '</tr>';

                        echo '
										<script>
											servers.push({
												id: '.$server->GetValue('id').',
												ip: "'.$server->GetValue('ip').'",
												port: "'.$server->GetValue('port').'"
											});
										</script>
									';

                        $modals[] = '
										<div class="modal fade" id="servers_server_'.$server->GetValue('id').'_modal" tabindex="-1" role="dialog" aria-hidden="true">
											<div class="modal-dialog">
												<div class="modal-content">
													<div class="modal-header">
														<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
														<h4 class="modal-title"><i class="fa fa-users"></i> &nbsp; '.Lang('players_on_server').' #'.$server->GetValue('id').'</h4>
													</div>

													<div class="modal-body">
											            <table class="table table-responsive table-hover">
															<tr class="active">
																<th style="width: 60%;">'.Lang('name').'</th>
																<th style="width: 20%;">'.Lang('score').'</th>
																<th style="width: 20%; " class="text-right">'.Lang('online_since').'</th>
															</tr>

															<tbody id="servers_playerlist_'.$server->GetValue('id').'">

															</tbody>
														</table>
													</div>

												</div>
											</div>
										</div>

									';
                    }

                    echo '</tbody>
						</table>
						</div>
					';
                }
            }

            if (!$printed) {
                echo '<i>'.Lang('no_entries').'</i>';
            }
        ?>
	</div>
</div>

<hr>

<b><?php echo Lang('total'); ?>:</b> <span id="servers_total">0</span> <?php echo Lang('players'); ?>

<?php
    foreach ($modals as $modal) {
        echo $modal;
    }
?>

<script>
	$('#servers_server_teamspeak_modal').on('show.bs.modal', function(e){
		teamspeak_refresh(true);
	});

	var players_total = 0;
	
	function discord_refrsh(){
		if(discord){
			$.getJSON( "request.php?t=servers", {
				serverid: 'discord'
			}).done(function( data ) {
				if(data["status"]){
					$("#servers_users_discord" ).html('<i style="color:green;" class="fa fa-bolt"></i> <a onclick="server_playerlist(\'discord\');" href="#">' + data["members"] + '</a>');
					$("#servers_hostname_discord").html(data["hostname"]);
				}else{
					$("#servers_users_discord").html('<i style="color:red;" class="fa fa-bolt"></i> 0 / 0');
					$("#servers_hostname_discord").html('-');
				}
			});
		}
	}

	function teamspeak_refresh(viewer = false){
		teamspeak_viewer = 0;

		if(viewer){
			teamspeak_viewer = 1;
		}

		teamspeakservers.forEach(function(server){
			$.getJSON( "request.php?t=servers", {
				serverid: server["id"],
				teamspeak_viewer: teamspeak_viewer
			}).done(function( data ) {
				if(data["status"]){
					$("#servers_users_" + server["id"] ).html('<i style="color:green;" class="fa fa-bolt"></i> <a onclick="server_playerlist(\'' + server["id"] + '\');" href="#">' + data["online"] + ' / ' + data["max"] + '</a>');
					$("#servers_hostname_" + server["id"]).html(data["hostname"]);

					if(data.hasOwnProperty('users')){
						$("#servers_playerlist_" + server["id"]).html('');

						//var ts3v_url_1 = "https://www.tsviewer.com/ts3viewer.php?ID=1052049&text=757575&text_size=12&text_family=1&text_s_color=000000&text_s_weight=normal&text_s_style=normal&text_s_variant=normal&text_s_decoration=none&text_i_color=&text_i_weight=normal&text_i_style=italic&text_i_variant=normal&text_i_decoration=none&text_c_color=&text_c_weight=normal&text_c_style=normal&text_c_variant=normal&text_c_decoration=none&text_u_color=000000&text_u_weight=bold&text_u_style=normal&text_u_variant=normal&text_u_decoration=none&text_s_color_h=&text_s_weight_h=bold&text_s_style_h=normal&text_s_variant_h=normal&text_s_decoration_h=none&text_i_color_h=000000&text_i_weight_h=bold&text_i_style_h=normal&text_i_variant_h=normal&text_i_decoration_h=none&text_c_color_h=&text_c_weight_h=normal&text_c_style_h=normal&text_c_variant_h=normal&text_c_decoration_h=none&text_u_color_h=&text_u_weight_h=bold&text_u_style_h=normal&text_u_variant_h=normal&text_u_decoration_h=none&iconset=default_mono_2014";
						//ts3v_display.init(ts3v_url_1, server['tsviewerid'], 100);
						$('#servers_playerlist_' + server["id"]).html(data['users']);
					}
				}else{
					$("#servers_users_" + server["id"]).html('<i style="color:red;" class="fa fa-bolt"></i> 0 / 0');
					$("#servers_hostname_" + server["id"]).html('-');
				}
			});
		});
	}

	function servers_refresh(){
		players_total = 0;

		servers.forEach(function(server){
			$.getJSON( "request.php?t=servers", {
				serverid: server["id"]
			}).done(function( data ) {
				if(data["status"]){
					$("#servers_players_" + server["id"] ).html('<i style="color:green;" class="fa fa-bolt"></i> <a onclick="server_playerlist(' + server["id"] + ');" href="#">' + data["players"].length + ' / ' + data["slots"] + '</a>');
					$("#servers_map_" + server["id"]).html(data["map"]);
					$("#servers_playerlist_" + server["id"]).html('');

					data["players"].forEach(function(player){
						$("#servers_playerlist_" + server["id"]).append('<tr><td><a style="color: ' + player['group_color'] + '" target="_blank" href="index.php?t=user&id=' + player['steamid64'] + '">' + player['nick'] + '</a></td><td>' + player['score'] + '</td><td class="text-right">' + moment("2015-01-01").startOf('day').seconds(player['time']).format('H:mm') + '</td></tr>');
					});

					players_total = players_total + data["players"].length;

					$('#servers_total').html(players_total);
				}else{
					$("#servers_players_" + server["id"]).html('<i style="color:red;" class="fa fa-bolt"></i> 0 / 0');
					$("#servers_map_" + server["id"]).html('-');
				}
			});
		});

		teamspeak_refresh();
		
		discord_refrsh();
	}

	function server_playerlist(id){
		$('#servers_server_' + id + '_modal').modal('show');
	}

	servers_refresh();
</script>
