<!--{"language":"donate","icon":"fa-money","place":"main","position":20,"nologin":true}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<link rel="stylesheet" href="assets/css/pricingtable.css">

<div class="row">
	<div class="col-md-12">
		<h1 class="page-header"><?php echo Settings::Get('settings_donations_shop') ? Lang('shop') : Lang('donate'); ?> <span id="donate_heading_right" class="pull-right"></span></h1>
	</div>
</div>

<?php
    if (!ValidateBool(Settings::Get('settings_donations_enabled'))) {
        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('donations_not_enabled').'", type: "error"');
        die(Lang('donations_not_enabled'));
    }

    if (null != $auth_user && Settings::Get('settings_donations_email_required') && tempty($auth_user->GetValue('email'))) {
        DirectNotifications::Execute('title: "'.Lang('warning').'", text: "'.Lang('email_required').': <a data-toggle=modal data-target=#main_modal_settings href=#>'.Lang('settings').'</a>'.'", type: "error", hide: false');
    }
?>



<div id="donation_main">
	<div class="row">
		<div class="col-md-12">
			<?php
                $displayed_1 = false;

                $monthtotal = Donations::GetMonthTotal();
                $goal = Settings::Get('settings_donations_monthlygoal');

                if ($goal > 0) {
                    $displayed_1 = true;
                    $percentage = floor(($monthtotal / $goal) * 100); ?>
					<b><?php echo Lang('monthly_goal').'</b> ('.FormatPrice($monthtotal).' '.Settings::Get('settings_donations_currency_plain').' / '.FormatPrice($goal).' '.Settings::Get('settings_donations_currency_plain').')'; ?>
					<div class="progress">
			   			<?php
                            echo '<div class="progress-bar progress-bar-striped active" role="progressbar" style="width: '.$percentage.'%">';
                    echo '<span style="color:black; font-weight:bold;position:absolute;right:0;left:0;">'.$percentage.'%</span>';
                    echo '</div>'; ?>
					</div>

			<?php
                }

                if (ValidateBool(Settings::Get('settings_donations_event_enabled'))) {
                    if (time() - strtotime(Settings::Get('settings_donations_event_deadline')) < 86400 && strtotime(Settings::Get('settings_donations_event_begin')) < time()) {
                        echo '<br>';

                        $displayed_1 = true;

                        $betweentotal = Donations::GetBetweenTotal(Settings::Get('settings_donations_event_begin'), Settings::Get('settings_donations_event_deadline'));
                        $goal = Settings::Get('settings_donations_event_goal');
                        $percentage = floor(($betweentotal / $goal) * 100); ?>
						<b><?php echo Lang('event_name').'</b>: '.Settings::Get('settings_donations_event_name'); ?><br>
						<b><?php echo Lang('deadline').'</b>: '.FormatDate(Settings::Get('settings_donations_event_deadline')); ?><br>
						<b><?php echo Lang('goal').':</b> ('.$betweentotal.' '.Settings::Get('settings_donations_currency_plain').' / '.$goal.' '.Settings::Get('settings_donations_currency_plain').')'; ?>
						<div class="progress">
				   			<?php
                                echo '<div class="progress-bar progress-bar-striped active progress-bar-success" role="progressbar" style="width: '.$percentage.'%">';
                        echo '<span style="color:black; font-weight:bold;position:absolute;right:0;left:0;">'.$percentage.'%</span>';
                        echo '</div>'; ?>
						</div>
			<?php
                    }
                } ?>
		</div>
	</div>

	<?php echo $displayed_1 ? '<hr/>' : ''; ?>

	<?php if (!tempty(Settings::Get('settings_donations_description'))) {
                    ?>
	<div class="row">
		<div class="text-center">
			<?php echo Settings::Get('settings_donations_description'); ?>
		</div>
	</div>
	<br>
	<?php
                } ?>
	<div class="row">
		<div class="text-center">
			<button type="button" onclick="donate_bundles_select_modal_open();" class="btn btn-lg btn-primary"><i class="fa fa-server"></i> <?php echo Lang('select_server'); ?></button>
		</div>
	</div>
	<?php if (Settings::Get('settings_donations_statistics')) {
                    ?>
	<hr>
	<div class="row">
		<div class="col-sm-6">
			<div class="box">
			    <div class="box-header">
			        <div class="box-title pull-left">
						<p><i class="fa fa-clock-o fa-lg"></i></p>
			        	<p><b><?php echo Lang('latest_donations'); ?></b></p>
			        </div>
				</div>

			  	<div class="box-content" id="donate_latest_donations">
			  		<div class="table-responsive">
				  		<table class="table table-hover">
							<tr>
								<th><?php echo Lang('name'); ?></th>
								<th><?php echo Lang('package'); ?></th>
								<th><?php echo Lang('date'); ?></th>
								<th style="width: 10%;"><?php echo Lang('amount'); ?></th>
							</tr>
							<tbody>
								<?php
                                    foreach (Donations::GetLatestDonations(6, true) as $donation) {
                                        if (0 != $donation['amount']) {
                                            $buyer = new User($donation['steamid64_buyer']);

                                            $package = new Package($donation['package'], null, false);

                                            if ($package->valid && $buyer->valid) {
                                                echo '<tr>';
                                                echo '<td>';
                                                echo '<a href="index.php?t=user&id='.$buyer->GetValue('steamid64').'" target="_blank">'.$buyer->GetValue('nick').'</a>';
                                                echo '</td>';
                                                echo '<td>';
                                                echo '<a href="index.php?t=shop&bundle='.$package->GetValue('serverbundle').'&package='.$package->GetValue('id').'" target="_blank">'.$package->GetValue('title').'</a>';
                                                echo '</td>';
                                                echo '<td>';
                                                echo FormatDate($donation['date']);
                                                echo '</td>';
                                                echo '<td>';
                                                echo Settings::Get('settings_donations_currency').FormatPrice($donation['amount']);
                                                echo '</td>';
                                                echo '</tr>';
                                            }
                                        }
                                    } ?>
							</tbody>
						</table>
					</div>
			  	</div>
			</div>
		</div>
		<div class="col-sm-6">
			<div class="box">
			    <div class="box-header">
			        <div class="box-title pull-left">
						<p><i class="fa fa-bar-chart fa-lg"></i></p>
			        	<p><b><?php echo Lang('top_donators'); ?></b></p>
			        </div>
				</div>

			  	<div class="box-content" id="donate_top_donators">
			  		<div class="table-responsive">
				  		<table class="table table-hover">
							<tr>
								<th><?php echo Lang('name'); ?></th>
								<th style="width: 10%;"><?php echo Lang('amount'); ?></th>
							</tr>
							<tbody>
								<?php
                                    foreach (Donations::GetTopDonators(6) as $steamid64 => $amount) {
                                        $buyer = new User($steamid64);

                                        if ($buyer->valid) {
                                            echo '<tr>';
                                            echo '<td>';
                                            echo '<a href="index.php?t=user&id='.$buyer->GetValue('steamid64').'" target="_blank">'.$buyer->GetValue('nick').'</a>';
                                            echo '</td>';
                                            echo '<td>';
                                            echo Settings::Get('settings_donations_currency').FormatPrice($amount);
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    } ?>
							</tbody>
						</table>
					</div>
			  	</div>
			</div>
		</div>
	</div>
	<?php
                } ?>
</div>




<!-- SelectServer Modal -->
<div class="modal fade" id="donate_modal_selectserver" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-server"></i> &nbsp;<?php echo Lang('select_server'); ?></h4>
			</div>
			<div class="modal-body">
				<div class="panel panel-default">
		            <div class="panel-body">
	            		<?php
                            $first = true;

                            foreach (Serverbundle::GetAll(true) as $bundle) {
                                if ($bundle->GetValue('donations')) {
                                    if (!$first) {
                                        echo '<hr>';
                                    } else {
                                        $first = false;
                                    }

                                    $image = 'assets/img/bundles/'.$bundle->GetValue('id').'.png';

                                    if (!file_exists($image)) {
                                        $image = '';
                                    }

                                    echo '
                                    <div class="row"><div class="col-md-2">
					                    '.($image ? '<img class="img-responsive" width="70" height="70" src="'.$image.'" />' : '').'
					                </div>
					                <div class="col-md-8">
					                    <p>
					                    	<strong>'.$bundle->GetValue('name').($bundle->GetValue('discount') ? ' <span style="color:red;">[-'.$bundle->GetValue('discount').'%]</span>' : '').'</strong>
					                    	<br>
					                    	'.$bundle->GetValue('description').'
					                    </p>
					                </div>
					                <div class="col-md-2 pull-right">
					                <br>
					                    <button class="btn btn-primary btn-sm" onclick="donate_packages_load('.$bundle->GetValue('id').');" type="button"><i class="fa fa-arrow-right"></i></button>
					                </div></div>';
                                }
                            }
                        ?>
		            </div>
		        </div>
			</div>
		</div>
	</div>
</div>

<!-- PurchaseDetails Modal -->
<div class="modal fade" id="donate_modal_purchasedetails" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-shopping-cart"></i> &nbsp;<?php echo Lang('overview'); ?></h4>
			</div>
		
			<div class="modal-body">
				<label><?php echo Lang('product'); ?></label><br/>
				<i id="donate_modal_purchasedetails_package_name"></i>
				<br/>
				<br/>
				
				<label><?php echo Lang('price'); ?></label><br/>
				<i id="donate_modal_purchasedetails_price"></i> <i><?php echo Settings::Get('settings_donations_currency_plain'); ?></i>
				<br/>
				<br/>
				
				<label><?php echo Lang('recipient'); ?></label><br/>
				<i id="donate_modal_purchasedetails_recipient"></i>
				<br/>
				<br/>
				
				<label><?php echo Lang('payment_method'); ?></label><br/>
				<i id="donate_modal_purchasedetails_payment_method"></i>
				<br/>
				<br/>
				
				<label><?php echo Lang('coupon'); ?></label><br/>
				<i id="donate_modal_purchasedetails_coupon"></i>
				<br/>
				<br/>
				
				<?php 
                    $checkboxes = 0;

                    if (!tempty(Settings::Get('settings_donations_checkboxes'))) {
                        foreach (explode(PHP_EOL, Settings::Get('settings_donations_checkboxes')) as $cbtext) {
                            ++$checkboxes;
                            CreateCheckbox('primary', '', 'donate_purchase_checkboxes', $cbtext, '', '', false, false);
                        }
                    }
                ?>
				
				<button <?php echo $checkboxes > 0 ? 'disabled=""' : ''; ?> id="donate_purchase_checkout" class="btn btn-primary" style="width: 100%; border-radius: 0;" onclick="donate_purchase_purchase();"><i class="fa fa-shopping-cart"></i> <?php echo Lang('pay_mendatory'); ?></button>
			</div>
		</div>
	</div>
</div>

<script>
	var coupon = '';
	var couponamount = 0;
	var steamid_for = steamid64;
	var checkout = {};

	function donate_purchase_coupon_redeem(price, custom){
		if(!coupon){
			if(custom){
				price = $('#donate_custom').val();
			}

			$.getJSON('request.php?t=donate&code=' + $('#donate_coupon_code').val(), function(data) {
				if(data['valid']){
					coupon = data['code'];
					couponamount = data['amount_left'];
					$('#donate_coupon_code').toggle("highlight", {color: '#449D44'}, 500);
					$('#donate_coupon_button').html('<span class="fa fa-check"></span> <?php echo Settings::Get('settings_donations_currency'); ?>' + data['amount_left']);

					data['amount_left'] = ReplaceAll(',', '', data['amount_left']);

					if(Number(data['amount_left']) >= Number(price) && $.isNumeric(price)){
						$('#donate_purchase_gateways').html($('#donate_purchase_gateway_coupon_template')[0].outerHTML);
						$('#donate_purchase_gateway_coupon_template').removeClass('hidden').addClass('active').css('width', '90%');
					}
				}else{
					$('#donate_coupon_code').effect("highlight", {color: '#FC6A6A'}, 500);
				}
				setTimeout(function(){
					donate_purchase_adjustsize()}
				, 800);
			});
		}
	}

	function donate_purchase_for_set(){
		$.getJSON('request.php?t=donate&steamid=' + $('#donate_for_steamid').val(), function(data) {
			if(data['valid']){
				steamid_for = data['steamid64'];
				$('#donate_for_steamid').toggle("highlight", {color: '#449D44'}, 500);
				$('#donate_for_button').html('<?php echo Lang('for'); ?>: ' + data['nick']);
			}else{
				$('#donate_for_steamid').effect("highlight", {color: '#FC6A6A'}, 500);
			}
			setTimeout(function(){
				donate_purchase_adjustsize()}
			, 800);
		});
	}

	function donate_bundles_select_modal_open(){
		$('#donate_modal_selectserver').modal('show');
	}

	var PackagesLoaded = false;

	function donate_packages_load(bundle){
		$('#donate_modal_selectserver').modal('hide');
		$('#donation_main').html('<i class="fa fa-spinner fa-pulse fa-2x"></i>');
		$('#donate_heading_right').html('');

		UpdateURL('index.php?t=shop&bundle=' + bundle);

		$.getJSON('request.php?t=donate&bundle=' + bundle, function(data) {
			if('error' in data){
				window.location.replace("index.php?t=shop");
			}else{
				PackagesLoaded = true;

				var packages = data['packages'];
				var categories = {};

				bundle = data['bundle'];

				var packages_count = 0;

				packages.forEach(function(entry){
					if(entry['active']){
						if(!categories.hasOwnProperty(entry['category'])){
							categories[entry['category']] = '';
						}

						categories[entry['category']] = categories[entry['category']] + donate_package_create(entry, bundle);

						packages_count++;
					}
				});

				if(packages_count == 1){
					donate_package_select(bundle["id"], packages[0]["id"], true);
				}else if(packages_count == 0){
					$('#donation_main').html('<i><?php echo Lang('no_entries'); ?></i>');
					$('#donate_heading_right').html('<button onclick="donate_bundles_select_modal_open()" class="btn btn-default"><i class="fa fa-server"></i> <?php echo Lang('select_server'); ?></button>');
				}else{
					var newHTML = '';

					var keys = Object.keys(categories);
					var i, len = keys.length;

					keys.sort();

					for (i = 0; i < len; i++) {
						key = keys[i];

						newHTML = newHTML + '<div class="row">';

						if(key != ''){
							newHTML	= newHTML + '<div id="donate_category_' + i + '" class="donate-category col-xs-12"><h5 class="page-header" style="margin: 0 0 20px;">' + key + '</h3>' + categories[key] + '</div>';
						}else{
							newHTML	= newHTML + '<span id="donate_category_" class="donate-category">' + categories[key] + '</span>';
						}

						newHTML = newHTML + '</div>';
					}

					$('#donation_main').html(newHTML);
					
					setTimeout(function(){
						donate_packages_adjustsize();
					}, 250);

                    setTimeout(function(){
                        donate_packages_adjustsize();
                    }, 500);

                    setTimeout(function(){
                        donate_packages_adjustsize();
                    }, 1000);

                    setTimeout(function(){
                        donate_packages_adjustsize();
                    }, 2000);

		            $('#donate_heading_right').html('<button onclick="donate_bundles_select_modal_open()" class="btn btn-default"><i class="fa fa-server"></i> <?php echo Lang('select_server'); ?></button>');

		            $(".pricing").hover(function() {
						$(this).css("border","3px solid " + bundle['hexcolor']);
						$(this).find("h4").css("color", bundle['hexcolor']);
					}, function(){
						$(this).css("border","3px solid #eee");
						$(this).find("h4").css("color", "#828282");
					});

		            main_load();
				}
			}
		});
	}

	function donate_package_create(package, bundle){
		var duration = package['days'] + ' <?php echo Lang('days'); ?>';

		if(!package['days']){
			duration = '<?php echo Lang('permanent'); ?>';
		}

		var price = '<i><?php echo Settings::Get('settings_donations_currency'); ?></i>' + package['price'];

		if(package['price_custom']){
			price = '?';
		}

		if(bundle['discount']){
			price = '<font color="red">' + price + '</font>'
		}

		var content = ReplaceAll('<ul>', '<ul class="list-unstyled">', package['description']);

		return `<div class="col-xs-12 col-sm-6 col-lg-4 donation-package">
					<div class="pricing hover-effect text-center">
						<div class="pricing-head">
							<h3 style="background-color: ` + bundle['hexcolor'] + `;">
								` + package['title'] + `
								<span>` + package['subtitle'] + `</span>
							</h3>
							<h4>
								` + price + `
								<span>
									` + duration + `
								</span>
							</h4>
						</div>
						<div class="pricing-content">
							` + content + `
						</div>

						<div class="pricing-footer">
							<button class="btn btn-sm" onclick="donate_package_select(` + bundle['id'] + `, ` + package['id'] + `);" style="color: white; background: ` + bundle['hexcolor'] + `">
								<?php echo Lang('select'); ?>
							</button>
						</div>
					</div>

              	</div>`;
	}

	function donate_purchase_purchase(){
		post('index.php?t=purchase', {'package': checkout['package'], 'gateway': checkout['gateway'], 'coupon': checkout['coupon'], 'for': steamid_for, 'price_custom': checkout['price']});
	}
	
	function donate_purchase_continue(package, price, package_name, duration){
		var price_custom = 0;
		var gateway = 'none';

		if(price > 0){
			gateway = $('.donate_purchase_gateway.active').attr('value');

			if($('#donate_custom').length){
				price_custom = $('#donate_custom').val();

				if(price_custom < price || !$.isNumeric(price_custom)){
					$('#donate_custom').effect("highlight", {color: '#FC6A6A'}, 500);
					return false;
				}
			}
		}else{
			gateway = 'coupon';
			coupon = '_free'
		}
		
		checkout = {'price': price_custom,
					'package': package,
					'gateway': gateway,
					'coupon': coupon}

		$('#donate_modal_purchasedetails_package_name').html(package_name + ' (' + duration + ')');
		$('#donate_modal_purchasedetails_price').html(price);
		$('#donate_modal_purchasedetails_payment_method').html(gateway);
		$('#donate_modal_purchasedetails_recipient').html(steamid_for);
		
		if(coupon){
			$('#donate_modal_purchasedetails_coupon').html(coupon + ' (' + couponamount + ' <?php echo Settings::Get('settings_donations_currency_plain'); ?>)');
		}else{
			$('#donate_modal_purchasedetails_coupon').html('-');
		}
		
		$('#donate_modal_purchasedetails').modal('show');
	}

	function donate_packages_adjustsize(){
		var packagesPerRow = 3;

		if($(document).width() < 768){
			packagesPerRow = 1;
		}else if($(document).width() < 992){
			packagesPerRow = 2;
		}

		$('.donate-category').each(function(key1, val1) {
			var currentBoxes = [];

			var id = $(val1).attr('id');

			$('#' + id ).find('.pricing-content').each(function (key2, val2) {
	        	currentBoxes.push($(val2));

	        	if(currentBoxes.length >= packagesPerRow){
	        		var highestBox = 0;

	        		$.each(currentBoxes, function(i, pckg){
	        			if($(pckg).height() > highestBox){
	        				highestBox = $(pckg).prop('scrollHeight');
	        			}
	        		});

	        		$.each(currentBoxes, function(i, pckg){
	        			$(pckg).height(highestBox);
	        		});

	        		currentBoxes = [];
	        	}
	        });

	        if(currentBoxes.length > 0){
	    		var highestBox = 0;

	    		$.each(currentBoxes, function(i, pckg){
	    			if($(pckg).prop('scrollHeight') > highestBox){
	    				highestBox = $(pckg).prop('scrollHeight');
	    			}
	    		});

	    		$.each(currentBoxes, function(i, pckg){
	    			$(pckg).height(highestBox);
	    		});
	        }
		});
	}

	function donate_adjustsize(ignoresize = false){
		setTimeout(function(){
			if($('#donate_latest_donations, #donate_top_donators').length){
				if($( document ).width() > 1000 || ignoresize){
					$('#donate_latest_donations, #donate_top_donators').height($('#donate_latest_donations, #donate_top_donators').height());
				}
			}
		}, 50);
	}

	donate_adjustsize(true);

	function donate_purchase_adjustsize(ignoresize = false){
		setTimeout(function(){
			if($('.item-description').length){
				if($( document ).width() > 1000 || ignoresize){
					$('.item-description').height($('.item-for').offset().top - $('.item-purchase').offset().top + $('.item-for').height());
				}
			}
		}, 50);
	}

	$( window ).resize(function() {
		donate_packages_adjustsize();
		donate_purchase_adjustsize();
		donate_adjustsize();
	});

	function donate_package_select(bundle, package, select_server_button = false){
		$('#donation_main').html('<i class="fa fa-spinner fa-pulse fa-2x"></i>');
		$('#donate_heading_right').html('');

		UpdateURL('index.php?t=shop&bundle=' + bundle + '&package=' + package);

		if(steamid64 == 'guest'){
			Redirect('request.php?t=main_login');
		}else{
			$.getJSON('request.php?t=donate&bundle=' + bundle + '&package=' + package, function(data) {
				if('error' in data){
					donate_packages_load(bundle);
				}else{
					bundle = data['bundle'];
					package = data['package'];
					var buyable = data['buyable'];
					var taxes = data['taxes'];

					var price_text = '<?php echo Settings::Get('settings_donations_currency'); ?>' + package["price"];
					var price = package["price"];
					var custom = false;

					if(package['price_custom']){
						price_text = `<div class="col-md-6 col-md-offset-3">
									  	<input id="donate_custom" value="` + package['price'] + `" type="text" class="form-control" placeholder="<?php echo Lang('price'); ?>" aria-describedby="donate_custom_addon">
									</div><br>`;

						custom = true;
					}
					
					var duration = package['days'] + ' <?php echo Lang('days'); ?>';

					if(!package['days']){
						duration = '<?php echo Lang('permanent'); ?>';
					}

					var newHTML =
					`
						<div class="row">
							<div class="col-xs-12" id="donate_alerts">

							</div>
						</div>
						<div class="row">
							<div class="col-md-8 col-sm-8">
								<div class="box ">
								    <div class="box-header">
								        <div class="box-title pull-left">
											<p><i class="fa fa-archive fa-lg"></i></p>
								        	<p><b>` + package['title'] + `</b></p>
								        </div>
									</div>

								  	<div style="overflow-x:auto;" class="box-content item-description">

								  		` + ReplaceAll('<li>', '<li class="list-group-item">', ReplaceAll('<ul>', '<ul class="list-group">',  package['description'])) + `

								  	</div>
								</div>
							</div>
							<div class="col-md-4 col-sm-4">
								<div class="box">
								    <div class="box-header">
								        <div class="box-title pull-left">
											<p><i class="fa fa-money fa-lg"></i></p>
								        	<p><b><?php echo Lang('payment_details'); ?></b></p>
								        </div>
									</div>

								  	<div class="box-content text-center item-purchase">
								  		<h2 style="margin-top:10px;"><b>` + price_text + `</b></h2>
								  		
								  		<span class="text-muted">` + duration + `</span>
								  		
								  		<br/>

								  		<small><i>` + ((taxes['taxRate'] > 0) ? ReplaceAll('%taxamount%', taxes['taxAmount'] + ' <?php echo Settings::Get('settings_donations_currency_plain'); ?>', ReplaceAll('%percent%', taxes['taxRate'], ((package['price_custom']) ? '<?php echo Lang('including_vat_custom'); ?>' : '<?php echo Lang('including_vat'); ?>'))) : '') + `</i></small>

										` + ((taxes['note'] != '') ? ((taxes['taxRate'] > 0) ? '<br />' : '') + '<small><i>' + taxes['note'] + '</i></small>' : '') + `

										<hr style="margin-bottom: 10px;">

										<ul class="nav nav-pills" role="tablist" id="donate_purchase_gateways">
									  		<?php
                                                $first = true;

                                                foreach (Gateway::GetAll() as $gateway) {
                                                    if ($gateway->GetValue('enabled')) {
                                                        $active = '';
                                                        $id = '';

                                                        if ('coupon' != $gateway->GetValue('name')) {
                                                            if ($first) {
                                                                $active = 'active';
                                                                $first = false;
                                                            }
                                                        } else {
                                                            $active = 'hidden';
                                                            $id = 'donate_purchase_gateway_coupon_template';
                                                        }

                                                        echo '
															<li style="cursor:pointer;width:45%; margin-left: 3.5%; margin-top:10px;" value="'.$gateway->GetValue('name').'" id="'.$id.'" class="donate_purchase_gateway '.$active.'">
																<a role="tab" data-toggle="tab" aria-expanded="false" id="donate_purchase_gateway_'.$gateway->GetValue('name').'">
																	<i class="fa fa-'.$gateway->GetValue('icon').'"></i>
																	'.$gateway->GetValue('text_display').'
																</a>
															</li>
														';
                                                    }
                                                }
                                            ?>
							  			</ul>

								  		<hr>

								  		<button id="donate_purchase_continue" class="btn btn-primary" style="width: 100%; border-radius: 0;" onclick="donate_purchase_continue(` + package['id'] + `, ` + package['price'] + `, '` + package['title'] + `', '` + duration + `');"><i class="fa fa-shopping-cart"></i> <?php echo Lang('continue'); ?></button>
								  	</div>
								</div>

								<div class="box">
								    <div class="box-header">
								        <div class="box-title pull-left">
											<p><i class="fa fa-ticket fa-lg"></i></p>
								        	<p><b><?php echo Lang('coupon'); ?></b></p>
								        </div>
									</div>

								  	<div class="box-content text-center item-coupon">
								  		<input style="width: 100%; border-radius: 0; margin-bottom: 7px;" id="donate_coupon_code" class="form-control" placeholder="<?php echo Lang('code'); ?>"></input>
								  		<button style="width: 100%; border-radius: 0;" id="donate_coupon_button" class="btn btn-success" onclick="donate_purchase_coupon_redeem(` + price + `, ` + custom + `)"><i class="fa fa-cart-plus"></i> <?php echo Lang('redeem'); ?></button>
								  	</div>
								</div>

								<div class="box">
								    <div class="box-header">
								        <div class="box-title pull-left">
											<p><i class="fa fa-user-plus fa-lg"></i></p>
								        	<p><b><?php echo Lang('buy_so_else'); ?></b></p>
								        </div>
									</div>

								  	<div class="box-content text-center item-for">
								  		<input style="width: 100%; border-radius: 0; margin-bottom: 7px;" id="donate_for_steamid" class="form-control" placeholder="SteamID64 / SteamID32"></input>
								  		<button style="width: 100%; border-radius: 0;" class="btn btn-warning" id="donate_for_button" onclick="donate_purchase_for_set()"><i class="fa fa-arrow-circle-right"></i> <?php echo Lang('set'); ?></button>
								  	</div>
								</div>

							</div>
						</div>

					`;

					if(!select_server_button){
						$('#donate_heading_right').html('<button onclick="donate_packages_load(' + bundle['id'] + ')" class="btn btn-default"><i class="fa fa-chevron-left"></i> <?php echo Lang('packages'); ?></button>');
					}else{
						$('#donate_heading_right').html('<button onclick="donate_bundles_select_modal_open()" class="btn btn-default"><i class="fa fa-server"></i> <?php echo Lang('select_server'); ?></button>');
					}


					$('#donation_main').html(newHTML);

					$("#donate_custom").TouchSpin({
				        min: package['price'],
				        max: 100000,
				        step: 1,
				        forcestepdivisibility: 'none',
				        verticalbuttons: true,
				        prefix: '<?php echo Settings::Get('settings_donations_currency'); ?>'
				    });

					$( "#donate_custom" ).change(function() {
						if(coupon){
							if(couponamount >= $('#donate_custom').val() && $.isNumeric($('#donate_custom').val())){
								$('#donate_purchase_coupon').prop('disabled', false);
							}else{
								$('#donate_purchase_coupon').prop('disabled', true);
							}
						}
					});

					$('.donate_purchase_checkboxes').change(function() {
				        if($(this).is(":checked")) {
				        	var allchecked = true;
				        	
				        	$('.donate_purchase_checkboxes').each(function(){
				        		if(!$(this).is(":checked")){
				        			allchecked = false;
				        		}
				        	});
				        	
				        	if(allchecked){
				        		$('#donate_purchase_checkout').prop('disabled', false);
				        	}else{
				        		$('#donate_purchase_checkout').prop('disabled', true);
				        	}
				        }else{
				        	$('#donate_purchase_checkout').prop('disabled', true);
				        }
				    });

					if(!buyable){
						$('#donate_alerts').prepend('<div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true"><i class="fa fa-times"></i></span></button><?php echo Lang('donate_cant_buy_for_yourself'); ?></div>');
					}

					donate_purchase_adjustsize(true);

					main_load();
				}
			});
		}


	}
</script>

<?php
    if (isset($_GET['bundle']) && isset($_GET['package'])) {
        if (is_numeric($_GET['bundle']) && is_numeric($_GET['package'])) {
            echo '<script>
					if (!PackagesLoaded){
						donate_package_select('.$_GET['bundle'].', '.$_GET['package'].');
					}
				</script>';
        }
    } elseif (isset($_GET['bundle'])) {
        if (is_numeric($_GET['bundle'])) {
            echo '<script>
					if (!PackagesLoaded){
						donate_packages_load('.$_GET['bundle'].');
					}
				</script>';
        }
    }
?>

