<!--{"language":"tickets","icon":"fa-ticket","place":"help","position":10}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    $ticket = null;
    $status = null;
    $nick_admin = null;
    $nick_user = null;

    if (isset($_GET['id'])) {
        $ticket = new Ticket($_GET['id']);

        if (!$ticket->valid) {
            $ticket = null;
        } else {
            $creator = new User($ticket->GetValue('steamid64'));

            if ($creator->valid) {
                //                                    Creator                               or (                                             admin and not answered                          or                                      is ticket admin                      or                  can takover)
                if (($auth_user->GetValue('steamid64') == $creator->GetValue('steamid64')) || ((Permissions::HasPermission('tickets_admin') && '' == $ticket->GetValue('steamid64_admin')) || ($auth_user->GetValue('steamid64') == $ticket->GetValue('steamid64_admin')) || Permissions::HasPermission('tickets_admin_takeover'))) {
                    if (isset($_POST['tickets_delete']) && Permissions::HasPermission('tickets_admin') && Permissions::HasPermission('tickets_delete')) {
                        $ticket->Delete();
                        $ticket = null;
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('ticket_deleted').'", type: "success"');
                    } else {
                        if (isset($_POST['tickets_reply_form_text'])) {
                            if (!empty($_POST['tickets_reply_form_text'])) {
                                $ticket->Reply(nl2br($_POST['tickets_reply_form_text']));
                                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('reply_sent').'", type: "success"');
                            }
                        }

                        if (isset($_POST['tickets_close'])) {
                            $ticket->Close();
                            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('ticket_closed').'", type: "success"');
                        }

                        if (0 == $ticket->GetValue('seen_admin') && $ticket->GetValue('steamid64') != $auth_user->GetValue('steamid64')) {
                            $ticket->SetValue('seen_admin', 1);
                        } elseif (0 == $ticket->GetValue('seen_user') && $ticket->GetValue('steamid64') == $auth_user->GetValue('steamid64')) {
                            $ticket->SetValue('seen_user', 1);
                        }

                        $status = '<span class="label label-success">'.Lang('open').'</span>';

                        if (1 == $ticket->GetValue('status')) {
                            $status = '<span class="label label-danger">'.Lang('closed').'</span>';
                        }

                        $nick_admin = '-';
                        $admin = new User($ticket->GetValue('steamid64_admin'));

                        if ($admin->valid) {
                            $nick_admin = '<a target="_blank" href="index.php?t=user&id='.$admin->GetValue('steamid64').'">'.$admin->GetValue('nick').'</a>';
                        }

                        $nick_user = '<a target="_blank" href="index.php?t=user&id='.$creator->GetValue('steamid64').'">'.$creator->GetValue('nick').'</a>';
                    }
                } else {
                    PermissionsError();
                    $ticket = null;
                }
            } else {
                $ticket = null;
            }
        }
    } else {
        if (isset($_POST['tickets_ticket_create_modal_submit'])) {
            if (!empty($_POST['tickets_ticket_create_modal_subject']) && !empty($_POST['tickets_ticket_create_modal_text']) && !empty($_POST['tickets_ticket_create_modal_category'])) {
                $id = Ticket::Create($_POST['tickets_ticket_create_modal_subject'], nl2br($_POST['tickets_ticket_create_modal_text']), $_POST['tickets_ticket_create_modal_category']);
                DirectNotifications::Queue('title: "'.Lang('success').'", text: "'.Lang('ticket_created').'", type: "success"');
                Redirect('index.php?t=tickets&id='.$id);
            }
        }
    }
?>

<!-- Summernote CSS -->
<link rel="stylesheet" href="assets/css/summernote.css" />

<!-- Summernote JS-->
<script src="assets/js/summernote.min.js"></script>

<?php if (null == $ticket) {
    ?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('tickets'); ?>

			<span class="pull-right">
				<button onclick="tickets_ticket_create();" class="btn btn-success"><i class="fa fa-plus-circle"></i> <?php echo Lang('create'); ?></button>
			</span>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
	    <div class="table-responsive">
    		<table class="table">
    			<tr class="active">
    				<th style="width:0%;">#</th>
    				<th><?php echo Lang('creator'); ?></th>
    				<th><?php echo Lang('subject'); ?></th>
    				<th><?php echo Lang('admin'); ?></th>
    				<th><?php echo Lang('category'); ?></th>
    				<th><?php echo Lang('created'); ?></th>
    				<th><?php echo Lang('updated'); ?></th>
    				<th class="text-right"><?php echo Lang('status'); ?></th>
    			</tr>
    
    			<tbody>
    				<?php
                        $page = 1;

    if (isset($_GET['page'])) {
        $page = $_GET['page'];
    }

    $tickets = Ticket::GetUserTickets(25, $page);

    foreach ($tickets as $ticket) {
        $creator = new User($ticket->GetValue('steamid64'));

        if ($creator->valid) {
            $status = '<span class="label label-success">'.Lang('open').'</span>';

            if (1 == $ticket->GetValue('status')) {
                $status = '<span class="label label-danger">'.Lang('closed').'</span>';
            }

            $nick_admin = '-';
            $admin = new User($ticket->GetValue('steamid64_admin'));

            if ($admin->valid) {
                $nick_admin = '<a target="_blank" href="index.php?t=user&id='.$admin->GetValue('steamid64').'">'.$admin->GetValue('nick').'</a>';
            }

            $class = '';

            if ((0 == $ticket->GetValue('seen_admin') && $ticket->GetValue('steamid64') != $auth_user->GetValue('steamid64')) || (0 == $ticket->GetValue('seen_user') && $ticket->GetValue('steamid64') == $auth_user->GetValue('steamid64'))) {
                $class = 'class="success"';
            }

            echo '<tr '.$class.'>';
            echo '<td>';
            echo $ticket->GetValue('id');
            echo '</td>';

            echo '<td>';
            echo '<a target="_blank" href="index.php?t=user&id='.$creator->GetValue('steamid64').'">'.$creator->GetValue('nick').'</a>';
            echo '</td>';

            echo '<td>';
            echo '<a target="_blank" href="index.php?t=tickets&id='.$ticket->GetValue('id').'">'.$ticket->GetValue('subject').'</a>';
            echo '</td>';

            echo '<td>';
            echo $nick_admin;
            echo '</td>';

            echo '<td>';
            echo ''.(!empty($ticket->GetValue('category')) ? $ticket->GetValue('category') : '<i class="text-muted">'.Lang('unknown').'</i>');
            echo '</td>';

            echo '<td>';
            echo FormatDate($ticket->GetValue('created'));
            echo '</td>';

            echo '<td>';
            echo FormatDate($ticket->GetValue('updated'));
            echo '</td>';

            echo '<td class="text-right">';
            echo $status;
            echo '</td>';
            echo '</tr>';
        }
    } ?>
    			</tbody>
    		</table>
    	</div>

		<ul class="pager">
			<?php if ($page > 1) {
        ?>
				<li class="previous"><a href="index.php?t=tickets&page=<?php echo $page - 1; ?>"><span aria-hidden="true">&larr;</span> <?php echo Lang('previous'); ?></a></li>
			<?php
    } ?>

			<?php if (25 == sizeof($tickets)) {
        ?>
				<li class="next"><a href="index.php?t=tickets&page=<?php echo $page + 1; ?>"><?php echo Lang('next'); ?> <span aria-hidden="true">&rarr;</span></a></li>
			<?php
    } ?>
		</ul>
	</div>
</div>

<!-- Create Modal -->
<div class="modal fade" id="tickets_ticket_create_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-ticket"></i> &nbsp; <?php echo Lang('ticket_create'); ?></h4>
			</div>

			<form method="POST" action="index.php?t=tickets">
				<div class="modal-body">
					<?php
                        if (!tempty(Settings::Get('settings_tickets_instructions'))) {
                            echo '<label>'.Lang('instructions').'</label><br/>'.Settings::Get('settings_tickets_instructions').'<br><br>';
                        } ?>

					<label><?php echo Lang('category'); ?></label><br>
		            <select name="tickets_ticket_create_modal_category" type="text" class="form-control">
		            	<?php
                            foreach (Ticket::GetCategories() as $category) {
                                echo '<option>'.$category['name'].'</option>';
                            } ?>
		            </select>
		            <br>

		            <label><?php echo Lang('subject'); ?></label><br>
		            <input name="tickets_ticket_create_modal_subject" type="text" class="form-control" placeholder="<?php echo Lang('description_short'); ?>">
		            <br>

                    <label><?php echo Lang('text'); ?></label><br>
					<textarea name="tickets_ticket_create_modal_text" placeholder="<?php echo Lang('problem_request_describe'); ?>"></textarea>
				</div>
				<div class="modal-footer">
					<button onclick="$(this).click(function(event){event.preventDefault();}); setTimeout(function(){ location.reload(); }, 6000);" type="submit" name="tickets_ticket_create_modal_submit" class="btn btn-success"><?php echo Lang('create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
	$('textarea[name="tickets_ticket_create_modal_text"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_reduced
	});

	function tickets_ticket_create(){
		$('#tickets_ticket_create_modal').modal('show');
	}
</script>

<?php
} else {
                                ?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<a href="index.php?t=tickets"><i class="fa fa-long-arrow-left"></i></a> <?php echo Lang('ticket').': '.$ticket->GetValue('subject'); ?>
            <span class="pull-right">
		    	<?php
                    if (0 == $ticket->GetValue('status')) {
                        echo '<button onclick="post(\'index.php?t=tickets&id='.$ticket->GetValue('id').'\', {tickets_close:true});" class="btn btn-warning"><i class="fa fa-power-off"></i> '.Lang('close').'</button> ';
                    }

                                if (Permissions::HasPermission('tickets_admin') && Permissions::HasPermission('tickets_delete')) {
                                    echo '<button onclick="ticket_delete('.$ticket->GetValue('id').');" class="btn btn-danger"><i class="fa fa-trash"></i> '.Lang('delete').'</button>';
                                } ?>
            </span>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
	    <div class="table-responsive">
    		<table class="table">
    			<tr class="active">
    				<th style="width:0%;">#</th>
    				<th><?php echo Lang('creator'); ?></th>
    				<th><?php echo Lang('admin'); ?></th>
    				<th><?php echo Lang('category'); ?></th>
    				<th><?php echo Lang('created'); ?></th>
    				<th><?php echo Lang('updated'); ?></th>
    				<th class="text-right"><?php echo Lang('status'); ?></th>
    			</tr>
    
    			<tbody>
    				<tr>
    					<td><?php echo $ticket->GetValue('id'); ?></td>
    					<td><?php echo $nick_user; ?></td>
    					<td><?php echo $nick_admin; ?></td>
    					<td><?php echo $ticket->GetValue('category'); ?></td>
    					<td><?php echo FormatDate($ticket->GetValue('created')); ?></td>
    					<td><?php echo FormatDate($ticket->GetValue('updated')); ?></td>
    					<td class="text-right"><?php echo $status; ?></td>
    				</tr>
    			</tbody>
    		</table>
	    </div>
	</div>
</div>

<hr>

<?php
    foreach ($ticket->GetValue('conversation') as $message) {
        $author = new User($message['steamid64']);

        if ($author->valid) {
            $img = '<div class="col-xs-1"><a target="_blank" href="index.php?t=user&id='.$author->GetValue('steamid64').'"><img style="border-radius: 4px;" class="img-responsive" src="'.$author->GetValue('avatar_medium').'" /></a></div>';

            echo '<div class="row">';

            $offset = 'col-xs-offset-1';

            $left = '<p><i class="fa fa-comment fa-lg"></i></p><p><span class="clickable" onclick="console.log(1);OpenInNewTab(\'index.php?t=user&id='.$author->GetValue('steamid64').'\');"><b style="color: '.$author->GetGroup(0)->GetValue('hexcolor').';">'.$author->GetValue('nick').'</b></span></p>';
            $right = TimeElapsed($message['date']).' &nbsp;<i class="fa fa-clock-o"></i>';

            if ($message['steamid64'] == $ticket->GetValue('steamid64')) {
                echo $img;
                $offset = '';
            } else {
                $right = '<p><span class="clickable" onclick="console.log(1);OpenInNewTab(\'index.php?t=user&id='.$author->GetValue('steamid64').'\');"><b style="color: '.$author->GetGroup(0)->GetValue('hexcolor').';">'.$author->GetValue('nick').'</b></span></p><p><i class="fa fa-comment fa-lg fa-flip-horizontal"></i></p>';
                $left = '<i style="border-right-style: none;" class="fa fa-clock-o"></i> &nbsp;'.TimeElapsed($message['date']);
            }

            echo '
				<div class="col-xs-10 '.$offset.'">
					<div class="box">
					    <div class="box-header">
					        <div class="box-title pull-left">
					          	'.$left.'
					        </div>

					        <div class="box-title pull-right">
								 '.$right.'
							</div>
						</div>

					  	<div class="box-content">
							'.ValidateHTML($message['text'], array(), true).'
					  	</div>
					</div>
				</div>
			';

            if ($message['steamid64'] != $ticket->GetValue('steamid64')) {
                echo $img;
            }

            echo '</div>';
        }
    } ?>

<hr>

<div class="row">
	<div class="col-xs-12">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
		          	<p><i class="fa fa-commenting fa-lg"></i></p>
					<p><b><?php echo Lang('reply'); ?></b></p>
		        </div>

		        <div class="box-title pull-right">
					 <i style="color: #337AB7;" class="clickable fa fa-share" onclick="$('#tickets_reply_form').submit();"></i>
				</div>
			</div>

		  	<div class="box-content">
				<form id="tickets_reply_form" method="post" action="index.php?t=tickets&id=<?php echo $ticket->GetValue('id'); ?>">
					<textarea name="tickets_reply_form_text" placeholder="<?php echo Lang('your_answer'); ?>"></textarea>
				</form>
		  	</div>
		</div>
	</div>
</div>

<script>
	$('textarea[name="tickets_reply_form_text"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_reduced
	});

	function ticket_delete(ticketid){
        var text = '<?php echo Lang('are_you_sure'); ?>';

        (new PNotify({
            title: '<?php echo Lang('confirmation'); ?>',
            text: text,
            type: "error",
            hide: false,
            icon: '',
            confirm: {
                confirm: true
            },
            buttons: {
                closer: false,
                sticker: false
            },
            history: {
                history: false
            }
            })).get().on('pnotify.confirm', function() {
                post('index.php?t=tickets&id=' + ticketid, {tickets_delete:true});
        });
	}
</script>


<?php
                            } ?>