<!--{"language":"user","icon":"fa-user","place":"none","position":0,"nologin":true}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>
<?php
    $profiles_user = null;

    if (isset($_GET['id'])) {
        $profiles_user = new User($_GET['id']);

        if (!$profiles_user->valid) {
            $profiles_user = null;
        } else {
            $profiles_user->RefreshSteamData();
        }
    }

    if (!$profiles_user) {
        DirectNotifications::Queue('title: "'.Lang('error').'", text: "'.Lang('user_not_found').'", type: "error"');
        Redirect('index.php');
        die();
    }

    if (!DemoLock()) {
        if (isset($_POST['user_modal_edit_form_submit'])) {
            if (Permissions::HasPermission('user_edit')) {
                if (($auth_user->GetGroup()->GetValue('level') >= $profiles_user->GetGroup()->GetValue('level')) || Permissions::HasPermission('super')) {
                    $error = false;

                    if (isset($_POST['user_modal_edit_form_email'])) {
                        if (!$profiles_user->SetValue('email', htmlspecialchars($_POST['user_modal_edit_form_email']))) {
                            $error = true;
                        }
                    }

                    if (isset($_POST['user_modal_edit_form_ts3uid'])) {
                        if (!tempty($profiles_user->GetValue('ts3uid'))) {
                            if ($profiles_user->GetValue('ts3uid') != $_POST['user_modal_edit_form_ts3uid']) {
                                $profiles_user->RemoveTs3Servergroups();
                            }
                        }

                        if (!$profiles_user->SetValue('ts3uid', htmlspecialchars($_POST['user_modal_edit_form_ts3uid']))) {
                            $error = true;
                        }

                        if (!tempty($profiles_user->GetValue('ts3uid'))) {
                            $profiles_user->AddTs3Servergroups();
                        }
                    }

                    if (isset($_POST['user_modal_edit_form_discord_username'])) {
                        $username = $_POST['user_modal_edit_form_discord_username'];
                        $username_exp = explode('#', $username);

                        if ($username != $profiles_user->GetValue('discord_username')) {
                            if (!empty($username) && (2 != sizeof($username_exp) || !is_numeric($username_exp[1]))) {
                                $error = true;
                            } else {
                                $update_result = $profiles_user->UpdateDiscordUsername($username);
                                if (true !== $update_result) {
                                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "Discord error:<br/>'.$update_result.'", type: "error"');
                                    $error = true;
                                }
                            }
                        }
                    }

                    foreach ($_POST as $key => $val) {
                        if (StartsWith($key, 'user_modal_edit_form_groups_')) {
                            $bundleid = substr($key, 28);

                            if (is_numeric($bundleid)) {
                                $newgroup = new Group($val);

                                if ($newgroup->valid) {
                                    if (($auth_user->GetGroup($bundleid)->GetValue('level') >= $newgroup->GetValue('level')) || Permissions::HasPermission('super')) {
                                        $profiles_user->SetGroup($val, $bundleid);
                                    } else {
                                        $error = true;
                                    }
                                } else {
                                    $error = true;
                                }
                            } else {
                                $error = true;
                            }
                        }
                    }

                    if (!$error) {
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                    }
                } else {
                    PermissionsError();
                }
            }
        } elseif (isset($_POST['user_package_add_modal_submit'])) {
            if (Permissions::HasPermission('user_packages')) {
                $package = $_POST['user_package_add_modal_package'];
                $days = $_POST['user_package_add_modal_days'];

                if (is_numeric($package) && (is_numeric($days) || '' == trim($days))) {
                    $package = new Package($package);

                    if ($package->valid) {
                        if ('' == trim($days)) {
                            $package->ActivateFor($profiles_user, 0);
                        } else {
                            $package->ActivateFor($profiles_user, 0, $days);
                        }

                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('package_assigned_success').'", type: "success"');
                    }
                }
            }
        } elseif (isset($_POST['user_ts3_channel_create_modal_submit'])) {
            if (Permissions::HasPermission('user_packages')) {
                $name = $_POST['user_ts3_channel_create_modal_name'];
                $parent = $_POST['user_ts3_channel_create_modal_parent'];
                $channelgroup = $_POST['user_ts3_channel_create_modal_channelgroup'];
                $days = $_POST['user_ts3_channel_create_modal_days'];

                if (tempty($name)) {
                    $name = $profiles_user->GetValue('nick')."'s Channel";
                }

                $insert_template = array(
                    'steamid64' => $profiles_user->GetValue('steamid64'),
                    'donationid' => -1,
                    'package' => -1,
                    'package_bought' => -1,
                    'status' => 0,
                    'expires' => ($days > 0 ? date('Y-m-d H:i:s', strtotime('+'.$days.' days')) : '2037-01-01 00:00:00'),
                    'serverbundle' => 0,
                    'once' => 0,
                    'one_from_all' => 0,
                    'executed_on' => '',
                    'on_expire' => 0,
                    'on_spawn' => 0,
                    'on_connect' => 0,
                );

                $data = $insert_template;

                $data['type'] = 'ts3_channel';
                $data['value'] = ToJson(array('name' => $name, 'parentchannel' => $parent, 'channelgroup' => $channelgroup, 'id' => -1, 'delete' => ($days > 0)));

                if (Rewards::Create($data)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('channel_created_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
                }
            }
        }
    }
?>

<!-- ImageFrame CSS-->
<link rel="stylesheet" href="assets/css/image-frame.css" />

<!-- ZingChart JS-->
<script src="assets/js/zingchart.min.js"></script>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header">
			<?php echo Lang('profile'); ?>: <?php echo $profiles_user->GetValue('nick'); ?>
			<span class="pull-right hidden-xs" id="user_header_buttons">
				<?php
                    if (Permissions::HasPermission('user_ips', $auth_user)) {
                        echo ' <button onclick="user_ips_open()" class="btn btn-info"><i class="fa fa-eye"></i></button>';
                    }

                    if (Permissions::HasPermission('user_packages', $auth_user)) {
                        echo ' <button onclick="user_ts3_channel_create_open()" class="btn btn-success"><i class="fa fa-microphone"></i></button>';
                    }
                ?>
				<div class="btn-group" id="user_button_steam_btngroup">
					<button id="user_button_steam" onclick="OpenInNewTab('http://steamcommunity.com/profiles/<?php echo $profiles_user->GetValue('steamid64'); ?>');" type="button" class="btn btn-default"><i class="fa fa-steam fa-lg"></i></button>
					<button id="user_button_steam_ddbtn" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
						<span class="fa fa-angle-down">
					</button>
					<ul class="dropdown-menu" role="menu">
						<li><a href="steam://friends/add/<?php echo $profiles_user->GetValue('steamid64'); ?>"><i class="fa fa-plus-circle"></i> <?php echo Lang('friend'); ?></a></li>
					</ul>
				</div>
			</span>
		</h1>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
		         	<p><i class="fa fa-user fa-lg"></i></p>
		          	<p><b><?php echo $profiles_user->GetValue('nick'); ?></b></p>
		        </div>

		        <div class="box-icon pull-right">
		        	<?php
                        if (Permissions::HasPermission('user_edit', $auth_user)) {
                            echo '<a href="#" data-toggle="modal" data-target="#user_modal_edit"><i class="fa fa-pencil fa-lg"></i></a>';
                        }
                    ?>
		        </div>
			</div>
			<div class="box-content" id="user_general">
				<div class="row">
					<div class="col-sm-4">
						<span class="table-label label label-primary"><?php echo Lang('general'); ?> </span><br>
						<table class="table table-responsive">
							<tbody>
								<tr>
									<td><i class="fa fa-user"></i></td>
									<td><?php echo  Lang('nickname'); ?></td>
									<td style="width: 50%;"><?php echo $profiles_user->GetValue('nick'); ?></td>
								</tr>
								<tr>
									<td><i class="fa fa-steam"></i></td>
									<td>SteamID64</td>
									<td><?php echo $profiles_user->GetValue('steamid64'); ?></td>
								</tr>
								<tr>
									<td><i class="fa fa-steam"></i></td>
									<td>SteamID32</td>
									<td><?php echo $profiles_user->GetValue('steamid32'); ?></td>
								</tr>
								<tr>
									<td><i class="fa fa-exclamation-triangle"></i></td>
									<td><?php echo Lang('warnings'); ?></td>
									<td>
										<?php
                                            if (Permissions::HasPagePermission('admin_bans')) {
                                                echo '<a href="index.php?t=admin_warnings&id='.$profiles_user->GetValue('steamid64').'" target="_blank">'.sizeof(Warnings::GetByUser($profiles_user->GetValue('steamid64'))).'</a>';
                                            } else {
                                                echo '-';
                                            }
                                        ?>
									</td>
								</tr>
								<tr>
									<td><i class="fa fa-ban"></i></td>
									<td><?php echo Lang('bans'); ?></td>
									<td>
										<?php
                                            if (Permissions::HasPagePermission('admin_bans')) {
                                                echo '<a href="index.php?t=admin_bans&id='.$profiles_user->GetValue('steamid64').'" target="_blank">'.sizeof(Bans::GetByUser($profiles_user->GetValue('steamid64'))).'</a>';
                                            } else {
                                                echo '-';
                                            }
                                        ?>
									</td>
								</tr>
							</tbody>
						</table>
					</div>

					<div class="col-sm-4">
						<div class="profile-header-container">
				    		<div class="profile-header-img">
				                <img style="border-color: <?php echo $profiles_user->GetGroup()->GetValue('hexcolor'); ?>;" class="img-circle" src="<?php echo $profiles_user->GetValue('avatar_large'); ?>" />
				                <!-- badge -->
				                <div class="rank-label-container">
				                    <span style="background-color: <?php echo $profiles_user->GetGroup()->GetValue('hexcolor'); ?>;" class="label label-default rank-label"><font size="2.5"><?php echo $profiles_user->GetGroup()->GetValue('displayname'); ?></font></span>
				                </div>
				            </div>
				        </div>
					</div>

					<div class="col-sm-4">
						<br style="margin-bottom:16px;"/>
						<span class="table-label label label-primary"><?php echo  Lang('activity'); ?></span><br>
						<table class="table table-responsive table-user-information">
							<tbody>
								<tr>
									<td><i class="fa fa-sign-in"></i></td>
									<td><?php echo  Lang('registered'); ?></td>
									<td><?php echo FormatDate($profiles_user->GetValue('date_registered')); ?></td>
								</tr>
								<tr>
								<td><i class="fa fa-globe"></i></td>
									<td>Web</td>
									<td><?php echo FormatDate($profiles_user->GetValue('date_lastonline_web')); ?></td>
								</tr>
								<tr>
									<td><i class="fa fa-gamepad"></i></td>
									<td>Garry's Mod</td>
									<td style="width: 50%;"><?php echo FormatDate($profiles_user->GetValue('date_lastonline_gmod')); ?></td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-sm-6">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
					<p><i class="fa fa-users fa-lg"></i></p>
		        	<p><b><?php echo Lang('groups'); ?></b></p>
		        </div>
			</div>

		  	<div class="box-content" id="user_groups">
		  		<ul class="list-group" >
		  			<li class="list-group-item" style="border-radius: 0px;">
						<i class="fa fa-globe"></i> Web
						<?php
                            $group = $profiles_user->GetGroup();
                            echo '<span style="background-color: '.$group->GetValue('hexcolor').'" class="badge">'.$group->GetValue('displayname').'</span>';
                        ?>
					</li>

			  		<?php
                        foreach (Serverbundle::GetAll() as $bundle) {
                            $group = $profiles_user->GetGroup($bundle->GetValue('id'));
                            echo '
								<li class="list-group-item" style="border-radius: 0px;">
									<i class="fa fa-server"></i> '.$bundle->GetValue('name').'
									<span style="background-color: '.$group->GetValue('hexcolor').'" class="badge">'.$group->GetValue('displayname').'</span>
								</li>
							';
                        }

                    ?>
		  		</ul>
		  	</div>
		</div>
	</div>

	<div class="col-sm-6">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
					<p><i class="fa fa-archive fa-lg"></i></p>
		        	<p><b><?php echo Lang('packages'); ?></b></p>
		        </div>

		        <div class="box-icon pull-right">
	        		<?php echo Permissions::HasPermission('user_packages') ? '<a href="#" onclick="user_package_add()"><i class="fa fa-plus fa-lg"></i></a>' : ''; ?>
		        </div>
			</div>

		  	<div class="box-content" id="user_donations">
		  		<ul class="list-group" >
			  		<?php
                        Package::GeneratePackageListForUser($profiles_user);
                    ?>
		  		</ul>
		  	</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">
		<div class="box">
		    <div class="box-header">
		        <div class="box-title pull-left">
		          	<p><i class="fa fa-line-chart fa-lg"></i></p>
					<p><b><?php echo Lang('statistics'); ?></b></p>
		        </div>
			</div>

		  	<div class="box-content" id="user_statistics">
				<ul class="nav nav-tabs" role="tablist">
					<?php
                        $count = 0;
                        foreach (Serverbundle::GetAll() as $bundle) {
                            $statistics = $profiles_user->statistics->GetTimeStatistics($bundle);

                            if (!empty($statistics)) {
                                if (!$count) {
                                    echo '<li class="active">';
                                } else {
                                    echo '<li>';
                                }

                                $totaltime = array_sum(array_map(function ($item) {
                                    return $item[1];
                                }, $statistics));

                                echo '<a href="#stats_server'.$bundle->GetValue('id').'" role="tab" data-toggle="tab">'.$bundle->GetValue('name').' ('.$totaltime.' '.Lang('hours_short').')</a></li>';

                                ++$count;
                            }
                        }
                    ?>
			  	</ul>
				<div class="tab-content">
					<?php
                        $count = 0;
                        foreach (Serverbundle::GetAll() as $bundle) {
                            $statistics = $profiles_user->statistics->GetTimeStatistics($bundle);

                            if (!empty($statistics)) {
                                if (!$count) {
                                    echo '<div role="tabpanel" class="tab-pane active" id="stats_server'.$bundle->GetValue('id').'">';
                                } else {
                                    echo '<div style="position:relative;" role="tabpanel" class="tab-pane" id="stats_server'.$bundle->GetValue('id').'">';
                                }

                                echo '<div style="height: 220px; !important;" id="chart_stats_server_'.$bundle->GetValue('id').'">';
                                echo '</div>';
                                echo '</div>';

                                echo '  <script>
									var statdata = JSON.parse(\''.json_encode($statistics).'\');
									var subtitle = "";

									if(statdata.length == 0){
										subtitle = "<i>'.Lang('no_data_available').'</i>";
									}else{
										subtitle = "'.Lang('total_alltime').': '.$profiles_user->statistics->GetTotalTime($bundle).' '.Lang('hours').'";
									}

									var user_chart_onlinetime_data = {
							            "graphset": [
							                {
							                    "type": "area",
							                    "plotarea": {
							                		"adjust-layout":true
							                    },
							                    "gui": {
													"watermark": {
											        	"position": "tr" //br (default), bl, tr, tl
													},
													"behaviors":[
											            {
											                "id":"DownloadPDF",
											                "enabled":"none"
											            },
											            {
											                "id":"DownloadPNG",
											                "enabled":"none"
											            },
											            {
											                "id":"DownloadSVG",
											                "enabled":"none"
											            },
											            {
											                "id":"About",
											                "enabled":"none"
											            },
											            {
											                "id":"Print",
											                "enabled":"none"
											            },
											            {
											                "id":"SaveAsImage",
											                "enabled":"none"
											            },
											            {
											                "id":"ViewSource",
											                "enabled":"none"
											            },
											            {
											                "id":"ExportData",
											                "enabled":"none"
											            },
											            {
											                "id":"GuideHide",
											                "enabled":"none"
											            },
											            {
											                "id":"GuideShow",
											                "enabled":"none"
											            },
											            {
											                "id":"ZoomIn",
											                "enabled":"none"
											            },
											            {
											                "id":"ZoomOut",
											                "enabled":"none"
											            },
											            {
											                "id":"CrosshairHide",
											                "enabled":"none"
											            }
											        ]
												},
							                    "tooltip":{
							                        "visible":false
							                    },
							                    "crosshair-x":{
							                        "plot-label":{
							                            "text":"%v '.Lang('hours').'"
							                        }
							                    },
							                    "backgroundColor":"none",
							                    "scale-y":{
							                    	//"values":"0:24"
							                    },
							                    "scale-x":{
							                    	"offset": 15,
							                        "max-items":5,
							                        "zooming":true,
							                        "max-ticks":5,
							                        "guide": {
							                        	"visible": true
							                        },
							                        "transform":{
							                            "item":{
							                                "visible":false
							                            },
							                            "type":"date",
							                            "all": "'.Settings::Get('settings_general_timeformat_charts').'"
							                        }
							                    },
							                    "series":[
								                    {
								                      "values":statdata
								                    }
								                ]
								            }
								        ]
								    };

							        zingchart.render({
							    		hideprogresslogo: true,
							            id: "chart_stats_server_'.$bundle->GetValue('id').'",
							            data: user_chart_onlinetime_data,
							            height: "100%",
							            width: "100%",
							        });
							   </script>';

                                ++$count;
                            }
                        }
                    ?>
				</div>
		  	</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-xs-12 visible-xs" id="user_buttons_xs">

	</div>
</div>

<!-- Profile Settings Modal -->
<div class="modal fade" id="user_modal_edit" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-cogs"></i> &nbsp;<?php echo Lang('settings_profile'); ?></h4>
			</div>
			<form method="post" action="index.php?t=user&id=<?php echo $profiles_user->GetValue('steamid64'); ?>">
				<div class="modal-body">
					<label><?php echo Lang('email'); ?></label><br>
		            <input type="text" name="user_modal_edit_form_email" class="form-control" />
		            <br>
		            
		            <!-- TS3 UID -->
					<?php if (!tempty(Settings::Get('settings_teamspeak_query_password'))) {
                        ?>
		            <label><?php echo Lang('ts3uid'); ?></label><br>
		            <input type="text" class="form-control" name="user_modal_edit_form_ts3uid" />
		            <br />
		            <?php
                    } ?>
            
		            <!-- Discord Username -->
					<?php if (!tempty(Settings::Get('settings_discord_bot_token'))) {
                        ?>
		            <label><?php echo Lang('discord_username_with_id'); ?></label><br>
		            <input type="text" class="form-control" name="user_modal_edit_form_discord_username" placeholder="username#1234" />
		            <br>
		            <?php
                    } ?>
                    
		            
		            <label><?php echo Lang('groups'); ?></label><br>
		            <table class="table table-responsive table-hover">
					    <tr>
					        <th><?php echo Lang('serverbundle'); ?></th>
					        <th style="width: 60%;"><?php echo Lang('group'); ?></th>
					    </tr>

						<tbody>
							<?php
                                foreach (Serverbundle::GetAll(true) as $bundle) {
                                    echo '<tr>';
                                    echo '<td>';
                                    echo $bundle->GetValue('name');
                                    echo '</td>';
                                    echo '<td>';
                                    echo '
												<select class="form-control" name="user_modal_edit_form_groups_'.$bundle->GetValue('id').'">';
                                    foreach (array_reverse(Group::GetAll()) as $group) {
                                        echo '<option style="color: '.$group->GetValue('hexcolor').';">'.$group->GetValue('groupname').'</option>';
                                    }

                                    echo '</select>';
                                    echo '</td>';
                                    echo '</tr>';
                                }
                            ?>

						</tbody>
					</table>
				</div>
				<div class="modal-footer">
					<button type="submit" name="user_modal_edit_form_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Assing Package Modal -->
<div class="modal fade" id="user_package_add_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-archive"></i> &nbsp;<?php echo Lang('package_assign'); ?></h4>
			</div>

			<form method="post" action="index.php?t=user&id=<?php echo $profiles_user->GetValue('steamid64'); ?>">
				<div class="modal-body">
					<label><?php echo Lang('package'); ?></label><br>
					<select class="form-control" name="user_package_add_modal_package">
						<?php
                            foreach (Package::GetAll() as $package) {
                                $bundle = $package->GetServerbundle();

                                if ($bundle->valid) {
                                    echo '<option value="'.$package->GetValue('id').'">'.$package->GetValue('title').' ('.$bundle->GetValue('name').')</option>';
                                }
                            }
                        ?>
					</select>

					<br/>

					<label>(<?php echo Lang('days'); ?>)</label><br>
		            <input type="text" name="user_package_add_modal_days" class="form-control" />
				</div>

				<div class="modal-footer">
					<button type="submit" name="user_package_add_modal_submit" class="btn btn-success"><?php echo Lang('assign'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Assing ts3 channel Modal -->
<div class="modal fade" id="user_ts3_channel_create_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-microphone"></i> &nbsp;<?php echo Lang('ts3_channel_create'); ?></h4>
			</div>

			<form method="post" action="index.php?t=user&id=<?php echo $profiles_user->GetValue('steamid64'); ?>">
				<div class="modal-body">
					<label><?php echo Lang('channel_name'); ?></label><br>
		            <input type="text" name="user_ts3_channel_create_modal_name" class="form-control" placeholder="(<?php echo Lang('optional'); ?>)"/><br>

		            <label><?php echo Lang('ts3_channel_parent_id'); ?></label><br>
		            <input type="text" name="user_ts3_channel_create_modal_parent" class="form-control" placeholder="123"/><br>

		            <label><?php echo Lang('ts3_channelgroup'); ?></label><br>
		            <input type="text" name="user_ts3_channel_create_modal_channelgroup" class="form-control" placeholder="Channel Admin" /><br>

					<label><?php echo Lang('package_days'); ?></label><br>
		            <input type="text" name="user_ts3_channel_create_modal_days" value="0" class="form-control" />
				</div>

				<div class="modal-footer">
					<button type="submit" name="user_ts3_channel_create_modal_submit" class="btn btn-success"><?php echo Lang('create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- IP Modal -->
<div class="modal fade" id="user_ips_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-eye"></i> &nbsp;<?php echo Lang('ipaddresses'); ?></h4>
			</div>

			<div class="modal-body">
				<ul class="list-group">
					<?php
                        if (Permissions::HasPermission('user_ips')) {
                            if (!DemoLock()) {
                                $first = true;
                                foreach (array_reverse($profiles_user->GetValue('ips')) as $ip) {
                                    if ($first) {
                                        $first = false;
                                        echo '<li class="list-group-item"><span class="badge" style="background-color:#5cb85c;">'.Lang('latest').'</span>'.$ip.'</li>';
                                    } else {
                                        echo '<li class="list-group-item">'.$ip.'</li>';
                                    }
                                }
                            } else {
                                echo '<li class="list-group-item"><span class="badge" style="background-color:#5cb85c;">'.Lang('latest').'</span>123.46.78.121</li>';
                                echo '<li class="list-group-item">45.889.221.3</li>';
                            }
                        }
                    ?>
				</ul>
			</div>
		</div>
	</div>
</div>

<script>
	<?php
        if (Permissions::HasPermission('user_edit')) {
            echo '$(\'select[name="user_modal_edit_form_groups_0"]\').val(\''.$profiles_user->GetGroup(0)->GetValue('groupname').'\');';

            foreach (Serverbundle::GetAll() as $bundle) {
                echo '$(\'select[name="user_modal_edit_form_groups_'.$bundle->GetValue('id').'"]\').val(\''.$profiles_user->GetGroup($bundle->GetValue('id'))->GetValue('groupname').'\');';
            } ?>
		$('input[name="user_modal_edit_form_email"]').val("<?php echo OneLine($profiles_user->GetValue('email')); ?>");
		$('input[name="user_modal_edit_form_ts3uid"]').val("<?php echo OneLine($profiles_user->GetValue('ts3uid')); ?>");
		$('input[name="user_modal_edit_form_discord_username"]').val("<?php echo OneLine($profiles_user->GetValue('discord_username')); ?>");
	<?php
        }
    ?>

	$("input[name='user_package_add_modal_days']").TouchSpin({
        min: 0,
        max: 8000,
        step: 10,
        forcestepdivisibility: 'none',
        verticalbuttons: true
    });

    $("input[name='user_ts3_channel_create_modal_days']").TouchSpin({
        min: 0,
        max: 1000000,
        step: 10,
        forcestepdivisibility: 'none',
        verticalbuttons: true
    });

	function user_ips_open(){
		$('#user_ips_modal').modal('show');
	}

	function user_ts3_channel_create_open(){
		$('#user_ts3_channel_create_modal').modal('show');
	}

	function user_adjustsize(){
		if($('#user_groups, #user_donations').length){
			if($( document ).width() > 768){
				$('#user_groups, #user_donations').height($('#user_general').height());
			}else{
				if($('#user_buttons_xs').html().trim() == ''){
					$('#user_buttons_xs').html($('#user_header_buttons').html());
				}
			}
		}
	}

	function user_package_add(){
		$('#user_package_add_modal').modal('show');
	}

	user_adjustsize();

	$( window ).resize(function() {
		user_adjustsize();
	});
</script>