<!--{"language":"violations","icon":"fa-exclamation-circle","place":"user","position":10}-->
<?php
    if (!isset($G_MAIN)) {
        die(json_encode(array("error" => "authentification failed")));
    }
?>

<?php
    if (ValidateBool(Settings::Get("settings_bans_protests_enabled"))) {
        if (isset($_POST['bans_modal_protest_banid']) && isset($_POST['bans_modal_protest_protesttext'])) {
            if (is_numeric($_POST['bans_modal_protest_banid']) && !empty($_POST['bans_modal_protest_protesttext'])) {
                if (Banprotest::Create($_POST['bans_modal_protest_banid'], $_POST['bans_modal_protest_protesttext'])) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('banprotest_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('banprotest_fail').'", type: "error"');
                }
            }
        }
    }
?>

<div class="row">
	<div class="col-md-12">
		<h1 class="page-header"><?php echo Lang('bans'); ?></h1>
	</div>
</div>

<?php
    $makerow = true;
    $count = 0;

    $userbans = $auth_user->GetBans();

    $ids = array();

    foreach ($userbans as $ban) {
        $count++;

        $ids[] = $ban['id'];

        $admin = new User($ban['steamid64_admin']);
        $admin_unbanned = new User($ban['steamid64_admin_unbanned']);
        $admin_unbanned_name = "N/A";
        $serverbundle = '?';

        $bundle = new Serverbundle($ban['serverbundle']);

        $expires = new DateTime($ban['date_banned']);
        $expires->add(new DateInterval('PT' . $ban['length'] . 'M'));

        $now = new DateTime('now');

        if ($admin_unbanned->valid) {
            $admin_unbanned_name = $admin_unbanned->GetValue('nick');
        }

        if ($ban['global']) {
            $serverbundle = Lang('global');
        } else {
            if ($bundle->valid) {
                $serverbundle = $bundle->GetValue('name');
            } else {
                $serverbundle = '(' . $ban['serverbundle'] . ')';
            }
        }

        $length = SecondsToTimeString($ban['length'] * 60);

        $expired = '';

        if ($now > $expires && $ban['length']) {
            $expired = ' <font color="red">(' . Lang('reached') . ')</font>';
        }

        $unbannedtext = Lang('admin_bans_unbanned');
        $unbannedtext = str_replace('%date%', FormatDate($ban['date_unbanned']), $unbannedtext);
        $unbannedtext = str_replace('%admin%', '<a href="index.php?t=user&id=' . $ban['steamid64_admin_unbanned'] . '" target="_blank">' . $admin_unbanned_name . '</a>', $unbannedtext);

        $unbaninfo = '<div class="panel panel-warning">
							<div class="panel-body">
								' . $unbannedtext . '
							</div>
						</div>';

        if ($ban['status'] != 1) {
            $unbaninfo = "";
        }

        $protestbtn = '<button type="button" onclick="bans_protest_create(' . $ban['id'] . ');" class="btn btn-primary"><span class="fa fa-unlock"></span> ' . Lang('protest_create') . '</button>';

        if (!ValidateBool(Settings::Get("settings_bans_protests_enabled"))) {
            if (!tempty(Settings::Get("settings_bans_protests_url"))) {
                $protestbtn = '<a target="_blank" href="' . Settings::Get("settings_bans_protests_url") . '"><button type="button" class="btn btn-primary"><span class="fa fa-unlock"></span> ' . Lang('protest_create') . '</button>';
            } else {
                $protestbtn = '';
            }
        }

        if ($expired || $ban['status'] != 0) {
            $protestbtn = "";
        }

        if ($makerow) {
            echo '<div class="row">';
        }

        echo '
			<div class="col-md-6 col-xs-12">
				<div class="panel panel-default" id="bans_ban_' . $ban['id'] . '">
					<div class="panel-body">
						<table class="table table-responsive table-bordered table-striped">
							<tr>
								<td>ID:</td>
								<td>#' . $ban['id'] . '</td>
							</tr>
							<tr>
								<td>' . Lang('ban_date') . ':</td>
								<td>' . FormatDate($ban['date_banned']) . '</td>
							</tr>
							<tr>
								<td>' . Lang('unban_date') . ':</td>
								<td>' . FormatDate($expires->format('Y-m-d H:i:s')) . $expired . '</td>
							</tr>
							<tr>
								<td>' . Lang('length') . ':</td>
								<td>' . $length . '</td>
							</tr>
							<tr>
								<td>' . Lang('reason') . ':</td>
								<td>' . $ban['reason'] . '</td>
							</tr>
							<tr>
								<td>' . Lang('admin') . ':</td>
								<td>' .  '<a href="index.php?t=user&id=' . $admin->GetValue('steamid64') . '" target="_blank">' . $admin->GetValue('nick') . '</a>' . '</td>
							</tr>
							<tr>
								<td>' . Lang('serverbundle') . ':</td>
								<td>' . $serverbundle . '</td>
							</tr>
						</table>

						' . $unbaninfo . '

						<div class="row">
							<div class="col-xs-12">
						';

        $count_2 = 0;

        foreach (Banprotest::GetForBan($ban['id']) as $protest) {
            $count_2++;
            $in = ' in';

            $status = Lang('pending');

            if ($protest->GetValue('status') == 1) {
                $status = '<font color="green">' . Lang('accepted') . '</font>';
                $in = '';
            } elseif ($protest->GetValue('status') == 2) {
                $status = '<font color="red">' . Lang('denied') . '</font>';
                $in = '';
            }

            echo '
								<div class="panel panel-default" id="bans_protest_' . $protest->GetValue('id') . '">
									<div class="panel-heading">
										<h4 class="panel-title">
											<a data-toggle="collapse" data-parent="#accordion" href="#bans_protest_collapse_' . $protest->GetValue('id') . '">' . Lang('protest') . ' #' . $count_2 . '</a>
										</h4>
									</div>
									<div id="bans_protest_collapse_' . $protest->GetValue('id') . '" class="panel-collapse collapse' . $in . '">
										<div class="panel-body">
											' . $protest->GetValue('protesttext') . '
										</div>
										<div class="panel-footer">
											' . Lang('status') . ': <b>' . $status . '</b>
										</div>
									</div>
								</div>';
        }



        echo '
						</div>
						</div>

						<div class="row">
							<div class="col-xs-12">
								<div class="pull-right">
									' . $protestbtn . '
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		';

        if (!$makerow || (sizeof($userbans) - $count) < 1) {
            echo '</div>';

            if (isset($ids[1])) {
                echo '
					<script>
						if($("#bans_ban_' . $ids[0] . '").height() > $("#bans_ban_' . $ids[1] . '").height()){
							$("#bans_ban_' . $ids[1] . '").height($("#bans_ban_' . $ids[0] . '").height());
						}else{
							$("#bans_ban_' . $ids[0] . '").height($("#bans_ban_' . $ids[1] . '").height());
						}
					</script>
				';
            }


            $ids = array();
        }

        $makerow = !$makerow;
    }

    if (!sizeof($userbans)) {
        echo '<i>' . Lang('no_entries') . '</i>';
    }
?>

<div class="row">
	<div class="col-xs-12">
		<h1 class="page-header"><?php echo Lang('warnings'); ?></h1>
	</div>
</div>


<div class="row">
	<div class="col-xs-12">
		<table class="table table-responsive">
			<tr class="active">
				<th style="width: 0%;">#</th>
				<th><?php echo Lang('reason'); ?></th>
				<th><?php echo Lang('admin'); ?></th>
				<th><?php echo Lang('date'); ?></th>
				<th><?php echo Lang('serverbundle'); ?></th>
			</tr>
			<tbody>
				<?php
                    $warnings = Warnings::GetByUser($auth_user->GetValue('steamid64'));

                    foreach ($warnings as $warning) {
                        $admin = new User($warning['steamid64_admin']);

                        if ($admin->valid) {
                            $status = $warning['status'];

                            if (time() > (strtotime($warning['date']) + (Settings::Get('settings_warnings_decay')*60))) {
                                $status = 1;
                            }

                            $class = "";

                            if ($status == 1) {
                                $class = "danger";
                            } elseif ($status == 0) {
                                $class = "success";
                            }

                            $serverbundle = new Serverbundle($warning['serverbundle']);

                            if ($serverbundle->valid) {
                                echo '<tr class="'.$class.'">';
                                echo '<td>';
                                echo $warning['id'];
                                echo '</td>';
                                echo '<td>';
                                echo htmlspecialchars($warning['reason']);
                                echo '</td>';
                                echo '<td>';
                                echo '<a href="index.php?t=user&id=' . $admin->GetValue('steamid64') . '" target="_blank">' . $admin->GetValue('nick') . '</a>';
                                echo '</td>';
                                echo '<td>';
                                echo FormatDate($warning['date']);
                                echo '</td>';
                                echo '<td>';
                                echo $serverbundle->GetValue('name');
                                echo '</td>';
                                echo '</tr>';
                            }
                        }
                    }
                ?>
			</tbody>
		</table>
	</div>
</div>


<!-- Prootest Modal -->
<div class="modal fade" id="bans_modal_protest" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-unlock"></i> &nbsp;<?php echo Lang('protest_create'); ?></h4>
			</div>
			<form method="post" action="index.php?t=violations">
				<div class="modal-body">
					<textarea style="resize:vertical;" rows="10" class="form-control" name="bans_modal_protest_protesttext" placeholder="<?php echo Lang('unban_why'); ?>" ></textarea>

		            <input type="hidden" name="bans_modal_protest_banid" />
				</div>
				<div class="modal-footer">
					<button type="submit" name="bans_modal_protest_submit" class="btn btn-primary"><?php echo Lang('submit'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
	function bans_protest_create(id){
		$('#bans_modal_protest').modal('show');
		$('input[name="bans_modal_protest_banid"]').val(id);
	}

</script>