<?php
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    $G_REQUEST = true;

    session_start();

    include 'assets/php/utils.php';

    include 'assets/php/autoload.php';

    require __DIR__.'/vendor/autoload.php';

    include 'config.php';

    date_default_timezone_set(Config::Get('timezone'));

    $db = new MysqliDb(array(
        'host' => Config::Get('mysql_server'),
        'username' => Config::Get('mysql_user'),
        'password' => Config::Get('mysql_pw'),
        'db' => Config::Get('mysql_db'),
        'port' => Config::Get('mysql_port'),
        'prefix' => 'gex_',
        'charset' => (!tempty(Config::Get('mysql_charset')) ? Config::Get('mysql_charset') : 'latin1'),
    ));

    $nonloginfiles = NoAuthFiles::GetForApplication('request');
    $ignorebanfiles = array('main_notifications');

    $addonManager = new AddonManager();
    $requestManager = new FileManager('request');
    $pagesManager = new FileManager('pages');
    $languageManager = new LanguageManager('language');
    $themeManager = new FileManager('themes');
    $versionManager = new VersionManager();

    if (isset($_GET['t'])) {
        include 'auth.php';

        if (!in_array($_GET['t'], $nonloginfiles)) {
            if (!$auth_user) {
                Error('authentification required');
            }

            if (!in_array($_GET['t'], $ignorebanfiles)) {
                if ($auth_user->IsBanned(0)) {
                    Error('you are banned from this website');
                }
            }
        }

        $languageManager->Load();

        if (in_array($_GET['t'], array_keys($requestManager->files))) {
            foreach ($requestManager->files[$_GET['t']]['files'] as $_file) {
                if (file_exists($_file)) {
                    include $_file;
                }
            }
        } else {
            Error('requested target not found');
        }
    } else {
        Error('no target given');
    }
