<?php

    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    if (!DemoLock()) {
        if (Permissions::HasPagePermission('admin_bans')) {
            if (isset($_REQUEST['protestid']) && isset($_REQUEST['accept'])) {
                $protestid = $_REQUEST['protestid'];
                $accept = $_REQUEST['accept'];

                $protest = new Banprotest($protestid);

                if ($protest->valid) {
                    if (0 == $protest->GetValue('status')) {
                        $db->where('id', $protest->GetValue('banid'));
                        $ban = $db->getOne('bans');

                        if ($db->count) {
                            if (Bans::CanBan($ban['steamid64'], $ban['length'], $ban['serverbundle'])) {
                                $data_protest = array();
                                $data_ban = array();

                                if ($accept) {
                                    $data_protest = array('status' => 1);
                                    $data_ban = array('status' => 1, 'date_unbanned' => $db->now(), 'steamid64_admin_unbanned' => $auth_user->GetValue('steamid64'));
                                } else {
                                    $data_protest = array('status' => 2);
                                }

                                if ($accept) {
                                    $db->where('id', $protest->GetValue('banid'));
                                    $db->update('bans', $data_ban);
                                }

                                if ($accept) {
                                    Notifications::Send($ban['steamid64'], 'notification_protest_accepted', array(), 'index.php?t=bans', 'check');
                                } else {
                                    Notifications::Send($ban['steamid64'], 'notification_protest_declined', array(), 'index.php?t=bans', 'times');
                                }

                                $db->where('id', $protestid);
                                $db->update('bans_protests', $data_protest);

                                if ($db->count) {
                                    Success();
                                } else {
                                    Error('could not update protest');
                                }
                            } else {
                                Error('no permission');
                            }
                        } else {
                            Error('ban not found');
                        }
                    } else {
                        Error('protest already handeled');
                    }
                }
            }
        }
    }
