<?php 
    if (!isset($auth_user)) {
        die(json_encode(array("error" => "authentification failed")));
    }
    
    if (isset($_REQUEST['serverid'])) {
        if (Permissions::HasPagePermission('admin_console')) {
            $bundle = Serverbundle::GetByServer($_REQUEST['serverid']);
            
            if ($bundle) {
                if (Permissions::HasPermission('console', $auth_user->GetGroup($bundle->GetValue('id'))) || Permissions::HasPermission('super')) {
                    if (isset($_REQUEST['timeframe'])) {
                        $server = new Server($_REQUEST['serverid']);
                        
                        if ($server->valid && is_numeric($_REQUEST['timeframe'])) {
                            $log = $server->GetLog($_REQUEST['timeframe']);
                            
                            echo $log;
                        }
                    } elseif (isset($_REQUEST['command'])) {
                        if (!DemoLock()) {
                            if (Permissions::HasPermission('console_command', $auth_user->GetGroup($bundle->GetValue('id'))) || Permissions::HasPermission('super')) {
                                if (Command::Send($_REQUEST['serverid'], $_REQUEST['command'])) {
                                    Success();
                                } else {
                                    Error('Invalid input.');
                                }
                            } else {
                                Error('Insufficient permissions.');
                            }
                        }
                    /*}elseif(isset($_REQUEST['users_online'])){
                        $server = new Server($_REQUEST['serverid']);

                        if($server->valid){
                            $actions = Actions::GetAll();

                            $users = User::GetFromSteamIDs($server->GetValue('users_online'));

                            foreach($users as $user){
                                $commands = array();

                                foreach($actions as $action){
                                    $command = $action['command'];
                                    $command = str_replace('%steamid64%', $user->GetValue('steamid64'));
                                    $command = str_replace('%steamid32%', $user->GetValue('steamid32'));
                                    $command = str_replace('%uniqueid%', $user->GetValue('uniqueid'));
                                    $command = str_replace('%nick%', $user->GetValue('nick'));

                                }
                            }
                        }*/
                    } else {
                        $server = new Server($_REQUEST['serverid']);
                        
                        if ($server->valid) {
                            Result($server->GetTimeframes());
                        }
                    }
                } else {
                    PermissionsError();
                }
            }
        } else {
            Error('Insufficient permissions.');
        }
    }
