<?php
    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    if (Permissions::HasPagePermission('admin_donations')) {
        if (isset($_REQUEST['id'])) {
            if (is_numeric($_REQUEST['id'])) {
                $donation = new Donation($_REQUEST['id']);

                if ($donation->valid) {
                    $info = array(
                        'donation' => $donation->data,
                    );

                    $package = new Package($donation->GetValue('package'));
                    $buyer = new User($donation->GetValue('steamid64_buyer'));
                    $for = new User($donation->GetValue('steamid64_for'));

                    $info['package'] = array('title' => $package->GetValue('title'));
                    $info['buyer'] = array('steamid64' => $buyer->GetValue('steamid64'), 'nick' => $buyer->GetValue('nick'));
                    $info['for'] = array('steamid64' => $for->GetValue('steamid64'), 'nick' => $for->GetValue('nick'));

                    unset($info['donation']['invoice']);

                    $info['paysafecard_partner'] = false;
                    if (!tempty(Paysafecard::GetKey())) {
                        $info['paysafecard_partner'] = true;
                    }

                    $info['date'] = FormatDate($donation->GetValue('date'));
                    $info['donation']['amount'] = FormatPrice($donation->GetValue('amount'));
                    unset($info['donation']['name_buyer']);

                    if (!empty($donation->GetValue('coupon'))) {
                        $coupon = new Coupon($donation->GetValue('coupon'), true);

                        if ($coupon->valid) {
                            $info['coupon'] = $coupon->data;
                        }
                    }

                    if (Permissions::HasPermission('donations_paysafecard') && 'paysafecard' == $donation->GetValue('gateway')) {
                        $db->where('id', str_replace('psc-', '', $donation->GetValue('transactionid')));
                        $psc_inquirie = $db->getOne('paysafecard');
                        $info['paysafecard'] = $psc_inquirie;
                    }

                    Result($info);
                } else {
                    Error('Donation not found.');
                }
            }
        }
    }
