<?php
    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    if (Permissions::HasPagePermission('shop') || !$auth_user) {
        if (isset($_REQUEST['bundle']) && isset($_REQUEST['package'])) {
            if ($auth_user) {
                if (is_numeric($_REQUEST['bundle']) && is_numeric($_REQUEST['package'])) {
                    $bundle = new Serverbundle($_REQUEST['bundle']);
                    if ($bundle->valid) {
                        if ($bundle->GetValue('donations')) {
                            $package = new Package($_REQUEST['package'], null, true);
                            if ($package->valid) {
                                if ($package->GetValue('active')) {
                                    if ($package->GetValue('serverbundle') == $bundle->GetValue('id')) {
                                        $pdata = $package->data;

                                        unset($pdata['rewards']);

                                        $package->taxes['note'] = ValidateHTML($package->taxes['note']);

                                        $retarray = array('package' => $pdata, 'bundle' => $bundle->data, 'buyable' => $package->Buyable($auth_user), 'taxes' => $package->taxes);
                                        echo ToJson($retarray);
                                    } else {
                                        Error('bundle and package do not match');
                                    }
                                } else {
                                    Error('package not enabled');
                                }
                            } else {
                                Error('package not found');
                            }
                        } else {
                            Error('donations are disabled for this bundle');
                        }
                    } else {
                        Error('bundle not found');
                    }
                }
            }
        } elseif (isset($_REQUEST['bundle'])) {
            if (is_numeric($_REQUEST['bundle'])) {
                $bundle = new Serverbundle($_REQUEST['bundle']);

                if ($bundle->valid) {
                    if ($bundle->GetValue('donations')) {
                        $retarray = array('packages' => Donations::GetPackages($_REQUEST['bundle'], true, true), 'bundle' => $bundle->data);
                        echo ToJson($retarray);
                    } else {
                        Error('donations are disabled for this bundle');
                    }
                } else {
                    Error('bundle not found');
                }
            }
        } elseif (isset($_REQUEST['steamid'])) {
            $for = new User(trim($_REQUEST['steamid']));

            if ($for->valid) {
                $for->RefreshSteamData();
                echo json_encode(array(
                    'valid' => true,
                    'nick' => $for->GetValue('nick'),
                    'steamid64' => $for->GetValue('steamid64'),
                ));
            } else {
                echo json_encode(array(
                    'valid' => false,
                ));
            }
        } elseif (isset($_REQUEST['code'])) {
            $coupon = new Coupon($_REQUEST['code']);
            if ($coupon->valid) {
                if ($coupon->GetValue('amount_left') > 0) {
                    echo json_encode(array(
                        'valid' => true,
                        'amount_left' => FormatPrice($coupon->GetValue('amount_left')),
                        'code' => $coupon->GetValue('code'),
                    ));
                } else {
                    echo json_encode(array('valid' => false));
                }
            } else {
                echo json_encode(array('valid' => false));
            }
        }
    }
