<?php
    if (!isset($G_REQUEST)) {
        Error('authentification failed');
    }

    Rewards::CheckForExecute();

    $emails = EmailQueue::Get();

    foreach ($emails as $email) {
        EmailQueue::Delete($email['id']);

        if (!tempty(Config::Get('mail_host'))) {
            $user = new User($email['steamid64']);

            if ($user->valid) {
                if (!tempty($user->GetValue('email')) && $user->GetValue('emailnotifications')) {
                    $attachments = FromJson($email['attachments']);

                    foreach ($attachments as $key => $attachment) {
                        $attachments[$key]['name'] = base64_decode($attachment['name']);
                        $attachments[$key]['content'] = base64_decode($attachment['content']);
                    }

                    $user->SendEmail($email['subject'], $email['body'], $attachments);
                }
            }
        }
    }

    if (intval(Settings::Get('languages_lastupdate')) > time() || (time() - intval(Settings::Get('languages_lastupdate'))) > 86400) {
        Settings::Set('languages_lastupdate', time());

        $languageManager->UpdateLanguages();
    }

    $url = Settings::Get('settings_donations_invoice_api');

    if(!tempty($url)) {
        $db->where('api_notified', 0);
        $donationsData = $db->get('donations');

        if ($db->count) {
            foreach ($donationsData as $donationData) {
                $donation = new Donation($donationData['id']);
                $buyer = new User($donationData['steamid64_buyer']);
                $package = new Package($donationData['package']);

                if ($donation->valid && $buyer->valid && $package->valid) {
                    Debug('Trying to notify invoicing API about payment ' . $donationData['id']);

                    if(Payment::NotifyInvoicingAPI($url, $donation->data, $buyer, $package, 3) !== false){
                        $donation->SetValue('api_notified', 1);
                    }

                    break;
                }
            }
        }
    }