<?php

    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    if (isset($_REQUEST['message'])) {
        if ($auth_user) {
            if (!empty($_REQUEST['message'])) {
                $data = array(
                    'steamid64' => $auth_user->GetValue('steamid64'),
                    'message' => $_REQUEST['message'],
                );

                if ($db->insert('chat', $data)) {
                    echo json_encode(array('success' => 'true'));
                } else {
                    echo json_encode(array('error' => 'sqlerror'));
                }
            }
        }
    } elseif (isset($_REQUEST['entryid'])) {
        if ($auth_user) {
            if (!DemoLock()) {
                if (Permissions::HasPermission('chat_admin')) {
                    $db->where('id', $_REQUEST['entryid']);
                    $db->delete('chat');
                }
            }
        }
    } else {
        $db->orderBy('date', 'Desc');
        $result = $db->get('chat', 30);

        $chatlines = array();

        $modperm = Permissions::HasPermission('chat_admin');

        foreach ($result as $entry) {
            $time = $entry['date'];
            $user = null;

            $user = new User($entry['steamid64']);

            $donator = false;
            $message = htmlspecialchars($entry['message']);

            array_push($chatlines, array(
                'id' => $entry['id'],
                'steamid64' => $entry['steamid64'],
                'message' => $message,
                'nick' => $user->GetValue('nick'),
                'groupcolor' => $user->GetGroup()->GetValue('hexcolor'),
                'donator' => $donator,
                'image' => $user->GetValue('avatar_small'),
                'time' => $time,
                'modperm' => $modperm,
            ));
        }

        echo json_encode(array_reverse($chatlines));
    }
