<?php
    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    RequiredArguments('gateway', 'payment_id');

    $gateway_name = $gateway;

    $gateway = new Gateway($gateway_name);

    if ($gateway->GetValue('enabled')) {
        $payment = Payment::PostProcess($payment_id);

        if ($payment) {
            $buyer = new User($payment['buyer']);
            $for = new User($payment['for']);
            $coupon = new Coupon($payment['coupon']);
            $price = $payment['price'];
            $package = new Package($payment['package'], null, true, $buyer);

            if ($buyer->valid && $for->valid && $package->valid && $price) {
                if ($package->Buyable($for)) {
                    if ('paysafecard' == $gateway_name && tempty(Paysafecard::GetKey())) {
                        if (isset($_REQUEST['pins'])) {
                            $seperators = array(',', '-', '/', ' ');
                            if (strlen($_REQUEST['pins']) >= 16 && ctype_digit(trim(str_replace($seperators, '', $_REQUEST['pins'])))) {
                                $db->where('steamid64_buyer', $auth_user->GetValue('steamid64'));
                                $result = $db->get('paysafecard');

                                $db->where('steamid64_buyer', $auth_user->GetValue('steamid64'));
                                $db->where('status', 0);
                                $activepsc = $db->get('paysafecard');

                                if ($db->count < 3) {
                                    $discount = 0;

                                    if ($payment['coupon']) {
                                        if ($coupon->valid) {
                                            $discount = $coupon->GetValue('amount_left');
                                            $coupon->Devaluate();
                                        } else {
                                            Error('Coupon already used. Please restart payment (F5).');
                                        }
                                    }

                                    $data = array(
                                        'pins' => htmlspecialchars($_REQUEST['pins']),
                                        'steamid64_buyer' => $auth_user->GetValue('steamid64'),
                                        'steamid64_for' => $for->GetValue('steamid64'),
                                        'package' => $package->GetValue('id'),
                                        'price_should' => $price,
                                        'price' => $package->GetValue('price'),
                                        'coupon' => $payment['coupon'],
                                        'discount' => $discount,
                                        'status' => 0,
                                    );

                                    $db->insert('paysafecard', $data);

                                    foreach (Permissions::GetSteamIDsWithPermission(true, 'admin_donations') as $steamid64) {
                                        Notifications::Send($steamid64, 'notification_new_psc', array('donator' => $auth_user->GetValue('nick'), 'price' => Settings::Get('settings_donations_currency').$price, 'package' => $package->GetValue('title')), 'index.php?t=admin_donations&part=paysafecard', 'credit-card-alt');
                                    }

                                    if ($db->count) {
                                        Success();
                                    }
                                } else {
                                    Error(Lang('psc_max'));
                                }
                            }
                        }
                    } elseif ('payssion' == $gateway_name) {
                        RequiredArguments('method');

                        $payssion = new Payssion(Settings::Get('settings_donations_payssion_apikey'), Settings::Get('settings_donations_payssion_secretkey'), !(Settings::Get('settings_donations_payssion_sandbox')));

                        $response = null;
                        try {
                            $response = $payssion->create(array(
                                'amount' => $payment['price'],
                                'currency' => Settings::Get('settings_donations_currency_plain'),
                                'pm_id' => $method,
                                'description' => $package->GetValue('title'),
                                'order_id' => $payment_id,
                                'return_url' => GetCurrentLocation().'index.php?t=purchase&gateway=payssion',
                            ));
                        } catch (Exception $e) {
                            Error($e->getMessage(), true);
                        }

                        if ($payssion->isSuccess()) {
                            $todo = $response['todo'];
                            if ($todo) {
                                $todo_list = explode('|', $todo);
                                if (in_array('redirect', $todo_list)) {
                                    $paylink = $response['redirect_url'];
                                    Result(array('url' => $paylink));
                                } else {
                                    Error('Error while contacting Payssion service.');
                                }
                            } else {
                                Error('Error while contacting Payssion service.');
                            }
                        } else {
                            Error('Could not start payment: '.$response['description'], true);
                        }
                    } elseif ('stripe' == $gateway_name) {
                        RequiredArguments('token');

                        $token = FromJson($token);

                        if (isset($token['id'])) {
                            if (!$payment['coupon'] || $coupon->valid) {
                                $stripe = new Stripe();

                                $response = $stripe->MakeCharge($token['id'], $price, $package->GetValue('title'));

                                if (isset($response['error'])) {
                                    Error($response['error']['type'].': '.$response['error']['message']);
                                }

                                if ('succeeded' == $response['status'] && $response['paid'] = true) {
                                    $coupon->Devaluate();

                                    $db->where('transactionid', $response['id']);
                                    $db->getOne('donations');

                                    if ($db->count) {
                                        Error('TransactionID already proceeded', true);
                                    }

                                    $name = $buyer->GetValue('nick');

                                    if (isset($response['source'])) {
                                        if (isset($response['source']['name']) && false === strpos($response['source']['name'], '@')) {
                                            $name .= "\r\n".$response['source']['name'];
                                        }

                                        if (isset($response['source']['address_line1']) && isset($response['source']['address_city']) && isset($response['source']['address_zip'])) {
                                            $name .= "\r\n".$response['source']['address_line1']."\r\n".$response['source']['address_zip'].' '.$response['source']['address_city'];
                                        }
                                    }

                                    $data = array(
                                        'name_buyer' => $name,
                                        'steamid64_buyer' => $buyer->GetValue('steamid64'),
                                        'steamid64_for' => $for->GetValue('steamid64'),
                                        'amount' => $price,
                                        'package' => $package->GetValue('id'),
                                        'transactionid' => $response['id'],
                                        'coupon' => $payment['coupon'],
                                        'email' => $token['email'],
                                        'gateway' => 'stripe',
                                    );

                                    Payment::Finish($data, $buyer, $for, $package, $payment);

                                    Success();
                                } elseif ('failed' == $response['status']) {
                                    Error($response['failure_code'].' - '.$response['failure_message'], true);
                                } elseif ('pending' == $response['status']) {
                                    Error('Payment pending.', true);
                                }
                            } else {
                                Error('Invalid coupon.', true);
                            }
                        } else {
                            Error('Invalid token.');
                        }
                    } else {
                        Error('Gateway handler not found.');
                    }
                } else {
                    Error("The user can't receive this package.");
                }
            } else {
                Error('Payment data invalid.');
            }
        } else {
            Error('Payment not found.');
        }
    } else {
        Error('Gateway not enabled.');
    }

    Error(Lang('input_invalid'));
