<?php

if (!isset($G_REQUEST)) {
    die(json_encode(array('error' => 'authentification failed')));
}

if (!DemoLock()) {
    if (Permissions::HasPermission('super')) {
        $url = Settings::Get('settings_donations_invoice_api');

        if(!tempty($url)) {
            $donations = Donations::GetAll();

            foreach ($donations as $donation) {
                $buyer = new User($donation['steamid64_buyer']);
                $package = new Package($donation['package']);

                if(!$buyer->valid){
                    print("user with steamid64 " . $buyer->GetValue('steamid64') . " not found.<br/>");
                }

                if(!$package->valid){
                    print("package with id " . $buyer->GetValue('steamid64') . " not found.<br/>");
                }

                if($buyer->valid && $package->valid){
                    Payment::NotifyInvoicingAPI($url, $donation, $buyer, $package);
                    print("sent invoice notification for purchase " . $donation['id'] . "</br>");
                }
            }
        }else{
            Error("no notification url specified");
        }
    } else {
        Error("no super permissions");
    }
}
