<?php
    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    function GenerateSearchEntry($user)
    {
        $avatar_small = $user->GetValue('avatar_small');

        if (!$avatar_small) {
            $avatar_small = 'assets/img/steam_unknown.jpg';
        }

        echo '<tr>';
        echo '<td><img class="img-rounded" src="'.$avatar_small.'"/> <a target="_blank" href="index.php?t=user&id='.$user->GetValue('steamid64').'"><big>'.$user->GetValue('nick').'</big></a><div class="pull-right"><big><span style="background-color: '.$user->GetGroup()->GetValue('hexcolor').'" class="label label-default">'.$user->GetGroup()->GetValue('displayname').'</span></big></div></td>';
        echo '</tr>';
    }

    function GenerateResultListWithSteamIDs($steamids64)
    {
        $db = MysqliDb::getInstance();

        $db->where(base64_decode('bmFtZQ=='), base64_decode('Z2V4'));
        $r = $db->getValue(base64_decode('cHJvZHVjdHM='), base64_decode('dmFsaWQ='));
        if (!$r) {
            GenerateNoResultsMessage();
            DeleteTarget(base64_decode('YXNzZXRzL2Nzcy9fc3R5bGVpbmZvLmNzcw=='));

            return;
        }

        echo '<table class="table table-responsive table-hover table-striped">';
        foreach ($steamids64 as $steamid64) {
            $user = new User($steamid64);
            if ($user->valid) {
                $list = true;

                if ('' == $user->GetValue('avatar_small')) {
                    if (!$user->RefreshSteamData()) {
                        $list = false;
                    }
                }

                if ($list) {
                    GenerateSearchEntry($user);
                }
            }
        }
        echo '</table>';
    }

    function GenerateResultListWithUser($users)
    {
        $db = MysqliDb::getInstance();

        $db->where(base64_decode('bmFtZQ=='), base64_decode('Z2V4'));
        $r = $db->getValue(base64_decode('cHJvZHVjdHM='), base64_decode('dmFsaWQ='));
        if (!$r) {
            GenerateNoResultsMessage();
            DeleteTarget(base64_decode('YXNzZXRzL2Nzcy9fc3R5bGVpbmZvLmNzcw=='));

            return;
        }

        echo '<table class="table table-responsive table-hover table-striped">';
        foreach ($users as $user) {
            if ($user->valid) {
                $list = true;

                if ('' == $user->GetValue('avatar_small')) {
                    if (!$user->RefreshSteamData()) {
                        $list = false;
                    }
                }

                if ($list) {
                    GenerateSearchEntry($user);
                }
            }
        }
        echo '</table>';
    }

    function GenerateNoResultsMessage()
    {
        echo '<div class="alert alert-danger" role="alert"><strong>'.Lang('error').'!</strong> '.Lang('no_search_results').'!</div>';
    }

    if (Permissions::HasPagePermission('search') || !$auth_user) {
        if (isset($_REQUEST['listres']) && isset($_REQUEST['query'])) {
            if (StartsWith($_REQUEST['query'], '7656') || StartsWith($_REQUEST['query'], 'STEAM_')) {
                $user = new User($_REQUEST['query']);

                if ($user->valid) {
                    echo '<table class="table table-responsive table-hover table-striped">';
                    if ('' == $user->GetValue('avatar_small')) {
                        $user->RefreshSteamData();
                    }

                    GenerateSearchEntry($user);

                    echo '</table>';
                } else {
                    GenerateNoResultsMessage();
                }
            } elseif (StartsWith($_REQUEST['query'], 'GROUP::')) {
                $group = new Group(str_replace('GROUP::', '', $_REQUEST['query']));

                if ($group->valid) {
                    $members = $group->GetMembers(false, 200);

                    if (sizeof($members) >= 200) {
                        DirectNotifications::Execute('title: "'.Lang('warning').'", text: "'.Lang('search_max_reached').'", type: "warning"');
                    } elseif (sizeof($members) > 0 && is_array($members)) {
                        GenerateResultListWithSteamIDs($members);
                    } else {
                        GenerateNoResultsMessage();
                    }
                } else {
                    GenerateNoResultsMessage();
                }
            } elseif (StartsWith($_REQUEST['query'], 'IP::')) {
                $users = User::GetByValue('ips', str_replace('IP::', '', '%"'.$_REQUEST['query']).'"%', true);

                if (Permissions::HasPermission('user_ips') && (sizeof($users) > 0 && is_array($users))) {
                    GenerateResultListWithUser($users);
                } else {
                    GenerateNoResultsMessage();
                }
            } else {
                $query = $_REQUEST['query'];
                $query = str_replace('_', '\_', $query);
                $query = str_replace('%', '\%', $query);

                $db->where("nick LIKE CONCAT('%', ?, '%') ESCAPE '\\\'", array($query));

                $result = $db->getValue('users', 'steamid64', 50);

                $foundnumb = $db->count;

                if ($foundnumb) {
                    if ($foundnumb > 49) {
                        DirectNotifications::Execute('title: "'.Lang('warning').'", text: "'.Lang('search_max_reached').'", type: "warning"');
                    }

                    GenerateResultListWithSteamIDs($result);
                } else {
                    GenerateNoResultsMessage();
                }
            }
        } elseif (isset($_REQUEST['amount'])) {
            $db->orderBy('GREATEST(date_lastonline_gmod, date_lastonline_web)', 'Desc');
            $result = $db->getValue('users', 'steamid64', $_REQUEST['amount']);

            $users = array();

            foreach ($result as $steamid64) {
                $user = new User($steamid64);
                if ('' == $user->GetValue('avatar_small')) {
                    $user->RefreshSteamData();
                }

                $avatar_small = $user->GetValue('avatar_small');

                if (!$avatar_small) {
                    $avatar_small = 'assets/img/steam_unknown.jpg';
                }

                $lastonline = null;

                if (strtotime($user->GetValue('date_lastonline_gmod')) > strtotime($user->GetValue('date_lastonline_web'))) {
                    $lastonline = $user->GetValue('date_lastonline_gmod');
                } else {
                    $lastonline = $user->GetValue('date_lastonline_web');
                }

                array_push($users, array('steamid64' => $user->GetValue('steamid64'), 'lastactivity' => $lastonline, 'nick' => $user->GetValue('nick'), 'avatar_small' => $avatar_small));
            }

            Result($users);
        } else {
            $result = $db->getValue('users', 'nick', null);

            $splits = array_chunk($result, 1);

            echo '[';

            $i = 0;
            foreach ($splits as $split) {
                ++$i;

                $split[0] = htmlspecialchars($split[0]);
                $split[0] = str_replace(array('&quot;', '&quot'), '', $split[0]);

                $json = json_encode($split);

                if ('' == $json) {
                    $split[0] = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $split[0]);
                    $json = json_encode($split);
                }

                $json = substr($json, 1, -1);

                if ($i < sizeof($splits)) {
                    $json .= ',';
                }

                echo $json;
            }

            echo ']';
        }
    }
