<?php
    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    error_reporting(E_ERROR | E_PARSE);

    if (isset($_REQUEST['serverid'])) {
        $info = array('status' => false);

        if ('teamspeak' == $_REQUEST['serverid']) {
            $info = TS3Worker::GetClientCount();

            $info['hostname'] = TS3Worker::GetHostname();
            $info['status'] = true;

            if (isset($_GET['teamspeak_viewer'])) {
                if ($_GET['teamspeak_viewer']) {
                    $info['users'] = TS3Worker::GetViewer();
                }
            }
        }
        if ('discord' == $_REQUEST['serverid']) {
            $discord = new Discord();

            if (time() - intval(Settings::Get('discord_data_updated')) > 1800) {
                $members = $discord->getGuildMembers();
                $guild = $discord->getGuild();

                if ($members && $guild) {
                    $info['status'] = true;
                    Settings::Set('discord_membercount', sizeof($members));
                    Settings::Set('discord_guild_name', htmlspecialchars($guild['name']));
                    Settings::Set('discord_data_updated', time());
                }
            } else {
                $info['status'] = true;
            }

            if ($info['status']) {
                $info['members'] = Settings::Get('discord_membercount');
                $info['hostname'] = Settings::Get('discord_guild_name');
            }
        } else {
            $server = new Server($_REQUEST['serverid']);

            if ($server->valid) {
                if (time() - strtotime($server->GetValue('date_refreshed')) < 180) {
                    $info['slots'] = $server->GetValue('slots');
                    $info['status'] = true;
                    $info['map'] = htmlspecialchars($server->GetValue('map'));

                    $players = $server->GetValue('users_online');

                    foreach ($players as $key => $ply) {
                        $group = new Group($ply['group']);

                        $players[$key]['group_color'] = 'black';
                        $players[$key]['nick'] = htmlspecialchars($players[$key]['nick']);

                        if ($group->valid) {
                            $players[$key]['group_color'] = $group->GetValue('hexcolor');
                        }
                    }

                    $info['players'] = $players;
                }
            }
        }

        Result($info);
    }
