<?php
    header('Content-Type: application/json');

    if (!isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $input = file_get_contents('php://input');
        $body = json_decode($input);
    }

    if (json_last_error() !== JSON_ERROR_NONE || !isset($_REQUEST['action'])) {
        http_response_code(400);
        echo json_encode([ 'error' => 'Invalid request.' ]);
        exit;
    }

    if($_REQUEST['action'] == 'key'){
        Result(['publishableKey' => Settings::Get('settings_donations_stripe_publickey')]);
    }elseif($_REQUEST['action'] == 'pay'){
        $price = null;

        if(isset($body->paymentId)){
            $payment = Payment::PostProcess($body->paymentId);

            if(isset($payment['price'])){
                $price = $payment['price'];
            }else{
                Error('Payment not found.');
            }
        }

        $intent = Stripe::MakePayment(
            (isset($body->paymentIntentId) ? $body->paymentIntentId : null),
            $price,
            (isset($body->paymentMethodId) ? $body->paymentMethodId : null),
            (isset($body->useStripeSdk) ? $body->useStripeSdk : null),
            (isset($body->paymentId) ? $body->paymentId : null)
        );
        $res = Stripe::GenerateResponse($intent);

        Result($res);
    }


