<!--{"language":"addons","icon":"fa-puzzle-piece","position":9000}-->

<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_addons_uninstall'])) {
            if ($addonManager->Uninstall($_POST['settings_addons_uninstall'])) {
                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('uninstall_success').'", type: "success"');
            } else {
                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('uninstall_error').'", type: "error"');
            }
        } elseif (isset($_POST['settings_addons_install'])) {
            if ($addonManager->Install($_POST['settings_addons_install'])) {
                DirectNotifications::Queue('title: "'.Lang('success').'", text: "'.Lang('install_success').'", type: "success"');
                Redirect('index.php?t=admin_settings&part=addons');
            } else {
                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('install_error').'", type: "error"');
            }
        }
    }
?>

<h3>
    <?php echo Lang('addons'); ?>
    <div class="pull-right">
		<a target="_blank" href="https://www.gmodstore.com/scripts/?0=search&search=GExtension"><button type="button" class="btn btn-info btn-sm"><i class="fa fa-download"></i> <?php echo Lang('get_addons'); ?></button></a>
	</div>
</h3>

<hr>


<div class="table-responsive">
    <table class="table table-hover">
        <tr class="active">
            <th><?php echo Lang('name'); ?></th>
            <th><?php echo Lang('version_installed'); ?></th>
            <th><?php echo Lang('author'); ?></th>
            <th class="text-right"><i class="fa fa-cogs"></i></th>
        </tr>
    
        <tbody>
            <?php
                foreach ($addonManager->addons as $name => $addon) {
                    echo '<tr>';
                    echo '<td>';
                    echo $addon['rawname'];
                    echo '</td>';
                    echo '<td>';
                    echo ''.(isset($addon['data']['version']) ? $addon['data']['version'] : '-');
                    echo '</td>';
                    echo '<td>';
                    echo ''.(isset($addon['data']['author']) ? $addon['data']['author'] : '-');
                    echo '</td>';
                    echo '<td class="text-right">';
                    if (!$addon['installed']) {
                        echo '<button onclick="post(\'index.php?t=admin_settings&part=addons\', {settings_addons_install: \''.$addon['rawname'].'\'});" class="btn btn-success btn-xs">'.Lang('install').'</button>';
                    } else {
                        echo '<button onclick="post(\'index.php?t=admin_settings&part=addons\', {settings_addons_uninstall: \''.$addon['rawname'].'\'});" class="btn btn-danger btn-xs">'.Lang('uninstall').'</button>';
                    }
                    echo '</td>';
                    echo '</tr>';
                }

            ?>
    
        </tbody>
    </table>
</div>
