<!--{"language":"adverts","icon":"fa-envelope","position":80}-->

<?php
	if(!isset($auth_user)){
		die(json_encode(array("error" => "authentification failed")));
	}
?>

<?php
    if(!DemoLock()){
    	if(isset($_POST['settings_adverts_submit'])){
    	    $checkboxes = array('settings_adverts_tag');
    	    $ignore = array('settings_adverts_submit');

        	foreach($checkboxes as $checkbox){
        		if(!array_key_exists($checkbox, $_POST)){
        			$_POST[$checkbox] = 0;
        		}else{
        			$_POST[$checkbox] = 1;
        		}
        	}

        	foreach($_POST as $key => $postvar){
                if(!in_array($key, $ignore) && StartsWith($key, 'settings_adverts_')){
                    Settings::Set($key, $postvar);
                }
            }

            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
    	}
    }

?>

<h3><?php echo Lang('adverts'); ?></h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=adverts">
            <div class="row">
                <div class="col-sm-6">
                    <label><?php echo Lang('tags_enabled'); ?></label><br>
                    <?php CreateCheckBox('primary', 'settings_adverts_tag', '', Lang('tags_enabled_adverts')); ?>
                </div>
                <div class="col-sm-6">
                    <label><?php echo Lang('interval'); ?></label><br>
                    <input name="settings_adverts_interval" class="form-control" />
                </div>
            </div>

            <br />

            <!-- Submit Button -->
            <button name="settings_adverts_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>
    </div>
</div>



<script>
    $('input[name="settings_adverts_interval"]').TouchSpin({
        min: 0,
        max: 1000000,
    	step: 60,
    	forcestepdivisibility: 'none',
        decimals: 0,
        verticalbuttons: true,
        postfix: '<?php echo Lang('minutes'); ?>'
    });

    $('input[name="settings_adverts_tag"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_adverts_tag')); ?>);
    $('input[name="settings_adverts_interval"]').val(<?php echo OneLine(Settings::Get('settings_adverts_interval')); ?>);
</script>