<!--{"language":"api","icon":"fa-globe","position":90}-->

<?php 
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array("error" => "authentification failed")));
    }
    
    if (!Permissions::HasPermission('super')) {
        error("super permissions required");
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_api_renew'])) {
            Settings::Set('settings_api_key', date('d') . random_string(50));
        }
        
        if (isset($_POST['settings_testlogin_renew'])) {
            Settings::Set('settings_testlogin', date('d') . random_string(25));
        }
    }
?>

<h3>
    <?php echo Lang('api'); ?>
    <div class="pull-right">
		<button onclick="OpenInNewTab('https://gextension.ibot3.de/wiki/index.php?title=API');" type="button" class="btn btn-info btn-sm"><i class="fa fa-book"></i> <?php echo Lang('documentation'); ?></button>
	</div>
</h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=api">
            <label><?php echo Lang('key'); ?></label><br>
            <div class="row">
                <div class="col-sm-11">
                    <pre><?php echo(DemoLock() ? '<i>Hidden</i>' : Settings::Get('settings_api_key')); ?></pre>
                </div>
                
                <div class="col-sm-1">
                    <button type="submit" name="settings_api_renew" class="btn btn-warning btn-sm"><i class="fa fa-refresh"></i></button>
                </div>
            </div>
            
            
            <br>
            <label><?php echo Lang('url'); ?></label><br>
            <a href="#"><?php echo GetCurrentLocation() . 'api.php?t=&lt;page&gt;[&key=&lt;key&gt;]'; ?></a>
            
            <hr>
            
            <label><?php echo Lang('testlogin'); ?></label>
            <span class="pull-right"><?php CreateTooltip(Lang('testlogin_description'), 'left'); ?></span>
            
            <div class="row">
                <div class="col-sm-11">
                    <pre><?php echo(DemoLock() ? '<i>Hidden</i>' : GetCurrentLocation() . 'request.php?t=main_testlogin&key=' . Settings::Get('settings_testlogin')); ?></pre>
                </div>
                
                <div class="col-sm-1">
                    <button type="submit" name="settings_testlogin_renew" class="btn btn-warning btn-sm"><i class="fa fa-refresh"></i></button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>

</script>