<!--{"language":"bans","icon":"fa-ban","position":50}-->

<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array("error" => "authentification failed")));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_bans_submit'])) {
            $checkboxes = array('settings_bans_protests_enabled', 'settings_bans_global');
            $ignore = array('settings_bans_submit');

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            foreach ($_POST as $key => $postvar) {
                if (!in_array($key, $ignore) && StartsWith($key, 'settings_bans_')) {
                    Settings::Set($key, $postvar);
                }
            }

            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        }
    }
?>

<h3><?php echo Lang('bans'); ?></h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=bans">
            <!-- Protest Enabled -->
            <label><?php echo Lang('ban_global'); ?></label><br>
            <?php CreateCheckbox('primary', 'settings_bans_global', '', Lang('ban_global_default')); ?>

            <br />

        	<!-- Protest Enabled -->
            <label><?php echo Lang('protests_enabled'); ?></label><br>
            <?php CreateCheckbox('primary', 'settings_bans_protests_enabled', '', Lang('protests_intern_use')); ?>

			<br>

			<div class="row">
			    <div class="col-sm-4">
			        <!-- Max Protests -->
                    <label><?php echo Lang('max_protests_per_ban'); ?></label><br>
                    <input value="3" name="settings_bans_protests_max" type="text" class="form-control" placeholder="3">
			    </div>

			    <div class="col-sm-1">
			        <center><b><?php echo Lang('or'); ?></b></center>
			    </div>

			    <div class="col-sm-7">
			        <!-- Protests Url -->
                    <label><?php echo Lang('protests_url'); ?></label><br>
                    <input name="settings_bans_protests_url" type="text" class="form-control" placeholder="https://www.example.com">
			    </div>
			</div>

            <br>

            <!-- Submit Button -->
            <button name="settings_bans_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>
    </div>
</div>

<script>
    $("input[name='settings_bans_protests_max']").TouchSpin({
        min: 0,
        max: 100,
    	step: 1,
    	forcestepdivisibility: 'none',
        decimals: 0,
        verticalbuttons: true
    });

    $('input[name="settings_bans_protests_enabled"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_bans_protests_enabled')); ?>);
    $('input[name="settings_bans_global"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_bans_global')); ?>);
    $('input[name="settings_bans_protests_url"]').val('<?php echo OneLine(Settings::Get('settings_bans_protests_url')); ?>');
    $('input[name="settings_bans_protests_max"]').val('<?php echo OneLine(Settings::Get('settings_bans_protests_max')); ?>');
</script>