<!--{"language":"design","icon":"fa-pencil-square-o","position":65}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_design_submit'])) {
            $checkboxes = array('settings_design_square', 'settings_design_banner_default', 'settings_design_snow');
            $ignore = array('settings_design_submit');

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            foreach ($_POST as $key => $postvar) {
                if (!in_array($key, $ignore) && StartsWith($key, 'settings_design_')) {
                    Settings::Set($key, $postvar);
                }
            }

            if (isset($_FILES['settings_design_banner_custom']) && !$_POST['settings_design_banner_default']) {
                if (!tempty($_FILES['settings_design_banner_custom']['name'])) {
                    $file = $_FILES['settings_design_banner_custom']['tmp_name'];
                    $file_name = $_FILES['settings_design_banner_custom']['name'];

                    $error = false;

                    if (EndsWith(strtolower($file_name), '.png')) {
                        if (!move_uploaded_file($file, 'assets/img/banner_custom.png')) {
                            $error = true;
                        }
                    } else {
                        $error = true;
                    }

                    if ($error) {
                        DirectNotifications::Queue('title: "'.Lang('error').'", text: "'.Lang('fileupload_error').'", type: "error"');
                    }
                }
            } elseif ($_POST['settings_design_banner_default']) {
                if (file_exists('assets/img/banner_custom.png')) {
                    unlink('assets/img/banner_custom.png');
                    Redirect('index.php?t=admin_settings&part=design');
                }
            }

            DirectNotifications::Queue('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');

            Redirect('index.php?t=admin_settings&part=design');
        }

        if (isset($_POST['settings_design_externalurl_create_modal_submit'])) {
            $title = htmlspecialchars($_POST['settings_design_externalurl_create_modal_title']);
            $icon = htmlspecialchars($_POST['settings_design_externalurl_create_modal_icon']);
            $position = $_POST['settings_design_externalurl_create_modal_position'];
            $place = $_POST['settings_design_externalurl_create_modal_place'];
            $newtab = (isset($_POST['settings_design_externalurl_create_modal_newtab']) ? 1 : 0);
            $url = htmlspecialchars($_POST['settings_design_externalurl_create_modal_url']);

            if (!empty($title) && !empty($icon) && !empty($position) && !empty($url) && !empty($place)) {
                if (ExternalUrls::Create($title, $icon, $position, $place, $url, $newtab)) {
                    DirectNotifications::Queue('title: "'.Lang('success').'", text: "'.Lang('externalurl_created_success').'", type: "success"');
                } else {
                    DirectNotifications::Queue('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
                }
            }

            Redirect('index.php?t=admin_settings&part=design');
        } elseif (!empty($_POST['settings_design_externalurl_delete'])) {
            if (ExternalUrls::Delete($_POST['settings_design_externalurl_delete'])) {
                DirectNotifications::Queue('title: "'.Lang('success').'", text: "'.Lang('externalurl_deleted_success').'", type: "success"');
            } else {
                DirectNotifications::Queue('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
            }

            Redirect('index.php?t=admin_settings&part=design');
        }
    }
?>

<script src="assets/js/fontawesome-iconpicker.min.js"></script>
<link rel="stylesheet" href="assets/css/fontawesome-iconpicker.min.css">

<script src="assets/js/codemirror/codemirror.js"></script>
<link rel="stylesheet" href="assets/css/codemirror/codemirror.css">
<script src="assets/js/codemirror/modes/css.js"></script>

<link rel="stylesheet" href="assets/css/bootstrap.colorpickersliders.css">
<script src='assets/js/bootstrap.colorpickersliders.js'></script>
<script src='assets/js/tinycolor-min.js'></script>

<h3>
    <?php echo Lang('design'); ?>
    <div class="pull-right">
		<button onclick="settings_design_externalurl_create();" type="button" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> <?php echo Lang('externalurl_create'); ?></button>
	</div>
</h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=design" enctype="multipart/form-data">
            <div class="row">
                <div class="col-sm-4">
                    <!-- Theme -->
                    <label><?php echo Lang('theme'); ?></label><br>
                    <select name="settings_design_theme" type="text" class="form-control">
                        <?php
                            foreach ($themeManager->files as $file) {
                                echo '<option>'.$file['rawname'].'</option>';
                            }
                        ?>
                    </select>
                </div>
                <div class="col-sm-4">
                    <!-- Color / Exttra-->
                    <label><?php echo Lang('color'); ?> / <?php echo Lang('extra'); ?></label><br>
                    <input name="settings_design_color" type="text" class="form-control" placeholder="#337AB7">
                </div>
                <div class="col-sm-4">
                    <!-- Square Design -->
                    <label><?php echo Lang('square_design'); ?></label><br>
                    <?php CreateCheckBox('primary', 'settings_design_square', '', Lang('square_design_use')); ?>
                </div>
            </div>

            <br />

            <!-- Banner -->
            <label><?php echo Lang('banner'); ?></label><div class="pull-right"><?php CreateTooltip(Lang('hint_png'), 'left'); ?></div>
            <div class="row">
                <div class="col-md-5">
                    <?php CreateCheckBox('primary', 'settings_design_banner_default', '', Lang('use_default')); ?>
                </div>
                <div class="col-md-2 text-center">
                    <b><?php echo Lang('or'); ?></b>
                </div>
                <div class="col-md-5">
                    <input name="settings_design_banner_custom" type="file" accept="image/x-png" />
                </div>
            </div>

            <br />

            <label><?php echo Lang('custom_css'); ?></label><br>
	        <textarea id="settings_design_css" name="settings_design_css" style="display:none;"></textarea>
	        <br />
	        
	        <label><?php echo Lang('snow'); ?></label><br>
	        <?php CreateCheckBox('primary', 'settings_design_snow', '', Lang('snow_effect_enable')); ?>
	        <br />

            <!-- Submit Button -->
            <button name="settings_design_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>

        <br /><br/>
    
        <div class="table-responsive">
            <table class="table table-hover">
            	<caption><?php echo Lang('external_urls'); ?></caption>
    
            	<tr class="active">
            		<th><?php echo Lang('title'); ?></th>
            		<th><?php echo Lang('icon'); ?></th>
            		<th><?php echo Lang('position'); ?> <a target="_blank" href="http://image.prntscr.com/image/24f7cc894287474c91f29556c18bdd6a.png">?</a></th>
            		<th><?php echo Lang('url'); ?></th>
            		<th><?php echo Lang('new_tab'); ?></th>
            		<th class="text-right"><i class="fa fa-cogs"></i></th>
            	</tr>
    
            	<tbody>
            		<?php
                        foreach (ExternalUrls::GetAll() as $exturl) {
                            echo '<tr>';
                            echo '<td>';
                            echo $exturl['title'];
                            echo '</td>';
                            echo '<td>';
                            echo '<i class="fa '.$exturl['icon'].'"></i>';
                            echo '</td>';
                            echo '<td>';
                            echo $exturl['position'].' | '.$exturl['place'];
                            echo '</td>';
                            echo '<td>';
                            echo $exturl['url'];
                            echo '</td>';
                            echo '<td>';
                            echo '<i class="fa fa-'.($exturl['newtab'] ? 'check-square-o' : 'square-o').'"></i>';
                            echo '</td>';
                            echo '<td class="text-right">';
                            echo '<button onclick="settings_design_externalurl_delete('.$exturl['id'].');" type="button" class="btn btn-danger btn-xs"><i class="fa fa-trash"></i> '.Lang('delete').'</button>';
                            echo '</td>';
                            echo '</tr>';
                        }
                    ?>
            	</tbody>
            </table>
        </div>
    </div>
</div>

<!-- External URL Create Modal -->
<div class="modal fade" id="settings_design_externalurl_create_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-link"></i> &nbsp;<?php echo Lang('externalurl_create'); ?></h4>
			</div>

			<form method="post" action="index.php?t=admin_settings&part=design">
				<div class="modal-body">
		            <label><?php echo Lang('title'); ?></label><br>
		            <input name="settings_design_externalurl_create_modal_title" type="text" class="form-control" />
		            <br>

		            <label><?php echo Lang('icon'); ?></label><br>
		            <div class="input-group">
                        <input data-placement="bottomRight" id="settings_design_externalurl_create_modal_icon" name="settings_design_externalurl_create_modal_icon" type="text" class="form-control"/>
                        <span class="input-group-addon"></span>
                    </div>

		            <br>

		            <label><?php echo Lang('position'); ?></label><br>
		            <div class="row">
		                <div class="col-sm-4">
                            <input name="settings_design_externalurl_create_modal_position" type="text" value="10" class="form-control" />
		                </div>
		                <div class="col-sm-4">
		                    <select name="settings_design_externalurl_create_modal_place" type="text" class="form-control">
		                        <option>main</option>
		                        <option>help</option>
		                        <option>admin</option>
		                        <option>user</option>
                            </select>
		                </div>
		                <div class="col-sm-4">
                            <?php CreateCheckBox('primary', 'settings_design_externalurl_create_modal_newtab', '', Lang('open_new_tab')); ?>
		                </div>
		            </div>

		            <br />

		            <label><?php echo Lang('url'); ?></label><br>
		            <input name="settings_design_externalurl_create_modal_url" type="text" placeholder="https://www.example.com" class="form-control"/>
				</div>
				<div class="modal-footer">
					<button type="submit" name="settings_design_externalurl_create_modal_submit" class="btn btn-success"><?php echo Lang('create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script>
    $('select[name="settings_design_theme"]').val('<?php echo OneLine(Settings::Get('settings_design_theme')); ?>');
    $('input[name="settings_design_square"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_design_square')); ?>);
    $('input[name="settings_design_banner_default"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_design_banner_default')); ?>);
    $('input[name="settings_design_snow"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_design_snow')); ?>);

    $('#settings_design_externalurl_create_modal_icon').iconpicker();

    $("input[name='settings_design_externalurl_create_modal_position']").TouchSpin({
        min: 0,
        max: 2000000000,
        step: 10,
        forcestepdivisibility: 'none',
        verticalbuttons: true
    });

    var color = '<?php echo OneLine(Settings::Get('settings_design_color')); ?>';

    if(color.length <= 9){
        $('input[name="settings_design_color"]').ColorPickerSliders({
            color: color,
            previewformat: 'hex',
            sliders: false,
            swatches: false,
            hsvpanel: true
        });
    }else{
        $('input[name="settings_design_color"]').val(color);
    }

    var cssEditor = CodeMirror.fromTextArea($('textarea[name="settings_design_css"]').get(0), {
    	lineNumbers: true,
    	mode: 'css',
    	indentUnit: 4
    });

    var textarr = <?php echo ToJson(array('text' => Settings::Get('settings_design_css'))); ?>

    cssEditor.setOption('value', textarr['text']);

    function settings_design_externalurl_delete(id){
        post('index.php?t=admin_settings&part=design', {settings_design_externalurl_delete: id});
    }

    function settings_design_externalurl_create(){
    	$('input[name="settings_design_externalurl_create_modal_newtab"]').prop('checked', true);
        $('#settings_design_externalurl_create_modal').modal('show');
    }
</script>