<!--{"language":"discord","icon":"fa-comments-o","position":82}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_discord_submit'])) {
            foreach ($_POST as $key => $postvar) {
                if ('settings_discord_submit' != $key && StartsWith($key, 'settings_discord_')) {
                    Settings::Set($key, $postvar);
                }
            }
            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        }
    }
?>

<h3><?php echo Lang('discord'); ?></h3>

<hr>

<div class="row">
    <div class="col-xs-12">

        <div class="alert alert-info alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"><i class="fa fa-times"></i></span></button><?php echo Lang('see_instructions_wiki'); ?> <a target="_blank" href="https://gextension.ibot3.de/wiki/index.php?title=Discord">Discord</a></div>
        
        <div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"><i class="fa fa-times"></i></span></button><?php echo Lang('discord_rank_hierarchy_warning'); ?></div>

        <form method="post" action="index.php?t=admin_settings&part=discord">
			<!-- guild_id -->
            <label><?php echo Lang('guild_id'); ?></label><br>
            <input name="settings_discord_guild_id" type="text" class="form-control">
            
            <br/>
            
            <!-- app_client_id -->
            <label><?php echo Lang('app_client_id'); ?></label><br>
            <input name="settings_discord_app_client_id" type="text" class="form-control">
            
            <br/>

			<!-- bot_token -->
            <label><?php echo Lang('bot_token'); ?></label><br>
            <input name="settings_discord_bot_token" type="text" class="form-control">

            <br/>
            
            <div class="row">
                <div class="col-xs-6">
                    <!-- Submit Button -->
                    <button name="settings_discord_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
                </div>
                
                <div class="col-xs-6">
                    <button <?php echo !empty(Settings::Get('settings_discord_app_client_id')) ? '' : 'disabled'; ?> onclick="OpenInNewTab('<?php echo sprintf('https://discordapp.com/oauth2/authorize?client_id=%s&scope=bot&permissions=268438544', Settings::Get('settings_discord_app_client_id')); ?>');" class="btn btn-success pull-right"><?php echo Lang('add_bot_to_guild'); ?></a>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    $('input[name="settings_discord_guild_id"]').val('<?php echo OneLine(Settings::Get('settings_discord_guild_id')); ?>');
    $('input[name="settings_discord_app_client_id"]').val('<?php echo DemoLock() ? 'hidden' : OneLine(Settings::Get('settings_discord_app_client_id')); ?>');
    $('input[name="settings_discord_bot_token"]').val('<?php echo DemoLock() ? 'hidden' : OneLine(Settings::Get('settings_discord_bot_token')); ?>');
</script>