<!--{"language":"shop","icon":"fa-money","position":40}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    $packageschanged = false;

    if (!DemoLock()) {
        if (isset($_POST['settings_donations_submit'])) {
            $checkboxes = array('settings_donations_enabled', 'settings_donations_event_enabled', 'settings_donations_invoices', 'settings_donations_donatedmessage', 'settings_donations_taxes_add', 'settings_donations_footerlogos', 'settings_donations_shop', 'settings_donations_statistics', 'settings_donations_taxes_unknown_block', 'settings_donations_taxes_euvat', 'settings_donations_details_not_public');
            $html_validation = array('settings_donations_cancellation_terms', 'settings_donations_description');

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            foreach ($_POST as $key => $val) {
                if ('settings_donations_submit' != $key && StartsWith($key, 'settings_donations_')) {
                    if (StartsWith($key, 'settings_donations_')) {
                        if (in_array($key, $html_validation)) {
                            $val == ValidateHTML($val);
                        }

                        Settings::Set($key, $val);
                    }
                }
            }
            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        } elseif (isset($_POST['settings_donations_paymentgateways_submit'])) {
            $checkboxes = array('settings_donations_paypal_sandbox', 'settings_donations_g2apay_sandbox',  'settings_donations_payssion_sandbox');
            $gateways = Gateway::GetAll();

            foreach ($gateways as $gateway) {
                $checkboxes[] = 'settings_donations_gateways_'.$gateway->GetValue('name');
            }

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            $payssion_methods = array();

            foreach ($_POST as $key => $val) {
                if ('settings_donations_paymentgateways_submit' != $key && StartsWith($key, 'settings_donations_')) {
                    if (StartsWith($key, 'settings_donations_gateways_')) {
                        $gateway = new Gateway(substr($key, 28));

                        if ($gateway->valid) {
                            $gateway->SetValue('enabled', $val);
                        }
                    } elseif (StartsWith($key, 'settings_donations_payssion_method_')) {
                        $payssion_methods[] = substr($key, 35);
                    } elseif (StartsWith($key, 'settings_donations_')) {
                        Settings::Set($key, $val);
                    }
                }
            }

            Settings::Set('settings_donations_payssion_methods', ToJson($payssion_methods));

            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        } elseif (isset($_POST['settings_donations_email_submit'])) {
            $checkboxes = array('settings_donations_email_required', 'settings_donations_email_enabled');

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            foreach ($_POST as $key => $val) {
                if ('settings_donations_email_submit' != $key && StartsWith($key, 'settings_donations_')) {
                    if (StartsWith($key, 'settings_donations_')) {
                        if (is_array($val)) {
                            $val = ToJson($val);
                        }

                        Settings::Set($key, $val);
                    }
                }
            }

            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        } elseif (isset($_POST['settings_donations_packages_modal_editadd_submit']) || isset($_POST['settings_donations_packages_modal_editadd_submit_copy'])) {
            $packageschanged = true;

            $packageid = -1;

            $data = array();

            $general = array();
            $rewards = array();
            $extra = array('incompatible' => array(), 'disable' => array(),  'upgrade_from' => array(), 'required' => array());

            $checkboxes = array_merge(array('settings_donations_packages_modal_editadd_general_active', 'settings_donations_packages_modal_editadd_general_price_custom'), Rewards::GetSelectorCheckboxes());

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            foreach ($_POST as $key => $val) {
                if (StartsWith($key, 'settings_donations_packages_modal_editadd_general_')) {
                    $general[substr($key, 50)] = $val;
                } elseif (StartsWith($key, 'rewardselector_')) {
                    $rewards[substr($key, 15)] = $val;
                } elseif (StartsWith($key, 'settings_donations_packages_modal_editadd_extra_incompatible_')) {
                    $extra['incompatible'][] = substr($key, 61);
                } elseif (StartsWith($key, 'settings_donations_packages_modal_editadd_extra_disable_')) {
                    $extra['disable'][] = substr($key, 56);
                } elseif (StartsWith($key, 'settings_donations_packages_modal_editadd_extra_upgrade_from_')) {
                    $extra['upgrade_from'][] = substr($key, 61);
                } elseif (StartsWith($key, 'settings_donations_packages_modal_editadd_extra_required_')) {
                    $extra['required'][] = substr($key, 57);
                }
            }

            $data = array_merge($data, $general);

            $data['title'] = htmlspecialchars($data['title']);
            $data['subtitle'] = htmlspecialchars($data['subtitle']);
            $data['category'] = htmlspecialchars($data['category']);
            $data['description'] = ValidateHTML($data['description']);
            $data['rewards'] = ToJson($rewards);
            $data['incompatible'] = ToJson($extra['incompatible']);
            $data['disable'] = ToJson($extra['disable']);
            $data['upgrade_from'] = ToJson($extra['upgrade_from']);
            $data['required'] = ToJson($extra['required']);
            $data['orderid'] = 0;

            if (!empty($_POST['settings_donations_packages_modal_editadd_packageid'])) {
                $packageid = $_POST['settings_donations_packages_modal_editadd_packageid'];
            }

            if ($packageid == -1 || isset($_POST['settings_donations_packages_modal_editadd_submit_copy'])) {
                if (Package::Create($data)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('package_created_success').'", type: "success"');
                }
            } else {
                $package = new Package($packageid);

                if ($package->valid) {
                    if ($package->Update($data)) {
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
                    }
                }
            }
        } elseif (isset($_POST['settings_donations_package_delete_id'])) {
            $packageschanged = true;

            if (is_numeric($_POST['settings_donations_package_delete_id'])) {
                $package = new Package($_POST['settings_donations_package_delete_id']);

                if ($package->valid && $package->Delete()) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('package_deleted_success').'", type: "success"');
                }
            }
        }
    }
?>

<!-- Summernote CSS -->
<link rel="stylesheet" href="assets/css/summernote.css" />
<!-- Bootstrap Multiselect CSS -->
<link rel="stylesheet" href="assets/css/bootstrap-multiselect.css">

<!-- Bootstrap Multiselect JS -->
<script src="assets/js/bootstrap-multiselect.js"></script>
<!-- Typeahead JS -->
<script type="text/javascript" src="assets/js/bootstrap3-typeahead.min.js"></script>
<!-- Summernote JS-->
<script src="assets/js/summernote.min.js"></script>
<!-- Sortable JS-->
<script src="assets/js/sortable.js"></script>
<!-- DatePicker JS-->
<script src="assets/js/bootstrap-datepicker.js"></script>

<div class="row">
	<div class="col-xs-12">
		<h3>
			<?php echo Lang('donations'); ?>
		</h3>
	</div>
</div>

<hr>

<div class="row">
	<div class="col-xs-12">
		<ul id="admin_settings_donations_menu" class="nav nav-tabs" role="tablist">
		    <li role="presentation" class="active"><a href="#settings_donations_general" role="tab" data-toggle="tab"><i class="fa fa-wrench"></i> <?php echo Lang('general'); ?></a></li>
		    <li role="presentation"><a href="#settings_donations_paymentgateways" role="tab" data-toggle="tab"><i class="fa fa-money"></i> <?php echo Lang('payment_gateways'); ?></a></li>
		    <li role="presentation"><a href="#settings_donations_packages" role="tab" data-toggle="tab"><i class="fa fa-archive"></i> <?php echo Lang('packages'); ?></a></li>
		    <li role="presentation"><a href="#settings_donations_email" role="tab" data-toggle="tab"><i class="fa fa-envelope"></i> <?php echo Lang('email'); ?></a></li>
		</ul>

		<!-- Tab panes -->
		<div class="tab-content">
		    <div role="tabpanel" class="tab-pane active" id="settings_donations_general">
		    	<br>

				<div class="row">
					<form method="post" action="index.php?t=admin_settings&part=donations&subpart=general">
						<div class="col-xs-12">
							<!-- Enabled -->
				        	<label><?php echo Lang('enabled'); ?></label>
					        <?php CreateCheckbox('primary', 'settings_donations_enabled', '', Lang('donations_enabled')); ?>
				            <br>


				            <div class="row">
				            	<!-- Currency -->
				            	<div class="col-sm-4 col-xs-6">
				            		<label><?php echo Lang('currency_code'); ?></label><br>
					            	<input name="settings_donations_currency_plain" type="text" maxlength="3" class="form-control" placeholder="<?php echo Lang('currency'); ?> (USD)">
					            </div>
					            <div class="col-sm-4 col-xs-6">
					            	<label><?php echo Lang('currency_symbol'); ?></label><br>
					            	<input name="settings_donations_currency" type="text" class="form-control" placeholder="<?php echo Lang('currency_icon'); ?> ($)">
					            </div>

						        <!-- Monthly Goal -->
						        <div class="col-sm-4 col-xs-12">
						            <label><?php echo Lang('monthly_goal'); ?></label><br>
							        <input name="settings_donations_monthlygoal" type="text" class="form-control" placeholder="<?php echo Lang('monthly_goal'); ?>">
				            	</div>
				            </div>
				            <br>

				        	<label><?php echo Lang('other'); ?></label>
				        	<!-- Footer logos -->
					        <?php CreateCheckbox('primary', 'settings_donations_footerlogos', '', Lang('footer_gatewaylogos_enable')); ?>
				            <!-- Shop logos -->
					        <?php CreateCheckbox('primary', 'settings_donations_shop', '', Lang('shop_instead_donate')); ?>
					        <!-- Statistics -->
					        <?php CreateCheckbox('primary', 'settings_donations_statistics', '', Lang('enable_top_latest_donations')); ?>
					        <!-- Donatedmessage -->
					        <?php CreateCheckbox('primary', 'settings_donations_donatedmessage', '', Lang('donatedmessage_enabled').' (GMOD)'); ?>
					        <!-- Invoices -->
					        <?php CreateCheckbox('primary', 'settings_donations_invoices', '', Lang('invoices_enable')); ?>
					        <!-- Details not public -->
					        <?php CreateCheckbox('primary', 'settings_donations_details_not_public', '', Lang('donation_details_not_public')); ?>
					        <br />

					        <label><?php echo Lang('business_address').' '.Lang('required_for_invoices'); ?></label>
					        <textarea rows="5" class="form-control" name="settings_donations_invoice_business" placeholder="{Business Name}
{Business Address}
{Business ZIP + City}
{Business Country}
[TaxID]"></textarea>

							<br />

					        <!-- Taxes -->
					        <label><?php echo Lang('taxes'); ?></label><br>

							<input type="hidden" name="settings_donations_taxes_countryspecific" />
					        <table class="table table-responsive table-hover">
								<caption><?php echo Lang('country_specific_values'); ?> <span class="pull-right"><button type="button" class="btn btn-xs btn-success" onclick="settings_donations_taxes_countryspecific_add('', '', '');"><i class="fa fa-plus-circle"></i></button></span></caption>

								<tr class="active">
									<th style="width: 30%;"><?php echo Lang('country'); ?></th>
									<th style="width: 10%;"><?php echo Lang('tax'); ?> %</th>
									<th><?php echo Lang('note'); ?></th>
									<th style="width: 2%;" class="text-right"><i class="fa fa-trash"></i></th>
								</tr>

								<tbody id="settings_donations_taxes_countryspecific_table">

								</tbody>
							</table>

							<?php CreateCheckbox('primary', 'settings_donations_taxes_add', '', Lang('taxes_add')); ?>

							<?php CreateCheckbox('primary', 'settings_donations_taxes_euvat', '', Lang('euvat_enable')); ?>

							<?php CreateCheckbox('primary', 'settings_donations_taxes_unknown_block', '', Lang('taxes_block_unknown')); ?>

							<br />

				            <!-- Description -->
				            <label><?php echo Lang('description'); ?></label><br>
				            <textarea name="settings_donations_description"></textarea >
				            
				            <br />

				            <!-- cancellation_terms -->
				            <label><?php echo Lang('cancellation_terms'); ?></label><br>
				            <textarea name="settings_donations_cancellation_terms"></textarea >
				            
				            <br/>
				            
				            <!-- checkboxes -->
				            <label><?php echo Lang('checkboxes'); ?></label><br>
				            <textarea class="form-control" name="settings_donations_checkboxes"></textarea>

				            <hr>

							<!-- Event Goal -->
				            <div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<i class="fa fa-star"></i>
										<a role="button" data-toggle="collapse" href="#settings_donations_event_collapse">
											<?php echo Lang('event'); ?>
										</a>
									</h4>
								</div>
								<div id="settings_donations_event_collapse" class="panel-collapse collapse">
									<div class="panel-body">
							            <div class="row">
							            	<div class="col-xs-6">
							            		<label><?php echo Lang('enabled'); ?></label>
								     			<?php CreateCheckbox('primary', 'settings_donations_event_enabled', '', Lang('event_goal')); ?>
							            	</div>

							            	<div class="col-xs-6">
							            		<label><?php echo Lang('name'); ?></label><br>
									        	<input name="settings_donations_event_name" type="text" class="form-control" placeholder="<?php echo Lang('event_name'); ?>">
							            	</div>
							            </div>

							            <br>


					            		<label><?php echo Lang('goal'); ?></label><br>
								        <input name="settings_donations_event_goal" type="text" value="50" class="form-control">
						            	<br>

							            <div class="row">
							            	<div class="col-xs-6">
							            		<label><?php echo Lang('begin'); ?></label><br>
									        	<input name="settings_donations_event_begin" type="text" class="form-control datepicker">
							            	</div>

							            	<div class="col-xs-6">
							            		<label><?php echo Lang('deadline'); ?></label><br>
									        	<input name="settings_donations_event_deadline" type="text" class="form-control datepicker">
							            	</div>
							            </div>
									</div>
								</div>
							</div>

				            <!-- Submit Button -->
				            <button name="settings_donations_submit" type="submit" onclick="settings_donations_taxes_countryspecific_save();" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				    	</div>
				     </form>
				</div>
		    </div>
		    <div role="tabpanel" class="tab-pane" id="settings_donations_paymentgateways">
		    	<form method="post" action="index.php?t=admin_settings&part=donations&subpart=paymentgateways">
		    		<br>
		    		<label><?php echo Lang('payment_gateways'); ?></label><br>
			    	<?php
                        foreach (Gateway::GetAll() as $gateway) {
                            CreateCheckbox('primary', 'settings_donations_gateways_'.$gateway->GetValue('name'), '', $gateway->GetValue('text_display'));
                        }
                    ?>
	                
	                <hr/>
	                
	                <div class="alert alert-info alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"><i class="fa fa-times"></i></span></button><?php echo Lang('testlogin_hint'); ?></div>
	                
	                <!-- Paypal -->
		            <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-paypal"></i>
								<a role="button" data-toggle="collapse" href="#settings_donations_paypal_collapse">
									PayPal
								</a>
							</h4>
						</div>
						<div id="settings_donations_paypal_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>E-Mail</label><br>
						        <input name="settings_donations_paypal_email" type="text" class="form-control" placeholder="paypal@email.com">
					            <br>
	
					            <label>Sandbox</label>
						        <?php CreateCheckbox('primary', 'settings_donations_paypal_sandbox', '', 'Sandbox mode'); ?>
						        <br>
	
						        <label>IPN URL</label><br>
						        <a target="_blank" href="https://www.paypal.com/cgi-bin/customerprofileweb?cmd=_profile-ipn-notify"><?php echo Lang('set_ipn_url').'</a>: '.GetCurrentLocation().'request.php?t=ipn_paypal'; ?>
							</div>
						</div>
					</div>
	
					<!-- G2APay -->
		            <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-star"></i>
								<a role="button" data-toggle="collapse" href="#settings_donations_g2apay_collapse">
									G2APay
								</a>
							</h4>
						</div>
						<div id="settings_donations_g2apay_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>E-Mail</label><br>
						        <input name="settings_donations_g2apay_email" type="text" class="form-control" placeholder="g2apay@email.com">
					            <br>
	
					            <label>Secret Key</label><br>
						        <input name="settings_donations_g2apay_secret" type="text" class="form-control" placeholder="">
					            <br>
	
					            <label>API Hash</label><br>
						        <input name="settings_donations_g2apay_apihash" type="text" class="form-control" placeholder="">
					            <br>
	
					            <label>Sandbox</label>
						        <?php CreateCheckbox('primary', 'settings_donations_g2apay_sandbox', '', 'Sandbox mode'); ?>
						        <br>
	
						        <label>IPN URL</label><br>
						        <a target="_blank" href="https://pay.g2a.com/setting/merchant"><?php echo Lang('set_ipn_url').'</a>: '.GetCurrentLocation().'request.php?t=ipn_g2apay'; ?>
							</div>
						</div>
					</div>
	
					<!-- Paysafecard -->
		            <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-credit-card-alt"></i>
								<a role="button" data-toggle="collapse" href="#settings_donations_paysafecard_collapse">
									Paysafecard
								</a>
								<span class="pull-right"><?php CreateTooltip(Lang('psc_ignore_if_not_partner'), 'left'); ?></span>
							</h4>
						</div>
						<div id="settings_donations_paysafecard_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>API Key</label><br>
						        <input name="settings_donations_paysafecard_key" type="text" class="form-control" placeholder="psc_xxx">
					            <br>
	
					            <label><?php echo Lang('environment'); ?></label>
						        <select name="settings_donations_paysafecard_environment" class="form-control">
						        	<option>TEST</option>
						        	<option>PRODUCTION</option>
						        </select>
							</div>
						</div>
					</div>
	
					<!-- Payssion -->
		            <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-globe"></i>
								<a role="button" data-toggle="collapse" href="#settings_donations_payssion_collapse">
									Payssion
								</a>
							</h4>
						</div>
						<div id="settings_donations_payssion_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>API Key</label><br>
						        <input name="settings_donations_payssion_apikey" type="text" class="form-control" placeholder="API Key">
					            <br>
	
					            <label>Secret Key</label><br>
						        <input name="settings_donations_payssion_secretkey" type="text" class="form-control" placeholder="Secret Key">
					            <br>
	
					            <label>Sandbox</label>
						        <?php CreateCheckbox('primary', 'settings_donations_payssion_sandbox', '', 'Sandbox mode'); ?>
						        <br>
	
						        <label>Notify URL</label><br>
						        <?php echo Lang('set_ipn_url').': '.GetCurrentLocation().'request.php?t=ipn_payssion'; ?>
						        <br/> <br/>
	
						        <label>Return URL</label><br>
						        <?php echo Lang('set_return_url').': '.GetCurrentLocation().'index.php?t=purchase&gateway=payssion'; ?>
						        <br/> <br/>
	
					            <div class="panel panel-default">
									<div class="panel-heading">
										<h4 class="panel-title">
											<i class="fa fa-sign-out"></i>
											<a role="button" data-toggle="collapse" href="#settings_donations_payssion_methods_collapse">
												Payment Methods
											</a>
										</h4>
									</div>
									<div id="settings_donations_payssion_methods_collapse" class="panel-collapse collapse">
										<div class="panel-body row">
											<?php
                                                $methods = Payssion::GetPaymentMethods(true);
                                                $methods_active = FromJson(Settings::Get('settings_donations_payssion_methods'));

                                                foreach ($methods as $country => $cmethods) {
                                                    echo '<div class="col-xs-12"><label><b>'.$country.'</b></label></div>';

                                                    foreach ($cmethods as $method_id => $method) {
                                                        $checked = false;

                                                        if (in_array($method_id, $methods_active)) {
                                                            $checked = true;
                                                        }

                                                        echo '<div class="col-xs-12 col-sm-4">';
                                                        CreateCheckbox('primary', 'settings_donations_payssion_method_'.$method_id, 'settings_donations_payssion_method', $method, '', '', $checked);
                                                        echo '</div>';
                                                    }
                                                }
                                            ?>
										</div>
									</div>
								</div>
	
							</div>
						</div>
					</div>
	
					<!-- Stripe -->
		            <div class="panel panel-default">
						<div class="panel-heading">
							<h4 class="panel-title">
								<i class="fa fa-cc-stripe"></i>
								<a role="button" data-toggle="collapse" href="#settings_donations_stripe_collapse">
									Stripe
								</a>
							</h4>
						</div>
						<div id="settings_donations_stripe_collapse" class="panel-collapse collapse">
							<div class="panel-body">
								<label>Public Key</label><br>
						        <input name="settings_donations_stripe_publickey" type="text" class="form-control" placeholder="pk_">
					            <br>
	
					            <label>Secret Key</label><br>
						        <input name="settings_donations_stripe_secretkey" type="text" class="form-control" placeholder="sk_">
							</div>
						</div>
					</div>
					
					<!-- Submit Button -->
					<button name="settings_donations_paymentgateways_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</form>
		    </div>
		    <div role="tabpanel" class="tab-pane" id="settings_donations_email">
		    	<form method="post" action="index.php?t=admin_settings&part=donations&subpart=email">
		    		<br/>

			        <?php CreateCheckbox('primary', 'settings_donations_email_enabled', '', Lang('enabled')); ?>
			        <?php CreateCheckbox('primary', 'settings_donations_email_required', '', Lang('email_required')); ?>
		            <br>
		            
		            <!-- Subject -->
		            <label><?php echo Lang('subject'); ?></label><br>
			        <input name="settings_donations_email_subject" type="text" class="form-control">
		            <br>
		            
		            <!-- Content -->
		            <label><?php echo Lang('content'); ?></label><br>
		            <b><?php echo Lang('available'); ?>:</b> %nick%, %amount%, %package_name%, %invoice_url%
		            <textarea name="settings_donations_email_content"></textarea>
		            <br/>
		            
		            <!-- Attachments -->
		            <label><?php echo Lang('attachments'); ?></label><br>
					<select name="settings_donations_email_attachments[]" id="settings_donations_email_attachments" multiple>
						<option value="tos"><?php echo Lang('tos'); ?></option>
						<option value="cancellation_terms"><?php echo Lang('cancellation_terms'); ?></option>
					</select>
					
					<br/>
					<br/>
					
					<!-- Submit Button -->
					<button name="settings_donations_email_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
		    	</form>
		    </div>
		    <div role="tabpanel" class="tab-pane" id="settings_donations_packages">
				<br>

				<?php
                    $packagedata = '';

                    $makerow = true;
                    $count = 0;

                    $serverbundles = Serverbundle::GetAll(true);

                    foreach ($serverbundles as $bundle) {
                        ++$count;

                        if ($makerow) {
                            echo '<div class="row">';
                        }

                        echo '
							<div class="col-sm-6">
								<div class="panel panel-default">
									<div class="panel-heading" style="background-color:'.$bundle->GetValue('hexcolor').'; color: white;">
										<h3 class="panel-title">
											'.$bundle->GetValue('name').'
											<a onclick="settings_donations_package_create('.$bundle->GetValue('id').');" class="clickable pull-right"><i class="fa fa-plus"></i></a>
										</h3>
									</div>
									<div class="panel-body">
										<div class="list-group sortable">

										';

                        foreach (Donations::GetPackages($bundle->GetValue('id'), false, false) as $package) {
                            $disabled = '';

                            if (!$package->GetValue('active')) {
                                $disabled = 'disabled';
                            }

                            //$package_json = str_replace('"', "\'",  json_encode($package->packagedata));
                            $package_json = ToJson($package->data);

                            $packagedata .= 'packagedata['.$package->GetValue('id').'] = '.$package_json.';';

                            echo '				<a class="clickable list-group-item settings_donations_packages_'.$bundle->GetValue('id').' '.$disabled.'" id="settings_donations_packages_package_'.$package->GetValue('id').'" onclick="settings_donations_package_select('.$package->GetValue('id').');">
													'.$package->GetValue('title').'
													<span class="pull-right">
														<i style="padding-top: 4px;" class="fa fa-sort cursor-sortable"></i>
													</span>
													</a>
													';
                        }

                        echo '			</div>

										<button onclick="settings_donations_order_save('.$bundle->GetValue('id').');" class="btn btn-sm btn-default">
											'.Lang('save').'
										</button>
									</div>
								</div>
							</div>
							';

                        if (!$makerow || sizeof($serverbundles) - $count < 1) {
                            echo '</div>';
                        }

                        $makerow = !$makerow;
                    }
                ?>
		    </div>
		</div>
	</div>
</div>


<div class="modal fade settings_donations_packages_modal_editadd" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-pencil"></i> &nbsp;<span id="settings_donations_packages_modal_editadd_title"></span></h4>
			</div>
			<form method="post" action="index.php?t=admin_settings&part=donations&subpart=packages">
				<div class="modal-body">
				    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#settings_donations_packages_modal_editadd_tabs_general" role="tab" data-toggle="tab"><i class="fa fa-wrench"></i> <?php echo Lang('general'); ?></a></li>
                        <li role="presentation"><a href="#settings_donations_packages_modal_editadd_tabs_rewards" role="tab" data-toggle="tab"><i class="fa fa-gift"></i> <?php echo Lang('rewards'); ?></a></li>
                        <li role="presentation"><a href="#settings_donations_packages_modal_editadd_tabs_extra" role="tab" data-toggle="tab"><i class="fa fa-plus-circle"></i> <?php echo Lang('extra'); ?></a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="settings_donations_packages_modal_editadd_tabs_general">
                            <br>

                            <input type="hidden" value="" name="settings_donations_packages_modal_editadd_packageid" />

        					<label><?php echo Lang('title'); ?></label><br>
        					<input class="form-control" name="settings_donations_packages_modal_editadd_general_title" />
        					<br>

        					<label><?php echo Lang('subtitle'); ?></label><br>
        					<input class="form-control" name="settings_donations_packages_modal_editadd_general_subtitle" />
        					<br>

        					<label><?php echo Lang('enabled'); ?></label><br>
        					<?php CreateCheckbox('primary', 'settings_donations_packages_modal_editadd_general_active', '', Lang('package_enabled')); ?>
        					<br>

        					<label><?php echo Lang('description'); ?></label><span class="pull-right"><?php CreateTooltip(Lang('hint_uls'), 'left'); ?></span><br>
        					<textarea name="settings_donations_packages_modal_editadd_general_description"></textarea >

        					<label><?php echo Lang('serverbundle'); ?></label><br>
        					<select class="form-control" name="settings_donations_packages_modal_editadd_general_serverbundle">
        						<?php
                                    foreach (Serverbundle::GetAll(true) as $bundle) {
                                        echo '<option value="'.$bundle->GetValue('id').'">'.$bundle->GetValue('name').'</option>';
                                    }
                                ?>
        					</select>
        					<br>

        					<label><?php echo Lang('price'); ?></label><br>
        					<div class="row">
        						<div class="col-xs-4">
        							<input class="form-control" name="settings_donations_packages_modal_editadd_general_price">
        						</div>
        						<div class="col-xs-8">
        							<?php CreateCheckbox('primary', 'settings_donations_packages_modal_editadd_general_price_custom', '', Lang('package_custom_price')); ?>
        						</div>
        					</div>
        					<br>

        					<label><?php echo Lang('package_days'); ?></label><br>
        					<input class="form-control" name="settings_donations_packages_modal_editadd_general_days">
        					<br>

        					<label><?php echo Lang('rebuyable'); ?></label><br>
        					<select name="settings_donations_packages_modal_editadd_general_rebuyable" class="form-control">
	        					<option value="0"><?php echo Lang('not_rebuyable'); ?></option>
	        					<option value="1"><?php echo Lang('rebuyable_expired'); ?></option>
	        					<option value="2"><?php echo Lang('rebuyable_active'); ?></option>
							</select>
        					<br>

        					<label><?php echo Lang('category'); ?></label><br>
        					<input class="form-control" name="settings_donations_packages_modal_editadd_general_category">

        					<script>
        						var categories = [];

        						<?php
                                    foreach (Package::GetCategories() as $category) {
                                        echo 'categories.push("'.$category.'");';
                                    }
                                ?>

        						$('input[name="settings_donations_packages_modal_editadd_general_category"]').typeahead({ source:categories, showHintOnFocus: true });
        					</script>

                        </div>
                        <div role="tabpanel" class="tab-pane" id="settings_donations_packages_modal_editadd_tabs_rewards">
                            <br>

                            <?php Rewards::LoadSelector(); ?>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="settings_donations_packages_modal_editadd_tabs_extra">
                            <br>
                            <div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<i class="fa fa-ban"></i>
										<a role="button" data-toggle="collapse" href="#settings_donations_packages_modal_editadd_extra_incompatible_collapse">
											<?php echo Lang('not_compatible'); ?>
										</a>
									</h4>
								</div>
								<div id="settings_donations_packages_modal_editadd_extra_incompatible_collapse" class="panel-collapse collapse">
									<div class="panel-body">
										<label><?php echo Lang('not_compatible_description'); ?></label><br>
										<?php
                                            foreach (Donations::GetPackages(null, false) as $package) {
                                                $bundle = new Serverbundle($package->GetValue('serverbundle'));

                                                if ($bundle->valid) {
                                                    CreateCheckbox('primary', 'settings_donations_packages_modal_editadd_extra_incompatible_'.$package->GetValue('id'), 'settings_donations_packages_modal_editadd_extra_incompatible', $package->GetValue('title').' ('.$bundle->GetValue('name').')');
                                                }
                                            }
                                        ?>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<i class="fa fa-power-off"></i>
										<a role="button" data-toggle="collapse" href="#settings_donations_packages_modal_editadd_extra_disable_collapse">
											<?php echo Lang('disable_after_buying'); ?>
										</a>
									</h4>
								</div>
								<div id="settings_donations_packages_modal_editadd_extra_disable_collapse" class="panel-collapse collapse">
									<div class="panel-body">
										<label><?php echo Lang('disable_after_buying_description'); ?></label><br>
										<?php
                                            foreach (Donations::GetPackages(null, false) as $package) {
                                                $bundle = new Serverbundle($package->GetValue('serverbundle'));

                                                if ($bundle->valid) {
                                                    CreateCheckbox('primary', 'settings_donations_packages_modal_editadd_extra_disable_'.$package->GetValue('id'), 'settings_donations_packages_modal_editadd_extra_disable', $package->GetValue('title').' ('.$bundle->GetValue('name').')');
                                                }
                                            }
                                        ?>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<i class="fa fa-level-up"></i>
										<a role="button" data-toggle="collapse" href="#settings_donations_packages_modal_editadd_extra_upgrade_from_collapse">
											<?php echo Lang('upgrade_from'); ?>
										</a>
									</h4>
								</div>
								<div id="settings_donations_packages_modal_editadd_extra_upgrade_from_collapse" class="panel-collapse collapse">
									<div class="panel-body">
			        					<label><?php echo Lang('upgrade_from_description'); ?></label><br>
										<?php
                                            foreach (Donations::GetPackages(null, false) as $package) {
                                                $bundle = new Serverbundle($package->GetValue('serverbundle'));

                                                if ($bundle->valid) {
                                                    CreateCheckbox('primary', 'settings_donations_packages_modal_editadd_extra_upgrade_from_'.$package->GetValue('id'), 'settings_donations_packages_modal_editadd_extra_upgrade_from', $package->GetValue('title').' ('.$bundle->GetValue('name').')');
                                                }
                                            }
                                        ?>
									</div>
								</div>
							</div>
							<div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<i class="fa fa-check-square-o"></i>
										<a role="button" data-toggle="collapse" href="#settings_donations_packages_modal_editadd_extra_required_collapse">
											<?php echo Lang('required'); ?>
										</a>
									</h4>
								</div>
								<div id="settings_donations_packages_modal_editadd_extra_required_collapse" class="panel-collapse collapse">
									<div class="panel-body">
			        					<label><?php echo Lang('required_description'); ?></label><br>
										<?php
                                            foreach (Donations::GetPackages(null, false) as $package) {
                                                $bundle = new Serverbundle($package->GetValue('serverbundle'));

                                                if ($bundle->valid) {
                                                    CreateCheckbox('primary', 'settings_donations_packages_modal_editadd_extra_required_'.$package->GetValue('id'), 'settings_donations_packages_modal_editadd_extra_required', $package->GetValue('title').' ('.$bundle->GetValue('name').')');
                                                }
                                            }
                                        ?>
									</div>
								</div>
							</div>
                        </div>
                    </div>
				</div>
				<div class="modal-footer">
					<button type="button" onclick="settings_donations_package_delete();" name="settings_donations_packages_modal_editadd_submit_delete" class="btn btn-danger"><?php echo Lang('delete'); ?></button>
					<button type="submit" name="settings_donations_packages_modal_editadd_submit_copy" class="btn btn-warning"><?php echo Lang('copy'); ?></button>
					<button type="submit" name="settings_donations_packages_modal_editadd_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<script src="assets/js/countrycodes.js"></script>

<script>
	<?php
        if (isset($_GET['subpart'])) {
            echo 'activateTab("settings_donations_'.$_GET['subpart'].'")';
        }
    ?>

	var packagedata = {};

	<?php echo $packagedata; ?>

	$('textarea[name="settings_donations_packages_modal_editadd_general_description"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});

	$('textarea[name="settings_donations_description"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});
	
	$('textarea[name="settings_donations_cancellation_terms"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	})
	
	;$('textarea[name="settings_donations_email_content"]').summernote({
		height: 200,
		toolbar: summernote_toolbar_default
	});
	
	$('#settings_donations_email_attachments').multiselect();

	$('.sortable').each(function(i, obj){
		new Sortable(obj);
	});

	$(".rewards-spin").TouchSpin({
        min: 0,
    	step: 5,
    	forcestepdivisibility: 'none',
        verticalbuttons: true,
    });

	$("input[name='settings_donations_packages_modal_editadd_general_price']").TouchSpin({
        min: 0,
        max: 100000,
    	step: 5,
    	forcestepdivisibility: 'none',
        decimals: 2,
        verticalbuttons: true,
        prefix: '<?php echo Settings::Get('settings_donations_currency_plain'); ?>'
    });

	$("input[name='settings_donations_packages_modal_editadd_general_days']").TouchSpin({
        min: 0,
        max: 100000,
        step: 10,
        forcestepdivisibility: 'none',
        verticalbuttons: true,
        prefix: '<i class="fa fa-calendar-check-o"></i>'
    });

	$("input[name='settings_donations_packages_modal_editadd_rewards_ts3_clientlimit']").TouchSpin({
        min: 0,
        max: 100000,
        step: 1,
        forcestepdivisibility: 'none',
        verticalbuttons: true
    });

	$("input[name='settings_donations_monthlygoal']").TouchSpin({
        min: 0,
        max: 100000,
        step: 10,
        forcestepdivisibility: 'none',
        verticalbuttons: true,
        prefix: '<?php echo Settings::Get('settings_donations_currency_plain'); ?>'
    });

	$("input[name='settings_donations_event_goal']").TouchSpin({
        min: 0,
        max: 100000,
        step: 10,
        forcestepdivisibility: 'none',
        verticalbuttons: true,
        prefix: '<?php echo Settings::Get('settings_donations_currency_plain'); ?>'
    });

    function settings_donations_taxes_countryspecific_add(country, tax, note){
    	var newrow = '';

		newrow =  newrow + '<tr><td><select class="countryspecific_country form-control">';

		$.each(GetCountrycodes2(true), function(cc, cn){
			var selected = "";

			if(country == cc){
				selected = "selected";
			}

			newrow =  newrow + '<option ' + selected + ' value="' + cc + '">' + cc + ' - ' + cn + '</option>';
		});

		newrow =  newrow + '</select></td><td><input class="countryspecific_tax form-control" value="' + tax + '"/></td><td><input value="' + note + '" class="countryspecific_note form-control" /></td><td><i style="margin-top: 10px; color:red;" class="fa fa-times fa-lg clickable" onclick="$(this).parent().parent().remove();"></i></td></tr>';

		$('#settings_donations_taxes_countryspecific_table').append(newrow);
    }

    function settings_donations_taxes_countryspecific_save(){
    	var countryspecific_values = [];

    	$('#settings_donations_taxes_countryspecific_table tr').each(function(i, r){
    		var country = $(r).find('.countryspecific_country').val();
    		var tax = $(r).find('.countryspecific_tax').val();
    		var note = $(r).find('.countryspecific_note').val();

			countryspecific_values.push({country: country, tax: tax, note: note});
    	});

    	console.log(countryspecific_values);

    	$('input[name="settings_donations_taxes_countryspecific"]').val(JSON.stringify(countryspecific_values));
    }

    function settings_donations_taxes_countryspecific_load(){
		var countryspecific_values = FromJson($('input[name="settings_donations_taxes_countryspecific"]').val());

		if(countryspecific_values){
			$.each(countryspecific_values, function(i, cv){
				settings_donations_taxes_countryspecific_add(cv['country'], cv['tax'], cv['note']);
			});
		}
    }

    function settings_donations_package_modal_reset(bundleid = 0){
    	activateTab('settings_donations_packages_modal_editadd_tabs_general');
    	$('.settings_donations_packages_modal_editadd input').val('');
    	$('.settings_donations_packages_modal_editadd select').prop("selectedIndex", 0);
    	$('textarea[name="settings_donations_packages_modal_editadd_general_description"]').summernote('code', '');
    	$('.settings_donations_packages_modal_editadd input[type=checkbox]').prop('checked', false);
    	$('.settings_donations_packages_modal_editadd textarea').val('');
    	$('select[name="settings_donations_packages_modal_editadd_general_serverbundle"]').val(bundleid);

    	rewardselector_reset();

    	$('button[name="settings_donations_packages_modal_editadd_submit_delete"]').hide();
    	$('button[name="settings_donations_packages_modal_editadd_submit_copy"]').hide();

    	$('#settings_donations_packages_modal_editadd_title').html('<?php echo Lang('create_package'); ?>');

    	$('input[name="settings_donations_packages_modal_editadd_packageid"]').val('');

    	$('.settings_donations_packages_modal_editadd .panel-collapse').collapse('hide');
    }

    function settings_donations_package_create(bundleid){
    	settings_donations_package_modal_reset(bundleid);
    	$('.settings_donations_packages_modal_editadd').modal('show');
    }

    function settings_donations_package_select(package){
    	package = packagedata[package];

    	settings_donations_package_modal_reset();

    	$('button[name="settings_donations_packages_modal_editadd_submit_delete"]').show();
    	$('button[name="settings_donations_packages_modal_editadd_submit_copy"]').show();

		//General
    	$('#settings_donations_packages_modal_editadd_title').html('<?php echo Lang('edit_package'); ?>');
    	$('input[name="settings_donations_packages_modal_editadd_packageid"]').val(package['id']);
    	$('input[name="settings_donations_packages_modal_editadd_general_title"]').val(package['title']);
    	$('input[name="settings_donations_packages_modal_editadd_general_subtitle"]').val(package['subtitle']);
    	$('textarea[name="settings_donations_packages_modal_editadd_general_description"]').summernote('code', package['description']);

		$('input[name="settings_donations_packages_modal_editadd_general_price"]').val(package['price']);

		$('select[name="settings_donations_packages_modal_editadd_general_serverbundle"] option[value="' + package['serverbundle'] + '"]').prop('selected', true);
		$('input[name="settings_donations_packages_modal_editadd_general_category"]').val(package['category']);

    	$('input[name="settings_donations_packages_modal_editadd_general_days"]').val(package['days']);

    	$('input[name="settings_donations_packages_modal_editadd_general_active"]').prop('checked', package['active']);
    	$('input[name="settings_donations_packages_modal_editadd_general_price_custom"]').prop('checked', package['price_custom']);
    	$('select[name="settings_donations_packages_modal_editadd_general_rebuyable"]').val(package['rebuyable']);

    	//Rewards
    	var rewards = JSON.parse(package['rewards']);

    	rewardselector_load(rewards);

    	//Extra
    	var extras = {};
    	extras['incompatible'] = JSON.parse(package['incompatible']);
    	extras['disable'] = JSON.parse(package['disable']);
    	extras['upgrade_from'] = JSON.parse(package['upgrade_from']);
    	extras['required'] = JSON.parse(package['required']);

    	$('.settings_donations_packages_modal_editadd_extra_incompatible').prop('checked', false);
    	$('.settings_donations_packages_modal_editadd_extra_disable').prop('checked', false);
    	$('.settings_donations_packages_modal_editadd_extra_upgrade_from').prop('checked', false);
    	$('.settings_donations_packages_modal_editadd_extra_required').prop('checked', false);

    	for (var k in extras){
		    if (extras.hasOwnProperty(k)) {
		    	extras[k].forEach(function(serverid){
		    		$('#settings_donations_packages_modal_editadd_extra_' + k + '_' + serverid).prop('checked', true);
		    	});
		    }
		}

		$('.settings_donations_packages_modal_editadd').modal('show');
    }

    function settings_donations_order_save(bundle){
    	var packages = {};
    	$('.settings_donations_packages_' + bundle).each(function(i, obj){
			packages[$(obj).attr('id').substr(36)] = i;
		});

		$.getJSON('request.php?t=admin_settings_donations&order=' + JSON.stringify(packages), function(data) {
			if(data['success']){
				new PNotify({
				    title: '<?php echo Lang('success'); ?>',
				    text: '<?php echo Lang('order_saved'); ?>',
				    type: 'success'
				});
			}else{
				new PNotify({
				    title: '<?php echo Lang('error'); ?>',
				    text: data['error'],
				    type: 'error'
				});
			}
		});
    }

    function settings_donations_package_delete(){
    	var packageid = $('input[name="settings_donations_packages_modal_editadd_packageid"]').val();

    	if($.isNumeric(packageid)){
    		var text = '<?php echo Lang('confirmpackagedelete'); ?>';
	        text = text.replace('%packageid%', packageid);

	        (new PNotify({
	            title: '<?php echo Lang('confirmation'); ?>',
	            text: text,
	            icon: '',
	            type: "error",
	            hide: false,
	            confirm: {
	                confirm: true
	            },
	            buttons: {
	                closer: false,
	                sticker: false
	            },
	            history: {
	                history: false
	            }
	            })).get().on('pnotify.confirm', function() {
	                post('index.php?t=admin_settings&part=donations', {settings_donations_package_delete_id: packageid});
	        });
    	}
    }

    <?php
        foreach (Gateway::GetAll() as $gateway) {
            echo "$('input[name=\"settings_donations_gateways_".$gateway->GetValue('name')."\"]').prop('checked', ".$gateway->GetValue('enabled').');';
        }
    ?>

    $('input[name="settings_donations_currency_plain"]').val('<?php echo OneLine(Settings::Get('settings_donations_currency_plain')); ?>');
    $('input[name="settings_donations_currency"]').val('<?php echo OneLine(Settings::Get('settings_donations_currency')); ?>');
    $('input[name="settings_donations_monthlygoal"]').val('<?php echo OneLine(Settings::Get('settings_donations_monthlygoal')); ?>');
    $('input[name="settings_donations_taxes_countryspecific"]').val('<?php echo OneLine(Settings::Get('settings_donations_taxes_countryspecific')); ?>');
    $('input[name="settings_donations_paypal_email"]').val('<?php echo OneLine(Settings::Get('settings_donations_paypal_email')); ?>');
    $('input[name="settings_donations_paysafecard_key"]').val('<?php echo OneLine(Settings::Get('settings_donations_paysafecard_key')); ?>');
    $('select[name="settings_donations_paysafecard_environment"]').val('<?php echo OneLine(Settings::Get('settings_donations_paysafecard_environment')); ?>');
    $('input[name="settings_donations_event_goal"]').val('<?php echo OneLine(Settings::Get('settings_donations_event_goal')); ?>');
    $('input[name="settings_donations_event_deadline"]').val('<?php echo OneLine(Settings::Get('settings_donations_event_deadline')); ?>');
    $('input[name="settings_donations_event_begin"]').val('<?php echo OneLine(Settings::Get('settings_donations_event_begin')); ?>');
    $('input[name="settings_donations_event_name"]').val('<?php echo OneLine(Settings::Get('settings_donations_event_name')); ?>');
    $('input[name="settings_donations_email_subject"]').val('<?php echo OneLine(Settings::Get('settings_donations_email_subject')); ?>');
    $('textarea[name="settings_donations_checkboxes"]').val(`<?php echo Settings::Get('settings_donations_checkboxes'); ?>`);
    $('input[name="settings_donations_event_enabled"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_event_enabled')); ?>);
    $('input[name="settings_donations_paypal_sandbox"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_paypal_sandbox')); ?>);
    $('input[name="settings_donations_enabled"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_enabled')); ?>);
    $('input[name="settings_donations_shop"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_shop')); ?>);
    $('input[name="settings_donations_statistics"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_statistics')); ?>);
    $('input[name="settings_donations_email_required"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_email_required')); ?>);
    $('input[name="settings_donations_donatedmessage"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_donatedmessage')); ?>);
    $('input[name="settings_donations_footerlogos"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_footerlogos')); ?>);
    $('input[name="settings_donations_email_enabled"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_email_enabled')); ?>);
    $('textarea[name="settings_donations_description"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_donations_description')); ?>');
    $('textarea[name="settings_donations_cancellation_terms"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_donations_cancellation_terms')); ?>');
    $('textarea[name="settings_donations_email_content"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_donations_email_content')); ?>');
    $('textarea[name="settings_donations_invoice_business"]').val(ReplaceAll('<br /> ', '\n', '<?php echo OneLine(nl2br(Settings::Get('settings_donations_invoice_business'))); ?>'));
    $('input[name="settings_donations_g2apay_email"]').val('<?php echo OneLine(Settings::Get('settings_donations_g2apay_email')); ?>');
    $('input[name="settings_donations_g2apay_secret"]').val('<?php echo OneLine(Settings::Get('settings_donations_g2apay_secret')); ?>');
    $('input[name="settings_donations_g2apay_apihash"]').val('<?php echo OneLine(Settings::Get('settings_donations_g2apay_apihash')); ?>');
    $('input[name="settings_donations_g2apay_sandbox"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_g2apay_sandbox')); ?>);
    $('input[name="settings_donations_stripe_publickey"]').val('<?php echo OneLine(Settings::Get('settings_donations_stripe_publickey')); ?>');
    $('input[name="settings_donations_stripe_secretkey"]').val('<?php echo OneLine(Settings::Get('settings_donations_stripe_secretkey')); ?>');
    $('input[name="settings_donations_payssion_apikey"]').val('<?php echo OneLine(Settings::Get('settings_donations_payssion_apikey')); ?>');
    $('input[name="settings_donations_payssion_secretkey"]').val('<?php echo OneLine(Settings::Get('settings_donations_payssion_secretkey')); ?>');
    $('input[name="settings_donations_payssion_sandbox"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_payssion_sandbox')); ?>);
    $('input[name="settings_donations_taxes_euvat"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_taxes_euvat')); ?>);
    $('input[name="settings_donations_taxes_unknown_block"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_taxes_unknown_block')); ?>);
    $('input[name="settings_donations_taxes_add"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_taxes_add')); ?>);
    $('input[name="settings_donations_invoices"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_invoices')); ?>);
    $('input[name="settings_donations_details_not_public"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_donations_details_not_public')); ?>);

    <?php
        $attachments = FromJson(Settings::Get('settings_donations_email_attachments'));

        foreach ($attachments as $attachment) {
            echo '$("#settings_donations_email_attachments").multiselect("select", "'.$attachment.'");';
        }
    ?>

    settings_donations_taxes_countryspecific_load();
    
    $('#admin_settings_donations_menu a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var target = $(e.target).attr("href").substr(20);

        UpdateURL('index.php?t=admin_settings&part=donations&subpart=' + target);
    });
</script>