<!--{"language":"general","icon":"fa-wrench","position":10}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>
<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_general_submit'])) {
            if (empty($_POST['settings_general_timeformat'])) {
                DirectNotifications::Execute('title: "'.Lang('error').'", text: "Timeformat shouldn\'t be empty!<br />Default: d.m.Y H:i<br />DO NOT SUBMIT IF TEXT EDITORS DO NOT LOAD CORRECTLY.", type: "error"');
            } else {
                $html_validation = array('settings_general_about', 'settings_general_tos', 'settings_general_privacy_policy', 'settings_general_motd');
                $checkboxes = array('settings_general_shoutbox');
                $ignore = array('settings_design_submit');

                if (!isset($_POST['settings_general_pages_disabled'])) {
                    $_POST['settings_general_pages_disabled'] = array();
                }

                foreach ($checkboxes as $checkbox) {
                    if (!array_key_exists($checkbox, $_POST)) {
                        $_POST[$checkbox] = 0;
                    } else {
                        $_POST[$checkbox] = 1;
                    }
                }

                foreach ($_POST as $key => $postvar) {
                    if (!in_array($key, $ignore) && StartsWith($key, 'settings_general_')) {
                        if (in_array($key, $html_validation)) {
                            $postvar == ValidateHTML($postvar);
                        }

                        if (is_array($postvar)) {
                            $postvar = ToJson($postvar);
                        }

                        Settings::Set($key, $postvar);
                    }
                }
                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
            }
        }
    }
?>

<!-- Summernote CSS -->
<link rel="stylesheet" href="assets/css/summernote.css">
<!-- Bootstrap Multiselect CSS -->
<link rel="stylesheet" href="assets/css/bootstrap-multiselect.css">

<!-- Summernote JS-->
<script src="assets/js/summernote.min.js"></script>
<!-- Bootstrap Multiselect JS -->
<script src="assets/js/bootstrap-multiselect.js"></script>

<h3><?php echo Lang('general'); ?></h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=general">
            <!-- Default Language -->
            <label><?php echo Lang('lang_default'); ?></label><br>
            <div class="row">
                <div class="col-xs-9">
                     <select name="settings_general_defaultlanguage" class="form-control">
                        <?php
                            foreach ($languageManager->GetLanguages() as $lang_name) {
                                echo '<option>'.$lang_name.'</option>';
                            } ?>
                    </select>
                </div>

                <div class="col-xs-3">
                    <button type="button" onclick="settings_general_set_language_all();" style="width:100%;" class="btn btn-warning"><?php echo Lang('set_language_all'); ?></button>
                </div>
            </div>

            <br>

            <!-- Default Group -->
            <label><?php echo Lang('group_default'); ?></label><br>
            <select name="settings_general_defaultgroup" class="form-control">
                <?php
                    foreach (Group::GetAll() as $group) {
                        if (!Permissions::HasPermission('super', $group) && !Permissions::HasPagePermission('admin_settings', $group)) {
                            echo '<option>'.$group->GetValue('groupname').'</option>';
                        }
                    }
                ?>
            </select>
            <br>

            <!-- Default Timeformat -->
            <label><?php echo Lang('timeformat'); ?></label><br>
            <div class="row">
                <div class="col-xs-10">
                    <input id="settings_general_timeformat" name="settings_general_timeformat" type="text" class="form-control" placeholder="<?php echo Lang('timeformat'); ?>">
                </div>

                <div class="col-xs-2">
                    <button type="button" onclick="$('#settings_general_timeformat').val('d.m.Y H:i');" style="width:100%;" class="btn btn-info"><?php echo Lang('default'); ?></button>
                </div>
            </div>

            <br>

            <!-- Community Name -->
            <label><?php echo Lang('community_name'); ?></label><br>
            <input name="settings_general_community_name" type="text" class="form-control" placeholder="<?php echo Lang('community_name'); ?>">
            <br>

            <!-- Website Decription -->
            <label><?php echo Lang('website_decription_searchengines'); ?></label><br>
            <input name="settings_general_description" type="text" class="form-control" placeholder="<?php echo Lang('website_decription'); ?>">
            <br>

            <?php
                $pages = array_unique(array_merge(array_keys($pagesManager->files), FromJson(Settings::Get('settings_general_pages_disabled')), array(Settings::Get('settings_general_startpage'))));
                sort($pages);
            ?>

            <div class="row">
                <div class="col-sm-6">
                    <!-- Start Page -->
                    <label><?php echo Lang('startpage'); ?></label><br>
                    <select name="settings_general_startpage" class="form-control">
                        <?php
                            foreach ($pages as $rawname) {
                                if (!StartsWith($rawname, 'admin_')) {
                                    echo '<option>'.$rawname.'</option>';
                                }
                            }
                        ?>
                    </select>
                </div>

                <div class="col-sm-6">
                    <label><?php echo Lang('pages_disabled'); ?></label><br>
					<select name="settings_general_pages_disabled[]" id="settings_general_pages_disabled" multiple>
						<?php
                            foreach ($pages as $rawname) {
                                if ('admin_settings' != $rawname) {
                                    echo '<option>'.$rawname.'</option>';
                                }
                            }
                        ?>
					</select>
                </div>
            </div>

            <br />

            <!-- about, tos, privacy policy, motd -->
            <label><?php echo Lang('motd'); ?></label><br>
            <textarea name="settings_general_motd"></textarea>
            <br>

            <label><?php echo Lang('about'); ?></label><br>
            <textarea name="settings_general_about"></textarea>
            <br>

            <label><?php echo Lang('tos'); ?></label><br>
            <textarea name="settings_general_tos"></textarea>
            <br>

            <!-- Shoutbox Enabled -->
            <label><?php echo Lang('other'); ?></label><br>
            <?php CreateCheckBox('primary', 'settings_general_shoutbox', '', Lang('shoutbox_enabled')); ?>
            <br />

            <!-- Submit Button -->
            <button name="settings_general_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>

    </div>
</div>

<script>
    function settings_general_set_language_all(){
		$.get( "request.php?t=admin_settings_general", {
			setforall: true
		}).done(function(  ) {
			new PNotify({
			    title: '<?php echo Lang('success'); ?>',
			    text: '',
			    type: 'success'
			});
		});
	}

	$('#settings_general_pages_disabled').multiselect();

    $('textarea[name="settings_general_motd"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});

    $('textarea[name="settings_general_tos"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});

	$('textarea[name="settings_general_about"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});

	<?php
        $pages_disabled = FromJson(Settings::Get('settings_general_pages_disabled'));

        foreach ($pages_disabled as $page) {
            echo '$("#settings_general_pages_disabled").multiselect("select", "'.$page.'");';
        }
    ?>

    $('select[name="settings_general_defaultlanguage"]').val('<?php echo OneLine(Settings::Get('settings_general_defaultlanguage')); ?>');
    $('select[name="settings_general_defaultgroup"]').val('<?php echo OneLine(Settings::Get('settings_general_defaultgroup')); ?>');
    $('input[name="settings_general_timeformat"]').val('<?php echo OneLine(Settings::Get('settings_general_timeformat')); ?>');
    $('input[name="settings_general_description"]').val('<?php echo OneLine(Settings::Get('settings_general_description')); ?>');
    $('select[name="settings_general_startpage"]').val('<?php echo OneLine(Settings::Get('settings_general_startpage')); ?>');
    $('input[name="settings_general_community_name"]').val('<?php echo OneLine(Settings::Get('settings_general_community_name')); ?>');

    $('textarea[name="settings_general_motd"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_general_motd')); ?>');
    $('textarea[name="settings_general_about"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_general_about')); ?>');
    $('textarea[name="settings_general_tos"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_general_tos')); ?>');

    $('input[name="settings_general_shoutbox"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_general_shoutbox')); ?>);
</script>