<!--{"language":"groups","icon":"fa-users","position":20}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>
<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_groups_notification_delete_groupname_source'])) {
            $group = new Group($_POST['settings_groups_notification_delete_groupname_source']);

            if (($group->GetValue('level') <= $auth_user->GetGroup()->GetValue('level')) || Permissions::HasPermission('super')) {
                if ($group->valid && $group->Delete()) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('group_deleted_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
                }
            }
        } elseif (isset($_POST['settings_groups_sync'])) {
            $group = new Group($_POST['settings_groups_sync']);

            if (($group->GetValue('level') <= $auth_user->GetGroup()->GetValue('level')) || Permissions::HasPermission('super')) {
                if ($group->valid) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('sync').': '.$group->Sync().'", type: "success"');
                }
            }
        }

        if ((isset($_POST['settings_groups_modal_editadd_form_submit']) && isset($_POST['settings_groups_modal_editadd_form_groupname_source'])) || isset($_POST['settings_groups_modal_editadd_form_submit_copy'])) {
            $checkboxes = array(
                'settings_groups_modal_editadd_form_settings_kickbanimmunity',
                'settings_groups_modal_editadd_form_settings_reservedslot',
                'settings_groups_modal_editadd_form_settings_ttt_specprop',
                'settings_groups_modal_editadd_form_settings_ttt_voicedrain',
                'settings_groups_modal_editadd_form_settings_teamspeak_disablechanneldeletion',
                'settings_groups_modal_editadd_form_settings_team_member',
                'settings_groups_modal_editadd_form_settings_secure',
            );

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            $groupname = trim($_POST['settings_groups_modal_editadd_form_general_groupname']);
            $displayname = $_POST['settings_groups_modal_editadd_form_general_displayname'];
            $color = $_POST['settings_groups_modal_editadd_form_general_color'];
            $permlevel = $_POST['settings_groups_modal_editadd_form_general_permlevel'];
            $webgroup = $_POST['settings_groups_modal_editadd_form_general_webgroup'];

            $pagepermissions = array();
            $permissions = array();
            $settings = array();
            $ts3_servergroups = array();
            $discord_role_ids = array();

            foreach ($_POST as $key => $value) {
                if (StartsWith($key, 'settings_groups_modal_editadd_form_permissions_')) {
                    $permissions[] = substr($key, 47);
                } elseif (StartsWith($key, 'settings_groups_modal_editadd_form_settings_')) {
                    $settings[substr($key, 44)] = $value;
                } elseif (StartsWith($key, 'settings_groups_modal_editadd_form_pagepermissions_')) {
                    $pagepermissions[] = substr($key, 51);
                } elseif (StartsWith($key, 'settings_groups_modal_editadd_form_general_ts3_servergroup_')) {
                    $ts3_servergroups[substr($key, 59)] = $value;
                } elseif (StartsWith($key, 'settings_groups_modal_editadd_form_general_discord_role_id_')) {
                    $discord_role_ids[substr($key, 59)] = $value;
                }
            }

            $data = array(
                'groupname' => $groupname,
                'displayname' => $displayname,
                'hexcolor' => $color,
                'level' => $permlevel,
                'pagepermissions' => ToJson($pagepermissions),
                'permissions' => ToJson($permissions),
                'settings' => ToJson($settings),
                'ts3_servergroups' => ToJson($ts3_servergroups),
                'discord_role_ids' => ToJson($discord_role_ids),
                'webgroup' => $webgroup,
            );

            $permissionfail = false;

            foreach ($permissions as $permission) {
                if (!Permissions::HasPermission($permission)) {
                    $permissionfail = true;
                }
            }

            if (($permlevel > $auth_user->GetGroup()->GetValue('level') || $permissionfail) && Permissions::HasPermission('super')) {
                PermissionsError();
            } else {
                if (!empty($_POST['settings_groups_modal_editadd_form_groupname_source']) && !isset($_POST['settings_groups_modal_editadd_form_submit_copy'])) {
                    $group = new Group($_POST['settings_groups_modal_editadd_form_groupname_source']);

                    if ($group->valid) {
                        if (($group->GetValue('level') <= $auth_user->GetGroup()->GetValue('level')) || Permissions::HasPermission('super')) {
                            unset($data['groupname']);

                            if ($group->Update($data)) {
                                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');

                                if ($group->GetValue('groupname') != $groupname) {
                                    if (!$group->Rename($groupname)) {
                                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('name_doubleerror').'", type: "error"');
                                    }
                                }
                            } else {
                                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_update').'", type: "error"');
                            }
                        } else {
                            PermissionsError();
                        }
                    }
                } else {
                    try {
                        $groupname = Group::Create($data);

                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('group_created_success').'", type: "success"');
                    } catch (Exception $e) {
                        if ('GroupCreate_NameAlreadyInUseError' == $e->getMessage()) {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('name_doubleerror').'", type: "error"');
                        } elseif ('GroupCreate_UnknownError' == $e->getMessage()) {
                            DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('error').'", type: "error"');
                        }
                    }
                }
            }
        }
    }
?>
<h3>
    <?php echo Lang('groups'); ?>
    <button onclick="settings_groups_group_add();" type="button" class="btn btn-success btn-sm pull-right"><i class="fa fa-plus-circle"></i> <?php echo Lang('create'); ?></button>
</h3>

<hr>

<!-- Bootstrap ColorPicker CSS -->
<link rel="stylesheet" href="assets/css/bootstrap.colorpickersliders.css" />

<!-- Bootstrap TinyColor JS -->
<script src='assets/js/tinycolor-min.js'></script>
<!-- Bootstrap ColorPicker JS | Requires tinycolor -->
<script src='assets/js/bootstrap.colorpickersliders.js'></script>

<script>
    function settings_groups_membercount(groupname){
        $.getJSON( 'request.php?t=admin_settings_groups', {
        	groupname: groupname
        }).done(function( data ) {
            groupname = ReplaceAll('\\+' , '\\+', groupname);

            if($.isNumeric(data['count'])){
		        $("#settings_groups_nummembers_" + groupname).html(data['count']);
		    }else{
		        $("#settings_groups_nummembers_" + groupname).html('-');
		    }
        });
	}
</script>

<div class="table-responsive">
    <table class="table table-hover">
        <tr class="active">
            <th><?php echo Lang('name'); ?> <?php CreateTooltip(Lang('groupname_help'), 'top'); ?></th>
            <th style="width: 20%;"><?php echo Lang('permlevel'); ?></th>
            <th style="width: 15%;"><?php echo Lang('members'); ?></th>
            <th style="width: 35%;" class="text-right"><i class="fa fa-cogs"></i></th>
        </tr>
    
        <tbody>
            <?php
                $groupdata = '';
                foreach (Group::GetAll() as $group) {
                    $groupdata .= 'groupdata[\''.$group->GetValue('groupname').'\'] = '.ToJson($group->data).';';
                    echo '<tr>';
                    echo '<td>';
                    echo '<font color="'.$group->GetValue('hexcolor').'">'.$group->GetValue('groupname').'</font>';
                    echo '</td>';
                    echo '<td>';
                    echo $group->GetValue('level');
                    echo '</td>';
                    echo '<td>';
                    echo '<div id="settings_groups_nummembers_'.$group->GetValue('groupname').'"><i class="fa fa-refresh fa-spin"></i></div>';
                    echo '</td>';
                    echo '<td class="text-right">';
                    echo '<button onclick="settings_groups_group_edit(\''.$group->GetValue('groupname').'\');" type="button" class="btn btn-primary btn-xs"><i class="fa fa-pencil"></i> '.Lang('edit').'</button>';
                    echo '&nbsp;';

                    if ($group->GetValue('groupname') != Settings::Get('settings_general_defaultgroup')) {
                        echo '<button onclick="post(\'index.php?t=admin_settings&part=groups\', {settings_groups_sync: \''.$group->GetValue('groupname').'\'});" type="button" class="btn btn-success btn-xs"><i class="fa fa-refresh"></i> '.Lang('sync').'</button>';
                        echo '&nbsp;';
                    }

                    echo '<button onclick="settings_groups_group_delete(\''.$group->GetValue('groupname').'\');" type="button" class="btn btn-danger btn-xs"><i class="fa fa-trash"></i> '.Lang('delete').'</button>';
                    echo '</td>';
                    echo '</tr>';
                    echo '<script>settings_groups_membercount("'.$group->GetValue('groupname').'");</script>';
                }

            ?>
    
        </tbody>
    </table>
</div>

<div class="modal fade settings_groups_modal_editadd" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-users"></i> &nbsp;<span id="settings_groups_modal_editadd_title"></span></h4>
			</div>
			<form method="post" action="index.php?t=admin_settings&part=groups">
				<div class="modal-body">
				    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#settings_groups_modal_editadd_tabs_general" role="tab" data-toggle="tab"><i class="fa fa-wrench"></i> <?php echo Lang('general'); ?></a></li>
                        <li role="presentation"><a href="#settings_groups_modal_editadd_tabs_pagepermissions" role="tab" data-toggle="tab"><i class="fa fa-file-text"></i> <?php echo Lang('pages'); ?></a></li>
                        <li role="presentation"><a href="#settings_groups_modal_editadd_tabs_permissions" role="tab" data-toggle="tab"><i class="fa fa-unlock-alt"></i> <?php echo Lang('permissions'); ?></a></li>
                        <li role="presentation"><a href="#settings_groups_modal_editadd_tabs_settings" role="tab" data-toggle="tab"><i class="fa fa-gear"></i> <?php echo Lang('other'); ?></a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="settings_groups_modal_editadd_tabs_general">
                            <br>

                            <input type="hidden" value="" id="settings_groups_modal_editadd_form_groupname_source" name="settings_groups_modal_editadd_form_groupname_source">

        					<label><?php echo Lang('name'); ?></label><br>
        					<input class="form-control" name="settings_groups_modal_editadd_form_general_groupname">
        					<br>

        					<label><?php echo Lang('displayname'); ?></label><br>
        					<input class="form-control" name="settings_groups_modal_editadd_form_general_displayname">
        					<br>

        					<label><?php echo Lang('color'); ?></label><br>

                                <input value="#0000FF" class="form-control" name="settings_groups_modal_editadd_form_general_color" placeholder="#ABCDEF">

        					<br>

        					<label><?php echo Lang('permlevel'); ?></label><br>
        				    <input class="form-control" name="settings_groups_modal_editadd_form_general_permlevel" value="0">

        				    <br />

        				    <label><?php echo Lang('associated_webgroup'); ?></label><br>
        				    <select class="form-control" name="settings_groups_modal_editadd_form_general_webgroup">
        				        <option></option>
                                <?php
                                    foreach (Group::GetAll() as $group) {
                                        echo '
                                            <option style="color:'.$group->GetValue('hexcolor').';" value="'.$group->GetValue('groupname').'">'.$group->GetValue('displayname').'</option>
								        ';
                                    }
                                ?>
        				    </select>

        				    <br />

        				    <div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<i class="fa fa-microphone"></i>
										<a role="button" data-toggle="collapse" href="#settings_groups_ts3servergroups_collapse">
											Teamspeak 3 Synchronization
										</a>
									</h4>
								</div>
								<div id="settings_groups_ts3servergroups_collapse" class="panel-collapse collapse">
									<div class="panel-body">
									    <div class="row">
									        <div class="col-sm-6">
								                <label>Web</label><br>
			                                    <input class="form-control settings_groups_modal_editadd_form_element_general_ts3_servergroup" placeholder="<?php echo Lang('ts3_servergroup'); ?>" name="settings_groups_modal_editadd_form_general_ts3_servergroup_0" />
								                <br />
								            </div>

									        <?php
                                                foreach (Serverbundle::GetAll() as $serverbundle) {
                                                    echo '
    										            <div class="col-sm-6">
    										                <label>'.$serverbundle->GetValue('name').'</label><br>
        				                                    <input class="form-control settings_groups_modal_editadd_form_element_general_ts3_servergroup" placeholder="'.Lang('ts3_servergroup').'" name="settings_groups_modal_editadd_form_general_ts3_servergroup_'.$serverbundle->GetValue('id').'" />
    										                <br />
    										            </div>

    										        ';
                                                }
                                            ?>
									    </div>
									</div>
								</div>
                            </div>
                            
                            <div class="panel panel-default">
								<div class="panel-heading">
									<h4 class="panel-title">
										<i class="fa fa-comments-o"></i>
										<a role="button" data-toggle="collapse" href="#settings_groups_discord_roles_collapse">
											Discord Synchronization
										</a>
									</h4>
								</div>
								<div id="settings_groups_discord_roles_collapse" class="panel-collapse collapse">
									<div class="panel-body">
									    <div class="row">
									        <div class="col-sm-6">
								                <label>Web</label><br>
			                                    <input class="form-control settings_groups_modal_editadd_form_element_general_discord_role_id" placeholder="<?php echo Lang('discord_role_id'); ?>" name="settings_groups_modal_editadd_form_general_discord_role_id_0" />
								                <br />
								            </div>

									        <?php
                                                foreach (Serverbundle::GetAll() as $serverbundle) {
                                                    echo '
    										            <div class="col-sm-6">
    										                <label>'.$serverbundle->GetValue('name').'</label><br>
        				                                    <input class="form-control settings_groups_modal_editadd_form_element_general_discord_role_id" placeholder="'.Lang('discord_role_id').'" name="settings_groups_modal_editadd_form_general_discord_role_id_'.$serverbundle->GetValue('id').'" />
    										                <br />
    										            </div>

    										        ';
                                                }
                                            ?>
									    </div>
									</div>
								</div>
                            </div>


                        </div>
                        <div role="tabpanel" class="tab-pane" id="settings_groups_modal_editadd_tabs_pagepermissions">
                            <br>
                            <table class="table table-responsive table-hover table-bordered">
                                <tr>
                                    <th><?php echo Lang('page'); ?></th>
                                    <th class="text-center" style="width: 20%;"><?php echo Lang('access'); ?></th>
                                </tr>

                                <?php
                                    $counter = 0;
                                    foreach ($pagesManager->files as $page) {
                                        echo '<tr>';
                                        echo '<td>';
                                        echo $page['rawname'];
                                        echo '</td>';
                                        echo '<td class="text-center">';
                                        echo '<div class="togglebutton">
                    				            	<label>
                    				                	<input class="settings_groups_modal_editadd_form_element_pagepermission" name="settings_groups_modal_editadd_form_pagepermissions_'.$page['rawname'].'" type="checkbox" />

                    				            	</label>
                    				            </div>
                                        ';
                                        echo '</td>';
                                        echo '</tr>';
                                    }
                                ?>
                			</table>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="settings_groups_modal_editadd_tabs_permissions">
                            <br>
                            <?php
                                $old = false;
                                foreach (Permissions::GetAll() as $permission) {
                                    $new = explode('_', $permission)[0];

                                    if ($old && $old != $new) {
                                        echo '<hr>';
                                    } elseif ($old) {
                                        echo '<br>';
                                    }

                                    $old = $new;

                                    echo '<label>'.Lang('perm_desc_'.$permission).'</label>';
                                    CreateCheckbox('primary', 'settings_groups_modal_editadd_form_permissions_'.$permission, 'settings_groups_modal_editadd_form_element_permission', $permission);
                                }
                            ?>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="settings_groups_modal_editadd_tabs_settings">
                            <br>

                            <label><?php echo Lang('immunity'); ?></label><br>
                            <?php CreateCheckbox('primary', 'settings_groups_modal_editadd_form_settings_kickbanimmunity', 'settings_groups_modal_editadd_form_element_setting', Lang('immune_kb')); ?>
                            <br>

                            <label><?php echo Lang('reservedslot'); ?></label><br>
                            <?php CreateCheckbox('primary', 'settings_groups_modal_editadd_form_settings_reservedslot', 'settings_groups_modal_editadd_form_element_setting', Lang('reservedslot_description')); ?>
                            <br>

                            <label><?php echo Lang('maxbanlength'); ?></label><br>
        					<input class="form-control settings_groups_modal_editadd_form_element_setting" name="settings_groups_modal_editadd_form_settings_maxbanlength"  value="0"/>
        					<br>

        					<label>Teamspeak</label><br>
        					<?php CreateCheckbox('primary', 'settings_groups_modal_editadd_form_settings_teamspeak_disablechanneldeletion', 'settings_groups_modal_editadd_form_element_setting', Lang('disablechanneldeletion')); ?>
        					<br/>

        					<label>TTT</label><br>
        					<?php CreateCheckbox('primary', 'settings_groups_modal_editadd_form_settings_ttt_specprop', 'settings_groups_modal_editadd_form_element_setting', Lang('ttt_specprop_infinite')); ?>
                            <?php CreateCheckbox('primary', 'settings_groups_modal_editadd_form_settings_ttt_voicedrain', 'settings_groups_modal_editadd_form_element_setting', Lang('ttt_voicedrain_infinite')); ?>
                            <br/>
                            
                            <label><?php echo Lang('team'); ?></label><br>
        					<?php CreateCheckbox('primary', 'settings_groups_modal_editadd_form_settings_team_member', 'settings_groups_modal_editadd_form_element_setting', Lang('is_team_member')); ?>
        					<br/>
        					
        					<label><?php echo Lang('security'); ?></label><br>
        					<?php CreateCheckbox('primary', 'settings_groups_modal_editadd_form_settings_secure', 'settings_groups_modal_editadd_form_element_setting', Lang('block_ingame_groupchanges')); ?>
                        </div>
                    </div>
				</div>
				<div class="modal-footer">
					<button type="submit" name="settings_groups_modal_editadd_form_submit_copy" class="btn btn-warning"><?php echo Lang('copy'); ?></button>
					<button type="submit" name="settings_groups_modal_editadd_form_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>


<script>
    var groupdata = {};

	<?php echo $groupdata; ?>

    $('input[name="settings_groups_modal_editadd_form_settings_maxbanlength"]').TouchSpin({
        min: 0,
        max: 100000,
    	step: 60,
    	forcestepdivisibility: 'none',
        decimals: 0,
        verticalbuttons: true,
        prefix: '<?php echo Lang('minutes'); ?>'
    });

    $("input[name='settings_groups_modal_editadd_form_general_permlevel']").TouchSpin({
        min: 0,
        max: 2000000000,
        step: 10,
        forcestepdivisibility: 'none',
        verticalbuttons: true
    });

    $('input[name="settings_groups_modal_editadd_form_general_color"]').ColorPickerSliders({
        color: "#ffffff",
        previewformat: 'hex',
        sliders: false,
        swatches: false,
        hsvpanel: true
    });

    function settings_groups_group_modal_reset(){
        $('.settings_groups_modal_editadd input').val('');
    	$(".settings_groups_modal_editadd select").prop("selectedIndex", 0);
    	$('.settings_groups_modal_editadd input[type=checkbox]').prop('checked', false);

    	$('button[name="settings_groups_modal_editadd_form_submit_copy"]').hide();

	    $('.settings_groups_modal_editadd_form_element_general_ts3_servergroup').val('');
        $('#settings_groups_modal_editadd_title').html('<?php echo Lang('group_create'); ?>');
        $('input[name="settings_groups_modal_editadd_form_general_color"]').trigger('colorpickersliders.updateColor', '#0000FF');
        $('.settings_groups_modal_editadd_form_element_pagepermission').prop('checked', false);

        $('input[name="settings_groups_modal_editadd_form_settings_maxbanlength"]').val(0);
        $('input[name="settings_groups_modal_editadd_form_general_permlevel"]').val(0);

        activateTab('settings_groups_modal_editadd_tabs_general');
        $('.settings_groups_modal_editadd').modal('show');
    }

	function settings_groups_group_edit(groupname){
	    settings_groups_group_modal_reset();

	    $('button[name="settings_groups_modal_editadd_form_submit_copy"]').show();

	    var data = groupdata[groupname];

        $('#settings_groups_modal_editadd_title').html('<?php echo Lang('group_edit'); ?>');
        $('input[name="settings_groups_modal_editadd_form_groupname_source"]').val(data['groupname']);
        $('input[name="settings_groups_modal_editadd_form_general_groupname"]').val(data['groupname']);
        $('select[name="settings_groups_modal_editadd_form_general_webgroup"]').val(data['webgroup']);
        $('input[name="settings_groups_modal_editadd_form_general_displayname"]').val(data['displayname']);
        $('input[name="settings_groups_modal_editadd_form_general_permlevel"]').val(data['level']);
        $('input[name="settings_groups_modal_editadd_form_general_ts3_servergroupid"]').val(data['ts3_servergroupid']);
        $('input[name="settings_groups_modal_editadd_form_general_color"]').trigger("colorpickersliders.updateColor", data['hexcolor']);

        $('.settings_groups_modal_editadd_form_element_pagepermission').prop('checked', false);

        data['pagepermissions'].forEach(function(page) {
           $('input[name="settings_groups_modal_editadd_form_pagepermissions_'+page+'"]').prop('checked', true);
        });

        $( ".settings_groups_modal_editadd_form_element_setting" ).prop('checked', false);
        $( ".settings_groups_modal_editadd_form_element_setting" ).val('');
        $( ".settings_groups_modal_editadd_form_element_permission" ).prop('checked', false);

        $('input[name="settings_groups_modal_editadd_form_settings_maxbanlength"]').val(0);

        data['permissions'].forEach(function(permission) {
            $('#settings_groups_modal_editadd_form_permissions_' + permission).prop('checked', true);
        });

        Object.keys(data['settings']).forEach(function(key) {
            if($('input[name="settings_groups_modal_editadd_form_settings_' + key + '"]').is(':checkbox')){
                $('input[name="settings_groups_modal_editadd_form_settings_' + key + '"]').prop('checked', data['settings'][key]);
            }else{
                $('input[name="settings_groups_modal_editadd_form_settings_' + key + '"]').val(data['settings'][key]);
            }
        });

        $('.settings_groups_modal_editadd_form_element_general_ts3_servergroup').val('');
        $('.settings_groups_modal_editadd_form_element_general_discord_role_id').val('');

        Object.keys(data['ts3_servergroups']).forEach(function(key) {
            $('input[name="settings_groups_modal_editadd_form_general_ts3_servergroup_' + key + '"]').val(data['ts3_servergroups'][key]);
        });
        
        Object.keys(data['discord_role_ids']).forEach(function(key) {
            console.log(data['discord_role_ids'][key]);
            $('input[name="settings_groups_modal_editadd_form_general_discord_role_id_' + key + '"]').val(data['discord_role_ids'][key]);
        });

        $('.settings_groups_modal_editadd').modal('show');
    }

    function settings_groups_group_add(){
        settings_groups_group_modal_reset();

        $('.settings_groups_modal_editadd_form_element_pagepermission').each(function(key, val){
            if(!$(val).attr('name').startsWith('settings_groups_modal_editadd_form_pagepermissions_admin_')){
                $(val).prop('checked', true);
            }
        });
    }

    function settings_groups_group_delete(groupname){
        var text = '<?php echo Lang('confirmgroupdelete'); ?>';
        text = text.replace('%group%', groupname);

        (new PNotify({
            title: '<?php echo Lang('confirmation'); ?>',
            text: text,
            icon: '',
            type: "error",
            hide: false,
            confirm: {
                confirm: true
            },
            buttons: {
                closer: false,
                sticker: false
            },
            history: {
                history: false
            }
            })).get().on('pnotify.confirm', function() {
                post('index.php?t=admin_settings&part=groups', {settings_groups_notification_delete_groupname_source: groupname});
        });
    }
</script>