<!--{"language":"languages","icon":"fa-language","position":100}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_languages_delete'])) {
            $lang = $_POST['settings_languages_delete'];

            if (ctype_alpha($lang) && 2 == strlen($lang) && isset($LANGUAGES[$lang]) && 'en' != $lang) {
                DeleteTarget('language/'.$lang.'.php');
            }
        } elseif (isset($_POST['settings_languages_add_modal_language'])) {
            $lang = $_POST['settings_languages_add_modal_language'];

            if (ctype_alpha($lang) && 2 == strlen($lang) && isset($LANGUAGES[$lang])) {
                if ($languageManager->DownloadLanguage($lang)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('language_added_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('error').'", type: "error"');
                }
            }
        }
    }
?>

<h3>
    <?php echo Lang('languages'); ?>
    <div class="pull-right">
		<?php echo in_array(Settings::Get('settings_general_defaultlanguage'), array('de', 'en')) ? '' : '<a target="_blank" href="https://customercenter.ibot3.de/index.php?t=languagecenter"><button type="button" class="btn btn-info btn-sm"><i class="fa fa-language"></i> '.Lang('translations_add_improve').'</button></a>'; ?>
		<button onclick="$('#settings_languages_add_modal').modal('show');" type="button" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> <?php echo Lang('language_add'); ?></button>
	</div>
</h3>

<hr>

<div class="row">
    <div class="col-xs-12">
         <div class="table-responsive">
    		 <table class="table table-hover">
            	<tr class="active">
            		<th><?php echo Lang('lang'); ?></th>
            		<th class="text-right"><i class="fa fa-cogs"></i></th>
            	</tr>
    
            	<tbody>
    				<?php
                        foreach ($languageManager->GetLanguages() as $lang) {
                            if (!isset($LANGUAGES[$lang])) {
                                continue;
                            }

                            echo '<tr>';
                            echo '<td>'.$LANGUAGES[$lang]['name'].'</td>';
                            echo '<td class="text-right"><button onclick="post(\'index.php?t=admin_settings&part=languages\', {settings_languages_delete: \''.$lang.'\'});" class="btn btn-xs btn-danger"><i class="fa fa-trash"></i></button></td>';
                            echo '</tr>';
                        }
                    ?>
            	</tbody>
            </table>
        </div>
    </div>
</div>

<!-- Language Add Modal -->
<div class="modal fade" id="settings_languages_add_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-language"></i> &nbsp;<?php echo Lang('language_add'); ?></h4>
			</div>

			<form method="post" action="index.php?t=admin_settings&part=languages">
				<div class="modal-body">
		            <label><?php echo Lang('name'); ?></label><br>
		            <select name="settings_languages_add_modal_language" class="form-control" />

		            </select>
				</div>
				<div class="modal-footer">
					<button type="submit" name="settings_languages_add_modal_submit" class="btn btn-success"><?php echo Lang('add'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>


<script>
	<?php
        foreach ($languageManager->GetAvailableLanguages() as $lang => $info) {
            echo '$(\'select[name="settings_languages_add_modal_language"]\').append(\'<option value="'.$lang.'">'.$info['name'].' ('.$info['progress'].'%)</option>\');';
        }
    ?>
</script>