<!--{"language":"privacy","icon":"fa-user-secret","position":95}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>
<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_privacy_submit'])) {
            $html_validation = array('settings_privacy_policy');
            $checkboxes = array('settings_privacy_collect_ips', 'settings_privacy_enforce_policy');

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            foreach ($_POST as $key => $postvar) {
                if (StartsWith($key, 'settings_privacy_')) {
                    if ('settings_privacy_enforce_policy_reset' == $key) {
                        if ($postvar) {
                            $db->update('users', array('accepted' => 0));
                            continue;
                        }
                    } elseif ('settings_privacy_collect_ips' == $key) {
                        if (!$postvar) {
                            $db->update('users', array('ips' => ''));
                        }
                    }

                    if (in_array($key, $html_validation)) {
                        $postvar == ValidateHTML($postvar);
                    }

                    if (is_array($postvar)) {
                        $postvar = ToJson($postvar);
                    }

                    Settings::Set($key, $postvar);
                }
            }
            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        }
    }
?>

<!-- Summernote CSS -->
<link rel="stylesheet" href="assets/css/summernote.css">

<!-- Summernote JS-->
<script src="assets/js/summernote.min.js"></script>


<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=privacy">
            <label><?php echo Lang('privacy_policy'); ?></label><br>
            <textarea name="settings_privacy_policy"></textarea>
            <br>

            <?php CreateCheckBox('primary', 'settings_privacy_collect_ips', '', Lang('collect_ips')); ?>
            <?php CreateCheckBox('primary', 'settings_privacy_enforce_policy', '', Lang('enforce_policy')); ?>
            <?php CreateCheckBox('primary', 'settings_privacy_enforce_policy_reset', '', Lang('reset_confirmations')); ?>
            <br />
            
            <!-- Submit Button -->
            <button name="settings_privacy_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>
    </div>
</div>

<script>
    $('textarea[name="settings_privacy_policy"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});
	
	$('input[name="settings_privacy_collect_ips"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_privacy_collect_ips')); ?>);
	$('input[name="settings_privacy_enforce_policy"]').prop('checked', <?php echo ValidateBool(Settings::Get('settings_privacy_enforce_policy')); ?>);
	$('textarea[name="settings_privacy_policy"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_privacy_policy')); ?>');
</script>