<!--{"language":"servers","icon":"fa-server","position":30}-->
<?php 
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['admin_settings_servers_bundle_editadd_modal_form_submit'])) {
            $name = htmlspecialchars($_POST['admin_settings_servers_bundle_editadd_modal_form_name']);
            $color = htmlspecialchars($_POST['admin_settings_servers_bundle_editadd_modal_form_color']);
            $description = htmlspecialchars($_POST['admin_settings_servers_bundle_editadd_modal_form_description']);
            $icon = htmlspecialchars($_POST['admin_settings_servers_bundle_editadd_modal_form_icon']);
            $discount = intval($_POST['admin_settings_servers_bundle_editadd_modal_form_discount']);
            $image = false;
            $id = $_POST['admin_settings_servers_bundle_editadd_modal_form_id'];

            if (isset($_POST['admin_settings_servers_bundle_editadd_modal_form_image'])) {
                $image = $_POST['admin_settings_servers_bundle_editadd_modal_form_image'];
            }

            $servers = array();

            foreach (Server::GetAll() as $server) {
                if (isset($_POST['admin_settings_servers_bundle_editadd_modal_form_server_'.$server->GetValue('id')])) {
                    $servers[] = $server->GetValue('id');
                }
            }

            $servers_assinged = array();

            foreach (Serverbundle::GetAll() as $bundle) {
                if ($bundle->GetValue('id') != $id) {
                    $_servers = $bundle->GetServers();
                    $serverids = array();

                    foreach ($_servers as $_server) {
                        $serverids[] = $_server->GetValue('id');
                    }

                    $servers_assinged = array_merge($servers_assinged, $serverids);
                }
            }

            $already_assigned = false;

            foreach ($servers as $key => $server) {
                if (in_array($server, $servers_assinged)) {
                    unset($servers[$key]);
                    $already_assigned = true;
                }
            }

            if ($already_assigned) {
                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('server_already_assigned').'", type: "error"');
            }

            $donations = 0;

            if (isset($_POST['admin_settings_servers_bundle_editadd_modal_form_donations'])) {
                $donations = 1;
            }

            $data = array(
                'name' => $name,
                'hexcolor' => $color,
                'description' => $description,
                'donations' => $donations,
                'image' => '',
                'servers' => ToJson($servers),
                'icon' => $icon,
                'discount' => $discount,
            );

            if (is_numeric($id)) {
                $serverbundle = new Serverbundle($id);

                if (0 == $id) {
                    $data['servers'] = ToJson(array());
                }

                if ($serverbundle->Update($data)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
                }
            } else {
                $id = Serverbundle::Create($data);
            }

            if ($_FILES['admin_settings_servers_bundle_editadd_modal_form_image']['name']) {
                $file = $_FILES['admin_settings_servers_bundle_editadd_modal_form_image']['tmp_name'];

                if (!move_uploaded_file($file, 'assets/img/bundles/'.$id.'.png')) {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('fileupload_error').'", type: "error"');
                }
            }
        } elseif (isset($_POST['admin_settings_servers_bundle_delete'])) {
            $id = $_POST['admin_settings_servers_bundle_delete'];

            if (is_numeric($id)) {
                if (0 != $id) {
                    $serverbundle = new Serverbundle($id);
                    if ($serverbundle->valid && $serverbundle->Delete()) {
                        DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('bundle_deleted_success').'", type: "success"');
                    } else {
                        DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
                    }
                }
            }
        } elseif (isset($_POST['admin_settings_servers_server_delete'])) {
            $id = $_POST['admin_settings_servers_server_delete'];

            if (is_numeric($id)) {
                $server = new Server($id);

                if ($server->valid && $server->Delete($id)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('server_deleted_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
                }
            }
        }
    }

?>
<script src="assets/js/fontawesome-iconpicker.min.js"></script>	
<link rel="stylesheet" href="assets/css/fontawesome-iconpicker.min.css">

<link rel="stylesheet" href="assets/css/bootstrap.colorpickersliders.css">
<script src='assets/js/bootstrap.colorpickersliders.js'></script>
<script src='assets/js/tinycolor-min.js'></script>

<h3>
	<?php echo Lang('servers'); ?>
	<div class="pull-right">
		<button onclick="settings_servers_bundle_add();" type="button" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> <?php echo Lang('bundle_create'); ?></button>
	</div>
</h3>

<hr>

<div class="table-responsive">
    <table class="table table-hover">
    	<caption><?php echo Lang('servers_all'); ?></caption>
    	
    	<tr class="active">
    		<th>#</th>
    		<th><?php echo Lang('hostname'); ?></th>
    		<th><?php echo Lang('ipaddress'); ?></th>
    		<th><?php echo Lang('port'); ?></th>
    		<th style="width: 2%; " class="text-right"><i class="fa fa-cogs"></i></th>
    	</tr>
    	
    	<tbody>
    		<?php
                foreach (Server::GetAll() as $server) {
                    echo '<tr>';
                    echo '<td>';
                    echo $server->GetValue('id');
                    echo '</td>';
                    echo '<td>';
                    echo htmlspecialchars($server->GetValue('hostname'));
                    echo '</td>';

                    echo '<td>';
                    echo $server->GetValue('ip');
                    echo '</td>';

                    echo '<td>';
                    echo $server->GetValue('port');
                    echo '</td>';
                    echo '<td class="text-right">';
                    echo '<button onclick="settings_servers_server_delete_confirm(\''.$server->GetValue('id').'\');" type="button" class="btn btn-danger btn-xs"><i class="fa fa-trash"></i> '.Lang('delete').'</button>';
                    echo '</td>';
                    echo '</tr>';
                }
            ?>
    	</tbody>
    </table>
</div>

<div class="table-responsive">
    <table class="table table-hover">
    	<caption><?php echo Lang('bundles_all'); ?></caption>
    	
    	<tr class="active">
    		<th>#</th>
    		<th><?php echo Lang('name'); ?></th>
    		<th style="width: 10%;"><?php echo Lang('color'); ?></th>
    		<th style="width: 10%;"><?php echo Lang('icon'); ?></th>
    		<th style="width: 15%;"><?php echo Lang('servers'); ?></th>
    		<th style="width: 25%;" class="text-right"><i class="fa fa-cogs"></i></th>
    	</tr>
    	
    	<tbody>
    		<?php
                $bundledata = '';
                foreach (Serverbundle::GetAll(true) as $bundle) {
                    $bundledata .= 'bundledata['.$bundle->GetValue('id').'] = '.ToJson($bundle->data).';';
                    echo '<tr>';
                    echo '<td>';
                    echo $bundle->GetValue('id');
                    echo '</td>';
                    echo '<td>';
                    echo $bundle->GetValue('name');
                    echo '</td>';
                    echo '<td>';
                    echo '<i style="color:'.$bundle->GetValue('hexcolor').';" class="fa fa-square"></i>';
                    echo '</td>';
                    echo '<td>';
                    echo '<i class="fa '.$bundle->GetValue('icon').'"></i>';
                    echo '</td>';
                    echo '<td>';
                    echo implode(', ', $bundle->GetValue('servers'));
                    echo '</td>';
                    echo '<td class="text-right">';
                    echo '<button onclick="settings_servers_bundle_edit(\''.$bundle->GetValue('id').'\');" type="button" class="btn btn-primary btn-xs"><i class="fa fa-pencil"></i> '.Lang('edit').'</button>';

                    if ($bundle->GetValue('id') > 0) {
                        echo '&nbsp;';
                        echo '<button onclick="settings_servers_bundle_delete_confirm(\''.$bundle->GetValue('id').'\', \''.$bundle->GetValue('name').'\');" type="button" class="btn btn-danger btn-xs"><i class="fa fa-trash"></i> '.Lang('delete').'</button>';
                    }

                    echo '</td>';
                    echo '</tr>';
                }
            ?>
    	</tbody>
    </table>
</div>

<!-- Bundle Edit/Add Modal -->
<div class="modal fade" id="admin_settings_servers_bundle_editadd_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-shopping-bag"></i> &nbsp; <span id="admin_settings_servers_bundle_editadd_modal_title"></span></h4>
			</div>
			
			<form method="post" action="index.php?t=admin_settings&part=servers" enctype="multipart/form-data">
				<div class="modal-body">
		            <label><?php echo Lang('name'); ?></label><br>
		            <input name="admin_settings_servers_bundle_editadd_modal_form_name" type="text" class="form-control">
		            <br>
		            
		            <label><?php echo Lang('color'); ?></label><br>
                    <input value="#0000FF" class="form-control" name="admin_settings_servers_bundle_editadd_modal_form_color">
                    <br>
                    
                    <label><?php echo Lang('icon'); ?></label><br>
		            <div class="input-group">
                        <input data-placement="bottomRight" id="admin_settings_servers_bundle_editadd_modal_form_icon" name="admin_settings_servers_bundle_editadd_modal_form_icon" type="text" class="form-control"/>
                        <span class="input-group-addon"></span>
                    </div>
                    <br/>
                    
                    <label><?php echo Lang('description'); ?></label><br>
					<textarea rows="8" class="form-control" style="resize:vertical;" name="admin_settings_servers_bundle_editadd_modal_form_description"></textarea>
            		<br>
            		
            		<div class="row">
            			<div class="col-sm-7">
            				<label><?php echo Lang('donations_enable'); ?></label><br>
							<?php CreateCheckbox('primary', 'admin_settings_servers_bundle_editadd_modal_form_donations', '', Lang('donations_enable_bundle')); ?>
            			</div>
            			
            			<div class="col-sm-5">
            				<label><?php echo Lang('discount'); ?></label><br>
                  			<input value="0" class="form-control" name="admin_settings_servers_bundle_editadd_modal_form_discount">
            			</div>
            		</div>

		            <label><?php echo Lang('image_change'); ?></label><div class="pull-right"><?php CreateTooltip(Lang('hint_image_quadratic_png'), 'left'); ?></div><br>
		            <input name="admin_settings_servers_bundle_editadd_modal_form_image" type="file" accept="image/x-png">
		            <br>
		            
		            <label><?php echo Lang('servers_assigned'); ?></label><br>
		            <?php
                        foreach (Server::GetAll() as $server) {
                            CreateCheckbox('primary', 'admin_settings_servers_bundle_editadd_modal_form_server_'.$server->GetValue('id'), 'admin_settings_servers_bundle_editadd_modal_form_servers', $server->GetValue('hostname'));
                        }
                    ?>
				</div>
				<div class="modal-footer">
					<input name="admin_settings_servers_bundle_editadd_modal_form_id" type="hidden">
					<button type="submit" name="admin_settings_servers_bundle_editadd_modal_form_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</div>
			</form>
			
		</div>
	</div>
</div>

<script>
	var bundledata = {};
	
	<?php echo $bundledata; ?>
	
	$(function(){
		$("input[name='admin_settings_servers_bundle_editadd_modal_form_discount']").TouchSpin({
	        min: 0,
	        max: 100,
	        step: 10,
	        postfix: '%',
	        forcestepdivisibility: 'none',
	        verticalbuttons: true
	    });
    
	     $('input[name="admin_settings_servers_bundle_editadd_modal_form_color"]').ColorPickerSliders({
	        color: '#0000FF',
	        previewformat: 'hex',
	        sliders: false,
	        swatches: false,
	        hsvpanel: true
	    });
        
        $('#admin_settings_servers_bundle_editadd_modal_form_icon').iconpicker();
    });
    
	function settings_servers_bundle_add(){
		$('#admin_settings_servers_bundle_editadd_modal_title').html('<?php echo Lang('bundle_create'); ?>');
		
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_id"]').val('');
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_name"]').val('');
		$.iconpicker.batch('#admin_settings_servers_bundle_editadd_modal_form_icon', 'update', 'fa-server');
		$('textarea[name="admin_settings_servers_bundle_editadd_modal_form_description"]').val('');
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_color"]').trigger("colorpickersliders.updateColor", '#0000FF');
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_image"]').val('');
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_discount"]').val('');
		
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_donations"]').prop('checked', false);
		
		$('.admin_settings_servers_bundle_editadd_modal_form_servers').each(function(i, checkbox){
			$(checkbox).prop('checked', false);
		});
		
		$('#admin_settings_servers_bundle_editadd_modal').modal('show');
	}
	
	function settings_servers_bundle_edit(bundle){
		var data = bundledata[bundle];

		$('#admin_settings_servers_bundle_editadd_modal_title').html('<?php echo Lang('bundle_edit'); ?>');
		
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_image"]').val('');
		
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_id"]').val(data['id']);
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_name"]').val(data['name']);
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_discount"]').val(data['discount']);
		$.iconpicker.batch('#admin_settings_servers_bundle_editadd_modal_form_icon', 'update', data['icon']);
		$('textarea[name="admin_settings_servers_bundle_editadd_modal_form_description"]').val(data['description']);
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_color"]').trigger("colorpickersliders.updateColor", data['hexcolor']);
		
		$('input[name="admin_settings_servers_bundle_editadd_modal_form_donations"]').prop('checked', data["donations"]);
		
		$('.admin_settings_servers_bundle_editadd_modal_form_servers').each(function(i, checkbox){
			$(checkbox).prop('checked', false);
		});

		data['servers'].forEach(function(server){
			$('input[name="admin_settings_servers_bundle_editadd_modal_form_server_' + server + '"]').prop('checked', true);
		});

		$('#admin_settings_servers_bundle_editadd_modal').modal('show');
	}
	
	function settings_servers_bundle_delete_confirm(id, name){
        var text = '<?php echo Lang('bundle_delete_confirm'); ?>';
        text = text.replace('%bundle%', name);
        
        (new PNotify({
            title: '<?php echo Lang('confirmation'); ?>',
            text: text,
            icon: '',
            type: "error",
            hide: false,
            confirm: {
                confirm: true
            },
            buttons: {
                closer: false,
                sticker: false
            },
            history: {
                history: false
            }
            })).get().on('pnotify.confirm', function() {
                post('index.php?t=admin_settings&part=servers', {admin_settings_servers_bundle_delete: id});
        });
    }
    
    function settings_servers_server_delete_confirm(id){
        var text = '<?php echo Lang('server_delete_confirm'); ?>';
        text = text.replace('%server%', id);
        
        (new PNotify({
            title: '<?php echo Lang('confirmation'); ?>',
            text: text,
            icon: '',
            type: "error",
            hide: false,
            confirm: {
                confirm: true
            },
            buttons: {
                closer: false,
                sticker: false
            },
            history: {
                history: false
            }
            })).get().on('pnotify.confirm', function() {
                post('index.php?t=admin_settings&part=servers', {admin_settings_servers_server_delete: id});
        });
    }
</script>