<!--{"language":"teamspeak3","icon":"fa-microphone","position":83}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_teamspeak_submit'])) {
            foreach ($_POST as $key => $postvar) {
                if ('settings_teamspeak_submit' != $key && StartsWith($key, 'settings_teamspeak_')) {
                    Settings::Set($key, $postvar);
                }
            }
            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        }
    }
?>

<h3><?php echo Lang('teamspeak3'); ?></h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <div class="alert alert-info alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"><i class="fa fa-times"></i></span></button><?php echo Lang('see_instructions_wiki'); ?> <a target="_blank" href="https://gextension.ibot3.de/wiki/index.php?title=Teamspeak">Teamspeak</a></div>

        <div class="alert alert-danger alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"><i class="fa fa-times"></i></span></button><?php echo Lang('teamspeak_whitelist_alert'); ?></div>

        <form method="post" action="index.php?t=admin_settings&part=teamspeak">
        	<div class="row">
        		<div class="col-xs-6">
        			 <!-- IP -->
		            <label><?php echo Lang('ipaddress'); ?></label><br>
		            <input name="settings_teamspeak_ip" type="text" class="form-control" placeholder="0.0.0.0">
        		</div>

        		<div class="col-xs-6">
        			 <!-- Port -->
		            <label><?php echo Lang('port'); ?></label><br>
		            <input name="settings_teamspeak_port" type="text" class="form-control" placeholder="9987">
        		</div>
        	</div>

           <hr>

           <div class="row">
        		<div class="col-sm-4">
        			 <!-- Query Login -->
		            <label><?php echo Lang('query_login'); ?></label><br>
		            <input name="settings_teamspeak_query_login" type="text" class="form-control" placeholder="">
        		</div>

        		<div class="col-sm-4">
        			 <!-- Query Password -->
		            <label><?php echo Lang('query_password'); ?></label><br>
		            <input name="settings_teamspeak_query_password" type="password" class="form-control" placeholder="">
        		</div>

        		<div class="col-sm-4">
        			 <!-- Query Port -->
		            <label><?php echo Lang('query_port'); ?></label><br>
		            <input name="settings_teamspeak_query_port" type="text" class="form-control" placeholder="10011">
        		</div>
        	</div>

        	<br>

            <!-- Submit Button -->
            <button name="settings_teamspeak_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>
    </div>
</div>

<script>
    $('input[name="settings_teamspeak_ip"]').val('<?php echo DemoLock() ? 'hidden' : OneLine(Settings::Get('settings_teamspeak_ip')); ?>');
    $('input[name="settings_teamspeak_port"]').val('<?php echo OneLine(Settings::Get('settings_teamspeak_port')); ?>');
    $('input[name="settings_teamspeak_query_login"]').val('<?php echo DemoLock() ? 'hidden' : OneLine(Settings::Get('settings_teamspeak_query_login')); ?>');
    $('input[name="settings_teamspeak_query_password"]').val('<?php echo DemoLock() ? 'hidden' : OneLine(Settings::Get('settings_teamspeak_query_password')); ?>');
    $('input[name="settings_teamspeak_query_port"]').val('<?php echo OneLine(Settings::Get('settings_teamspeak_query_port')); ?>');
</script>