<!--{"language":"tickets","icon":"fa-ticket","position":80}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_tickets_submit'])) {
            $checkboxes = array();
            $ignore = array('settings_tickets_submit');
            $html_validation = array('settings_tickets_instructions');

            foreach ($checkboxes as $checkbox) {
                if (!array_key_exists($checkbox, $_POST)) {
                    $_POST[$checkbox] = 0;
                } else {
                    $_POST[$checkbox] = 1;
                }
            }

            foreach ($_POST as $key => $postvar) {
                if (!in_array($key, $ignore) && StartsWith($key, 'settings_tickets_')) {
                    if (in_array($key, $html_validation)) {
                        $postvar == ValidateHTML($postvar);
                    }

                    Settings::Set($key, $postvar);
                }
            }

            DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('changes_saved').'", type: "success"');
        }

        if (isset($_POST['settings_tickets_category_create_modal_submit'])) {
            $name = htmlspecialchars($_POST['settings_tickets_category_create_modal_name']);

            if (!empty($name)) {
                if (Ticket::CreateCategory($name)) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('category_created_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_insert').'", type: "error"');
                }
            }
        } elseif (!empty($_POST['settings_tickets_category_delete'])) {
            if (Ticket::DeleteCategory($_POST['settings_tickets_category_delete'])) {
                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('category_deleted_success').'", type: "success"');
            } else {
                DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('sqlerror_delete').'", type: "error"');
            }
        }
    }
?>

<!-- Summernote CSS -->
<link rel="stylesheet" href="assets/css/summernote.css">

<!-- Summernote JS-->
<script src="assets/js/summernote.min.js"></script>

<h3>
    <?php echo Lang('tickets'); ?>
    <div class="pull-right">
		<button onclick="settings_tickets_category_create();" type="button" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> <?php echo Lang('category_create'); ?></button>
	</div>
</h3>

<hr>

<div class="row">
    <div class="col-xs-12">
        <form method="post" action="index.php?t=admin_settings&part=tickets" enctype="multipart/form-data">
            <label><?php echo Lang('instructions'); ?></label><br>
            <textarea name="settings_tickets_instructions"></textarea>

            <!-- Submit Button -->
            <button name="settings_tickets_submit" type="submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
        </form>

        <br/><br/>

        <div class="table-responsive">
            <table class="table table-hover">
            	<caption><?php echo Lang('categories'); ?></caption>
    
            	<tr class="active">
            		<th><?php echo Lang('name'); ?></th>
            		<th class="text-right"><i class="fa fa-cogs"></i></th>
            	</tr>
    
            	<tbody>
            		<?php
                        foreach (Ticket::GetCategories() as $category) {
                            echo '<tr>';
                            echo '<td>';
                            echo $category['name'];
                            echo '</td>';
                            echo '<td class="text-right">';
                            echo '<button onclick="settings_tickets_category_delete('.$category['id'].');" type="button" class="btn btn-danger btn-xs"><i class="fa fa-trash"></i> '.Lang('delete').'</button>';
                            echo '</td>';
                            echo '</tr>';
                        }
                    ?>
            	</tbody>
            </table>
        </div>
    </div>
</div>

<!-- Ticket Category Create Modal -->
<div class="modal fade" id="settings_tickets_category_create_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-th-large"></i> &nbsp;<?php echo Lang('category_create'); ?></h4>
			</div>

			<form method="post" action="index.php?t=admin_settings&part=tickets">
				<div class="modal-body">
		            <label><?php echo Lang('name'); ?></label><br>
		            <input name="settings_tickets_category_create_modal_name" type="text" class="form-control" />
				</div>
				<div class="modal-footer">
					<button type="submit" name="settings_tickets_category_create_modal_submit" class="btn btn-success"><?php echo Lang('create'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>


<script>
   $('textarea[name="settings_tickets_instructions"]').summernote({
		height: 150,
		toolbar: summernote_toolbar_default
	});

	$('textarea[name="settings_tickets_instructions"]').summernote('code', '<?php echo OneLine(Settings::Get('settings_tickets_instructions')); ?>');

	function settings_tickets_category_delete(id){
        post('index.php?t=admin_settings&part=tickets', {settings_tickets_category_delete: id});
    }

    function settings_tickets_category_create(){
        $('#settings_tickets_category_create_modal').modal('show');
    }
</script>