<!--{"language":"update","icon":"fa-refresh","position":10000}-->
<?php
    if (!isset($G_MAIN) && !isset($G_REQUEST)) {
        die(json_encode(array('error' => 'authentification failed')));
    }
?>

<?php
    if (!DemoLock()) {
        if (isset($_POST['settings_update_update'])) {
            $product = new Product($_POST['settings_update_update']);

            if ($product->valid) {
                if ($product->UpdateFiles()) {
                    echo '<i class="fa fa-refresh fa-spin fa-fw"></i> '.Lang('updating').'...';
                    Redirect('index.php?t=admin_settings&part=update&finish='.$product->GetValue('name'));
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('update_error').'", type: "error"');
                }
            }
        } elseif (isset($_POST['settings_update_license_modal_submit']) && isset($_POST['settings_update_license_modal_name']) && isset($_POST['settings_update_license_modal_license'])) {
            if (!empty($_POST['settings_update_license_modal_license']) && !empty($_POST['settings_update_license_modal_name'])) {
                $product = new Product($_POST['settings_update_license_modal_name']);

                if ($product->valid) {
                    $product->SetValue('license', $_POST['settings_update_license_modal_license']);

                    $product->RegisterLicense();
                    $product->VerifyLicense();

                    if ($product->GetValue('valid')) {
                        echo '<i class="fa fa-spinner fa-pulse fa-fw"></i> '.Lang('validating').'...';

                        Redirect('index.php?t=admin_settings&part=update');
                    }
                }
            }
        } elseif (isset($_POST['settings_update_product_modal_submit']) && isset($_POST['settings_update_product_modal_name']) && isset($_POST['settings_update_product_modal_license'])) {
            if (!empty($_POST['settings_update_product_modal_license']) && !empty($_POST['settings_update_product_modal_name'])) {
                if (Product::Add($_POST['settings_update_product_modal_name'], ($_POST['settings_update_product_modal_license']))) {
                    DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.Lang('product_add_success').'", type: "success"');
                } else {
                    DirectNotifications::Execute('title: "'.Lang('error').'", text: "'.Lang('product_add_error').'", type: "error"');
                }
            }
        } elseif (isset($_POST['settings_update_cleanup_start'])) {
            $cleanupresult = array();

            if (isset($_POST['settings_update_cleanup_users'])) {
                $cleanupresult['users'] = Cleanup::CleanUsers();
            }

            if (isset($_POST['settings_update_cleanup_debug'])) {
                $cleanupresult['debug'] = Cleanup::CleanDebug();
            }

            if (isset($_POST['settings_update_cleanup_paysafecard'])) {
                $cleanupresult['paysafecard'] = Cleanup::CleanPaysafecard();
            }

            if (isset($_POST['settings_update_cleanup_notifications'])) {
                $cleanupresult['notifications'] = Cleanup::CleanNotifications();
            }

            if (isset($_POST['settings_update_cleanup_sessions'])) {
                $cleanupresult['sessions'] = Cleanup::CleanSessions();
            }

            if (isset($_POST['settings_update_cleanup_unrelated_data'])) {
                $cleanupresult['unrelated_data'] = Cleanup::CleanUnrelatedData();
            }

            if (!empty($cleanupresult)) {
                $resstr = '';

                foreach ($cleanupresult as $key => $val) {
                    $resstr .= $key.': '.$val.'<br/>';
                }

                DirectNotifications::Execute('title: "'.Lang('success').'", text: "'.$resstr.'", type: "success"');
            }
        }
    }
?>

<h3>
	<?php echo Lang('update'); ?>
	<button onclick="settings_upade_product_add();" type="button" class="btn btn-success btn-sm pull-right"><i class="fa fa-plus-circle"></i> <?php echo Lang('product_add'); ?></button>
</h3>

<hr>

<?php 
    echo '<div class="alert alert-info" role="alert">'.Lang('license_agreement_update_notice').'</div>';

    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        echo '<div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>'.Lang('clouflare_update_warning').'</div>';
    }
?>

<div class="table-responsive">
    <table class="table table-hover">
        <tr class="active">
            <th><?php echo Lang('product'); ?></th>
            <th><?php echo Lang('version_installed'); ?></th>
            <th><?php echo Lang('version_available'); ?></th>
            <th><?php echo Lang('agreement'); ?></th>
            <th><?php echo Lang('status'); ?></th>
            <th class="text-right"><i class="fa fa-cogs"></i></th>
        </tr>
    
        <tbody>
            <?php
                foreach (Product::GetAll() as $product) {
                    $product->VerifyLicense();
                    $product->RefreshAvailableVersion();

                    echo '<tr>';
                    echo '<td>';
                    echo $product->GetValue('name');
                    echo '</td>';
                    echo '<td>';
                    echo $product->GetValue('version_installed');
                    echo '</td>';
                    echo '<td>';
                    echo '<a href="'.$product->GetChangelogURL().'" target="_blank">'.$product->GetValue('version_available').'</a>';
                    echo '</td>';
                    echo '<td>';
                    echo '<a href="'.$product->GetAgreementURL().'" target="_blank">'.Lang('agreement').'</a>';
                    echo '</td>';
                    echo '<td>';
                    if ($product->GetValue('valid')) {
                        echo '<span class="label label-success">'.Lang('valid').'</span>';
                    } else {
                        echo '<span class="label label-danger">'.Lang('invalid').'</span>';
                    }

                    if ($product->GetValue('noconnection')) {
                        echo ' <span class="label label-warning">'.Lang('noconnection').'</span>';
                    }
                    echo '</td>';
                    echo '<td class="text-right">';
                    if ($product->GetValue('valid')) {
                        $btntext = Lang('update_verb');
                        $color = 'success';

                        if ($product->GetValue('version_installed') == $product->GetValue('version_available')) {
                            $btntext = Lang('renew');
                            $color = 'default';
                        }

                        echo '<button onclick="settings_update_update(\''.$product->GetValue('name').'\');" class="btn btn-'.$color.' btn-xs">'.$btntext.'</button> ';
                        echo '<a href="'.(DemoLock() ? '#' : $product->GetLuaDownload()).'"><button class="btn btn-info btn-xs">Lua</button></a> ';
                    }

                    echo '<button onclick="settings_update_license(\''.$product->GetValue('name').'\');" class="btn btn-danger btn-xs">'.Lang('license').'</button>';
                    echo '</td>';
                    echo '</tr>';
                }
            ?>
    
        </tbody>
    </table>
</div>

<hr>

<h4><?php echo Lang('cleanup'); ?></h4>

<form method="post" action="index.php?t=admin_settings&part=update">
    <?php CreateCheckbox('primary', 'settings_update_cleanup_users', '', Lang('cleanup_users')); ?>
    <?php CreateCheckbox('primary', 'settings_update_cleanup_debug', '', Lang('cleanup_debug')); ?>
    <?php CreateCheckbox('primary', 'settings_update_cleanup_paysafecard', '', Lang('cleanup_paysafecard')); ?>
    <?php CreateCheckbox('primary', 'settings_update_cleanup_notifications', '', Lang('cleanup_notifications')); ?>
    <?php CreateCheckbox('primary', 'settings_update_cleanup_sessions', '', Lang('cleanup_sessions')); ?>
    <?php CreateCheckbox('primary', 'settings_update_cleanup_unrelated_data', '', Lang('cleanup_unrelated_data')); ?>
    
    <button type="submit" name="settings_update_cleanup_start" class="btn btn-primary"><?php echo Lang('cleanup_start'); ?></button>
</form>

<!-- License Modal -->
<div class="modal fade" id="settings_update_license_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-key"></i> &nbsp;<?php echo Lang('license_new'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_settings&part=update">
				<div class="modal-body">
					<input type="hidden" value="" name="settings_update_license_modal_name">

					<!-- License -->
		            <label><?php echo Lang('license_new'); ?></label><br>
		            <div class="input-group">
                        <input name="settings_update_license_modal_license" type="text" class="form-control" placeholder="<?php echo Lang('license'); ?>..." />

                        <span class="input-group-btn">
                            <button type="button" class="btn btn-success btn-sm" onclick="settings_update_crawl();">
                                <?php echo Lang('retrieve'); ?>
                            </button>
                        </span>
                    </div>
				</div>
				<div class="modal-footer">
					<button type="submit" name="settings_update_license_modal_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Add Product Modal -->
<div class="modal fade" id="settings_update_product_modal" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
				<h4 class="modal-title"><i class="fa fa-archive"></i> &nbsp;<?php echo Lang('product_add'); ?></h4>
			</div>
			<form method="post" action="index.php?t=admin_settings&part=update">
				<div class="modal-body">
					<!-- Product -->
					<label><?php echo Lang('product_name'); ?></label><br>
					<input type="text" class="form-control" placeholder="<?php echo Lang('product'); ?>" name="settings_update_product_modal_name">
					<br />
					<!-- License -->
		            <label><?php echo Lang('license'); ?></label><br>
		            <div class="input-group">
                        <input name="settings_update_product_modal_license" type="text" class="form-control" placeholder="<?php echo Lang('license'); ?>..." />

                        <span class="input-group-btn">
                            <button type="button" class="btn btn-success btn-sm" onclick="settings_update_crawl(true);">
                                <?php echo Lang('retrieve'); ?>
                            </button>
                        </span>
                    </div>
				</div>
				<div class="modal-footer">
					<button type="submit" name="settings_update_product_modal_submit" class="btn btn-primary"><?php echo Lang('save'); ?></button>
				</div>
			</form>
		</div>
	</div>
</div>


<script>
	function settings_update_update(product){
		post('index.php?t=admin_settings&part=update', {'settings_update_update': product});
	}

	function settings_update_license(product){
		$('input[name="settings_update_license_modal_name"]').val(product);
		$('#settings_update_license_modal').modal('show');
	}

	function settings_update_crawl(newproduct){
		var product = '';

		if(newproduct){
			product = $('input[name="settings_update_product_modal_name"]').val();
		}else{
			product = $('input[name="settings_update_license_modal_name"]').val();
		}

		if(product != ""){
			var w = window.open('<?php echo Settings::Get('settings_update_server').'?action=crawl'; ?>&product=' + product, 'Get License', 'width=850, height=700, ');

			/*
			$( $(w.document).contents().find('body') ).change(function() {
				if($(w.document).contents().find('body').html().indexOf('padm_license') >= 0){
					if($(w.document).contents().find('#padm_license').length){
						$('input[name="settings_update_license_modal_license"]').val($(w.document).contents().find('#padm_license').val());
					}
				}
			});*/
		}
	}

	function settings_upade_product_add(){
		$('#settings_update_product_modal').modal('show');
	}
</script>